/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.Color;
import java.io.IOException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import translator.AppPreferences;
import translator.AssembleParser;
import translator.FragmentMatch;
import translator.GlossaryResource;
import translator.MainView;
import translator.MatchBoard;
import translator.Project;
import translator.Prompter;
import translator.ResourceView;
import translator.SegmentParser;
import translator.TranslationResult;
import translator.TranslationUnit;
import translator.Workflow;
import translator.WorkflowManager;
import translator.XMLElement;
import translator.XMLHelper;
import translator.hunspell.HunSpellChecker;
import translator.server.RemoteMemory;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXResult;
import translator.web.Proz;

public class TranslateEvent {
    private MainView topui;
    private String memoryLookupText;
    private String glossaryLookupText;
    private String autoAssemblingLookupText;
    private String queryTagged;
    private String memoryLookupTextCleaned;
    private String glossaryLookupTextCleaned;
    private ConcurrentLinkedQueue localWorkers;
    private CountDownLatch startLatch;
    private Map autoMatchesMap;
    private List bestFuzzies;
    private List perfectTUs;
    private HashSet<FragmentMatch> fragmentsSet;
    private int fuzzyMatchAccuracy = 0;
    private int assembledAccuracy = 0;
    private int contextAccuracy = 0;
    private boolean tagsInserted = false;
    private boolean isBestFuzzyMatch = false;
    private String autoTranslation = null;
    private int autoTranslationAccuracy = 0;
    private int perfectTUPriority = 0;
    private TranslationResult translationResult;
    int resultsCount = 0;

    public TranslateEvent(MainView topui) {
        this.topui = topui;
        this.startLatch = new CountDownLatch(0);
        this.localWorkers = new ConcurrentLinkedQueue();
        this.bestFuzzies = new ArrayList();
        this.perfectTUs = new ArrayList();
        this.fragmentsSet = new HashSet();
    }

    public void setTranslateText(String memoryLookupText, String glossaryLookupText, String autoAssemblingLookupText, String queryTagged) {
        this.memoryLookupText = memoryLookupText;
        this.glossaryLookupText = glossaryLookupText;
        this.autoAssemblingLookupText = autoAssemblingLookupText;
        this.queryTagged = queryTagged;
        this.memoryLookupTextCleaned = memoryLookupText.replaceAll(AppPreferences.punctuation, "");
        this.memoryLookupTextCleaned = this.memoryLookupTextCleaned.trim();
        this.memoryLookupTextCleaned = XMLHelper.normalizeSpace(this.memoryLookupTextCleaned);
        this.memoryLookupTextCleaned = this.memoryLookupTextCleaned.replaceAll("\\s+", " ");
        if (glossaryLookupText != null) {
            this.glossaryLookupTextCleaned = glossaryLookupText.replaceAll(AppPreferences.punctuation, "");
            this.glossaryLookupTextCleaned = this.glossaryLookupTextCleaned.trim();
            this.glossaryLookupTextCleaned = XMLHelper.normalizeSpace(this.glossaryLookupTextCleaned);
            this.glossaryLookupTextCleaned = this.glossaryLookupTextCleaned.replaceAll("\\s+", " ");
        }
    }

    public String getMemoryLookupText() {
        return this.memoryLookupText;
    }

    public String getMemoryLookupTextCleaned() {
        return this.memoryLookupTextCleaned;
    }

    public String getGlossaryLookupText() {
        if (this.glossaryLookupText != null) {
            return this.glossaryLookupText;
        }
        return this.memoryLookupText;
    }

    public String getGlossaryLookupTextCleaned() {
        if (this.glossaryLookupTextCleaned != null) {
            return this.glossaryLookupTextCleaned;
        }
        return this.memoryLookupTextCleaned;
    }

    public String getAutoAssemblingLookupText() {
        if (this.autoAssemblingLookupText != null) {
            return this.autoAssemblingLookupText;
        }
        return this.memoryLookupText;
    }

    public synchronized void setTranslation() {
        Workflow w = this.topui.getWorkflowView().getWorkflowManager().getWorkflow();
        if (w != null) {
            String seg;
            if (!AppPreferences.bindExternalEditor) {
                this.topui.getTargetPane().requestFocus();
            }
            AssembleParser parser = new AssembleParser(this);
            parser.setPrefectTUS(this.perfectTUs);
            Object[] fuzzies = this.getBestFuzzies();
            parser.setBestFuzzies(fuzzies);
            Prompter prompt = this.topui.getSourceView().getPrompter();
            int minLen = 1;
            if (AppPreferences.noWordSeparatorSourceLanguage) {
                minLen = 0;
            }
            JTextPane tpane = this.topui.getSourcePane();
            StyledDocument doc = (StyledDocument)tpane.getDocument();
            Style styleGlossary = doc.getStyle("Terms");
            Style styleGlossaryLow = doc.getStyle("TermsLow");
            Style styleGlossaryHigh = doc.getStyle("TermsHigh");
            Style styleMemory = doc.getStyle("Phrases");
            Style styleMemoryLow = doc.getStyle("PhrasesLow");
            Style styleMemoryHigh = doc.getStyle("PhrasesHigh");
            Style stylePlaceables = doc.getStyle("Placeable");
            Color pc = (Color)stylePlaceables.getAttribute(StyleConstants.Background);
            int nonTranslatableRGB = pc.getRGB();
            String AISegment = null;
            try {
                int len = doc.getLength();
                AISegment = doc.getText(0, len);
                seg = AISegment.toLowerCase();
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TranslateEvent.class.getName()).log(Level.SEVERE, null, ex);
                seg = "";
            }
            this.autoMatchesMap = new LinkedHashMap();
            if (this.fragmentsSet.size() > 0) {
                int mtype;
                ArrayList<FragmentMatch> sortedFragments = new ArrayList<FragmentMatch>(this.fragmentsSet);
                Collections.sort(sortedFragments, new Comparator<FragmentMatch>(){

                    @Override
                    public int compare(FragmentMatch o1, FragmentMatch o2) {
                        Integer i1 = o1.getWeight();
                        Integer i2 = o2.getWeight();
                        int i = i2.compareTo(i1);
                        if (i == 0) {
                            i1 = o1.getPriority();
                            i2 = o2.getPriority();
                            i = i2.compareTo(i1);
                            if (i == 0) {
                                i1 = o1.getAltenative();
                                i2 = o2.getAltenative();
                                i = i2.compareTo(i1);
                                if (i == 0) {
                                    String s1 = o1.getSource();
                                    String s2 = o2.getSource();
                                    if (s1 != null && s2 != null) {
                                        i1 = s1.length();
                                        i2 = s2.length();
                                        i = i2.compareTo(i1);
                                    }
                                }
                            }
                        }
                        return i;
                    }
                });
                for (FragmentMatch fmatch : sortedFragments) {
                    Set mset;
                    String source = fmatch.getSource();
                    if (source == null || source.length() == 0) continue;
                    boolean lowQualityHit = false;
                    mtype = fmatch.getMatchTypeInt();
                    int contextL = fmatch.getContexLevel();
                    int hits = fmatch.getHitsNumber();
                    if (mtype == 3 && contextL == 0 && hits <= AppPreferences.hitToAutoThreshold) {
                        lowQualityHit = true;
                    }
                    if (mtype > 0 && !lowQualityHit) {
                        parser.addFragmentMatch(fmatch);
                    }
                    if (prompt != null && !lowQualityHit) {
                        boolean segmentMatch = fmatch.isSegmentMatch();
                        String target = fmatch.getTarget();
                        if (target != null) {
                            if (segmentMatch) {
                                prompt.getAssembledPhrases(target, false);
                            } else {
                                prompt.getAssembledPhrases(target, true);
                            }
                        }
                    }
                    if ((mset = (Set)this.autoMatchesMap.get(source)) == null) {
                        LinkedHashSet<FragmentMatch> mset2 = new LinkedHashSet<FragmentMatch>(4);
                        mset2.add(fmatch);
                        this.autoMatchesMap.put(source, mset2);
                        continue;
                    }
                    mset.add(fmatch);
                }
                for (int i = sortedFragments.size() - 1; i >= 0; --i) {
                    FragmentMatch fmatch;
                    fmatch = sortedFragments.get(i);
                    String frag = fmatch.getFragment();
                    String src = fmatch.getSource();
                    mtype = fmatch.getMatchTypeInt();
                    int priority = fmatch.getPriority();
                    if (seg.length() <= 0 || mtype == 7 || frag == null || frag.length() <= minLen) continue;
                    frag = frag.toLowerCase();
                    int rt = fmatch.getResourceType();
                    int wi = seg.indexOf(frag, 0);
                    if (wi == -1 && src != null) {
                        frag = src.toLowerCase();
                        wi = seg.indexOf(frag);
                    }
                    while (wi != -1) {
                        int cRGB;
                        Element elem = doc.getCharacterElement(wi);
                        AttributeSet as = elem.getAttributes();
                        Color c = StyleConstants.getBackground(as);
                        if (c != null && (cRGB = c.getRGB()) == nonTranslatableRGB) {
                            wi = seg.indexOf(frag, wi + frag.length());
                            continue;
                        }
                        if (rt == 1) {
                            if (!AppPreferences.hideMatchColorInSource) {
                                if (priority == 0) {
                                    doc.setCharacterAttributes(wi, frag.length(), styleMemoryLow, false);
                                } else if (priority == 2) {
                                    doc.setCharacterAttributes(wi, frag.length(), styleMemoryHigh, false);
                                } else {
                                    doc.setCharacterAttributes(wi, frag.length(), styleMemory, false);
                                }
                            }
                        } else if (!AppPreferences.hideMatchColorInSource2) {
                            if (priority == 0) {
                                doc.setCharacterAttributes(wi, frag.length(), styleGlossaryLow, false);
                            } else if (priority == 2) {
                                doc.setCharacterAttributes(wi, frag.length(), styleGlossaryHigh, false);
                            } else {
                                doc.setCharacterAttributes(wi, frag.length(), styleGlossary, false);
                            }
                        }
                        wi = seg.indexOf(frag, wi + frag.length());
                    }
                }
            }
            if (prompt != null) {
                parser.setAutocomplete(prompt);
            }
            String s = this.autoAssemblingLookupText != null ? this.autoAssemblingLookupText : this.memoryLookupText;
            String[] presult = parser.translate(s, this.queryTagged);
            this.assembledAccuracy = parser.getAccuracy();
            this.contextAccuracy = parser.getContextPercent();
            this.tagsInserted = parser.tagsInserted();
            int fuzzyAccuracy4AI = 0;
            String sourceMT = AppPreferences.correctAA ? parser.getSegmentForMTCorrection() : this.memoryLookupText;
            this.translationResult = new TranslationResult(this.autoMatchesMap, presult, fuzzies, this.assembledAccuracy, this.contextAccuracy);
            String[] aaResult = this.translationResult.getAAResult();
            Project project = this.topui.getProjectView().getProject();
            boolean autoinsert = false;
            boolean skipPopup = false;
            boolean isQA = project.isQAFilterWorkflow();
            if (aaResult != null && this.assembledAccuracy >= AppPreferences.autoapply) {
                String auto = aaResult[1];
                if (auto != null) {
                    autoinsert = true;
                    this.autoTranslation = auto;
                    this.autoTranslationAccuracy = this.assembledAccuracy;
                }
            } else {
                Object[] totalBest = this.translationResult.getFuzzyResult();
                String auto = null;
                Object o = totalBest[0];
                if (o != null) {
                    Object[] ob = (Object[])o;
                    Integer oi = (Integer)ob[0];
                    int acc = oi;
                    if (acc > fuzzyAccuracy4AI) {
                        fuzzyAccuracy4AI = acc;
                    }
                    if (acc >= AppPreferences.fuzzyautoapply && (auto = (String)ob[2]) != null) {
                        this.isBestFuzzyMatch = true;
                        this.fuzzyMatchAccuracy = acc;
                        autoinsert = true;
                        this.autoTranslation = auto;
                        this.autoTranslationAccuracy = this.fuzzyMatchAccuracy;
                    }
                }
                if (AppPreferences.autoInsertion && auto == null && aaResult != null && (auto = aaResult[1]) != null) {
                    autoinsert = true;
                    this.autoTranslation = auto;
                    this.autoTranslationAccuracy = this.assembledAccuracy;
                }
                if (!autoinsert && AppPreferences.skipNoMatches && !isQA) {
                    skipPopup = true;
                    WorkflowManager.suspendAutosave = true;
                    WorkflowManager.suspendQATagsCheck = true;
                    this.topui.getWorkflowView().autoNext();
                }
            }
            if (!skipPopup) {
                this.topui.getMatchBoard().showMatches(this);
                ResourceView rview = this.topui.getResourceView();
                if (AppPreferences.chatGPTAction == 1) {
                    String se = this.queryTagged != null ? this.queryTagged : sourceMT;
                    boolean promptAI = false;
                    if (AppPreferences.aiServiceActivation == 1) {
                        if (project.isCurrentSegmentEmpty()) {
                            promptAI = true;
                        }
                    } else if (AppPreferences.aiServiceActivation == 2) {
                        if (this.assembledAccuracy < 100) {
                            promptAI = true;
                        }
                    } else if (AppPreferences.aiServiceActivation == 3) {
                        if (fuzzyAccuracy4AI < 90 && this.assembledAccuracy < 100) {
                            promptAI = true;
                        }
                    } else if (AppPreferences.aiServiceActivation == 4) {
                        if (fuzzyAccuracy4AI < 80 && this.assembledAccuracy < 100) {
                            promptAI = true;
                        }
                    } else if (AppPreferences.aiServiceActivation == 5) {
                        if (fuzzyAccuracy4AI < 70 && this.assembledAccuracy < 100) {
                            promptAI = true;
                        }
                    } else {
                        promptAI = true;
                    }
                    if (promptAI) {
                        rview.translateAIService(se);
                    }
                }
                rview.translateMT(sourceMT);
                if (!(!AppPreferences.popupAutoassemblingPanel || autoinsert && AppPreferences.skipAutoMatches)) {
                    this.topui.getMemoryView().showAutoTranslationPopUp();
                }
            }
        }
    }

    public void countDownLatch() {
        if (this.startLatch != null) {
            this.startLatch.countDown();
            long c = this.startLatch.getCount();
            if (c == 0L) {
                this.localWorkers.clear();
                this.setTranslation();
            }
        }
    }

    public synchronized void addNewFragmentsToMatchBoard() {
        MatchBoard mb = this.topui.getMatchBoard();
        if (mb != null) {
            List MTResults = mb.getMTResultsList();
            ArrayList MTResultsCopy = new ArrayList(MTResults.size());
            for (Object next : MTResults) {
                MTResultsCopy.add(next);
            }
            mb.clearMatchBoard();
            if (!MTResultsCopy.isEmpty()) {
                mb.resetMTMatches(MTResultsCopy);
            }
        }
        this.setTranslation();
    }

    public synchronized void cancelAllThreads() {
        List remoteMemories;
        if (this.localWorkers != null) {
            Iterator it = this.localWorkers.iterator();
            while (it.hasNext()) {
                Object object = it.next();
                it.remove();
                SwingWorker worker = (SwingWorker)object;
                if (worker == null) continue;
                worker.cancel(true);
            }
        }
        if ((remoteMemories = this.topui.getMemoryView().getRemoteMemories()) != null) {
            for (Object object : remoteMemories) {
                RemoteMemory rm = (RemoteMemory)object;
                if (!rm.auto) continue;
                rm.cancelSearch();
            }
        }
    }

    public void translateSegment(boolean auto) {
        Proz proz;
        List remoteMemories;
        List localMemories;
        int len;
        int gsize;
        int threads = 0;
        boolean localTM = false;
        boolean remoteTM = false;
        boolean localGlossaries = false;
        List glossaries = this.topui.getResourceView().getGlossaries();
        if (glossaries != null && (gsize = glossaries.size()) > 0) {
            localGlossaries = true;
            threads += gsize;
            if (this.localWorkers.size() > 0) {
                this.localWorkers.clear();
            }
        }
        if ((len = (localMemories = this.topui.getMemoryView().getLocalMemories()).size()) > 0) {
            localTM = true;
            threads += len;
            if (this.localWorkers.size() > 0) {
                this.localWorkers.clear();
            }
        }
        if ((remoteMemories = this.topui.getMemoryView().getRemoteMemories()) != null && (len = remoteMemories.size()) > 0) {
            remoteTM = true;
            threads += len;
        }
        if ((proz = this.topui.getResourceView().getProzService()) != null && AppPreferences.prozExactFragmentsMatching) {
            ++threads;
        }
        this.startLatch = new CountDownLatch(threads);
        if (threads == 0) {
            this.countDownLatch();
        }
        if (localGlossaries) {
            for (Object object : glossaries) {
                GlossaryResource gr = (GlossaryResource)object;
                boolean matchingStopped = gr.isAutomaticMatchingStopped();
                if (!matchingStopped) {
                    this.searchGlossary(gr);
                    continue;
                }
                this.countDownLatch();
            }
        }
        if (localTM) {
            AppPreferences.memoryPrefixMatch = false;
            for (Object object : localMemories) {
                int mode;
                Memory m = (Memory)object;
                this.topui.getMemoryView().clearTMPane(m);
                if (m.getPrefixMatch()) {
                    AppPreferences.memoryPrefixMatch = true;
                }
                if ((mode = m.getWorkflowMode()) == 1) {
                    if (auto) {
                        this.showPretranslated(m);
                        continue;
                    }
                    this.translate(m);
                    continue;
                }
                if (mode == 0) {
                    this.translate(m);
                    continue;
                }
                if (mode == 2 && !auto) {
                    this.translate(m);
                    continue;
                }
                this.countDownLatch();
            }
        }
        if (remoteTM) {
            for (Object object : remoteMemories) {
                RemoteMemory rm = (RemoteMemory)object;
                if (rm.auto) {
                    rm.search(this.memoryLookupText, null);
                    continue;
                }
                this.countDownLatch();
            }
        }
        if (proz != null && AppPreferences.prozExactFragmentsMatching) {
            this.searchProz(this.memoryLookupText, proz);
        }
        this.topui.getResourceView().translateWebService(this.memoryLookupText);
    }

    public String translateForExactMatches(String processedQuery, XMLElement unit) {
        List localMemories;
        int len;
        boolean local = false;
        String exactMatch = null;
        if (!this.perfectTUs.isEmpty()) {
            this.perfectTUs.clear();
        }
        this.perfectTUPriority = 0;
        long count = this.startLatch.getCount();
        if (count > 0L) {
            this.cancelAllThreads();
        }
        if ((len = (localMemories = this.topui.getMemoryView().getLocalMemories()).size()) > 0) {
            local = true;
            if (this.localWorkers.size() > 0) {
                this.localWorkers.clear();
            }
        }
        if (local) {
            for (Object object : localMemories) {
                TranslationUnit ptu;
                Memory m = (Memory)object;
                TMX tmx = m.getTMX();
                SegmentParser cparser = tmx.getParser();
                String full = this.getMemoryLookupText();
                String clean = this.getMemoryLookupTextCleaned();
                if (clean.trim().length() <= 0) continue;
                TMXResult result = cparser.getFromCache(clean);
                if (result == null) {
                    result = cparser.translateExact(full, clean, unit);
                }
                if (result == null || (ptu = result.getPerfectTranslationUnit()) == null) continue;
                this.addPerfectTU(result);
            }
        }
        if (this.perfectTUs.size() > 0) {
            AssembleParser parser = new AssembleParser(this);
            parser.setPrefectTUS(this.perfectTUs);
            String e = parser.selectExactMatch(processedQuery);
            this.assembledAccuracy = parser.getAccuracy();
            this.contextAccuracy = parser.getContextPercent();
            if (e != null && this.assembledAccuracy == 101) {
                exactMatch = e;
            }
        }
        return exactMatch;
    }

    public boolean translateForTargetsDifferenceCheck(XMLElement unit) {
        List localMemories;
        int len;
        boolean difference = false;
        boolean local = false;
        long count = this.startLatch.getCount();
        if (count > 0L) {
            this.cancelAllThreads();
        }
        if ((len = (localMemories = this.topui.getMemoryView().getLocalMemories()).size()) > 0) {
            local = true;
            if (this.localWorkers.size() > 0) {
                this.localWorkers.clear();
            }
        }
        if (local) {
            for (Object object : localMemories) {
                Memory m = (Memory)object;
                if (!m.isCompareTargets()) continue;
                TMX tmx = m.getTMX();
                SegmentParser cparser = tmx.getParser();
                String full = this.getMemoryLookupText();
                String clean = this.getMemoryLookupTextCleaned();
                if (clean.trim().length() <= 0) continue;
                TMXResult result = cparser.getFromCache(clean);
                if (result == null) {
                    result = cparser.translateExact(full, clean, unit);
                }
                if (result == null || !result.targetDifferent) continue;
                difference = true;
                break;
            }
        }
        return difference;
    }

    private void searchGlossary(final GlossaryResource glossary) {
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ TranslateEvent this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                glossary.findGlossaryMatches(this.this$0);
                return null;
            }

            @Override
            protected void done() {
                if (this.isCancelled()) {
                    return;
                }
                this.this$0.countDownLatch();
            }
        };
        this.localWorkers.add(worker);
        worker.execute();
    }

    public void showPretranslated(final Memory mem) {
        SwingWorker worker = new SwingWorker(this){
            TMXResult result;
            final /* synthetic */ TranslateEvent this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                this.result = this.this$0.showPretranslatedBase(mem);
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                if (this.isCancelled()) {
                    return;
                }
                StringBuilder sb = new StringBuilder();
                if (this.result != null) {
                    String s3 = this.result.getHTMLResults();
                    sb.append(s3);
                }
                HTMLDocument cmemoryDoc = mem.getMemoryDoc();
                try {
                    cmemoryDoc.setInnerHTML(cmemoryDoc.getDefaultRootElement(), sb.toString());
                    mem.getMemoryPane().setCaretPosition(0);
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (IndexOutOfBoundsException ex) {
                    ex.printStackTrace();
                }
                finally {
                    if (this.result != null && sb.length() > 0) {
                        this.this$0.addTranslationResult(this.this$0.memoryLookupText, this.result, mem.isAutoAssemblingStopped());
                        this.this$0.countDownLatch();
                    } else {
                        this.this$0.translate(mem);
                    }
                }
            }
        };
        this.localWorkers.add(worker);
        worker.execute();
    }

    public TMXResult showPretranslatedBase(Memory ctm) {
        String clean;
        TMXResult result = null;
        TMX tmx = ctm.getTMX();
        SegmentParser cparser = tmx.getParser();
        result = cparser.getFromCache(clean = this.getMemoryLookupTextCleaned());
        if (result != null) {
            tmx.setTMXResult(result);
        }
        return result;
    }

    public synchronized void addTranslationResult(String segment, TMXResult result, boolean autoAssemblingStopped) {
        if (!autoAssemblingStopped) {
            List fragmentMatches = result.getFragmentMatches();
            this.putAutoMatches(fragmentMatches);
        }
        Object[] bf = result.getBestFuzzies();
        this.addBestFuzzies(bf);
        TranslationUnit ptu = result.getPerfectTranslationUnit();
        if (ptu != null) {
            this.addPerfectTU(result);
        }
    }

    public void addPerfectTU(TMXResult result) {
        int priority = result.getPriority();
        if (priority > this.perfectTUPriority) {
            this.perfectTUs.add(0, result);
            this.perfectTUPriority = priority;
        } else {
            this.perfectTUs.add(result);
        }
    }

    public void translate(final Memory ctm) {
        SwingWorker worker = new SwingWorker(this){
            TMXResult result = null;
            final /* synthetic */ TranslateEvent this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                this.result = this.this$0.searchBase(ctm);
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                if (this.isCancelled()) {
                    return;
                }
                StringBuilder sb = new StringBuilder();
                if (this.result != null) {
                    String matches = this.result.getHTMLResults();
                    if (this.result.hasMatches() && matches.length() > 0) {
                        sb.append(matches);
                    } else {
                        String s = ctm.getMemorySizeHTML();
                        sb.append(s);
                    }
                }
                HTMLDocument cmemoryDoc = ctm.getMemoryDoc();
                try {
                    cmemoryDoc.setInnerHTML(cmemoryDoc.getDefaultRootElement(), sb.toString());
                    ctm.getMemoryPane().setCaretPosition(0);
                }
                catch (BadLocationException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                catch (IndexOutOfBoundsException ex) {
                    ex.printStackTrace();
                }
                finally {
                    if (this.result != null) {
                        this.this$0.addTranslationResult(this.this$0.memoryLookupText, this.result, ctm.isAutoAssemblingStopped());
                    }
                    this.this$0.countDownLatch();
                }
            }
        };
        this.localWorkers.add(worker);
        worker.execute();
    }

    private void searchProz(final String query, final Proz proz) {
        if (query.length() > 0) {
            SwingWorker worker = new SwingWorker(this){
                final /* synthetic */ TranslateEvent this$0;
                {
                    this.this$0 = this$0;
                }

                public String doInBackground() {
                    proz.tanslate(query);
                    return null;
                }

                @Override
                protected void done() {
                    if (this.isCancelled()) {
                        return;
                    }
                    this.this$0.countDownLatch();
                }
            };
            this.localWorkers.add(worker);
            worker.execute();
        }
    }

    public void addBestFuzzies(Object[] b) {
        if (b != null) {
            this.bestFuzzies.add(b);
        }
    }

    public Object[] getBestFuzzies() {
        Object[] totalBest = new Object[AppPreferences.fuzzies];
        for (int k = 0; k < this.bestFuzzies.size(); ++k) {
            Object[] fuzz = (Object[])this.bestFuzzies.get(k);
            if (fuzz == null) continue;
            Object[] farray = fuzz;
            block1: for (int kk = 0; kk < farray.length; ++kk) {
                Object[] arr = (Object[])farray[kk];
                if (arr == null) continue;
                Integer oi = (Integer)arr[0];
                int pro = oi;
                for (int i = 0; i < totalBest.length; ++i) {
                    Object object = totalBest[i];
                    if (object != null) {
                        Object[] arrtotal = (Object[])object;
                        int bpro = (Integer)arrtotal[0];
                        if (pro <= bpro) continue;
                        for (int j = i; j < totalBest.length; ++j) {
                            object = totalBest[j];
                            totalBest[j] = arr;
                            if (object == null) continue block1;
                            arr = (Object[])object;
                        }
                        continue block1;
                    }
                    totalBest[i] = arr;
                    continue block1;
                }
            }
        }
        return totalBest;
    }

    private TMXResult searchBase(Memory ctm) {
        TMXResult result = null;
        TMX tmx = ctm.getTMX();
        SegmentParser cparser = tmx.getParser();
        if (cparser != null) {
            Project p = this.topui.getProjectView().getProject();
            XMLElement e = p.getCurrentTransUnit();
            String full = this.getMemoryLookupText();
            String clean = this.getMemoryLookupTextCleaned();
            if (clean.trim().length() > 0) {
                result = cparser.translate(full, clean, e, false);
                tmx.setTMXResult(result);
            }
        }
        return result;
    }

    private void putAutoMatches(List fragmentMatches) {
        for (FragmentMatch next : fragmentMatches) {
            this.fragmentsSet.add(next);
        }
    }

    public synchronized void addFragmentMatch(FragmentMatch fmatch) {
        boolean b = this.fragmentsSet.add(fmatch);
        if (!b && fmatch.getPriority() == 2 && (b = this.fragmentsSet.remove(fmatch))) {
            this.fragmentsSet.add(fmatch);
        }
    }

    public synchronized void addAssembledFragmentMatch(FragmentMatch fmatch) {
        String seg;
        Set mset;
        Prompter prompt;
        String source;
        boolean b = this.fragmentsSet.add(fmatch);
        if (!b && fmatch.getPriority() == 2 && (b = this.fragmentsSet.remove(fmatch))) {
            this.fragmentsSet.add(fmatch);
        }
        if ((source = fmatch.getSource()) == null || source.length() == 0) {
            return;
        }
        boolean lowQualityHit = false;
        int mtype = fmatch.getMatchTypeInt();
        int contextL = fmatch.getContexLevel();
        int hits = fmatch.getHitsNumber();
        if (mtype == 3 && contextL == 0 && hits <= AppPreferences.hitToAutoThreshold) {
            lowQualityHit = true;
        }
        if ((prompt = this.topui.getSourceView().getPrompter()) != null && !lowQualityHit) {
            boolean segmentMatch = fmatch.isSegmentMatch();
            String target = fmatch.getTarget();
            if (target != null) {
                if (segmentMatch) {
                    prompt.getAssembledPhrases(target, false);
                } else {
                    prompt.getAssembledPhrases(target, true);
                }
            }
        }
        if ((mset = (Set)this.autoMatchesMap.get(source)) == null) {
            LinkedHashSet<FragmentMatch> mset2 = new LinkedHashSet<FragmentMatch>(4);
            mset2.add(fmatch);
            this.autoMatchesMap.put(source, mset2);
        } else {
            mset.add(fmatch);
        }
        int minLen = 1;
        if (AppPreferences.noWordSeparatorSourceLanguage) {
            minLen = 0;
        }
        JTextPane tpane = this.topui.getSourcePane();
        StyledDocument doc = (StyledDocument)tpane.getDocument();
        Style styleGlossary = doc.getStyle("Terms");
        Style styleGlossaryLow = doc.getStyle("TermsLow");
        Style styleGlossaryHigh = doc.getStyle("TermsHigh");
        Style styleMemory = doc.getStyle("Phrases");
        Style styleMemoryLow = doc.getStyle("PhrasesLow");
        Style styleMemoryHigh = doc.getStyle("PhrasesHigh");
        Style stylePlaceables = doc.getStyle("Placeable");
        Color pc = (Color)stylePlaceables.getAttribute(StyleConstants.Background);
        int nonTranslatableRGB = pc.getRGB();
        Style stylePattern = doc.getStyle("Pattern");
        try {
            int len = doc.getLength();
            seg = doc.getText(0, len).toLowerCase();
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TranslateEvent.class.getName()).log(Level.SEVERE, null, ex);
            seg = "";
        }
        String frag = fmatch.getFragment();
        int priority = fmatch.getPriority();
        if (seg.length() > 0 && mtype != 7 && frag != null && frag.length() > minLen) {
            frag = frag.toLowerCase();
            int rt = fmatch.getResourceType();
            int wi = seg.indexOf(frag, 0);
            while (wi != -1) {
                int cRGB;
                Element elem = doc.getCharacterElement(wi);
                AttributeSet as = elem.getAttributes();
                Color c = StyleConstants.getBackground(as);
                if (c != null && (cRGB = c.getRGB()) == nonTranslatableRGB) {
                    wi = seg.indexOf(frag, wi + frag.length());
                    continue;
                }
                if (rt == 1) {
                    if (!AppPreferences.hideMatchColorInSource) {
                        if (priority == 0) {
                            doc.setCharacterAttributes(wi, frag.length(), styleMemoryLow, false);
                        } else if (priority == 2) {
                            doc.setCharacterAttributes(wi, frag.length(), styleMemoryHigh, false);
                        } else {
                            doc.setCharacterAttributes(wi, frag.length(), styleMemory, false);
                        }
                    }
                } else if (!AppPreferences.hideMatchColorInSource2) {
                    if (priority == 0) {
                        doc.setCharacterAttributes(wi, frag.length(), styleGlossaryLow, false);
                    } else if (priority == 2) {
                        doc.setCharacterAttributes(wi, frag.length(), styleGlossaryHigh, false);
                    } else {
                        doc.setCharacterAttributes(wi, frag.length(), styleGlossary, false);
                    }
                }
                if (mtype == 8) {
                    doc.setCharacterAttributes(wi, frag.length(), stylePattern, false);
                }
                wi = seg.indexOf(frag, wi + frag.length());
            }
        }
    }

    public int getResultCount() {
        return this.fragmentsSet.size();
    }

    public Set getFragments() {
        return this.fragmentsSet;
    }

    public Map getAutoMatchesMap() {
        if (this.translationResult != null) {
            return this.translationResult.getMatchesMap();
        }
        return null;
    }

    public String getBestTranslation() {
        return this.autoTranslation;
    }

    public int getAssembledAccuracy() {
        return this.assembledAccuracy;
    }

    public int getBestAccuracy() {
        return this.autoTranslationAccuracy;
    }

    public int getContextAccuracy() {
        return this.contextAccuracy;
    }

    public int getFuzzyAccuracy() {
        return this.fuzzyMatchAccuracy;
    }

    public boolean hasTagsTransferred() {
        return this.tagsInserted;
    }

    public boolean isBestFuzzyMatch() {
        return this.isBestFuzzyMatch;
    }

    public TranslationResult getTranslationResult() {
        return this.translationResult;
    }

    public synchronized void clearAutoMatch() {
        MatchBoard mb;
        Prompter auto;
        HunSpellChecker checker = this.topui.getSpellChecker();
        if (checker != null) {
            checker.clearMisspelledWords();
        }
        if ((auto = this.topui.getSourceView().getPrompter()) != null) {
            auto.clearPhrases();
        }
        if ((mb = this.topui.getMatchBoard()) != null) {
            mb.clearMatchBoard();
        }
        if (!this.bestFuzzies.isEmpty()) {
            this.bestFuzzies.clear();
        }
        if (!this.perfectTUs.isEmpty()) {
            this.perfectTUs.clear();
        }
        if (!this.fragmentsSet.isEmpty()) {
            this.fragmentsSet.clear();
        }
        this.translationResult = null;
        this.perfectTUPriority = 0;
        this.fuzzyMatchAccuracy = 0;
        this.assembledAccuracy = 0;
        this.contextAccuracy = 0;
        this.resultsCount = 0;
        this.autoTranslation = null;
        this.autoTranslationAccuracy = 0;
        this.isBestFuzzyMatch = false;
        this.tagsInserted = false;
    }

    public void adjustSegmentFragments(String source, String target) {
        Project project = this.topui.getProjectView().getProject();
        if (project == null) {
            return;
        }
        BreakIterator sourceWordsIterator = project.getSourceBreakIterator();
        BreakIterator targetWordsIterator = project.getTargetBreakIterator();
        for (FragmentMatch fm : this.fragmentsSet) {
            int p;
            String skey = fm.getSource();
            String svalue = fm.getTarget();
            int i = source.indexOf(skey);
            int j = target.indexOf(svalue);
            if (i == -1 || j == -1) continue;
            AssembleParser.addToSuperGlossary(skey, svalue);
            if (skey.length() <= 3 || svalue.length() <= 3) continue;
            sourceWordsIterator.setText(source);
            int f = sourceWordsIterator.following(i + skey.length());
            if (f == -1) {
                f = i + skey.length();
            }
            if ((p = sourceWordsIterator.preceding(i)) == -1) {
                p = i;
            }
            String skey2 = source.substring(p, f).trim();
            targetWordsIterator.setText(target);
            f = targetWordsIterator.following(j + svalue.length());
            if (f == -1) {
                f = j + svalue.length();
            }
            if ((p = targetWordsIterator.preceding(j)) == -1) {
                p = j;
            }
            String svalue2 = target.substring(p, f).trim();
            if (skey2.length() == skey.length() && svalue2.length() == svalue.length()) continue;
            AssembleParser.addToSuperGlossary(skey2, svalue2);
        }
    }
}

