/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.util.ResourceBundle;
import translator.AppPreferences;
import translator.XMLHelper;

public class WordCount {
    int tcharacters = 0;
    int tnowhites = 0;
    int twords = 0;
    float tprice = 0.0f;
    private String[] fields = new String[]{"0", "words", "0.0", "dollars"};
    int number;
    String unit;
    float amount;
    String currency;
    String wordsName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("WORDS");
    String charactersName = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHARACTERS");

    public WordCount() {
        String[] sfields = AppPreferences.billing.split("\\s");
        if (sfields != null && sfields.length == 4) {
            this.fields = sfields;
        }
        String num = this.fields[0];
        String am = this.fields[2];
        if (num != null && am != null) {
            this.number = Integer.parseInt(num);
            this.amount = Float.parseFloat(am);
            this.unit = this.fields[1];
            this.currency = this.fields[3];
        }
    }

    public void setCharsCount(int c) {
        this.tnowhites = c;
    }

    public void setAllCharsCount(int c) {
        this.tcharacters = c;
    }

    public void setWordCount(int c) {
        this.twords = c;
    }

    public int getCharsCount() {
        return this.tnowhites;
    }

    public int getAllCharsCount() {
        return this.tcharacters;
    }

    public int getWordCount() {
        return this.twords;
    }

    public String getCountMessage() {
        String billing = "";
        if (this.unit != null && this.currency != null) {
            if (this.unit.equals("x-characters")) {
                this.tprice = (float)this.tcharacters * this.amount / (float)this.number;
            } else if (this.unit.equals("characters")) {
                this.tprice = (float)this.tnowhites * this.amount / (float)this.number;
            } else if (this.unit.equals("words")) {
                this.tprice = (float)this.twords * this.amount / (float)this.number;
            }
            this.tprice = this.round(this.tprice, 2);
            if (this.tprice > 0.0f) {
                String val = String.valueOf(this.tprice);
                billing = val + " " + this.currency;
            }
        }
        return billing;
    }

    public void setBilling() {
        if (this.unit != null && this.currency != null) {
            if (this.unit.equals("x-characters")) {
                this.tprice = (float)this.tcharacters * this.amount / (float)this.number;
            } else if (this.unit.equals("characters")) {
                this.tprice = (float)this.tnowhites * this.amount / (float)this.number;
            } else if (this.unit.equals("words")) {
                this.tprice = (float)this.twords * this.amount / (float)this.number;
            }
        }
    }

    float round(float val, int places) {
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(val *= (float)factor);
        return (float)tmp / (float)factor;
    }

    public void doWordCount(String ctext) {
        int characters;
        if ((ctext = XMLHelper.parseTags(ctext)) == null || ctext.length() == 0) {
            return;
        }
        char[] chars = ctext.toCharArray();
        int nowhites = characters = chars.length;
        char space = chars[characters - 1];
        int words = characters == 0 || space == ' ' || space == '\n' || space == '\r' || space == '\t' || space == '\u3000' || space == '\u00a0' ? 0 : 1;
        boolean word = false;
        block3: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\u00a0': 
                case '\u3000': {
                    --nowhites;
                    if (!word) continue block3;
                    ++words;
                    word = false;
                    continue block3;
                }
                default: {
                    word = true;
                }
            }
        }
        this.tcharacters += characters;
        this.tnowhites += nowhites;
        this.twords += words;
    }

    public void doCJKVWordCount(String ctext) {
        int characters;
        if ((ctext = XMLHelper.parseTags(ctext)) == null || ctext.length() == 0) {
            return;
        }
        char[] chars = ctext.toCharArray();
        int nowhites = characters = chars.length;
        int words = 0;
        block3: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\u00a0': 
                case '\u3000': {
                    --nowhites;
                    continue block3;
                }
                default: {
                    char codepoint = c;
                    if (!Character.isIdeographic(codepoint) && (c < '\uff00' || c > '\uffef') && c != '\u3001' && c != '\u3002' && c != '\u3010' && c != '\u3011' && c != '\u300c' && c != '\u300d' && c != '\u300e' && c != '\u300f' && c != '\u300a' && c != '\u300b' && c != '\u3008' && c != '\u3009' && c != '\u22ef' && c != '\u2026' && c != '\u2025' && c != '\u303d' && c != '\u301c') continue block3;
                    ++words;
                }
            }
        }
        this.tcharacters += characters;
        this.tnowhites += nowhites;
        this.twords += words;
    }

    public void reset() {
        this.tcharacters = 0;
        this.tnowhites = 0;
        this.twords = 0;
    }
}

