/*
 * Decompiled with CFR 0.152.
 */
package translator;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import translator.AppPreferences;
import translator.MainView;
import translator.Project;
import translator.ProjectView;
import translator.ResourceView;
import translator.StatisticsView;
import translator.Translatable;
import translator.Workflow;
import translator.XMLElement;
import translator.ai.CTLinguist;
import translator.tmx.TMX;
import translator.translatables.MSOfficeDocumentReview;
import translator.ttx.TTX;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;
import translator.xliff.XliffFile;
import translator.xliff.XliffWorkflow;

public class WorkflowManager {
    private Workflow process;
    private Workflow process2;
    private MainView topui;
    private ProjectView prview;
    private int snumber = 0;
    private boolean review = false;
    private Timer timer;
    private boolean timerStandby;
    public static boolean suspendQATagsCheck = false;
    public static boolean suspendAutosave = false;
    public static boolean workflowStarted;
    ActionListener timerNextAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (AppPreferences.autopilot) {
                        WorkflowManager.this.reviewNext(true);
                    }
                }
            });
        }
    };

    public WorkflowManager(MainView topui) {
        this.topui = topui;
        this.prview = topui.getProjectView();
        this.setTimer(AppPreferences.autopilot);
    }

    public void setReview(boolean rev) {
        this.review = rev;
        if (!rev) {
            this.standByTimer(false);
        }
        if (this.review) {
            if (this.process != null && !this.process.hasSegments()) {
                this.process.saveCurrentContext();
            }
        } else if (this.process != null && this.process.hasSegments()) {
            this.process.resetSegments();
        }
    }

    public boolean isReview() {
        return this.review;
    }

    void reviewFirst() {
        if (!workflowStarted) {
            workflowStarted = true;
        }
        if (!this.review) {
            this.review = true;
        }
        Project project = this.prview.getProject();
        project.editFirst();
    }

    void reviewCurrent() {
        if (!this.review) {
            this.review = true;
        }
        Project project = this.prview.getProject();
        project.editCurrent();
    }

    void reviewLast() {
        if (!this.review) {
            this.review = true;
        }
        Project project = this.prview.getProject();
        project.editLast();
    }

    void reviewNext(boolean timer) {
        boolean stop;
        if (!this.review) {
            this.review = true;
        }
        Project project = this.prview.getProject();
        if (!timer && AppPreferences.autopilot && (stop = this.stopTimer())) {
            return;
        }
        if (AppPreferences.autopilot) {
            this.standByTimer(true);
        }
        project.edit("#-1");
        if (AppPreferences.autopilot) {
            XLIFFUnit tu;
            int len;
            XMLElement unit;
            if (!AppPreferences.autopilotDelayMode && (unit = project.getCurrentTransUnit()) != null && unit instanceof XLIFFUnit && (len = (tu = (XLIFFUnit)unit).getSourceTextLength()) > 0) {
                if (len > 10) {
                    float f = (float)len / 10.0f * (float)AppPreferences.autopilotDelayVariable;
                    int del = (int)f;
                    this.setTimerDelay(del);
                } else {
                    this.setTimerDelay(AppPreferences.autopilotDelayVariable);
                }
            }
            if (this.review && this.timerStandby) {
                this.startTimer();
            }
        }
    }

    void reviewAppend(boolean timer) {
        boolean stop;
        if (!this.review) {
            this.review = true;
        }
        Project project = this.prview.getProject();
        if (!timer && AppPreferences.autopilot && (stop = this.stopTimer())) {
            return;
        }
        if (AppPreferences.autopilot) {
            this.standByTimer(true);
        }
        project.edit("#-3");
        if (AppPreferences.autopilot && this.review && this.timerStandby) {
            this.startTimer();
        }
    }

    void reviewPrevious() {
        boolean stop;
        if (!workflowStarted) {
            this.start();
            return;
        }
        if (!this.review) {
            this.review = true;
        }
        if (AppPreferences.autopilot && (stop = this.stopTimer())) {
            return;
        }
        Project project = this.prview.getProject();
        project.edit("#-2");
    }

    public void joinSegment(boolean source) {
        XliffWorkflow xflow;
        XLIFF xliff;
        Project project = this.prview.getProject();
        if (project != null && (xliff = project.getXLIFF()) != null && (xflow = xliff.getWorkflow()) != null) {
            if (source) {
                xflow.joinTUSource();
            } else {
                xflow.joinTUTarget();
            }
        }
    }

    public void deleteSegment() {
        XliffWorkflow xflow;
        XLIFF xliff;
        Project project = this.prview.getProject();
        if (project != null && (xliff = project.getXLIFF()) != null && (xflow = xliff.getWorkflow()) != null) {
            xflow.removeTU();
        }
    }

    public void start() {
        int tmode;
        workflowStarted = true;
        Project project = this.prview.getProject();
        TMX tmx = project.getTMX();
        if (tmx != null) {
            this.reviewNext(false);
            return;
        }
        TTX ttx = project.getTTX();
        if (ttx != null) {
            this.reviewCurrent();
            return;
        }
        XLIFF xliff = project.getXLIFF();
        if (xliff == null) {
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO PROJECT IS CREATED!"));
            return;
        }
        if (!xliff.isCafeTranXLIFF || xliff.isDocumentBilingual || xliff.isPO) {
            this.reviewCurrent();
            return;
        }
        if (project.glue) {
            this.reviewNext(false);
            return;
        }
        XliffFile pfile = xliff.getCurrentFile();
        if (pfile == null) {
            project.createFile(false);
            return;
        }
        if (this.review) {
            project.cancelReviewMode();
            return;
        }
        this.endTranslation();
        this.snumber = 0;
        Translatable trans1 = null;
        Translatable trans2 = null;
        if (project.align) {
            ResourceView rv = this.topui.getResourceView();
            Translatable[] translatable = rv.getTranslatable();
            trans1 = translatable[0];
            trans2 = translatable[1];
            if (trans2 == null) {
                trans2 = project.getAlignedTranslatable();
            }
            if (trans1 == null || trans2 == null) {
                JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SELECT DOCUMENTS TAB FOR ALIGNMENT!"));
                return;
            }
            boolean allAlignButtons = false;
            if (project.autoalign || project.mode == 1) {
                allAlignButtons = true;
            }
            this.topui.getTabView().setAlignmentBar(allAlignButtons);
            this.topui.getTabView().setAlignmentMenu(allAlignButtons);
            if (project.autoalign) {
                this.reviewNext(false);
                return;
            }
        } else {
            String ph = project.getPhase();
            if (ph != null && ph.equals("Review") && project.mode == 0) {
                this.reviewCurrent();
                return;
            }
            trans1 = project.getTranslatable();
            if (trans1 == null) {
                ResourceView rv = this.topui.getResourceView();
                Translatable[] translatable = rv.getTranslatable();
                if (translatable[0] != null) {
                    trans1 = translatable[0];
                } else if (translatable[1] != null) {
                    trans1 = translatable[1];
                }
            }
        }
        this.process = new Workflow(this.topui);
        this.process.setTranslatable(trans1);
        if (this.process.unclean) {
            xliff.setSegmentSeparator(AppPreferences.segFormat);
        } else {
            xliff.setSegmentSeparator(AppPreferences.segmentSeparator);
        }
        boolean s = this.process.start();
        if (!s) {
            return;
        }
        project.initWorkflow(this.process);
        if (trans2 != null) {
            this.process2 = new Workflow(this.topui);
            this.process2.align = true;
            this.process2.justStarted = this.process.justStarted;
            this.process2.setPanes(this.topui.getTargetPane(), this.topui.getSourcePane());
            this.process2.setTranslatable(trans2);
            boolean ss = this.process2.start();
            if (!ss) {
                this.process2 = null;
            } else {
                this.process.setAlignmentWorkflow(this.process2);
            }
        }
        if (this.process.unclean) {
            String phase = project.getPhase();
            if (phase != null && phase.equals("Review")) {
                this.reviewCurrent();
            } else {
                this.process.automateUncleaned();
                project.setPhase("Review");
                this.reviewFirst();
            }
        } else if (project.mode == 1 && (tmode = this.process.getMode()) == 0) {
            this.autoNextSegment();
        }
    }

    void autoNextSegment() {
        if (this.process == null || this.process.getCurrentPosition() == -1) {
            return;
        }
        if (this.review) {
            Project project = this.prview.getProject();
            project.cancelReviewMode();
            return;
        }
        if (this.process != null) {
            this.process.automate();
            Project project = this.prview.getProject();
            if (project.align) {
                project.setPhase("Autoalignment");
                project.autoalign = true;
            } else {
                project.setPhase("Review");
            }
            this.reviewFirst();
            project.saveProject(false);
        }
    }

    void nextSegment(boolean save, int m, boolean timer) {
        CTLinguist gpt = this.topui.getResourceView().getCTLinguist();
        if (gpt != null) {
            gpt.newChat();
        }
        if (!workflowStarted) {
            this.start();
            return;
        }
        if (this.process == null) {
            this.reviewNext(false);
            return;
        }
        Project project = this.prview.getProject();
        if (project != null && project.autoalign) {
            if (save) {
                this.topui.getMemoryView().addToMemory();
            }
            this.reviewNext(false);
            if (AppPreferences.autosave > 0) {
                this.autoSave();
            }
            return;
        }
        boolean alignReview = this.review;
        if (this.process != null && (m & 2) != 2) {
            this.process.justStarted = false;
            if (project != null && !this.review && !project.align) {
                if (!suspendQATagsCheck) {
                    boolean ok = project.checkTagsQA();
                    if (!ok) {
                        return;
                    }
                } else {
                    suspendQATagsCheck = false;
                }
            }
            if (save) {
                this.topui.getMemoryView().addToMemory();
            }
            if (this.process.getCurrentPosition() == -1) {
                this.reviewNext(false);
                alignReview = this.review;
            } else if (!this.review) {
                boolean stop;
                if (!timer && !AppPreferences.autopilot && (stop = this.stopTimer())) {
                    return;
                }
                if (!AppPreferences.autopilot) {
                    this.standByTimer(true);
                }
                this.process.nextSegment();
                alignReview = this.review;
                if (!AppPreferences.autopilot) {
                    this.startTimer();
                }
            } else {
                this.reviewNext(false);
            }
            if (AppPreferences.autosave > 0) {
                this.autoSave();
            }
        }
        if (this.process2 != null && (m & 1) != 1) {
            this.process2.justStarted = false;
            if (!alignReview) {
                this.process2.align();
            } else if ((m & 2) == 2) {
                if (save) {
                    this.topui.getMemoryView().addToMemory();
                }
                this.reviewNext(false);
                if (AppPreferences.autosave > 0) {
                    this.autoSave();
                }
            }
        }
    }

    void skipSegmentInProgress() {
        if (!workflowStarted) {
            return;
        }
        if (this.process != null) {
            this.process.justStarted = false;
            this.process.align();
        }
        if (this.process2 != null) {
            this.process2.justStarted = false;
            this.process2.align();
        }
    }

    void appSegment(int m, boolean timer) {
        Project project = this.prview.getProject();
        boolean clipboard = false;
        if (project.mode == 3 && this.process != null && this.process.getCurrentPosition() != -1) {
            clipboard = true;
        }
        if (!project.align && !clipboard) {
            this.reviewAppend(false);
            return;
        }
        if (project.autoalign) {
            if ((m & 1) == 1) {
                this.joinSegment(true);
            } else if ((m & 2) == 2) {
                this.joinSegment(false);
            } else {
                this.reviewAppend(false);
            }
            return;
        }
        boolean alignReview = this.review;
        if (this.process != null && (m & 2) != 2) {
            if (!alignReview) {
                boolean stop;
                if (!timer && !AppPreferences.autopilot && (stop = this.stopTimer())) {
                    return;
                }
                if (!AppPreferences.autopilot) {
                    this.standByTimer(true);
                }
                this.process.appSegment();
                alignReview = this.review;
                if (!AppPreferences.autopilot) {
                    this.startTimer();
                }
            } else {
                this.joinSegment(true);
            }
        }
        if (this.process2 != null && (m & 1) != 1) {
            if (!alignReview) {
                this.process2.appAlign();
            } else {
                this.joinSegment(false);
            }
        }
    }

    void delete() {
        if (this.process == null || this.process.getCurrentPosition() == -1) {
            this.deleteSegment();
            return;
        }
        if (this.process != null) {
            if (!this.review) {
                this.skipSegmentInProgress();
            } else {
                this.deleteSegment();
            }
        }
    }

    private void autoSave() {
        ++this.snumber;
        if (this.snumber >= AppPreferences.autosave) {
            if (!suspendAutosave) {
                this.prview.saveProject();
                this.snumber = 0;
            } else {
                suspendAutosave = false;
            }
        }
    }

    public int getAutosaveStatus() {
        return this.snumber;
    }

    public void setAutoSaveStatus(int status) {
        this.snumber = status;
    }

    boolean previewTransDocument(String path) {
        if (this.process != null) {
            this.process.previewSegments(path);
            return true;
        }
        String title = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("START TRANSLATION");
        int n = JOptionPane.showConfirmDialog(this.topui, title, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATION IS NOT STARTED!"), 2);
        if (n == 0) {
            this.topui.getWorkflowView().start();
        }
        return false;
    }

    boolean previewTransDocumentWithNotes(String path) {
        if (this.process != null) {
            return this.process.previewSegmentsWithNotes(path);
        }
        String title = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("START TRANSLATION");
        int n = JOptionPane.showConfirmDialog(this.topui, title, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATION IS NOT STARTED!"), 2);
        if (n == 0) {
            this.topui.getWorkflowView().start();
        }
        return false;
    }

    boolean importSegmentsFromWord(String path) {
        Project project = this.topui.getProjectView().getProject();
        XLIFF xliff = project.getXLIFF();
        if (xliff != null && !xliff.isCafeTranXLIFF) {
            return false;
        }
        MSOfficeDocumentReview res = new MSOfficeDocumentReview();
        res.setMainView(this.topui);
        File file = new File(path);
        if (file.exists()) {
            res.loadFile(file, "", "UTF-8", null);
            boolean b = res.importToProject(project);
            return b;
        }
        return false;
    }

    boolean exportSegmentsToWord(String path, boolean notes) {
        Project project = this.topui.getProjectView().getProject();
        MSOfficeDocumentReview res = new MSOfficeDocumentReview();
        res.setMainView(this.topui);
        String lpath = AppPreferences.packagePath + "layouts/external/review.docx";
        File file = new File(lpath);
        if (file.exists()) {
            res.loadFile(file, "", "UTF-8", null);
            boolean b = res.exportForReview(project, path, notes);
            return b;
        }
        return false;
    }

    public boolean stopTranslation() {
        if (this.process == null) {
            return true;
        }
        int value = JOptionPane.showConfirmDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("STOP CURRENT TRANSLATION?"), "CafeTran", 0);
        switch (value) {
            case 0: {
                this.endTranslation();
                return true;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    public void endTranslation() {
        StatisticsView st;
        if (this.process == null) {
            return;
        }
        workflowStarted = false;
        this.topui.getWorkflowView().getWorkflowManager().setAutoSaveStatus(0);
        this.topui.resetSegmentsFilter();
        this.process.setSource("", false);
        this.process.setTarget("");
        int i = this.process.getMode();
        if (i == 1) {
            String t = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLIPBOARD");
            this.topui.getTabView().removeTab(t);
        }
        Project project = this.prview.getProject();
        if (AppPreferences.updateProjectStatistics && AppPreferences.pauseProjectStatistics && (st = this.topui.getStatisticsView()) != null) {
            st.pauseStatistics(false);
        }
        if (project != null) {
            long d = this.process.getTotalDuration();
            project.setDuration(Long.toString(d));
        }
        this.process = null;
        if (this.process2 != null) {
            this.process2 = null;
        }
        if (project != null) {
            if (this.review) {
                project.cancelReviewMode();
            }
            project.removeWorkflow();
            project.saveProject(false);
        }
    }

    public void setWorkflow(Workflow proc) {
        this.process = proc;
    }

    public Workflow getWorkflow() {
        return this.process;
    }

    public Workflow getAlignWorkflow() {
        return this.process2;
    }

    void setTimerDelay(int del) {
        if (this.timer != null) {
            this.timer.setDelay(del);
            this.timer.setInitialDelay(del);
        }
    }

    void setTimer(boolean isON) {
        if (isON) {
            int del = AppPreferences.autopilotDelayMode ? AppPreferences.autopilotDelayFixed : AppPreferences.autopilotDelayVariable;
            this.timer = new Timer(del, this.timerNextAction);
        } else {
            if (this.timer != null && this.timer.isRunning()) {
                this.timer.stop();
            }
            this.timer = null;
        }
    }

    boolean isTimerSet() {
        return this.timer != null;
    }

    boolean isTimerRunning() {
        return this.timer != null && (this.timer.isRunning() || this.timerStandby);
    }

    public void standByTimer(boolean standby) {
        if (this.timer != null) {
            this.timerStandby = standby;
        }
    }

    public boolean stopTimer() {
        if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
            return true;
        }
        return false;
    }

    public void startTimer() {
        if (this.timer != null) {
            this.timerStandby = false;
            if (this.timer.isRunning()) {
                this.timer.restart();
            } else {
                this.timer.start();
            }
        }
    }
}

