/*
 * Decompiled with CFR 0.152.
 */
package translator.ai;

import java.io.BufferedReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import translator.AppPreferences;
import translator.LanguageCodes;
import translator.json.JSONArray;
import translator.json.JSONObject;

class ClaudeAPI {
    private String SERVICE_URL = "https://api.anthropic.com/v1/messages";
    public static int tokens = 0;
    private BufferedReader input;
    private String APIKey = "";
    private StringBuilder logBuilder;
    private int statusCode;

    ClaudeAPI() {
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String chat(String text, String terms, boolean chatMode, LinkedHashMap<String, String> contexts) throws Exception {
        this.statusCode = -1;
        text = JSONObject.quote(text);
        this.APIKey = AppPreferences.claudeGPTAPIKey;
        String model = AppPreferences.claudeGPTModel.length() > 0 ? AppPreferences.claudeGPTModel : "claude-3-5-haiku-20241022";
        if (this.APIKey == null || this.APIKey.length() == 0) {
            throw new RuntimeException("Please set Claude API key");
        }
        StringBuilder context = new StringBuilder();
        String systemContext = "";
        if (AppPreferences.chatGPTPromptSystem.length() > 0) {
            String s = AppPreferences.chatGPTPromptSystem.replace("{source}", LanguageCodes.sourceLanguage);
            systemContext = s.replace("{target}", LanguageCodes.targetLanguage);
            context.append(systemContext);
        }
        String assistantContext = "";
        if (AppPreferences.chatGPTPromptAssistant.length() > 0 && !chatMode) {
            String s = AppPreferences.chatGPTPromptAssistant.replace("{source}", LanguageCodes.sourceLanguage);
            assistantContext = s.replace("{target}", LanguageCodes.targetLanguage);
            if (context.length() > 0) {
                context.append("\n");
            }
            context.append(assistantContext);
            if (terms != null && terms.length() > 0) {
                String t = "\n- Use the following phrases: " + terms;
                context.append(t);
            }
        }
        StringBuilder sb = new StringBuilder("{\"model\": \"" + model + "\", \"max_tokens\":4096,");
        if (context.length() > 0 && !chatMode) {
            String s = JSONObject.quote(context.toString());
            sb.append(" \"system\": ");
            sb.append(s);
            sb.append(",");
        }
        sb.append(" \"messages\": [\n");
        if (contexts != null && chatMode) {
            for (Map.Entry entry : contexts.entrySet()) {
                String u = (String)entry.getKey();
                String a = (String)entry.getValue();
                u = JSONObject.quote(u);
                a = JSONObject.quote(a);
                sb.append("{\"role\": \"user\", \"content\": " + u + "},\n");
                sb.append("{\"role\": \"assistant\", \"content\": " + a + "},\n");
            }
        }
        sb.append("{\"role\": \"user\", \"content\": " + text + "}]}");
        String requestBody = sb.toString();
        HttpClient httpClient = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.SERVICE_URL)).header("x-api-key", this.APIKey).header("anthropic-version", "2023-06-01").header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(requestBody, StandardCharsets.UTF_8)).build();
        HttpResponse<String> response = httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        this.statusCode = response.statusCode();
        String outputString = response.body();
        String content = "";
        JSONObject jResponse = new JSONObject(outputString);
        JSONArray jarr = jResponse.getJSONArray("content");
        for (int j = 0; j < jarr.length(); ++j) {
            JSONObject messageObject = jarr.getJSONObject(j);
            content = content + messageObject.getString("text");
        }
        int tt = 0;
        if (jResponse.has("usage")) {
            JSONObject usageObject = jResponse.getJSONObject("usage");
            tt = usageObject.getInt("input_tokens");
            tokens += (tt += usageObject.getInt("output_tokens"));
        }
        return content;
    }

    public String getError() {
        String e = null;
        if (this.statusCode == 200) {
            return e;
        }
        if (this.statusCode != -1) {
            e = "Claude API message: ";
        }
        if (this.statusCode == 400) {
            e = e + "there was an issue with the format or content of your request.";
        } else if (this.statusCode == 401) {
            e = e + "there\u2019s an issue with your API key.";
        } else if (this.statusCode == 403) {
            e = e + "your API key does not have permission to use the specified resource.";
        } else if (this.statusCode == 404) {
            e = e + "the requested resource was not found.";
        } else if (this.statusCode == 413) {
            e = e + "request exceeds the maximum allowed number of bytes";
        } else if (this.statusCode == 429) {
            e = e + "a rate limit has been hit.";
        } else if (this.statusCode == 500) {
            e = e + "an unexpected error has occurred internal to Anthropic\u2019s systems.";
        } else if (this.statusCode == 529) {
            e = e + "Anthropic\u2019s API is temporarily overloaded.";
        } else if (this.statusCode != -1) {
            e = "Claude API error " + Integer.toString(this.statusCode);
        }
        return e;
    }

    void closeConnection() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

