/*
 * Decompiled with CFR 0.152.
 */
package translator.ai;

import java.io.BufferedReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import translator.AppPreferences;
import translator.LanguageCodes;
import translator.json.JSONArray;
import translator.json.JSONObject;

class GeminiAPI {
    private String SERVICE_URL = "https://generativelanguage.googleapis.com/v1/models/";
    private BufferedReader input;
    private String APIKey = "";
    private StringBuilder logBuilder;
    private int statusCode;
    private String errorMessage;

    GeminiAPI() {
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String chat(String text, String terms, boolean chatMode, LinkedHashMap<String, String> contexts) throws Exception {
        String geminiURL = this.SERVICE_URL + AppPreferences.geminiGPTModel + ":generateContent";
        this.statusCode = -1;
        this.errorMessage = null;
        text = JSONObject.quote(text);
        this.APIKey = AppPreferences.geminiGPTAPIKey;
        if (this.APIKey == null || this.APIKey.length() == 0) {
            throw new RuntimeException("Please set Gemini API key");
        }
        StringBuilder context = new StringBuilder();
        String systemContext = "";
        if (AppPreferences.chatGPTPromptSystem.length() > 0) {
            String s = AppPreferences.chatGPTPromptSystem.replace("{source}", LanguageCodes.sourceLanguage);
            systemContext = s.replace("{target}", LanguageCodes.targetLanguage);
            context.append(systemContext);
        }
        String assistantContext = "";
        if (AppPreferences.chatGPTPromptAssistant.length() > 0 && !chatMode) {
            String s = AppPreferences.chatGPTPromptAssistant.replace("{source}", LanguageCodes.sourceLanguage);
            assistantContext = s.replace("{target}", LanguageCodes.targetLanguage);
            if (context.length() > 0) {
                context.append("\n");
            }
            context.append(assistantContext);
            if (terms != null && terms.length() > 0) {
                String t = "\n- Use the following phrases: " + terms;
                context.append(t);
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{ \"contents\": [");
        if (contexts != null && chatMode) {
            for (Map.Entry<String, String> entry : contexts.entrySet()) {
                String u = entry.getKey();
                String a = entry.getValue();
                u = JSONObject.quote(u);
                a = JSONObject.quote(a);
                sb.append("{\"role\":\"user\", \"parts\":[{\"text\": " + u + "}]},\n");
                sb.append("{\"role\":\"model\", \"parts\":[{\"text\": " + a + "}]},\n");
            }
        }
        StringBuffer q = new StringBuffer();
        if (!context.isEmpty() && !chatMode) {
            q.append(context.toString());
            q.append("\n");
        }
        q.append(text);
        String message = JSONObject.quote(q.toString());
        sb.append("{\"role\":\"user\", \"parts\":[{\"text\": " + message + "}]}]}");
        String requestBody = sb.toString();
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(geminiURL)).header("x-goog-api-key", this.APIKey).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(requestBody, StandardCharsets.UTF_8)).build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        this.statusCode = response.statusCode();
        String outputString = response.body();
        String content = "";
        JSONObject jResponse = new JSONObject(outputString);
        if (jResponse.has("error")) {
            String m;
            JSONObject errorObject = jResponse.getJSONObject("error");
            this.errorMessage = m = errorObject.getString("message");
            throw new Exception(m);
        }
        JSONArray jarr = jResponse.getJSONArray("candidates");
        for (int j = 0; j < jarr.length(); ++j) {
            JSONObject candidateObject = jarr.getJSONObject(j);
            if (!candidateObject.has("content")) continue;
            JSONObject contentObject = candidateObject.getJSONObject("content");
            JSONArray parts = contentObject.getJSONArray("parts");
            for (int k = 0; k < parts.length(); ++k) {
                JSONObject partObject = parts.getJSONObject(k);
                content = content + partObject.getString("text");
            }
            break;
        }
        if (content.length() == 0) {
            throw new Exception("Gemini has no content for this prompt.");
        }
        content = content.stripTrailing();
        return content;
    }

    public String getCallLog() {
        if (this.logBuilder != null && this.logBuilder.length() > 0) {
            return this.logBuilder.toString();
        }
        return null;
    }

    public String getError() {
        String e = null;
        if (this.statusCode == 200) {
            return e;
        }
        if (this.statusCode != -1) {
            e = "Gemini API message: ";
        }
        if (this.errorMessage != null) {
            e = "Gemini API message: " + this.errorMessage;
        } else if (this.statusCode == 400) {
            e = e + "there was an issue with the format or content of your request.";
        } else if (this.statusCode == 401) {
            e = e + "there\u2019s an issue with your API key.";
        } else if (this.statusCode == 403) {
            e = e + "your API key does not have permission to use the specified resource.";
        } else if (this.statusCode == 404) {
            e = e + "the requested resource was not found.";
        } else if (this.statusCode == 413) {
            e = e + "request exceeds the maximum allowed number of bytes";
        } else if (this.statusCode == 429) {
            e = e + "a rate limit has been hit.";
        } else if (this.statusCode == 500) {
            e = e + "an unexpected error has occurred internal to Google's systems.";
        } else if (this.statusCode == 529) {
            e = e + "Google API is temporarily overloaded.";
        } else if (this.statusCode != -1) {
            e = "Gemini API error " + Integer.toString(this.statusCode);
        }
        return e;
    }

    void closeConnection() {
        try {
            if (this.input != null) {
                this.input.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

