/*
 * Decompiled with CFR 0.152.
 */
package translator.browser;

import java.awt.EventQueue;
import javafx.application.Platform;

public abstract class Callback<T> {
    protected abstract void callImpl(T var1);

    protected abstract void callImplHTML(T var1);

    protected abstract void run(Runnable var1);

    protected abstract boolean isValidThread();

    public final void call(final T value) {
        if (this.isValidThread()) {
            this.callImpl(value);
        } else {
            this.run(new Runnable(){
                final /* synthetic */ Callback this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.callImpl(value);
                }
            });
        }
    }

    public final void callHTML(final T value) {
        if (this.isValidThread()) {
            this.callImplHTML(value);
        } else {
            this.run(new Runnable(){
                final /* synthetic */ Callback this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.callImplHTML(value);
                }
            });
        }
    }

    public static abstract class FX<T>
    extends Callback<T> {
        @Override
        protected final void run(Runnable task) {
            Platform.runLater((Runnable)task);
        }

        @Override
        protected final boolean isValidThread() {
            return Platform.isFxApplicationThread();
        }
    }

    public static abstract class EDT<T>
    extends Callback<T> {
        @Override
        protected final void run(Runnable task) {
            EventQueue.invokeLater(task);
        }

        @Override
        protected final boolean isValidThread() {
            return EventQueue.isDispatchThread();
        }
    }
}

