/*
 * Decompiled with CFR 0.152.
 */
package translator.browser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import translator.AppPreferences;
import translator.browser.SerializableHttpCookie;

public class PersistentCookieStore
implements CookieStore,
Runnable {
    private static final String COOKIE_NAME_PREFIX = "cookie_";
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, HttpCookie>> cookies;
    private final Preferences cookiePrefs;
    private HashSet<String> allowedHosts = new HashSet();
    private ReentrantLock lock = null;

    public PersistentCookieStore() {
        this.allowedHosts.add("google.com");
        this.allowedHosts.add("proz.com");
        this.allowedHosts.add("tm-town.com");
        this.allowedHosts.add("wikipedia.org");
        this.allowedHosts.add("cafetran.com");
        this.allowedHosts.add("microsoft.com");
        this.allowedHosts.add("live.com");
        this.allowedHosts.add("office.com");
        this.allowedHosts.add("bing.com");
        this.allowedHosts.add("languagetool.org");
        this.allowedHosts.add("pons.com");
        Preferences appPref = AppPreferences.getPreferences();
        this.cookiePrefs = appPref.node("cookies");
        this.cookies = new ConcurrentHashMap();
        try {
            String[] keys = this.cookiePrefs.keys();
            for (int i = 0; i < keys.length; ++i) {
                String[] cookieNames;
                String key = keys[i];
                String value = this.cookiePrefs.get(key, "");
                if (value == null || value.startsWith(COOKIE_NAME_PREFIX)) continue;
                for (String name : cookieNames = PersistentCookieStore.split(value, ",")) {
                    HttpCookie decodedCookie;
                    String encodedCookie = this.cookiePrefs.get(COOKIE_NAME_PREFIX + name, null);
                    if (encodedCookie == null || (decodedCookie = this.decodeCookie(encodedCookie)) == null) continue;
                    if (decodedCookie.hasExpired()) {
                        this.cookiePrefs.remove(COOKIE_NAME_PREFIX + name);
                        continue;
                    }
                    if (!this.cookies.containsKey(key)) {
                        this.cookies.put(key, new ConcurrentHashMap());
                    }
                    this.cookies.get(key).put(name, decodedCookie);
                }
            }
            this.cookiePrefs.clear();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(PersistentCookieStore.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.lock = new ReentrantLock(false);
        Runtime.getRuntime().addShutdownHook(new Thread(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(URI uri, HttpCookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie is null");
        }
        this.lock.lock();
        try {
            long age = cookie.getMaxAge();
            if (age != 0L) {
                ConcurrentHashMap<String, HttpCookie> map;
                String host2 = uri.getHost();
                String host = this.getDomainName(host2);
                if (!this.cookies.containsKey(host)) {
                    this.cookies.put(host, new ConcurrentHashMap());
                }
                if ((map = this.cookies.get(host)) != null) {
                    String name = cookie.getName() + host;
                    if (cookie.hasExpired()) {
                        map.remove(name);
                    } else {
                        map.put(name, cookie);
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HttpCookie> get(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is null");
        }
        boolean secureLink = "https".equalsIgnoreCase(uri.getScheme());
        ArrayList<HttpCookie> ret = new ArrayList<HttpCookie>();
        this.lock.lock();
        try {
            String host2 = uri.getHost();
            String host = this.getDomainName(host2);
            if (this.cookies.containsKey(host)) {
                ConcurrentHashMap<String, HttpCookie> map = this.cookies.get(host);
                Collection<HttpCookie> vals = map.values();
                Iterator<HttpCookie> iterator = vals.iterator();
                while (iterator.hasNext()) {
                    HttpCookie next = iterator.next();
                    if (next.hasExpired()) {
                        iterator.remove();
                        continue;
                    }
                    if (!secureLink && next.getSecure()) continue;
                    ret.add(next);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return ret;
    }

    @Override
    public boolean removeAll() {
        this.lock.lock();
        try {
            this.cookies.clear();
            this.cookiePrefs.clear();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(PersistentCookieStore.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(URI uri, HttpCookie cookie) {
        boolean modified = false;
        this.lock.lock();
        try {
            String host = uri.getHost();
            host = this.getDomainName(host);
            String name = cookie.getName() + host;
            if (this.cookies.containsKey(host) && this.cookies.get(host).containsKey(name)) {
                this.cookies.get(host).remove(name);
                this.cookiePrefs.remove(COOKIE_NAME_PREFIX + name);
                this.cookiePrefs.put(host, PersistentCookieStore.join(",", this.cookies.get(host).keySet()));
                modified = true;
            }
        }
        finally {
            this.lock.unlock();
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HttpCookie> getCookies() {
        ArrayList<HttpCookie> ret = new ArrayList<HttpCookie>();
        this.lock.lock();
        try {
            for (String key : this.cookies.keySet()) {
                ret.addAll(this.cookies.get(key).values());
            }
            Iterator iterator = ret.iterator();
            while (iterator.hasNext()) {
                HttpCookie next = (HttpCookie)iterator.next();
                if (!next.hasExpired()) continue;
                iterator.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<URI> getURIs() {
        ArrayList<URI> ret = new ArrayList<URI>();
        this.lock.lock();
        try {
            for (String key : this.cookies.keySet()) {
                try {
                    ret.add(new URI(key));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return ret;
    }

    protected String encodeCookie(SerializableHttpCookie cookie) {
        if (cookie == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ObjectOutputStream outputStream = new ObjectOutputStream(os);
            outputStream.writeObject(cookie);
        }
        catch (IOException e) {
            return null;
        }
        return this.byteArrayToHexString(os.toByteArray());
    }

    protected HttpCookie decodeCookie(String cookieString) {
        byte[] bytes = this.hexStringToByteArray(cookieString);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        HttpCookie cookie = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            cookie = ((SerializableHttpCookie)objectInputStream.readObject()).getCookie();
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return cookie;
    }

    protected String byteArrayToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte element : bytes) {
            int v = element & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase(Locale.US);
    }

    protected byte[] hexStringToByteArray(String hexString) {
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }

    public static String join(CharSequence delimiter, Iterable tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static String[] split(String text, String expression) {
        if (text.length() == 0) {
            return new String[0];
        }
        return text.split(expression, -1);
    }

    private String getDomainName(String host) {
        String[] levels = host.split("\\.");
        if (levels.length > 1) {
            host = levels[levels.length - 2] + "." + levels[levels.length - 1];
        }
        return host;
    }

    public void addSafeHost(String host) {
        if (host != null && host.length() > 0 && !this.allowedHosts.contains(host = this.getDomainName(host))) {
            this.allowedHosts.add(host);
        }
    }

    private URI getEffectiveURI(URI uri) {
        URI effectiveURI = null;
        try {
            effectiveURI = new URI("http", uri.getHost(), null, null, null);
        }
        catch (URISyntaxException ignored) {
            effectiveURI = uri;
        }
        return effectiveURI;
    }

    private boolean netscapeDomainMatches(String domain, String host) {
        if (domain == null || host == null) {
            return false;
        }
        boolean isLocalDomain = ".local".equalsIgnoreCase(domain);
        int embeddedDotInDomain = domain.indexOf(46);
        if (embeddedDotInDomain == 0) {
            embeddedDotInDomain = domain.indexOf(46, 1);
        }
        if (!(isLocalDomain || embeddedDotInDomain != -1 && embeddedDotInDomain != domain.length() - 1)) {
            return false;
        }
        int firstDotInHost = host.indexOf(46);
        if (firstDotInHost == -1 && isLocalDomain) {
            return true;
        }
        int domainLength = domain.length();
        int lengthDiff = host.length() - domainLength;
        if (lengthDiff == 0) {
            return host.equalsIgnoreCase(domain);
        }
        if (lengthDiff > 0) {
            String H = host.substring(0, lengthDiff);
            String D = host.substring(lengthDiff);
            return D.equalsIgnoreCase(domain);
        }
        if (lengthDiff == -1) {
            return domain.charAt(0) == '.' && host.equalsIgnoreCase(domain.substring(1));
        }
        return false;
    }

    private static URI cookieUri(URI uri, HttpCookie cookie) {
        URI cookieUri = uri;
        if (cookie.getDomain() != null) {
            String domain = cookie.getDomain();
            if (domain.charAt(0) == '.') {
                domain = domain.substring(1);
            }
            try {
                cookieUri = new URI(uri.getScheme() == null ? "http" : uri.getScheme(), domain, cookie.getPath() == null ? "/" : cookie.getPath(), null);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return cookieUri;
    }

    @Override
    public synchronized void run() {
        Set uris = this.cookies.keySet();
        for (String host : uris) {
            Map map;
            if (!this.allowedHosts.contains(host) || (map = (Map)this.cookies.get(host)) == null) continue;
            String joined = PersistentCookieStore.join(",", map.keySet());
            if (joined.length() < 8192) {
                this.cookiePrefs.put(host, joined);
            }
            for (Map.Entry entrySet : map.entrySet()) {
                String v;
                String name = (String)entrySet.getKey();
                HttpCookie cookie = (HttpCookie)entrySet.getValue();
                long age = cookie.getMaxAge();
                if (cookie.hasExpired() || age == -1L || (v = this.encodeCookie(new SerializableHttpCookie(cookie))) == null || v.length() >= 8192) continue;
                this.cookiePrefs.put(COOKIE_NAME_PREFIX + name, v);
            }
            try {
                this.cookiePrefs.flush();
            }
            catch (BackingStoreException ex) {
                Logger.getLogger(PersistentCookieStore.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

