/*
 * Decompiled with CFR 0.152.
 */
package translator.browser;

import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import translator.AppPreferences;
import translator.DefaultResource;
import translator.MainView;
import translator.MySwingWorker;
import translator.ResourceInfo;
import translator.ResourceView;
import translator.TabView;
import translator.TransparentBackground;
import translator.TransparentBackgroundListener;
import translator.browser.Browser;
import translator.browser.WebPane;
import translator.javafx.FX;
import translator.ui.HTMLFormat;

public class WebResourceFX
extends DefaultResource {
    private MainView topui;
    private TabView tview;
    private ResourceView rview;
    private String prefix;
    private String suffix;
    private String charset;
    private String infopath;
    private String path;
    private String service;
    private String command;
    private String[] extCommand;
    private URL url;
    private JLabel statusBar;
    private TransparentBackground tbg;
    private boolean transparentTab = true;
    private boolean inFrame = false;
    private boolean start = false;
    private boolean running;
    private String resourceName;
    private MySwingWorker worker;
    private Desktop desktop;
    private boolean postMethod = false;
    private boolean blockJavaScript = false;
    private WebPane webPane;
    private String tableEnd = "</body></html>";
    public static int browsers = 0;
    private static boolean cookieManagerReset = false;
    private int realTimePreview = -1;
    private boolean canSearchOnline = true;
    private boolean isMT = false;
    private boolean isQA = false;
    private String uid = Integer.toString(ResourceView.uniqueResourceID++);

    public WebResourceFX(String path, String name, boolean externalBrowser, boolean inFrame, int realTimePreview) {
        this.path = path;
        this.infopath = null;
        this.charset = System.getProperty("file.encoding");
        if (!externalBrowser) {
            this.canSearchOnline = false;
        }
        this.inFrame = inFrame;
        this.realTimePreview = realTimePreview;
        this.service = null;
        this.transparentTab = false;
        this.resourceName = name != null ? name : "Web Page";
        if (externalBrowser) {
            this.command = "System";
        } else {
            this.command = "CafeTran";
            this.transparentTab = true;
        }
        if (!(!this.command.equals("System") || Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE))) {
            this.command = "CafeTran";
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SYSTEM BROWSER IS NOT SUPPORTED ON YOUR SYSTEM."), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SYSTEM INFORMATION"), 1);
        }
    }

    public WebResourceFX(ResourceInfo ri) {
        this.path = ri.getResourceAddress();
        this.infopath = ri.getInfoPath();
        this.charset = ri.getEncoding();
        this.prefix = ri.getPrefix();
        if (this.prefix.startsWith("@")) {
            this.postMethod = true;
            this.prefix = this.prefix.substring(1);
        } else {
            this.postMethod = ri.getMethod();
        }
        this.suffix = ri.getSuffix();
        if (this.path != null) {
            this.canSearchOnline = false;
            if (this.prefix.length() == 0) {
                this.canSearchOnline = false;
            }
            if (this.path.equals("https://languagetool.org")) {
                this.isQA = true;
            }
        }
        String mtPath = null;
        if (this.path != null && this.path.length() > 0) {
            mtPath = this.path;
        } else if (this.prefix != null && this.prefix.length() > 0) {
            mtPath = this.prefix;
        }
        if (mtPath != null && (mtPath.indexOf("www.deepl.com") != -1 || mtPath.indexOf("://translate.google") != -1 || mtPath.indexOf("www.bing.com/translator") != -1 || mtPath.indexOf("mymemory.translated.net") != -1 || mtPath.indexOf("translate.systran.net") != -1 || mtPath.indexOf("www.modernmt.com/translate") != -1 || mtPath.indexOf("fanyi.youdao.com") != -1)) {
            this.isMT = true;
            if (this.path == null) {
                this.path = this.prefix + "Hello" + this.suffix;
            }
        }
        this.command = AppPreferences.browser;
        this.service = ri.getService();
        int i = this.infopath.lastIndexOf(AppPreferences.fs);
        if (i == -1) {
            i = this.infopath.lastIndexOf(47);
        }
        this.resourceName = i != -1 ? this.infopath.substring(i + 1, this.infopath.length() - 4) : this.path;
        if (this.service != null) {
            this.service = this.service.toLowerCase();
            if (this.service.indexOf("system browser") != -1) {
                this.command = "System";
            } else if (this.service.equals("translation")) {
                this.isMT = true;
                this.command = "CafeTran";
            }
        } else {
            this.command = AppPreferences.browser;
        }
        if (!(!this.command.equals("System") || Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE))) {
            this.command = "CafeTran";
            JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SYSTEM BROWSER IS NOT SUPPORTED ON YOUR SYSTEM."), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SYSTEM INFORMATION"), 1);
        }
    }

    @Override
    public void setMainView(MainView topui) {
        this.topui = topui;
        this.tview = topui.getTabView();
        this.rview = topui.getResourceView();
        this.statusBar = topui.getMainStatusBar();
        if (this.command.equalsIgnoreCase("CafeTran")) {
            if (this.resourceName != null && this.inFrame) {
                this.createFrame(this.resourceName);
            } else if (this.resourceName != null && this.resourceName.equals("Cloud Jobs")) {
                this.createFrame(this.resourceName);
            } else {
                this.createHTMLTab();
            }
        } else if (this.command.startsWith("System")) {
            if (this.transparentTab) {
                this.tbg = new TransparentBackground(topui);
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                this.tbg.setPreferredSize(dim);
                JScrollPane pane = new JScrollPane();
                pane.getVerticalScrollBar().setUnitIncrement(10);
                pane.getViewport().add(this.tbg);
                pane.setName(this.uid);
                this.tview.addTab(this, this.resourceName, pane);
            }
            if (this.path != null) {
                if (this.path.startsWith("www")) {
                    this.path = "http://" + this.path;
                }
                if (this.path.startsWith("http") || this.path.startsWith("file:")) {
                    this.search(this.path, null);
                    topui.repaint();
                }
            }
        }
    }

    public boolean isMTWebResurces() {
        return this.isMT;
    }

    public boolean isQAWebResurces() {
        return this.isQA;
    }

    public int getRealTimePreview() {
        return this.realTimePreview;
    }

    public void setTransparentTab(boolean ttab) {
        this.transparentTab = ttab;
    }

    public boolean hasTransparentTab() {
        return this.transparentTab;
    }

    public boolean hasExternalBrowser() {
        return this.command != null && this.command.startsWith("System");
    }

    public void transferToTargetSegment() {
        if (this.webPane != null) {
            this.webPane.getBrowser().executeTransferScript();
        }
    }

    public void bindWebpageEditor() {
        if (this.webPane != null) {
            this.webPane.getBrowser().executeBindScript();
        }
    }

    public void focusTextBox() {
        if (this.webPane != null) {
            this.webPane.getJFXPanel().requestFocusInWindow();
            this.webPane.getBrowser().executeFocusScript();
        }
    }

    @Override
    public void search(String okey, String rep) {
        if (this.realTimePreview != -1) {
            return;
        }
        if (!this.canSearchOnline || this.isMT) {
            if (this.webPane != null) {
                this.webPane.getBrowser().executeSearchStript(okey);
            }
            return;
        }
        final String key = okey;
        this.worker = new MySwingWorker(this){
            final /* synthetic */ WebResourceFX this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object construct() {
                if (this.this$0.command.startsWith("System")) {
                    this.this$0.loadPageInSystemBrowser(key);
                } else {
                    JFrame jf = this.this$0.topui.getExtendedFrame();
                    if (jf != null && jf.getExtendedState() == 1 && this.this$0.topui.getTabView().tabExists(this.this$0.resourceName)) {
                        jf.setExtendedState(0);
                    }
                    this.this$0.find(key);
                }
                return null;
            }

            @Override
            public void finished() {
            }
        };
        this.worker.start();
    }

    private void loadPageInSystemBrowser(String address) {
        String request = address;
        if (request.startsWith("www.")) {
            request = "http://" + request;
        }
        if (!request.startsWith("http") && !request.startsWith("file:")) {
            int i = request.indexOf(47);
            if (i != -1) {
                String s1 = request.substring(0, i);
                String s2 = request.substring(i + 1);
                try {
                    s1 = URLEncoder.encode(s1, this.charset);
                    s2 = URLEncoder.encode(s2, this.charset);
                    request = s1 + "/" + s2;
                }
                catch (UnsupportedEncodingException ex) {
                    ex.printStackTrace();
                }
            } else {
                try {
                    request = URLEncoder.encode(request, this.charset);
                }
                catch (UnsupportedEncodingException ex) {
                    ex.printStackTrace();
                }
            }
            request = this.prefix + request + this.suffix;
            if (request.indexOf("|") != -1) {
                request = request.replace("|", "%7C");
            }
        }
        if (this.extCommand != null && this.extCommand.length > 0) {
            String s;
            String os;
            if (request.indexOf("&") != -1 && (os = System.getProperty("os.name")).startsWith("Windows") && (s = this.extCommand[0]).startsWith("cmd")) {
                request = request.replaceAll("&", "^&");
            }
            this.extCommand[this.extCommand.length - 1] = request;
            try {
                Runtime.getRuntime().exec(this.extCommand);
            }
            catch (IOException io) {
                JOptionPane.showMessageDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FAILED TO OPEN EXTERNAL BROWSER."), null, 0);
            }
        } else {
            try {
                if (this.desktop == null) {
                    this.desktop = Desktop.getDesktop();
                }
                this.desktop.browse(new URI(request));
            }
            catch (URISyntaxException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void find(String key) {
        String request = (key = key.trim()).startsWith("www.") ? "http://" + key : key;
        if (!request.startsWith("http") && !request.startsWith("file:")) {
            int i = request.indexOf(47);
            if (i != -1) {
                String s1 = request.substring(0, i);
                String s2 = request.substring(i + 1);
                try {
                    s1 = URLEncoder.encode(s1, this.charset);
                    s2 = URLEncoder.encode(s2, this.charset);
                    request = s1 + "/" + s2;
                }
                catch (UnsupportedEncodingException ex) {
                    ex.printStackTrace();
                }
            } else {
                try {
                    request = URLEncoder.encode(request, this.charset);
                }
                catch (UnsupportedEncodingException ex) {
                    ex.printStackTrace();
                }
            }
            if (this.prefix != null && this.prefix.length() > 0 && this.prefix.indexOf(63) == -1 && this.prefix.charAt(this.prefix.length() - 1) == '/') {
                request = request.replace("+", "%20");
            }
            if ((request = this.prefix + request + this.suffix).indexOf("|") != -1) {
                request = request.replace("|", "%7C");
            }
            this.start = !this.postMethod;
        } else {
            this.start = true;
        }
        BufferedReader in = null;
        try {
            if (this.start) {
                this.loadPage(request);
            } else {
                String eline;
                int index;
                String post = null;
                if (this.postMethod && (index = request.lastIndexOf("?")) != -1) {
                    post = request.substring(index + 1);
                    request = request.substring(0, index);
                }
                this.url = new URL(request);
                this.running = true;
                StringBuilder line = new StringBuilder();
                in = this.getBufferedReader(this.url, post);
                while ((eline = in.readLine()) != null && this.running) {
                    line.append(eline);
                    line.append("\n");
                }
                String htmlText = line.toString();
                if (this.start) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("<html><body><head> <base href=\"");
                    sb.append(request);
                    sb.append("\" target=\"_blank\" /> </head>");
                    sb.append(htmlText);
                    sb.append(this.tableEnd);
                    this.webPane.getBrowser().loadHTML(sb.toString());
                } else {
                    this.webPane.getBrowser().loadHTML(htmlText);
                }
            }
        }
        catch (Exception er) {
            er.printStackTrace();
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PAGE UNAVAILABLE"));
        }
        finally {
            this.closeConnection(in);
        }
    }

    public void loadPage(String address) {
        this.webPane.load(address);
        this.statusBar.setText("");
    }

    public void findAndFrame(String s, boolean back) {
        this.webPane.findAndFrame(s, back);
    }

    public void findInPage(String s, boolean back) {
        this.webPane.findInPage(s, back);
    }

    private void closeConnection(BufferedReader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception ex) {
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("UNABLE TO CLOSE THE CONNECTION"));
        }
    }

    private void next() {
        if (this.webPane != null) {
            this.webPane.goForward();
        }
    }

    private void previous() {
        if (this.webPane != null) {
            this.webPane.goBack();
        }
    }

    @Override
    public void stopSearch() {
        if (this.webPane != null) {
            this.webPane.getBrowser().stopPage();
        }
        this.running = false;
        this.worker.interrupt();
    }

    private void createFrame(String name) {
        if (this.path != null) {
            if (this.path.startsWith("www")) {
                this.path = "http://" + this.path;
            }
            if (this.path.startsWith("http") || this.path.startsWith("file:")) {
                this.webPane = new WebPane(new Browser(this.path));
            } else {
                this.webPane = new WebPane(new Browser());
                if (this.realTimePreview != -1) {
                    this.showOnlineDocumentPreviewSites();
                }
            }
        } else {
            this.webPane = new WebPane(new Browser());
        }
        int[] dim = null;
        if (name.equals("ProZ.com - Authorization")) {
            dim = new int[]{-1, -1, 800, 400};
        }
        this.topui.floatComponent(this.webPane, name, dim);
        this.setTransparentTab(false);
    }

    private void createHTMLTab() {
        if (this.path != null) {
            if (this.path.startsWith("www")) {
                this.path = "http://" + this.path;
            }
            if (this.path.startsWith("http") || this.path.startsWith("file:")) {
                this.webPane = new WebPane(new Browser(this.path));
            } else {
                this.webPane = new WebPane(new Browser());
                if (this.realTimePreview != -1) {
                    this.showOnlineDocumentPreviewSites();
                }
            }
        } else {
            this.webPane = new WebPane(new Browser());
        }
        if (this.blockJavaScript) {
            this.webPane.getBrowser().blockJavaScript(this.blockJavaScript);
        }
        this.webPane.setName(this.uid);
        this.tview.addTab(this, this.resourceName, this.webPane);
        ++browsers;
    }

    private void pageOpen() {
        if (AppPreferences.isJavaFXReady()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        FileChooser fileChooser = new FileChooser();
                        fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN PAGE"));
                        final File file = fileChooser.showOpenDialog(null);
                        if (file != null) {
                            SwingUtilities.invokeLater(new Runnable(){
                                final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                @Override
                                public void run() {
                                    try {
                                        AppPreferences.fileDirectory = file.getParent();
                                        String path = file.toURI().toURL().toExternalForm();
                                        this.this$1.WebResourceFX.this.rview.setSearchBoxText(path);
                                        this.this$1.WebResourceFX.this.search(path, null);
                                        this.this$1.WebResourceFX.this.topui.repaint();
                                    }
                                    catch (MalformedURLException ex) {
                                        ex.printStackTrace();
                                    }
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        final String s = ex.getMessage();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(this.this$1.WebResourceFX.this.topui, s);
                            }
                        });
                    }
                }
            });
        } else {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OPEN PAGE"));
            if (0 == jFileChooser.showOpenDialog(this.topui)) {
                try {
                    File file = jFileChooser.getSelectedFile();
                    AppPreferences.fileDirectory = file.getParent();
                    String path = file.toURI().toURL().toExternalForm();
                    this.rview.setSearchBoxText(path);
                    this.search(path, null);
                    this.topui.repaint();
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public void newResource() {
    }

    @Override
    public void openResource() {
        this.pageOpen();
    }

    @Override
    public void saveResource() {
    }

    @Override
    public void saveAsResource() {
    }

    @Override
    public void closeResource() {
        TransparentBackgroundListener tbgl;
        List loader;
        this.running = false;
        if (this.worker != null) {
            this.worker.interrupt();
        }
        if (this.infopath != null) {
            loader = this.topui.getResourceLoader().getResourceLoaderList();
            loader.remove(this.infopath);
            this.topui.getProjectView().removeReference(this.infopath);
            this.topui.getResourceLoader().removeLastSessionResource(this.infopath);
        } else if (this.realTimePreview == 0) {
            loader = this.topui.getResourceLoader().getResourceLoaderList();
            loader.remove(this.path);
            this.topui.getProjectView().removeReference(this.path);
        }
        if (this.tbg != null && (tbgl = this.topui.getTransparentBackgroundListener()) != null) {
            tbgl.removeBackgroundComp(this.tbg);
        }
        this.topui.getResourceView().removeWebResource(this);
        if ((browsers > 1 || FX.canImplicitExitSet || this.tbg != null) && this.hasTransparentTab()) {
            this.tview.removeTab(this.uid, this.resourceName);
            if (AppPreferences.sws && this.tbg != null) {
                this.closeExternalWebResources();
            }
        }
        if (this.webPane != null && (browsers > 1 || FX.canImplicitExitSet)) {
            this.webPane.disposeComponent();
            --browsers;
        }
    }

    @Override
    public void nextResource() {
        this.next();
    }

    @Override
    public void previousResource() {
        this.previous();
    }

    @Override
    public void plusResource() {
        this.webPane.zoomUp();
    }

    @Override
    public void minusResource() {
        this.webPane.zoomDown();
    }

    @Override
    public String getInfoPath() {
        return this.infopath;
    }

    @Override
    public String getLocation() {
        return this.resourceName;
    }

    public String getResourceAddress() {
        return this.path;
    }

    private void showOnlineDocumentPreviewSites() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(HTMLFormat.styles);
        sb.append("<body bgcolor=#494949>");
        sb.append("<br>");
        sb.append("<br>");
        sb.append("<table align=center WIDTH=66% CELLSPACING=4 CELLPADDING=4>");
        sb.append("<tr>");
        sb.append("<td align=center width=50% style=\"color:black; background-color:#455A64;border-style:outset;border-width: 1px;border-color:white\">");
        sb.append("<a href=\"https://office.live.com\"><p style=color:white;font-size:").append(AppPreferences.UIFontSizeHTML + 4).append(">Preview via Office Live</p>");
        sb.append("</td>");
        sb.append("<td align=center width=50% style=\"color:black; background-color:#455A64;border-style:outset; border-width: 1px;border-color:white\">");
        sb.append("<a href=\"https://www.dropbox.com/home\"><p style=color:white;font-size:").append(AppPreferences.UIFontSizeHTML + 4).append(">Preview via Dropbox</p>");
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("<tr>");
        sb.append("<td align=center colspan=2>");
        sb.append("<p style=color:white;font-size:").append(AppPreferences.UIFontSizeHTML + 2).append(">or enter your website address in the search field above.</p>");
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("</body></html>");
        this.webPane.getBrowser().loadHTML(sb.toString());
    }

    protected BufferedReader getBufferedReader(URL page, String post) throws IOException {
        String enc;
        URLConnection conn = page.openConnection();
        conn.setRequestProperty("User-Agent", "Mozilla 5.0");
        conn.setDoOutput(true);
        if (post != null) {
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
            out.write(post);
            out.close();
        }
        if (conn instanceof HttpURLConnection) {
            boolean redirect;
            HttpURLConnection hconn = (HttpURLConnection)conn;
            hconn.setInstanceFollowRedirects(false);
            int response = hconn.getResponseCode();
            boolean bl = redirect = response >= 300 && response <= 399;
            if (redirect) {
                String loc = conn.getHeaderField("Location");
                page = loc.startsWith("http", 0) ? new URL(loc) : new URL(page, loc);
                return this.getBufferedReader(page, post);
            }
        }
        if ((enc = conn.getContentEncoding()) == null) {
            enc = this.charset;
        }
        InputStream in = conn.getInputStream();
        BufferedReader r = new BufferedReader(new InputStreamReader(in, enc));
        return r;
    }

    private void closeExternalWebResources() {
        List list = this.topui.getResourceView().getWebResources();
        if (list != null) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                WebResourceFX wr;
                Object object = it.next();
                if (!(object instanceof WebResourceFX) || (wr = (WebResourceFX)object).hasTransparentTab()) continue;
                it.remove();
            }
        }
    }
}

