/*
 * Decompiled with CFR 0.152.
 */
package translator.database;

import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.jdesktop.observablecollections.ObservableCollections;
import translator.AppPreferences;
import translator.database.Term;

public class DBConnection {
    private Connection connection;
    private Statement stmt;
    private ResultSet rs;
    private String[] cnames;
    private int[] ctypes;
    String referenceName = "";
    String noteName = "";
    String fieldName = "";
    String contextName = "";
    String idName = "";
    String sourceName = "";
    String targetName = "";
    boolean reference = false;
    boolean note = false;
    boolean field = false;
    boolean context = false;
    boolean clientID = false;
    boolean date = false;
    boolean time = false;
    boolean timestamp = false;
    List<String> columns;
    int columnCount;
    List<Term> terms;
    String selectAllRowsQuery;
    String selectRangeQuery;
    int page = 50;
    int pointer = 1;
    int srcCol = -1;
    int trgCol = -1;
    int newNo = 0;
    String tableName;
    String url;
    private String driverClassName;
    public boolean autoIncrementNull = false;
    private int resultSetType = 1;
    private int resultSetConcurrencyMode = 1;
    private int fetchSize = 100;
    private int sqlType = -1;
    private int offset = -1;
    private String query;

    public DBConnection(Connection connection) {
        this.connection = connection;
        ArrayList list1 = new ArrayList();
        ArrayList list2 = new ArrayList();
        this.terms = ObservableCollections.observableList(list1);
        this.columns = ObservableCollections.observableList(list2);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void refresh() throws SQLException {
        this.query = null;
        if (!this.connection.getAutoCommit()) {
            this.connection.commit();
        }
        this.setOffset(-1);
        String nq = this.getNextRowsQuery();
        if (nq == null) {
            this.selectAllRows();
        } else {
            this.selectRows(nq);
        }
        this.nextTerms();
    }

    public void closeConnection() {
        if (this.connection != null) {
            if (this.rs != null) {
                try {
                    this.rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (this.stmt != null) {
                try {
                    this.stmt.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            try {
                if (!this.connection.getAutoCommit()) {
                    this.connection.commit();
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                this.connection.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void closeSession() throws SQLException {
        this.getTermsList().clear();
        if (this.connection != null) {
            if (this.rs != null) {
                this.rs.close();
            }
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
            }
        }
    }

    void indexTable(String name) {
        try {
            if (this.sqlType == 0) {
                StringBuilder langs = new StringBuilder();
                for (int i = 0; i < this.ctypes.length; ++i) {
                    String cname;
                    int type = this.ctypes[i];
                    if (type != -9 && type != 12 || i >= this.cnames.length || (cname = this.cnames[i]) == null) continue;
                    if (langs.length() > 0) {
                        langs.append(',');
                        langs.append(cname);
                        continue;
                    }
                    langs.append(cname);
                }
                String drop = "CALL FT_DROP_INDEX('PUBLIC', '" + name + "')";
                String init = "CREATE ALIAS IF NOT EXISTS FT_INIT FOR \"org.h2.fulltext.FullText.init\"";
                String call = "CALL FT_INIT()";
                String cols = langs.toString();
                String q = "CALL FT_CREATE_INDEX('PUBLIC', '" + name + "','" + cols + "')";
                Statement st = this.connection.createStatement();
                st.execute(init);
                st.execute(call);
                st.execute(drop);
                st.execute(q);
                st.close();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void executeSQLCommand(String command) {
        try {
            int scrolltype = 1004;
            int concur = 1008;
            if (this.resultSetType == 0) {
                scrolltype = 1003;
            }
            if (this.resultSetConcurrencyMode == 0) {
                concur = 1007;
            }
            Statement st = this.connection.createStatement(scrolltype, concur);
            st.setFetchSize(this.fetchSize);
            boolean b = st.execute(command);
            if (b) {
                ResultSet result = st.getResultSet();
                if (result != null) {
                    this.selectRows(result);
                    this.nextTerms();
                }
            } else {
                this.refresh();
            }
            st.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(null, ex.getMessage(), "SQL ERROR", 0);
        }
    }

    public String backup() {
        String fname = null;
        try {
            if (this.sqlType == 0) {
                fname = "H2_Backup.zip";
                String s = "BACKUP TO '" + fname + "'";
                Statement st = this.connection.createStatement();
                st.execute(s);
                st.close();
            } else if (this.sqlType == 1) {
                fname = "SQLite_Backup.db";
                String s = "backup to '" + fname + "'";
                Statement st = this.connection.createStatement();
                st.execute(s);
                st.close();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
            fname = null;
        }
        return fname;
    }

    String getVersion() {
        String v = null;
        try {
            if (this.sqlType == 0) {
                String s = "SELECT H2VERSION()";
                Statement st = this.connection.createStatement();
                ResultSet rset = st.executeQuery(s);
                if (rset != null && rset.next()) {
                    v = "H2 " + rset.getString(1);
                }
                st.close();
            } else if (this.sqlType == 1) {
                String s = "select sqlite_version() AS sqlite_version, null;";
                Statement st = this.connection.createStatement();
                ResultSet rset = st.executeQuery(s);
                if (rset != null && rset.next()) {
                    v = "SQLite " + rset.getString(1);
                }
                st.close();
            } else if (this.sqlType == 2) {
                String s = "SELECT VERSION()";
                Statement st = this.connection.createStatement();
                ResultSet rset = st.executeQuery(s);
                if (rset != null && rset.next()) {
                    v = "MySQL " + rset.getString(1);
                }
                st.close();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
        return v;
    }

    public int countRows(List tnames) {
        int i = -1;
        for (int j = 0; j < tnames.size(); ++j) {
            String tname = (String)tnames.get(j);
            try {
                if (this.sqlType != 0 && this.sqlType != 1 && this.sqlType != 2) continue;
                String s = "SELECT COUNT(*) FROM " + tname;
                Statement st = this.connection.createStatement();
                ResultSet rset = st.executeQuery(s);
                if (rset != null && rset.next()) {
                    i += (int)rset.getLong(1);
                }
                st.close();
                continue;
            }
            catch (SQLException ex) {
                Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return i;
    }

    void deleteTable(String name) {
        try {
            this.rs.close();
            Statement st = this.connection.createStatement();
            if (this.sqlType == 0) {
                st.executeUpdate("CALL FT_DROP_INDEX('PUBLIC', '" + name + "')");
            }
            st.executeUpdate("DROP TABLE " + name);
            if (this.url.indexOf("jdbc:oracle") != -1) {
                st.executeUpdate("DROP sequence " + name + "_seq");
            }
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
            }
            st.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    boolean isOpen() {
        boolean open = true;
        try {
            if (this.connection == null || this.connection.isClosed()) {
                open = false;
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
        return open;
    }

    public void setSourceLang(String s) {
        this.sourceName = s;
    }

    public void setTargetLang(String s) {
        this.targetName = s;
    }

    public String getSourceLang() {
        return this.sourceName;
    }

    public String getTargetLang() {
        return this.targetName;
    }

    public void setClientIDName(String s) {
        this.idName = s;
    }

    public String getClientIDName() {
        return this.idName;
    }

    public void setFieldName(String s) {
        this.fieldName = s;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setContextName(String s) {
        this.contextName = s;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setNotesName(String s) {
        this.noteName = s;
    }

    public void setReferenceName(String s) {
        this.referenceName = s;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public String getNotesName() {
        return this.noteName;
    }

    List getColumnNames() {
        return this.columns;
    }

    public String[] getColumnNamesArray() {
        return this.cnames;
    }

    public int[] getColumnTypes() {
        return this.ctypes;
    }

    void setTable(String name) {
        this.selectAllRowsQuery = this.url.indexOf("jdbc:sqlite") != -1 ? "SELECT docid, * FROM " + name : (this.url.indexOf("jdbc:oracle") != -1 ? "SELECT " + name + ".* FROM " + name : "SELECT * FROM " + name);
        this.tableName = name;
    }

    public String getTableName() {
        return this.tableName;
    }

    void removeTerms(List list) {
        try {
            int scrollType = this.rs.getType();
            if (scrollType == 1003) {
                this.removeTermsSQLStatement(list);
                return;
            }
            if (this.driverClassName != null && this.driverClassName.equals("org.mariadb.jdbc.Driver")) {
                this.removeTermsSQLStatement(list);
                return;
            }
            for (Term term : list) {
                if (term.row == -1) continue;
                this.rs.absolute(term.row);
                this.rs.deleteRow();
            }
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
            }
        }
        catch (SQLException ex) {
            try {
                if (!this.connection.getAutoCommit()) {
                    this.connection.rollback();
                }
            }
            catch (SQLException ex1) {
                Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex1);
            }
            Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void removeTermsSQLStatement(List list) throws SQLException {
        for (Term term : list) {
            if (term.row == -1) continue;
            Integer integ = term.getInteger();
            String id = integ.toString();
            String sql = this.sqlType == 1 ? "DELETE FROM " + this.tableName + " WHERE " + this.tableName + ".DOCID = " + id + ";" : (this.sqlType == 2 ? "DELETE FROM " + this.tableName + " WHERE " + this.tableName + ".Id = " + id + ";" : "DELETE FROM " + this.tableName + " WHERE " + this.tableName + ".Id = " + id + ";");
            this.stmt = this.connection.createStatement();
            this.stmt.executeUpdate(sql);
        }
        this.stmt.close();
        if (!this.connection.getAutoCommit()) {
            this.connection.commit();
        }
    }

    void updateDB() {
        try {
            int scrollType = this.rs.getType();
            if (scrollType == 1003) {
                this.updateDBSQLStatetment();
                return;
            }
            if (this.driverClassName != null && this.driverClassName.equals("org.mariadb.jdbc.Driver")) {
                this.updateDBSQLStatetment();
                return;
            }
            ResultSetMetaData meta = this.rs.getMetaData();
            int colcount = meta.getColumnCount();
            this.rs.beforeFirst();
            for (Term term : this.terms) {
                if (!term.update) continue;
                boolean isNew = false;
                if (term.row == -1) {
                    isNew = true;
                    this.rs.moveToInsertRow();
                } else {
                    this.rs.absolute(term.row);
                }
                List values = term.getValues();
                int[] types = term.getTypes();
                int ti = 0;
                Iterator it = values.iterator();
                while (it.hasNext() && ti + 1 <= colcount) {
                    java.util.Date t;
                    Object object = it.next();
                    int type = types[ti];
                    if (type == -9 || type == 12) {
                        String s = (String)object;
                        this.rs.updateString(ti + 1, s);
                    } else if (type == 4 || type == 2) {
                        if (!meta.isAutoIncrement(ti + 1)) {
                            int i = (Integer)object;
                            this.rs.updateInt(ti + 1, i);
                        } else if (this.autoIncrementNull) {
                            this.rs.updateObject(ti + 1, null);
                        }
                    } else if (type == 91) {
                        Date d = (Date)object;
                        this.rs.updateDate(ti + 1, d);
                    } else if (type == 92) {
                        t = (Time)object;
                        this.rs.updateTime(ti + 1, (Time)t);
                    } else if (type == 93) {
                        t = (Timestamp)object;
                        this.rs.updateTimestamp(ti + 1, (Timestamp)t);
                    }
                    ++ti;
                }
                if (isNew) {
                    this.rs.insertRow();
                } else {
                    this.rs.updateRow();
                }
                term.update = false;
            }
            this.refresh();
        }
        catch (SQLException ex) {
            Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(null, ex.getMessage(), "SQL ERROR", 0);
            try {
                if (!this.connection.getAutoCommit()) {
                    this.connection.rollback();
                }
            }
            catch (SQLException ex1) {
                Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex1);
                JOptionPane.showMessageDialog(null, ex.getMessage(), "SQL ERROR", 0);
            }
        }
    }

    private void updateDBSQLStatetment() throws SQLException {
        Iterator<Term> iterator = this.terms.iterator();
        while (iterator.hasNext()) {
            String sql;
            StringBuilder sqlColumns = new StringBuilder("(");
            StringBuilder sqlValues = new StringBuilder("(");
            StringBuilder sqlUpdate = new StringBuilder();
            Term term = iterator.next();
            if (!term.update) continue;
            boolean isNew = false;
            if (term.row == -1) {
                isNew = true;
            }
            int id = 0;
            List values = term.getValues();
            int[] types = term.getTypes();
            int ti = 0;
            Iterator it = values.iterator();
            while (it.hasNext() && ti + 1 <= this.columnCount) {
                java.util.Date t;
                String s;
                Object object = it.next();
                int type = types[ti];
                String columnName = this.cnames[ti];
                if (type == -9 || type == 12) {
                    String s2 = (String)object;
                    if (s2.length() > 0) {
                        if (s2.indexOf(39) != -1) {
                            s2 = s2.replaceAll("'", "''");
                        }
                        if (isNew) {
                            sqlColumns.append(columnName);
                            sqlColumns.append(",");
                            sqlValues.append("'");
                            sqlValues.append(s2);
                            sqlValues.append("', ");
                        } else {
                            sqlUpdate.append(columnName);
                            sqlUpdate.append(" = '");
                            sqlUpdate.append(s2);
                            sqlUpdate.append("', ");
                        }
                    }
                } else if (type == 4 || type == 2) {
                    id = (Integer)object;
                } else if (type == 91) {
                    Date d = (Date)object;
                    s = d.toString();
                    if (s.length() > 0) {
                        if (isNew) {
                            sqlColumns.append(columnName);
                            sqlColumns.append(",");
                            sqlValues.append('\'');
                            sqlValues.append(s);
                            sqlValues.append('\'');
                            sqlValues.append(", ");
                        } else {
                            sqlUpdate.append(columnName);
                            sqlUpdate.append(" = ");
                            sqlUpdate.append('\'');
                            sqlUpdate.append(s);
                            sqlUpdate.append('\'');
                            sqlUpdate.append(", ");
                        }
                    }
                } else if (type == 92) {
                    t = (Time)object;
                    s = ((Time)t).toString();
                    if (s.length() > 0) {
                        if (isNew) {
                            sqlColumns.append(columnName);
                            sqlColumns.append(",");
                            sqlValues.append(s);
                            sqlValues.append(", ");
                        } else {
                            sqlUpdate.append(columnName);
                            sqlUpdate.append(" = ");
                            sqlUpdate.append(s);
                            sqlUpdate.append(", ");
                        }
                    }
                } else if (type == 93 && (s = ((Timestamp)(t = (Timestamp)object)).toString()).length() > 0) {
                    if (isNew) {
                        sqlColumns.append(columnName);
                        sqlColumns.append(",");
                        sqlValues.append(s);
                        sqlValues.append(", ");
                    } else {
                        sqlUpdate.append(columnName);
                        sqlUpdate.append(" = ");
                        sqlUpdate.append(s);
                        sqlUpdate.append(", ");
                    }
                }
                ++ti;
            }
            if (isNew) {
                if (sqlColumns.length() > 1) {
                    sqlColumns.setLength(sqlColumns.length() - 1);
                    sqlColumns.append(")");
                }
                if (sqlValues.length() > 2) {
                    sqlValues.setLength(sqlValues.length() - 2);
                    sqlValues.append(")");
                }
                sql = "INSERT INTO " + this.tableName + " " + sqlColumns.toString() + " VALUES " + sqlValues.toString() + ";";
                this.stmt = this.connection.createStatement();
                this.stmt.executeUpdate(sql);
            } else if (sqlUpdate.length() > 2) {
                sqlUpdate.setLength(sqlUpdate.length() - 2);
                sql = "UPDATE " + this.tableName + " SET " + sqlUpdate.toString() + " WHERE docid = " + Integer.toString(id) + ";";
                this.stmt = this.connection.createStatement();
                this.stmt.executeUpdate(sql);
            }
            term.update = false;
        }
        this.stmt.close();
        this.refresh();
    }

    public ResultSet getResultSet() {
        return this.rs;
    }

    public List getTermsList() {
        return this.terms;
    }

    public void selectAllRows() {
        try {
            String ccol;
            String rcol;
            String ncol;
            String fcol;
            String idcol;
            String tcol;
            this.terms.clear();
            this.columns.clear();
            String scol = this.getSourceLang();
            if (scol.indexOf("-") != -1) {
                scol = scol.replaceAll("-", "_");
            }
            if ((tcol = this.getTargetLang()).indexOf("-") != -1) {
                tcol = tcol.replaceAll("-", "_");
            }
            if ((idcol = this.getClientIDName()).indexOf("-") != -1) {
                idcol = idcol.replaceAll("-", "_");
            }
            if ((fcol = this.getFieldName()).indexOf("-") != -1) {
                fcol = fcol.replaceAll("-", "_");
            }
            if ((ncol = this.getNotesName()).indexOf("-") != -1) {
                ncol = ncol.replaceAll("-", "_");
            }
            if ((rcol = this.getReferenceName()).indexOf("-") != -1) {
                rcol = rcol.replaceAll("-", "_");
            }
            if ((ccol = this.getContextName()).indexOf("-") != -1) {
                ccol = ccol.replaceAll("-", "_");
            }
            if (this.stmt != null) {
                this.stmt.close();
            }
            int scrolltype = 1004;
            int concur = 1008;
            if (this.resultSetType == 0) {
                scrolltype = 1003;
            }
            if (this.resultSetConcurrencyMode == 0) {
                concur = 1007;
            }
            this.stmt = this.connection.createStatement(scrolltype, concur);
            this.stmt.setFetchSize(this.fetchSize);
            this.rs = this.stmt.executeQuery(this.selectAllRowsQuery);
            ResultSetMetaData meta = this.rs.getMetaData();
            this.columnCount = meta.getColumnCount();
            this.cnames = new String[this.columnCount];
            this.ctypes = new int[this.columnCount];
            for (int i = 1; i <= this.columnCount; ++i) {
                String name = meta.getColumnName(i);
                this.columns.add(name);
                int type = meta.getColumnType(i);
                this.cnames[i - 1] = name;
                this.ctypes[i - 1] = type;
                if (type == 91) {
                    this.date = true;
                    continue;
                }
                if (type == 92) {
                    this.time = true;
                    continue;
                }
                if (type == 93) {
                    this.timestamp = true;
                    continue;
                }
                if (type != -9 && type != 12) continue;
                if (name.equalsIgnoreCase(idcol)) {
                    this.clientID = true;
                    continue;
                }
                if (name.equalsIgnoreCase(fcol)) {
                    this.field = true;
                    continue;
                }
                if (name.equalsIgnoreCase(ccol)) {
                    this.context = true;
                    continue;
                }
                if (name.equalsIgnoreCase(ncol)) {
                    this.note = true;
                    continue;
                }
                if (name.equalsIgnoreCase(rcol)) {
                    this.reference = true;
                    continue;
                }
                if (name.equalsIgnoreCase(scol)) {
                    this.srcCol = i;
                    continue;
                }
                if (!name.equalsIgnoreCase(tcol)) continue;
                this.trgCol = i;
            }
            if (this.srcCol == -1) {
                int k;
                String s = AppPreferences.fileSLang.toUpperCase();
                if (s.indexOf("-") != -1) {
                    s = s.replaceAll("-", "_");
                }
                if ((k = this.columns.indexOf(s)) != -1) {
                    this.srcCol = k + 1;
                    this.sourceName = s;
                }
            }
            if (this.trgCol == -1) {
                int k;
                String s = AppPreferences.fileTLang.toUpperCase();
                if (s.indexOf("-") != -1) {
                    s = s.replaceAll("-", "_");
                }
                if ((k = this.columns.indexOf(s)) != -1) {
                    this.trgCol = k + 1;
                    this.targetName = s;
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(null, ex.getMessage(), "SQL ERROR", 0);
        }
    }

    public void selectRows(ResultSet rset) {
        this.rs = rset;
        try {
            String ccol;
            String rcol;
            String ncol;
            String fcol;
            String idcol;
            String tcol;
            this.terms.clear();
            this.columns.clear();
            String scol = this.getSourceLang();
            if (scol.indexOf("-") != -1) {
                scol = scol.replaceAll("-", "_");
            }
            if ((tcol = this.getTargetLang()).indexOf("-") != -1) {
                tcol = tcol.replaceAll("-", "_");
            }
            if ((idcol = this.getClientIDName()).indexOf("-") != -1) {
                idcol = idcol.replaceAll("-", "_");
            }
            if ((fcol = this.getFieldName()).indexOf("-") != -1) {
                fcol = fcol.replaceAll("-", "_");
            }
            if ((ncol = this.getNotesName()).indexOf("-") != -1) {
                ncol = ncol.replaceAll("-", "_");
            }
            if ((rcol = this.getReferenceName()).indexOf("-") != -1) {
                rcol = rcol.replaceAll("-", "_");
            }
            if ((ccol = this.getContextName()).indexOf("-") != -1) {
                ccol = ccol.replaceAll("-", "_");
            }
            if (this.stmt != null) {
                this.stmt.close();
            }
            ResultSetMetaData meta = rset.getMetaData();
            this.columnCount = meta.getColumnCount();
            this.cnames = new String[this.columnCount];
            this.ctypes = new int[this.columnCount];
            for (int i = 1; i <= this.columnCount; ++i) {
                String name = meta.getColumnName(i);
                this.columns.add(name);
                int type = meta.getColumnType(i);
                this.cnames[i - 1] = name;
                this.ctypes[i - 1] = type;
                if (type == 91) {
                    this.date = true;
                    continue;
                }
                if (type == 92) {
                    this.time = true;
                    continue;
                }
                if (type == 93) {
                    this.timestamp = true;
                    continue;
                }
                if (type != -9 && type != 12) continue;
                if (name.equalsIgnoreCase(idcol)) {
                    this.clientID = true;
                    continue;
                }
                if (name.equalsIgnoreCase(fcol)) {
                    this.field = true;
                    continue;
                }
                if (name.equalsIgnoreCase(ccol)) {
                    this.context = true;
                    continue;
                }
                if (name.equalsIgnoreCase(ncol)) {
                    this.note = true;
                    continue;
                }
                if (name.equalsIgnoreCase(rcol)) {
                    this.reference = true;
                    continue;
                }
                if (name.equalsIgnoreCase(scol)) {
                    this.srcCol = i;
                    continue;
                }
                if (!name.equalsIgnoreCase(tcol)) continue;
                this.trgCol = i;
            }
            if (this.srcCol == -1) {
                int k;
                String s = AppPreferences.fileSLang.toUpperCase();
                if (s.indexOf("-") != -1) {
                    s = s.replaceAll("-", "_");
                }
                if ((k = this.columns.indexOf(s)) != -1) {
                    this.srcCol = k + 1;
                    this.sourceName = s;
                }
            }
            if (this.trgCol == -1) {
                int k;
                String s = AppPreferences.fileTLang.toUpperCase();
                if (s.indexOf("-") != -1) {
                    s = s.replaceAll("-", "_");
                }
                if ((k = this.columns.indexOf(s)) != -1) {
                    this.trgCol = k + 1;
                    this.targetName = s;
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(null, ex.getMessage(), "SQL ERROR", 0);
        }
    }

    public void selectRows(String query) {
        try {
            String ccol;
            String rcol;
            String ncol;
            String fcol;
            String idcol;
            String tcol;
            this.terms.clear();
            this.columns.clear();
            String scol = this.getSourceLang();
            if (scol.indexOf("-") != -1) {
                scol = scol.replaceAll("-", "_");
            }
            if ((tcol = this.getTargetLang()).indexOf("-") != -1) {
                tcol = tcol.replaceAll("-", "_");
            }
            if ((idcol = this.getClientIDName()).indexOf("-") != -1) {
                idcol = idcol.replaceAll("-", "_");
            }
            if ((fcol = this.getFieldName()).indexOf("-") != -1) {
                fcol = fcol.replaceAll("-", "_");
            }
            if ((ncol = this.getNotesName()).indexOf("-") != -1) {
                ncol = ncol.replaceAll("-", "_");
            }
            if ((rcol = this.getReferenceName()).indexOf("-") != -1) {
                rcol = rcol.replaceAll("-", "_");
            }
            if ((ccol = this.getContextName()).indexOf("-") != -1) {
                ccol = ccol.replaceAll("-", "_");
            }
            if (this.stmt != null) {
                this.stmt.close();
            }
            int scrolltype = 1004;
            int concur = 1008;
            if (this.resultSetType == 0) {
                scrolltype = 1003;
            }
            if (this.resultSetConcurrencyMode == 0) {
                concur = 1007;
            }
            this.stmt = this.connection.createStatement(scrolltype, concur);
            this.stmt.setFetchSize(this.fetchSize);
            this.rs = this.stmt.executeQuery(query);
            ResultSetMetaData meta = this.rs.getMetaData();
            this.columnCount = meta.getColumnCount();
            this.cnames = new String[this.columnCount];
            this.ctypes = new int[this.columnCount];
            for (int i = 1; i <= this.columnCount; ++i) {
                String name = meta.getColumnName(i);
                this.columns.add(name);
                int type = meta.getColumnType(i);
                this.cnames[i - 1] = name;
                this.ctypes[i - 1] = type;
                if (type == 91) {
                    this.date = true;
                    continue;
                }
                if (type == 92) {
                    this.time = true;
                    continue;
                }
                if (type == 93) {
                    this.timestamp = true;
                    continue;
                }
                if (type != -9 && type != 12) continue;
                if (name.equalsIgnoreCase(idcol)) {
                    this.clientID = true;
                    continue;
                }
                if (name.equalsIgnoreCase(fcol)) {
                    this.field = true;
                    continue;
                }
                if (name.equalsIgnoreCase(ccol)) {
                    this.context = true;
                    continue;
                }
                if (name.equalsIgnoreCase(ncol)) {
                    this.note = true;
                    continue;
                }
                if (name.equalsIgnoreCase(rcol)) {
                    this.reference = true;
                    continue;
                }
                if (name.equalsIgnoreCase(scol)) {
                    this.srcCol = i;
                    continue;
                }
                if (!name.equalsIgnoreCase(tcol)) continue;
                this.trgCol = i;
            }
            if (this.srcCol == -1) {
                int k;
                String s = AppPreferences.fileSLang.toUpperCase();
                if (s.indexOf("-") != -1) {
                    s = s.replaceAll("-", "_");
                }
                if ((k = this.columns.indexOf(s)) != -1) {
                    this.srcCol = k + 1;
                    this.sourceName = s;
                }
            }
            if (this.trgCol == -1) {
                int k;
                String s = AppPreferences.fileTLang.toUpperCase();
                if (s.indexOf("-") != -1) {
                    s = s.replaceAll("-", "_");
                }
                if ((k = this.columns.indexOf(s)) != -1) {
                    this.trgCol = k + 1;
                    this.targetName = s;
                }
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
            JOptionPane.showMessageDialog(null, ex.getMessage(), "SQL ERROR", 0);
        }
    }

    public void selectSourceTargetRows() throws SQLException {
        String ccol;
        String rcol;
        String ncol;
        String fcol;
        String idcol;
        String tcol;
        String scol = this.getSourceLang();
        if (scol.indexOf("-") != -1) {
            scol = scol.replaceAll("-", "_");
        }
        if ((tcol = this.getTargetLang()).indexOf("-") != -1) {
            tcol = tcol.replaceAll("-", "_");
        }
        if ((idcol = this.getClientIDName()).indexOf("-") != -1) {
            idcol = idcol.replaceAll("-", "_");
        }
        if ((fcol = this.getFieldName()).indexOf("-") != -1) {
            fcol = fcol.replaceAll("-", "_");
        }
        if ((ncol = this.getNotesName()).indexOf("-") != -1) {
            ncol = ncol.replaceAll("-", "_");
        }
        if ((rcol = this.getReferenceName()).indexOf("-") != -1) {
            rcol = rcol.replaceAll("-", "_");
        }
        if ((ccol = this.getContextName()).indexOf("-") != -1) {
            ccol = ccol.replaceAll("-", "_");
        }
        String q = "SELECT " + scol + "," + tcol + " FROM " + this.tableName;
        this.terms.clear();
        this.columns.clear();
        this.stmt = this.connection.createStatement();
        this.stmt.setFetchSize(this.fetchSize);
        this.rs = this.stmt.executeQuery(q);
        ResultSetMetaData meta = this.rs.getMetaData();
        this.columnCount = meta.getColumnCount();
        this.cnames = new String[this.columnCount];
        this.ctypes = new int[this.columnCount];
        for (int i = 1; i <= this.columnCount; ++i) {
            String name = meta.getColumnName(i);
            this.columns.add(name);
            int type = meta.getColumnType(i);
            this.cnames[i - 1] = name;
            this.ctypes[i - 1] = type;
            if (type == 91) {
                this.date = true;
                continue;
            }
            if (type == 92) {
                this.time = true;
                continue;
            }
            if (type == 93) {
                this.timestamp = true;
                continue;
            }
            if (type != -9 && type != 12) continue;
            if (name.equalsIgnoreCase(idcol)) {
                this.clientID = true;
                continue;
            }
            if (name.equalsIgnoreCase(fcol)) {
                this.field = true;
                continue;
            }
            if (name.equalsIgnoreCase(ccol)) {
                this.context = true;
                continue;
            }
            if (name.equalsIgnoreCase(ncol)) {
                this.note = true;
                continue;
            }
            if (name.equalsIgnoreCase(rcol)) {
                this.reference = true;
                continue;
            }
            if (name.equalsIgnoreCase(scol)) {
                this.srcCol = i;
                continue;
            }
            if (!name.equalsIgnoreCase(tcol)) continue;
            this.trgCol = i;
        }
        if (this.srcCol == -1) {
            this.srcCol = 1;
            this.sourceName = meta.getColumnName(this.srcCol);
        }
        if (this.trgCol == -1) {
            this.trgCol = 2;
            this.targetName = meta.getColumnName(this.trgCol);
        }
    }

    private void setTerm(ResultSet rs, int index) throws SQLException {
        int j;
        String ccol;
        String rcol;
        String ncol;
        String fcol;
        String idcol;
        String tcol;
        String scol = this.getSourceLang();
        if (scol.indexOf("-") != -1) {
            scol = scol.replaceAll("-", "_");
        }
        if ((tcol = this.getTargetLang()).indexOf("-") != -1) {
            tcol = tcol.replaceAll("-", "_");
        }
        if ((idcol = this.getClientIDName()).indexOf("-") != -1) {
            idcol = idcol.replaceAll("-", "_");
        }
        if ((fcol = this.getFieldName()).indexOf("-") != -1) {
            fcol = fcol.replaceAll("-", "_");
        }
        if ((ncol = this.getNotesName()).indexOf("-") != -1) {
            ncol = ncol.replaceAll("-", "_");
        }
        if ((rcol = this.getReferenceName()).indexOf("-") != -1) {
            rcol = rcol.replaceAll("-", "_");
        }
        if ((ccol = this.getContextName()).indexOf("-") != -1) {
            ccol = ccol.replaceAll("-", "_");
        }
        Term term = new Term(index);
        int max = 1;
        int maxInt = 1;
        int maxDate = 1;
        int maxTime = 1;
        int maxTimestamp = 1;
        for (int i = 1; i <= this.columnCount && (j = i - 1) != this.ctypes.length; ++i) {
            int type = this.ctypes[j];
            if (type == -9 || type == 12) {
                String idCol;
                String s = rs.getString(i);
                if (s == null) {
                    s = "";
                }
                if ((idCol = this.cnames[i - 1]).equalsIgnoreCase(tcol)) {
                    term.setTarget(s);
                    continue;
                }
                if (idCol.equalsIgnoreCase(scol)) {
                    term.setSource(s);
                    continue;
                }
                if (idCol.equalsIgnoreCase(idcol)) {
                    term.setId(s);
                    continue;
                }
                if (idCol.equalsIgnoreCase(fcol)) {
                    term.setField(s);
                    continue;
                }
                if (idCol.equalsIgnoreCase(ccol)) {
                    term.setContext(s);
                    continue;
                }
                if (idCol.equalsIgnoreCase(ncol)) {
                    term.setNote(s);
                    continue;
                }
                if (idCol.equalsIgnoreCase(rcol)) {
                    term.setReference(s);
                    continue;
                }
                if (max == 1) {
                    term.setOne(s);
                    ++max;
                    continue;
                }
                if (max == 2) {
                    term.setTwo(s);
                    ++max;
                    continue;
                }
                if (max == 3) {
                    term.setThree(s);
                    ++max;
                    continue;
                }
                if (max == 4) {
                    term.setFour(s);
                    ++max;
                    continue;
                }
                if (max == 5) {
                    term.setFive(s);
                    ++max;
                    continue;
                }
                if (max == 6) {
                    term.setSix(s);
                    ++max;
                    continue;
                }
                term.setStringColumn(s);
                continue;
            }
            if (type == 4 || type == 2) {
                if (maxInt == 1) {
                    term.setInteger(rs.getInt(i));
                    ++maxInt;
                    continue;
                }
                term.setIntColumn(rs.getInt(i));
                continue;
            }
            if (type == 91) {
                if (maxDate == 1) {
                    term.setDate(rs.getDate(i));
                    ++maxDate;
                    continue;
                }
                term.setDateColumn(rs.getDate(i));
                continue;
            }
            if (type == 92) {
                if (maxTime == 1) {
                    term.setTime(rs.getTime(i));
                    ++maxTime;
                    continue;
                }
                term.setTimeColumn(rs.getTime(i));
                continue;
            }
            if (type == 93) {
                if (maxTimestamp == 1) {
                    term.setTimestamp(rs.getTimestamp(i));
                    ++maxTimestamp;
                    continue;
                }
                term.setTimestampColumn(rs.getTimestamp(i));
                continue;
            }
            term.setObjectColumn(rs.getObject(i), type);
        }
        this.terms.add(term);
    }

    public Term newTerm() {
        String ccol;
        String rcol;
        String ncol;
        String fcol;
        String idcol;
        String tcol;
        String scol = this.getSourceLang();
        if (scol.indexOf("-") != -1) {
            scol = scol.replaceAll("-", "_");
        }
        if ((tcol = this.getTargetLang()).indexOf("-") != -1) {
            tcol = tcol.replaceAll("-", "_");
        }
        if ((idcol = this.getClientIDName()).indexOf("-") != -1) {
            idcol = idcol.replaceAll("-", "_");
        }
        if ((fcol = this.getFieldName()).indexOf("-") != -1) {
            fcol = fcol.replaceAll("-", "_");
        }
        if ((ncol = this.getNotesName()).indexOf("-") != -1) {
            ncol = ncol.replaceAll("-", "_");
        }
        if ((rcol = this.getReferenceName()).indexOf("-") != -1) {
            rcol = rcol.replaceAll("-", "_");
        }
        if ((ccol = this.getContextName()).indexOf("-") != -1) {
            ccol = ccol.replaceAll("-", "_");
        }
        Term term = new Term();
        int max = 1;
        int maxInt = 1;
        int maxDate = 1;
        int maxTime = 1;
        int maxTimestamp = 1;
        for (int i = 1; i <= this.columnCount; ++i) {
            int type = this.ctypes[i - 1];
            if (type == -9 || type == 12) {
                String idCol = this.cnames[i - 1];
                if (idCol.equalsIgnoreCase(tcol)) {
                    term.setTarget("");
                    continue;
                }
                if (idCol.equalsIgnoreCase(scol)) {
                    term.setSource("");
                    continue;
                }
                if (idCol.equalsIgnoreCase(idcol)) {
                    term.setId("");
                    continue;
                }
                if (idCol.equalsIgnoreCase(fcol)) {
                    term.setField("");
                    continue;
                }
                if (idCol.equalsIgnoreCase(ccol)) {
                    term.setContext("");
                    continue;
                }
                if (idCol.equalsIgnoreCase(ncol)) {
                    term.setNote("");
                    continue;
                }
                if (idCol.equalsIgnoreCase(rcol)) {
                    term.setReference("");
                    continue;
                }
                if (max == 1) {
                    term.setOne("");
                    ++max;
                    continue;
                }
                if (max == 2) {
                    term.setTwo("");
                    ++max;
                    continue;
                }
                if (max == 3) {
                    term.setThree("");
                    ++max;
                    continue;
                }
                if (max == 4) {
                    term.setFour("");
                    ++max;
                    continue;
                }
                if (max == 5) {
                    term.setFive("");
                    ++max;
                    continue;
                }
                if (max == 6) {
                    term.setSix("");
                    ++max;
                    continue;
                }
                term.setStringColumn("");
                continue;
            }
            if (type == 4 || type == 2) {
                ++this.newNo;
                if (maxInt == 1) {
                    term.setInteger(this.newNo);
                    ++maxInt;
                    continue;
                }
                term.setIntColumn(this.newNo);
                continue;
            }
            if (type == 91) {
                java.util.Date today = new java.util.Date();
                Date date = new Date(today.getTime());
                if (maxDate == 1) {
                    term.setDate(date);
                    ++maxDate;
                    continue;
                }
                term.setDateColumn(date);
                continue;
            }
            if (type == 92) {
                java.util.Date now = new java.util.Date();
                Time time = new Time(now.getTime());
                if (maxTime == 1) {
                    term.setTime(time);
                    ++maxTime;
                    continue;
                }
                term.setTimeColumn(time);
                continue;
            }
            if (type != 93) continue;
            Timestamp timestamp = this.getTodayTimestamp();
            if (maxTimestamp == 1) {
                term.setTimestamp(timestamp);
                ++maxTimestamp;
                continue;
            }
            term.setTimestampColumn(timestamp);
        }
        return term;
    }

    void nextTerms() {
        this.terms.clear();
        try {
            int index;
            this.pointer = this.rs.getRow();
            int scrollType = this.rs.getType();
            if (scrollType != 1003 && this.rs.isLast()) {
                this.rs.beforeFirst();
            }
            for (index = 0; index < this.page && this.rs.next(); ++index) {
                int rowIndex = this.rs.getRow();
                this.setTerm(this.rs, rowIndex);
            }
            if (index == 0) {
                this.offset = -1;
            }
            if (scrollType != 1003 && this.rs.isAfterLast()) {
                this.rs.beforeFirst();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void previousTerms() {
        this.terms.clear();
        try {
            int index;
            int scrollType = this.rs.getType();
            this.pointer -= this.page;
            if (this.pointer <= 0) {
                if (this.pointer + this.page > 0) {
                    if (scrollType != 1003) {
                        this.rs.beforeFirst();
                    }
                    this.pointer = 0;
                } else {
                    if (scrollType != 1003) {
                        this.rs.last();
                        this.rs.relative(-50);
                    }
                    this.pointer = this.rs.getRow();
                }
            } else if (scrollType != 1003) {
                this.rs.absolute(this.pointer);
            }
            for (index = 0; index < this.page && this.rs.next(); ++index) {
                int rowIndex = this.rs.getRow();
                this.setTerm(this.rs, rowIndex);
            }
            if (index == 0) {
                this.offset = -1;
            }
            if (this.rs.isBeforeFirst()) {
                this.rs.afterLast();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void searchSourceDataBase(String s, String r) {
        this.query = s;
        if (this.sqlType == 0) {
            this.fullTextSearchH2(s);
            return;
        }
        if (this.sqlType == 1) {
            this.fullTextSearchSQLite(s, this.srcCol);
            return;
        }
        if (this.sqlType == 2) {
            this.fullTextSearchMySQL(s, this.srcCol);
            return;
        }
        try {
            int scrollType = this.rs.getType();
            this.terms.clear();
            Pattern p = AppPreferences.searchCase ? Pattern.compile(s) : Pattern.compile(s, 2);
            if (scrollType != 1003) {
                this.rs.beforeFirst();
            } else {
                this.selectAllRows();
            }
            int type = this.ctypes[this.srcCol - 1];
            int index = 0;
            while (this.rs.next()) {
                Matcher ma;
                String content;
                ++index;
                if (type == -9 || type == 12) {
                    content = this.rs.getString(this.srcCol);
                    if (content == null) continue;
                    if (content.indexOf(124) != -1) {
                        content = content.replaceAll("\\|", "");
                    }
                    if (!(ma = p.matcher(content)).find()) continue;
                    this.setTerm(this.rs, index);
                    continue;
                }
                if (type == 4 || type == 2) {
                    content = String.valueOf(this.rs.getInt(this.srcCol));
                    if (content == null || !(ma = p.matcher(content)).find()) continue;
                    this.setTerm(this.rs, index);
                    continue;
                }
                if (type == 91) {
                    content = this.rs.getDate(this.srcCol).toString();
                    if (content == null || !(ma = p.matcher(content)).find()) continue;
                    this.setTerm(this.rs, index);
                    continue;
                }
                if (type == 92) {
                    content = this.rs.getTime(this.srcCol).toString();
                    if (content == null || !(ma = p.matcher(content)).find()) continue;
                    this.setTerm(this.rs, index);
                    continue;
                }
                if (type != 93 || (content = this.rs.getTimestamp(this.srcCol).toString()) == null || !(ma = p.matcher(content)).find()) continue;
                this.setTerm(this.rs, index);
            }
            if (scrollType != 1003) {
                this.rs.beforeFirst();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void searchTargetDataBase(String s, String r) {
        this.query = s;
        if (this.sqlType == 0) {
            this.fullTextSearchH2(s);
            return;
        }
        if (this.sqlType == 1) {
            this.fullTextSearchSQLite(s, this.trgCol);
            return;
        }
        if (this.sqlType == 2) {
            this.fullTextSearchMySQL(s, this.trgCol);
            return;
        }
        try {
            int scrollType = this.rs.getType();
            this.terms.clear();
            Pattern p = AppPreferences.searchCase ? Pattern.compile(s) : Pattern.compile(s, 2);
            if (scrollType != 1003) {
                this.rs.beforeFirst();
            } else {
                this.selectAllRows();
            }
            int type = this.ctypes[this.trgCol - 1];
            int index = 0;
            while (this.rs.next()) {
                Matcher ma;
                String content;
                ++index;
                if (type == -9 || type == 12) {
                    content = this.rs.getString(this.trgCol);
                    if (content == null) continue;
                    if (content.indexOf(124) != -1) {
                        content = content.replaceAll("\\|", "");
                    }
                    if (!(ma = p.matcher(content)).find()) continue;
                    this.setTerm(this.rs, index);
                    continue;
                }
                if (type == 4 || type == 2) {
                    content = String.valueOf(this.rs.getInt(this.trgCol));
                    if (content == null || !(ma = p.matcher(content)).find()) continue;
                    this.setTerm(this.rs, index);
                    continue;
                }
                if (type == 91) {
                    content = this.rs.getDate(this.trgCol).toString();
                    if (content == null || !(ma = p.matcher(content)).find()) continue;
                    this.setTerm(this.rs, index);
                    continue;
                }
                if (type == 92) {
                    content = this.rs.getTime(this.trgCol).toString();
                    if (content == null || !(ma = p.matcher(content)).find()) continue;
                    this.setTerm(this.rs, index);
                    continue;
                }
                if (type != 93 || (content = this.rs.getTimestamp(this.srcCol).toString()) == null || !(ma = p.matcher(content)).find()) continue;
                this.setTerm(this.rs, index);
            }
            if (scrollType != 1003) {
                this.rs.beforeFirst();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void setOffset(int off) {
        this.offset = off;
    }

    public String getNextRowsQuery() {
        String q = null;
        if (this.sqlType == 0) {
            this.pointer = 1;
            this.offset = this.offset < 0 ? 0 : (this.offset += this.page);
            q = "SELECT * FROM " + this.tableName + " LIMIT " + Integer.toString(this.page) + " OFFSET " + Integer.toString(this.offset);
        } else if (this.sqlType == 1) {
            this.pointer = 1;
            this.offset = this.offset < 0 ? 0 : (this.offset += this.page);
            q = "SELECT docid, * FROM " + this.tableName + " LIMIT " + Integer.toString(this.page) + " OFFSET " + Integer.toString(this.offset);
        } else if (this.sqlType == 2) {
            this.pointer = 1;
            this.offset = this.offset < 0 ? 0 : (this.offset += this.page);
            q = "SELECT * FROM " + this.tableName + " LIMIT " + Integer.toString(this.offset) + "," + Integer.toString(this.page);
        }
        return q;
    }

    public String getPreviousRowsQuery() {
        String q = null;
        if (this.sqlType == 0) {
            this.pointer = 1;
            this.offset = this.offset < 0 || this.offset < this.page ? 0 : (this.offset -= this.page);
            q = "SELECT * FROM " + this.tableName + " LIMIT " + Integer.toString(this.page) + " OFFSET " + Integer.toString(this.offset);
        } else if (this.sqlType == 1) {
            this.pointer = 1;
            this.offset = this.offset < 0 || this.offset < this.page ? 0 : (this.offset -= this.page);
            q = "SELECT docid, * FROM " + this.tableName + " LIMIT " + Integer.toString(this.page) + " OFFSET " + Integer.toString(this.offset);
        } else if (this.sqlType == 2) {
            this.pointer = 1;
            this.offset = this.offset < 0 || this.offset < this.page ? 0 : (this.offset -= this.page);
            q = "SELECT * FROM " + this.tableName + " LIMIT " + Integer.toString(this.offset) + "," + Integer.toString(this.page);
        }
        return q;
    }

    public void fullTextSearchH2(String search) {
        int k = search.indexOf("\\Q");
        if (k != -1) {
            search = search.substring(k + 2, search.length() - 2);
        }
        int hits = AppPreferences.searchDisplayLimit;
        String q = "SELECT T.* FROM FT_SEARCH_DATA('" + search + "', 0, 0) FT, " + this.tableName + " T WHERE FT.TABLE='" + this.tableName + "' AND T.ID=FT.KEYS[0] LIMIT " + hits;
        this.setOffset(-1);
        this.selectRows(q);
        this.nextTerms();
    }

    public void fullTextSearchSQLite(String search, int column) {
        String q;
        String colName = this.cnames[column - 1];
        int k = search.indexOf("\\Q");
        if (k != -1) {
            search = search.substring(k + 2, search.length() - 2);
        }
        int hits = AppPreferences.searchDisplayLimit;
        if (search.indexOf(39) != -1) {
            search = search.replaceAll("'", "''");
        }
        if (AppPreferences.noWordSeparatorSourceLanguage) {
            search = "%" + search + "%";
            q = "SELECT docid, * FROM " + this.tableName + " WHERE " + colName + " LIKE '" + search + "' LIMIT " + hits + ";";
        } else {
            q = "SELECT docid, * FROM " + this.tableName + " WHERE " + colName + " MATCH '\"" + search + "\"' LIMIT " + hits + ";";
        }
        this.setOffset(-1);
        this.selectRows(q);
        this.nextTerms();
    }

    public void fullTextSearchMySQL(String search, int column) {
        String q;
        String colName = this.cnames[column - 1];
        int k = search.indexOf("\\Q");
        if (k != -1) {
            search = search.substring(k + 2, search.length() - 2);
        }
        int hits = AppPreferences.searchDisplayLimit;
        if (search.indexOf(39) != -1) {
            search = search.replaceAll("'", "''");
        }
        if (AppPreferences.noWordSeparatorSourceLanguage) {
            search = "%" + search + "%";
            q = "SELECT * FROM " + this.tableName + " WHERE " + colName + " LIKE '" + search + "' LIMIT " + hits + ";";
        } else {
            q = "SELECT * FROM " + this.tableName + " WHERE MATCH (" + colName + ") AGAINST ('\"" + search + "\"' IN BOOLEAN MODE) LIMIT " + hits + ";";
        }
        this.setOffset(-1);
        this.selectRows(q);
        this.nextTerms();
    }

    public String getH2QueryForWords(Set words, int hitsLimit) {
        Statement stat;
        String hits = Integer.toString(hitsLimit);
        TreeSet<String> idSet = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.valueOf(o1).compareTo(Integer.valueOf(o2));
            }
        });
        String wquery = null;
        try {
            stat = this.connection.createStatement();
        }
        catch (SQLException ex) {
            Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        Iterator it = words.iterator();
        while (it.hasNext()) {
            String word = it.next().toString();
            if (word.length() < AppPreferences.subsegmentMinimalLength) continue;
            String q = "SELECT * FROM FT_SEARCH_DATA('" + word + "', 0, 0) LIMIT " + hits;
            try {
                ResultSet rs2 = stat.executeQuery(q);
                while (rs2.next()) {
                    String tname = rs2.getString(2);
                    if (!tname.equalsIgnoreCase(this.tableName)) continue;
                    Array arr = rs2.getArray(4);
                    Object[] keys = (Object[])arr.getArray();
                    for (int i = 0; i < keys.length; ++i) {
                        idSet.add(keys[i].toString());
                    }
                }
            }
            catch (SQLException ex) {
            }
        }
        if (!idSet.isEmpty()) {
            StringBuilder sb = new StringBuilder(" WHERE ID IN (");
            for (String uid : idSet) {
                sb.append(uid);
                sb.append(',');
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
                wquery = "SELECT * FROM " + this.tableName + sb.toString() + ")";
            }
        }
        return wquery;
    }

    private Set createIDSet() {
        TreeSet<String> idSet = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Integer.valueOf(o1).compareTo(Integer.valueOf(o2));
            }
        });
        return idSet;
    }

    public String[] getMySQLQueriesForWords(Set words, int hitsLimit, List tables) {
        ArrayList<String> tnames;
        String colNameTrg;
        String colNameSrc;
        if (this.srcCol != -1) {
            colNameSrc = this.cnames[this.srcCol - 1];
        } else {
            colNameSrc = this.getSourceLang();
            if (colNameSrc != null) {
                if (colNameSrc.indexOf("-") != -1) {
                    colNameSrc = colNameSrc.replaceAll("-", "_");
                }
            } else {
                return null;
            }
        }
        if (this.trgCol != -1) {
            colNameTrg = this.cnames[this.trgCol - 1];
        } else {
            colNameTrg = this.getTargetLang();
            if (colNameTrg != null) {
                if (colNameTrg.indexOf("-") != -1) {
                    colNameTrg = colNameTrg.replaceAll("-", "_");
                }
            } else {
                return null;
            }
        }
        String hits = Integer.toString(hitsLimit);
        if (tables != null) {
            tnames = tables;
        } else {
            tnames = new ArrayList<String>(1);
            tnames.add(this.tableName);
        }
        String[] wqueries = new String[words.size() * tnames.size()];
        int qint = 0;
        Iterator iterator = tnames.iterator();
        while (iterator.hasNext()) {
            String s;
            int j;
            String tname = iterator.next().toString();
            boolean sourceLangSet = false;
            boolean targetLangSet = false;
            ArrayList<String> arr = new ArrayList<String>();
            try {
                DatabaseMetaData dmeta = this.connection.getMetaData();
                ResultSet rset = dmeta.getColumns(null, null, tname, null);
                while (rset.next()) {
                    String name = rset.getString("COLUMN_NAME");
                    if (name == null) continue;
                    arr.add(name);
                    if (name.equals(colNameSrc)) {
                        sourceLangSet = true;
                        continue;
                    }
                    if (!name.equals(colNameTrg)) continue;
                    targetLangSet = true;
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (!sourceLangSet) {
                int i = colNameSrc.lastIndexOf(95);
                if (i != -1) {
                    colNameSrc = colNameSrc.substring(0, i);
                }
                for (String next : arr) {
                    j = next.lastIndexOf(95);
                    if (j == -1 || !colNameSrc.equals(s = next.substring(0, j))) continue;
                    colNameSrc = next;
                    this.setSourceLang(next);
                    break;
                }
            }
            if (!targetLangSet) {
                int i = colNameTrg.lastIndexOf(95);
                if (i != -1) {
                    colNameTrg = colNameTrg.substring(0, i);
                }
                for (String next : arr) {
                    j = next.lastIndexOf(95);
                    if (j == -1 || !colNameTrg.equals(s = next.substring(0, j))) continue;
                    colNameTrg = next;
                    this.setTargetLang(next);
                    break;
                }
            }
            Iterator it = words.iterator();
            while (it.hasNext()) {
                String wquery;
                String word = it.next().toString();
                if (AppPreferences.noWordSeparatorSourceLanguage) {
                    if (word.indexOf(39) != -1) {
                        word = word.replaceAll("'", "''");
                    }
                    word = "%" + word + "%";
                    wqueries[qint] = wquery = "SELECT * FROM " + tname + " WHERE " + colNameSrc + " LIKE '" + word + "' LIMIT " + hits + ";";
                    ++qint;
                    continue;
                }
                if (word.length() < AppPreferences.subsegmentMinimalLength) continue;
                if (word.indexOf(39) != -1) {
                    word = word.replaceAll("'", "''");
                }
                wqueries[qint] = wquery = "SELECT * FROM " + tname + " WHERE MATCH (" + colNameSrc + ") AGAINST ('" + word + "') LIMIT " + hits + ";";
                ++qint;
            }
        }
        return wqueries;
    }

    public String[] getSQLiteQueriesForWords(Set words, int hitsLimit, List tables) {
        ArrayList<String> tnames;
        String colNameTrg;
        String colNameSrc;
        if (this.srcCol != -1) {
            colNameSrc = this.cnames[this.srcCol - 1];
        } else {
            colNameSrc = this.getSourceLang();
            if (colNameSrc != null) {
                if (colNameSrc.indexOf("-") != -1) {
                    colNameSrc = colNameSrc.replaceAll("-", "_");
                }
            } else {
                return null;
            }
        }
        if (this.trgCol != -1) {
            colNameTrg = this.cnames[this.trgCol - 1];
        } else {
            colNameTrg = this.getTargetLang();
            if (colNameTrg != null) {
                if (colNameTrg.indexOf("-") != -1) {
                    colNameTrg = colNameTrg.replaceAll("-", "_");
                }
            } else {
                return null;
            }
        }
        String hits = Integer.toString(hitsLimit);
        if (tables != null) {
            tnames = tables;
        } else {
            tnames = new ArrayList<String>(1);
            tnames.add(this.tableName);
        }
        String[] wqueries = new String[words.size() * tnames.size()];
        int qint = 0;
        Iterator iterator = tnames.iterator();
        while (iterator.hasNext()) {
            String s;
            int j;
            String tname = iterator.next().toString();
            boolean sourceLangSet = false;
            boolean targetLangSet = false;
            ArrayList<String> arr = new ArrayList<String>();
            try {
                DatabaseMetaData dmeta = this.connection.getMetaData();
                ResultSet rset = dmeta.getColumns(null, null, tname, null);
                while (rset.next()) {
                    String name = rset.getString("COLUMN_NAME");
                    if (name == null) continue;
                    arr.add(name);
                    if (name.equals(colNameSrc)) {
                        sourceLangSet = true;
                        continue;
                    }
                    if (!name.equals(colNameTrg)) continue;
                    targetLangSet = true;
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (!sourceLangSet) {
                int i = colNameSrc.lastIndexOf(95);
                if (i != -1) {
                    colNameSrc = colNameSrc.substring(0, i);
                }
                for (String next : arr) {
                    j = next.lastIndexOf(95);
                    if (j == -1 || !colNameSrc.equals(s = next.substring(0, j))) continue;
                    colNameSrc = next;
                    this.setSourceLang(next);
                    break;
                }
            }
            if (!targetLangSet) {
                int i = colNameTrg.lastIndexOf(95);
                if (i != -1) {
                    colNameTrg = colNameTrg.substring(0, i);
                }
                for (String next : arr) {
                    j = next.lastIndexOf(95);
                    if (j == -1 || !colNameTrg.equals(s = next.substring(0, j))) continue;
                    colNameTrg = next;
                    this.setTargetLang(next);
                    break;
                }
            }
            Iterator it = words.iterator();
            while (it.hasNext()) {
                String wquery;
                String word = it.next().toString();
                if (AppPreferences.noWordSeparatorSourceLanguage) {
                    if (word.indexOf(39) != -1) {
                        word = word.replaceAll("'", "''");
                    }
                    word = "%" + word + "%";
                    wqueries[qint] = wquery = "SELECT docid, * FROM " + tname + " WHERE " + colNameSrc + " LIKE '" + word + "' LIMIT " + hits + ";";
                    ++qint;
                    continue;
                }
                if (word.length() < AppPreferences.subsegmentMinimalLength) continue;
                if (word.indexOf(39) != -1) {
                    word = word.replaceAll("'", "''");
                }
                wqueries[qint] = wquery = "SELECT docid, * FROM " + tname + " WHERE " + colNameSrc + " MATCH '" + word + "' LIMIT " + hits + ";";
                ++qint;
            }
        }
        return wqueries;
    }

    public String[] getH2QueriesForWords(Set words, int hitsLimit, boolean allTables) {
        Set idSet;
        Statement stat;
        String hits = Integer.toString(hitsLimit);
        HashMap<String, Set> idSets = new HashMap<String, Set>();
        if (!allTables) {
            Set idSet2 = this.createIDSet();
            idSets.put(this.tableName, idSet2);
        }
        try {
            stat = this.connection.createStatement();
        }
        catch (SQLException ex) {
            Logger.getLogger(DBConnection.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        Iterator it = words.iterator();
        while (it.hasNext()) {
            String word = it.next().toString();
            if (word.length() < AppPreferences.subsegmentMinimalLength) continue;
            String q = "SELECT * FROM FT_SEARCH_DATA('" + word + "', 0, 0) LIMIT " + hits;
            try {
                int i;
                Object[] keys;
                Array arr;
                String tname;
                ResultSet rs2 = stat.executeQuery(q);
                if (!allTables) {
                    while (rs2.next()) {
                        tname = rs2.getString(2);
                        if (!tname.equalsIgnoreCase(this.tableName)) continue;
                        idSet = (Set)idSets.get(tname);
                        arr = rs2.getArray(4);
                        keys = (Object[])arr.getArray();
                        for (i = 0; i < keys.length; ++i) {
                            idSet.add(keys[i].toString());
                        }
                    }
                    continue;
                }
                while (rs2.next()) {
                    tname = rs2.getString(2);
                    idSet = (Set)idSets.get(tname);
                    if (idSet == null) {
                        idSet = this.createIDSet();
                        idSets.put(tname, idSet);
                    }
                    arr = rs2.getArray(4);
                    keys = (Object[])arr.getArray();
                    for (i = 0; i < keys.length; ++i) {
                        idSet.add(keys[i].toString());
                    }
                }
            }
            catch (SQLException ex) {
            }
        }
        String[] wqueries = new String[idSets.size()];
        int qint = 0;
        for (Map.Entry entry : idSets.entrySet()) {
            String wquery;
            String tbName = (String)entry.getKey();
            idSet = (Set)entry.getValue();
            if (idSet.isEmpty()) continue;
            StringBuilder sb = new StringBuilder(" WHERE ID IN (");
            for (String uid : idSet) {
                sb.append(uid);
                sb.append(',');
            }
            if (sb.length() <= 0) continue;
            sb.setLength(sb.length() - 1);
            wqueries[qint] = wquery = "SELECT * FROM " + tbName + sb.toString() + ")";
            ++qint;
        }
        return wqueries;
    }

    public String getQuery() {
        return this.query;
    }

    public Timestamp getTodayTimestamp() {
        Timestamp timeStamp = null;
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new java.util.Date());
            Date dt = new Date(calendar.getTimeInMillis());
            Time sqlTime = new Time(calendar.getTime().getTime());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            java.util.Date datee = simpleDateFormat.parse(dt.toString() + " " + sqlTime.toString());
            timeStamp = new Timestamp(datee.getTime());
        }
        catch (ParseException parseException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return timeStamp;
    }

    public void setURL(String s) {
        this.url = s;
        if (this.url != null) {
            if (this.url.indexOf("jdbc:h2:") != -1) {
                this.sqlType = 0;
            } else if (this.url.indexOf("jdbc:hsqldb:") != -1) {
                this.autoIncrementNull = true;
            } else if (this.url.indexOf("Microsoft Access") != -1) {
                this.fetchSize = 0;
            } else if (this.url.indexOf("jdbc:sqlite") != -1) {
                this.resultSetConcurrencyMode = 0;
                this.resultSetType = 0;
                this.sqlType = 1;
            } else if (this.url.indexOf("jdbc:mysql") != -1 || this.url.indexOf("jdbc:mariadb") != -1) {
                this.sqlType = 2;
            }
        }
    }

    public void setDriverClassName(String s) {
        this.driverClassName = s;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public int getSQLType() {
        return this.sqlType;
    }
}

