/*
 * Decompiled with CFR 0.152.
 */
package translator.database;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;
import translator.DashboardView;
import translator.MainView;
import translator.MySwingWorker;
import translator.NewResource;
import translator.Resource;
import translator.ResourceInfo;
import translator.TabView;
import translator.database.DBConnection;
import translator.database.DataBaseUI;
import translator.database.TableMaker;
import translator.database.TermBase;

public class DatabaseView {
    private MainView parent;
    private JMenu dbMenu;
    private JMenu basesMenu;
    private String urlName;
    private String driverClassName;
    private Connection connection = null;
    private LinkedHashMap tables = new LinkedHashMap();
    private ResourceInfo info;
    TermBase defaultTB;
    public boolean mergeTRMemories;

    public DatabaseView(MainView parent) {
        this.parent = parent;
        this.setDatabaseMenu();
    }

    public JMenu getMenu() {
        return this.dbMenu;
    }

    public void setDatabaseMenuName(String name) {
        this.basesMenu.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEMORY TABLES"));
    }

    private void setDatabaseMenu() {
        this.dbMenu = new JMenu("Total Recall");
        JMenuItem newdb = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW MEMORY TABLE..."));
        newdb.setName("MenuTRNewMemoryTable");
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_DATABASE_PLUS, (int)newdb.getFont().getSize(), (Color)newdb.getForeground());
        newdb.setIcon((Icon)ficon);
        newdb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseView.this.makeTable();
            }
        });
        this.basesMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CONNECTING TO DATABASE..."));
        this.basesMenu.setName("MenuTRMemoryTables");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_DATABASE, (int)this.basesMenu.getFont().getSize(), (Color)this.basesMenu.getForeground());
        this.basesMenu.setIcon((Icon)ficon);
        JMenuItem newEntry = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ADD NEW ENTRY"));
        newEntry.setName("MenuTRAddNewEntry");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_TABLE_ROW_PLUS_AFTER, (int)newEntry.getFont().getSize(), (Color)newEntry.getForeground());
        newEntry.setIcon((Icon)ficon);
        newEntry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Resource resource = DatabaseView.this.parent.getTabView().getCurrentResource();
                if (resource != null && resource instanceof TermBase) {
                    TermBase base = (TermBase)resource;
                    base.newEntry();
                }
            }
        });
        JMenuItem deleteEntry = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DELETE ENTRY"));
        deleteEntry.setName("MenuTRDeleteEntry");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_TABLE_ROW_REMOVE, (int)deleteEntry.getFont().getSize(), (Color)deleteEntry.getForeground());
        deleteEntry.setIcon((Icon)ficon);
        deleteEntry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Resource resource = DatabaseView.this.parent.getTabView().getCurrentResource();
                if (resource != null && resource instanceof TermBase) {
                    TermBase base = (TermBase)resource;
                    base.deleteEntry();
                }
            }
        });
        JMenuItem saveTable = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE AND REFRESH MEMORY TABLE"));
        saveTable.setName("MenuTRSaveAndRefreshMemoryTable");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_REFRESH, (int)saveTable.getFont().getSize(), (Color)saveTable.getForeground());
        saveTable.setIcon((Icon)ficon);
        saveTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Resource resource = DatabaseView.this.parent.getTabView().getCurrentResource();
                if (resource != null && resource instanceof TermBase) {
                    TermBase base = (TermBase)resource;
                    base.saveResource();
                }
            }
        });
        JMenuItem backupDB = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("BACKUP DATABASE"));
        backupDB.setName("MenuTRBackupDatabase");
        backupDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseView.this.backUpDatabase();
            }
        });
        JMenuItem infodb = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SHOW MEMORY TABLE INFO..."));
        infodb.setName("MenuTRShowMemoryTableInfo");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_INFORMATION, (int)infodb.getFont().getSize(), (Color)infodb.getForeground());
        infodb.setIcon((Icon)ficon);
        infodb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Resource r = DatabaseView.this.parent.getTabView().getCurrentResource();
                if (r instanceof TermBase) {
                    TermBase b = (TermBase)r;
                    b.showTableInfo(DatabaseView.this.parent);
                }
            }
        });
        JMenuItem loadDB1 = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RECALL MEMORY..."));
        loadDB1.setName("MenuTRRecallToMemory");
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_COFFEE, (int)loadDB1.getFont().getSize(), (Color)loadDB1.getForeground());
        loadDB1.setIcon((Icon)ficon);
        loadDB1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseView.this.parent.getMemoryView().TotalRecallToMemory();
            }
        });
        JMenuItem closeTable = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLOSE MEMORY TABLE"));
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CLOSE, (int)closeTable.getFont().getSize(), (Color)closeTable.getForeground());
        closeTable.setIcon((Icon)ficon);
        closeTable.setName("MenuTRCloseMemoryTable");
        closeTable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabView tview = DatabaseView.this.parent.getTabView();
                Resource resource = tview.getCurrentResource();
                if (resource != null && resource instanceof TermBase) {
                    resource.closeResource();
                }
            }
        });
        JMenu exchangeMenu = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT"));
        exchangeMenu.setName("MenuTRCATToolsExchange");
        JMenuItem loadTMX = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT TMX MEMORY") + "...");
        loadTMX.setName("MenuTRCATToolsExchangeLoadFromTMXMemory");
        loadTMX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseView.this.parent.getMemoryView().memoryOpen(2, DatabaseView.this.mergeTRMemories);
            }
        });
        JMenuItem loadCSV = new JMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT GLOSSARY") + "...");
        loadCSV.setName("MenuTRCATToolsExchangeLoadGlossaryOrTermList");
        loadCSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseView.this.loadGlossaryToTable();
            }
        });
        JCheckBoxMenuItem mergeTMs = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("IMPORT FILES IN FOLDER"));
        mergeTMs.setName("MenuMemoryMergeMemories");
        mergeTMs.setSelected(this.mergeTRMemories);
        mergeTMs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int i = e.getStateChange();
                DatabaseView.this.mergeTRMemories = i == 1;
            }
        });
        exchangeMenu.add(loadTMX);
        exchangeMenu.add(loadCSV);
        this.dbMenu.add(newdb);
        this.dbMenu.addSeparator();
        this.dbMenu.add(this.basesMenu);
        this.dbMenu.add(closeTable);
        this.dbMenu.addSeparator();
        this.dbMenu.add(loadDB1);
        this.dbMenu.addSeparator();
        this.dbMenu.add(mergeTMs);
        this.dbMenu.add(exchangeMenu);
        this.dbMenu.addSeparator();
        this.dbMenu.add(newEntry);
        this.dbMenu.add(deleteEntry);
        this.dbMenu.addSeparator();
        this.dbMenu.add(backupDB);
        this.dbMenu.add(saveTable);
        this.dbMenu.addSeparator();
        this.dbMenu.add(infodb);
    }

    JMenu getBasesMenu() {
        return this.basesMenu;
    }

    private void createDatabaseTab(String name, TermBase base) {
        DataBaseUI ui = new DataBaseUI(this.parent, base);
        base.setMainView(this.parent);
        base.setUI(ui);
        this.parent.getTabView().addTab(base, name, ui);
    }

    void setTablesMenu(List list) {
        this.basesMenu.removeAll();
        JMenu menu = this.basesMenu;
        int no = 0;
        for (Object object : list) {
            String name = object.toString();
            JCheckBoxMenuItem table = new JCheckBoxMenuItem(name);
            table.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getItem();
                    final String name = item.getText();
                    if (e.getStateChange() == 1) {
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 12 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            @Override
                            public void run() {
                                this.this$1.DatabaseView.this.openTable(name);
                            }
                        });
                    } else {
                        TermBase base = (TermBase)DatabaseView.this.tables.get(name);
                        if (base != null) {
                            base.closeResource();
                        }
                    }
                }
            });
            if (++no == 20) {
                JMenu more = new JMenu(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("MEMORY TABLES"));
                menu.addSeparator();
                menu.add(more);
                menu = more;
                no = 0;
            }
            menu.add(table);
        }
    }

    public TermBase connectToTermBase(String name, String slang, String tlang) {
        if (this.info == null) {
            return null;
        }
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.connection = this.makeConnection(this.info);
            }
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this.parent, ex.toString(), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DATABASE ACCESS ERROR!"), 0);
            ex.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException ex) {
            JOptionPane.showMessageDialog(this.parent, ex.toString(), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DATABASE DRIVER IS NOT INSTALLED!"), 1);
            ex.printStackTrace();
            return null;
        }
        DBConnection con = new DBConnection(this.connection);
        con.setURL(this.urlName);
        con.setDriverClassName(this.driverClassName);
        con.setSourceLang(slang);
        con.setTargetLang(tlang);
        con.setClientIDName(AppPreferences.dbClientCol);
        con.setFieldName(AppPreferences.dbFieldCol);
        con.setContextName(AppPreferences.dbContextCol);
        con.setNotesName(AppPreferences.dbNotesCol);
        con.setReferenceName(AppPreferences.dbURLCol);
        TermBase base = new TermBase(name);
        base.setConnection(con);
        base.openResource();
        return base;
    }

    public HashMap getTables() {
        return this.tables;
    }

    public String getURL() {
        return this.urlName;
    }

    public void prepareDatabase(final ResourceInfo ri) {
        MySwingWorker worker = new MySwingWorker(this){
            final /* synthetic */ DatabaseView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object construct() {
                try {
                    if (this.this$0.connection != null && !this.this$0.connection.isClosed()) {
                        this.this$0.connection.close();
                    }
                    this.this$0.connection = this.this$0.makeConnection(ri);
                }
                catch (SQLException ex) {
                    this.this$0.connection = null;
                    System.out.println(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DATABASE ACCESS ERROR!"));
                    ex.printStackTrace();
                }
                catch (ClassNotFoundException ex) {
                    this.this$0.connection = null;
                    System.out.println(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DATABASE DRIVER IS NOT INSTALLED!"));
                    ex.printStackTrace();
                }
                return null;
            }

            @Override
            public void finished() {
                if (this.this$0.connection != null) {
                    this.this$0.info = ri;
                    this.this$0.setDatabaseMenuName(AppPreferences.database);
                    List list = this.this$0.getTableNames();
                    this.this$0.setTablesMenu(list);
                    DashboardView dashboard = this.this$0.parent.getDashboardView();
                    if (dashboard != null) {
                        dashboard.setDatabaseTables(list);
                    }
                    try {
                        this.this$0.connection.close();
                    }
                    catch (SQLException ex) {
                        Logger.getLogger(DatabaseView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        };
        worker.start();
    }

    synchronized Connection makeConnection(ResourceInfo ri) throws SQLException, ClassNotFoundException {
        String driverFile = ri.getDriverFile();
        String driverClass = ri.getDriverClass();
        String url = ri.getConnectionURL();
        String user = ri.getUserName();
        String pass = ri.getPassword();
        Properties props = new Properties();
        if (user != null) {
            props.put("user", user);
        }
        if (pass != null) {
            props.put("password", pass);
        }
        Connection dbConnection = null;
        if (driverClass != null) {
            if (driverClass.equals("org.apache.derby.jdbc.EmbeddedDriver")) {
                String databaseDir = AppPreferences.packagePath + "resources" + AppPreferences.fs + "databases" + AppPreferences.fs;
                System.setProperty("derby.system.home", databaseDir);
                url = url + "; create=true";
            }
            if (driverFile != null) {
                File file = new File(driverFile);
                if (file.exists()) {
                    URL[] urls = new URL[1];
                    try {
                        urls[0] = file.toURI().toURL();
                    }
                    catch (MalformedURLException ex) {
                        Logger.getLogger(DatabaseView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    URLClassLoader loader = new URLClassLoader(urls);
                    loader.loadClass(driverClass);
                    Class.forName(driverClass);
                }
            } else {
                Class.forName(driverClass);
            }
            this.driverClassName = driverClass;
            if (url != null) {
                int i = url.indexOf("file:.");
                if (i != -1) {
                    String databaseDir = AppPreferences.packagePath + "resources" + AppPreferences.fs + "databases";
                    url = url.replace("file:.", "file:" + databaseDir);
                }
                this.urlName = url;
                AppPreferences.columnSize = this.urlName != null && this.urlName.indexOf("Microsoft Access") != -1 ? 255 : 1600;
                dbConnection = props.size() > 0 ? DriverManager.getConnection(url, props) : DriverManager.getConnection(url);
            }
        }
        return dbConnection;
    }

    public void backUpDatabase() {
        if (this.info == null) {
            return;
        }
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.connection = this.makeConnection(this.info);
            }
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this.parent, ex.toString(), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DATABASE ACCESS ERROR!"), 0);
            ex.printStackTrace();
            return;
        }
        catch (ClassNotFoundException ex) {
            JOptionPane.showMessageDialog(this.parent, ex.toString(), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DATABASE DRIVER IS NOT INSTALLED!"), 1);
            ex.printStackTrace();
            return;
        }
        if (this.connection != null) {
            DBConnection con = new DBConnection(this.connection);
            con.setURL(this.urlName);
            con.setDriverClassName(this.driverClassName);
            String s = con.backup();
            if (s != null) {
                JOptionPane.showMessageDialog(this.parent, s + " file created in CafeTran's working directory.");
            } else {
                JOptionPane.showMessageDialog(this.parent, "CafeTran cannot backup this type of database.");
            }
        }
    }

    public void openTable(String name) {
        TermBase base = this.connectToTermBase(name, AppPreferences.fileSLang, AppPreferences.fileTLang);
        if (base != null) {
            this.parent.setCursor(Cursor.getPredefinedCursor(3));
            base.setLoaded(true);
            this.createDatabaseTab(name, base);
            this.tables.put(name, base);
            this.defaultTB = base;
            this.parent.setCursor(null);
        }
    }

    public void makeTable() {
        if (this.info == null) {
            return;
        }
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.connection = this.makeConnection(this.info);
            }
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(this.parent, ex.toString(), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DATABASE ACCESS ERROR!"), 0);
            ex.printStackTrace();
            return;
        }
        catch (ClassNotFoundException ex) {
            JOptionPane.showMessageDialog(this.parent, ex.toString(), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DATABASE DRIVER IS NOT INSTALLED!"), 1);
            ex.printStackTrace();
            return;
        }
        if (this.connection != null) {
            TableMaker dlg = new TableMaker(this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NEW MEMORY TABLE"), this.connection);
            Dimension dlgSize = dlg.getPreferredSize();
            Dimension frmSize = this.parent.getSize();
            Point loc = this.parent.getLocationOnScreen();
            dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            dlg.setVisible(true);
        }
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    public List getTableNames() {
        ArrayList<String> tnames = new ArrayList<String>();
        if (this.info != null) {
            try {
                int i;
                ResultSet resultSet;
                if (this.connection == null || this.connection.isClosed()) {
                    this.connection = this.makeConnection(this.info);
                }
                DatabaseMetaData dbmd = this.connection.getMetaData();
                String[] types = new String[]{"TABLE"};
                if (this.urlName.startsWith("jdbc:oracle")) {
                    Statement stmt = this.connection.createStatement();
                    resultSet = stmt.executeQuery("SELECT * FROM user_tables");
                    i = 1;
                } else {
                    String n = this.connection.getCatalog();
                    resultSet = n != null && n.length() > 0 ? dbmd.getTables(n, "PUBLIC", "%", types) : dbmd.getTables(null, "PUBLIC", "%", types);
                    i = 3;
                }
                boolean sqlite = false;
                if (this.urlName.startsWith("jdbc:sqlite")) {
                    sqlite = true;
                }
                while (resultSet.next()) {
                    String tableName = resultSet.getString(i);
                    if (sqlite && (tableName.endsWith("_content") || tableName.endsWith("_segments") || tableName.endsWith("_docsize") || tableName.endsWith("_stat") || tableName.endsWith("_segdir"))) continue;
                    tnames.add(tableName);
                }
            }
            catch (SQLException e) {
                System.out.println(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DATABASE ACCESS ERROR!"));
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                System.out.println(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DATABASE DRIVER IS NOT INSTALLED!"));
                e.printStackTrace();
            }
        }
        return tnames;
    }

    public void searchTables(final String s, final String r, final int mode) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ DatabaseView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                Collection t = this.this$0.tables.values();
                for (Object object : t) {
                    TermBase tb = (TermBase)object;
                    if (mode == 6) {
                        tb.searchSource(s, r);
                        continue;
                    }
                    if (mode != 7) continue;
                    tb.searchTarget(s, r);
                }
            }
        });
    }

    public void addTermToTablesDirect() {
        if (this.tables != null) {
            Collection t = this.tables.values();
            for (Object object : t) {
                TermBase tb = (TermBase)object;
                if (tb.isBlocked()) continue;
                tb.addEntryDirectToBase();
            }
        }
    }

    public void addTermToTables(String source, String target, String user, String field, String note, String reference, String context) {
        if (this.tables != null) {
            Collection t = this.tables.values();
            for (Object object : t) {
                TermBase tb = (TermBase)object;
                if (tb.isBlocked()) continue;
                tb.addEntry(source, target, user, field, note, reference, context);
            }
        }
    }

    public TermBase getTermBase() {
        Resource resource = this.parent.getTabView().getCurrentResource();
        if (resource != null && resource instanceof TermBase) {
            TermBase base = (TermBase)resource;
            return base;
        }
        return this.defaultTB;
    }

    public void loadGlossaryToTable() {
        String s = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("GLOSSARY");
        String t = "Glossary";
        String rp = AppPreferences.packagePath + "forms/" + t + "AddResource";
        NewResource dlg = new NewResource(this.parent, s, rp, 8);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocationOnScreen();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
    }
}

