/*
 * Decompiled with CFR 0.152.
 */
package translator.database;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import translator.AppPreferences;
import translator.LanguageCodes;
import translator.MainView;
import translator.database.DBConnection;
import translator.database.DataBaseUI;
import translator.database.DatabaseView;
import translator.database.TermBase;

public class TableInfoDialog
extends JDialog
implements ActionListener {
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JComboBox combo1;
    private JComboBox combo2;
    private TermBase base;
    private DBConnection connection;
    private MainView parent;
    private List fields;

    public TableInfoDialog(MainView parent, TermBase base) {
        super(parent, base.getName(), true);
        this.parent = parent;
        this.base = base;
        this.connection = base.getConnection();
        int count = -1;
        String version = this.connection.getVersion();
        int[] ctypes = this.connection.getColumnTypes();
        if (ctypes == null) {
            String nq = this.connection.getNextRowsQuery();
            if (nq == null) {
                this.connection.selectAllRows();
            } else {
                this.connection.selectRows(nq);
            }
            ctypes = this.connection.getColumnTypes();
        }
        String[] cnames = this.connection.getColumnNamesArray();
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel0 = new JPanel();
        jPanel0.setBorder(new EmptyBorder(new Insets(10, 0, 0, 0)));
        jPanel0.setLayout(new GridLayout(0, 3, 10, 0));
        jPanel0.setOpaque(false);
        JPanel jPanel4 = new JPanel();
        jPanel4.setOpaque(false);
        jPanel4.setBorder(new CompoundBorder(new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LANGUAGE PAIR")), new EmptyBorder(new Insets(3, 3, 3, 3))));
        jPanel4.setLayout(new GridLayout(0, 3, 10, 3));
        jPanel2.add((Component)jPanel4, "Center");
        this.fields = new ArrayList();
        this.combo1 = new JComboBox();
        this.combo2 = new JComboBox();
        for (int i = 0; i < ctypes.length; ++i) {
            String name;
            int type = ctypes[i];
            if (type != -9 && type != 12 || i >= cnames.length || (name = cnames[i]) == null) continue;
            this.fields.add(name);
            String val = LanguageCodes.getName(name.replace("_", "-"));
            if (val != null) {
                name = val;
            }
            this.combo1.addItem(name);
            this.combo2.addItem(name);
        }
        String source = this.connection.getSourceLang();
        String target = this.connection.getTargetLang();
        String val = LanguageCodes.getName(source);
        if (val == null) {
            val = LanguageCodes.getName(AppPreferences.fileSLang);
        }
        if (val != null) {
            this.combo1.setSelectedItem(val);
        } else {
            this.combo1.setSelectedItem(source);
            this.combo1.setSelectedItem(source.toUpperCase());
        }
        val = LanguageCodes.getName(target);
        if (val == null) {
            val = LanguageCodes.getName(AppPreferences.fileTLang);
        }
        if (val != null) {
            this.combo2.setSelectedItem(val);
        } else {
            this.combo2.setSelectedItem(target);
            this.combo2.setSelectedItem(target.toUpperCase());
        }
        this.setResizable(false);
        this.jButton1 = new JButton();
        this.jButton1.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jButton1.addActionListener(this);
        this.jButton3 = new JButton();
        this.jButton3.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jButton3.addActionListener(this);
        this.jButton2 = new JButton();
        this.jButton2.setMnemonic(87);
        this.jButton2.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SWITCH"));
        this.jButton2.addActionListener(this);
        this.jButton4 = new JButton();
        this.jButton4.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DELETE"));
        this.jButton4.addActionListener(this);
        jPanel4.add(this.combo1);
        jPanel4.add(this.jButton2);
        jPanel4.add(this.combo2);
        jPanel0.add(this.jButton1);
        jPanel0.add(this.jButton4);
        jPanel0.add(this.jButton3);
        JPanel con = (JPanel)this.getContentPane();
        this.setContentPane(con);
        Border border = BorderFactory.createEmptyBorder(5, 10, 5, 10);
        con.setBorder(border);
        con.setLayout(new BorderLayout());
        if (count != -1) {
            String s = " (" + Integer.toString(count) + " entries)";
            String t = this.getTitle() + s;
            if (version != null) {
                t = t + " in " + version + " database";
            }
            this.setTitle(t);
        } else {
            String t = this.getTitle();
            if (version != null) {
                t = t + " in " + version + " database";
            }
            this.setTitle(t);
        }
        con.add((Component)jPanel2, "Center");
        con.add((Component)jPanel0, "South");
        con.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableInfoDialog.this.jButton1.doClick();
            }
        });
        con.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableInfoDialog.this.jButton3.doClick();
            }
        });
        con.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        con.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TableInfoDialog.this.cancel();
            }
        });
        this.pack();
    }

    void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    void cancel() {
        this.closeDialog();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jButton1) {
            String slang = (String)this.fields.get(this.combo1.getSelectedIndex());
            String tlang = (String)this.fields.get(this.combo2.getSelectedIndex());
            String sl = this.connection.getSourceLang();
            String tl = this.connection.getTargetLang();
            boolean change = false;
            if (!sl.equalsIgnoreCase(slang)) {
                change = true;
                this.connection.setSourceLang(slang);
            }
            if (!tl.equalsIgnoreCase(tlang)) {
                change = true;
                this.connection.setTargetLang(tlang);
            }
            if (change) {
                this.connection.setOffset(-1);
                String nq = this.connection.getNextRowsQuery();
                if (nq == null) {
                    this.connection.selectAllRows();
                } else {
                    this.connection.selectRows(nq);
                }
                this.connection.nextTerms();
                DataBaseUI ui = this.base.getUI();
                if (ui != null) {
                    ui.refreshUI();
                }
            }
            this.closeDialog();
        } else if (e.getSource() == this.jButton2) {
            String s1 = (String)this.combo1.getSelectedItem();
            String s2 = (String)this.combo2.getSelectedItem();
            this.combo1.setSelectedItem(s2);
            this.combo2.setSelectedItem(s1);
        } else if (e.getSource() == this.jButton4) {
            int i = JOptionPane.showConfirmDialog(this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("THE SELECTED TABLE WILL BE DELETED PERMANENTLY!"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DELETE MEMORY TABLE?"), 2);
            if (i == 0) {
                final String name = this.base.getName();
                final JProgressBar bar = this.parent.getPretranslateProgressBar();
                bar.setIndeterminate(true);
                bar.setStringPainted(true);
                bar.setString("Deleting " + this.getTitle() + "...");
                this.setVisible(false);
                SwingWorker worker = new SwingWorker(this){
                    final /* synthetic */ TableInfoDialog this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public String doInBackground() {
                        this.this$0.connection.deleteTable(name);
                        this.this$0.base.closeResource();
                        return null;
                    }

                    @Override
                    protected void done() {
                        DatabaseView dv = this.this$0.parent.getDatabaseView();
                        List list = dv.getTableNames();
                        dv.setTablesMenu(list);
                        this.this$0.closeDialog();
                        this.this$0.parent.removePretranslateProgressBar(bar);
                    }
                };
                worker.execute();
            }
        } else {
            this.cancel();
        }
    }
}

