/*
 * Decompiled with CFR 0.152.
 */
package translator.database;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import translator.AppPreferences;
import translator.DashboardView;
import translator.LanguageCodes;
import translator.MainView;
import translator.database.DatabaseView;

final class TableMaker
extends JDialog
implements ActionListener {
    private JComboBox comboL1 = null;
    private JComboBox comboL2 = null;
    private JComboBox comboL3 = null;
    private JComboBox comboL4 = null;
    private JComboBox comboL5 = null;
    private JComboBox comboL6 = null;
    private JComboBox comboL7 = null;
    private JComboBox comboL8 = null;
    private JComboBox DBClient = null;
    private JComboBox DBField = null;
    private JComboBox DBContext = null;
    private JComboBox DBNotes = null;
    private JComboBox DBRef = null;
    private JTextField namefield;
    private JButton jb1;
    private JButton jb2;
    private Connection connection;
    MainView parent;

    TableMaker(MainView parent, String title, Connection connection) {
        super(parent, title, true);
        this.parent = parent;
        this.connection = connection;
        this.enableEvents(64L);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel dbasePanel1 = new JPanel();
        dbasePanel1.setOpaque(false);
        dbasePanel1.setLayout(new GridLayout(0, 1, 5, 5));
        dbasePanel1.setBorder(new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PROPERTIES")));
        if (AppPreferences.dbFieldCol.length() > 0) {
            JLabel fieldCol = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SUBJECT COLUMN NAME:"));
            fieldCol.setHorizontalAlignment(2);
            dbasePanel1.add(fieldCol);
            this.DBField = new JComboBox();
            this.DBField.addItem("");
            this.DBField.addItem(AppPreferences.dbFieldCol);
            this.DBField.setEditable(true);
            dbasePanel1.add(this.DBField);
        }
        if (AppPreferences.dbClientCol.length() > 0) {
            JLabel userCol = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLIENT COLUMN NAME:"));
            userCol.setHorizontalAlignment(2);
            dbasePanel1.add(userCol);
            this.DBClient = new JComboBox();
            this.DBClient.addItem("");
            this.DBClient.addItem(AppPreferences.dbClientCol);
            this.DBClient.setEditable(true);
            dbasePanel1.add(this.DBClient);
        }
        if (AppPreferences.dbNotesCol.length() > 0) {
            JLabel notesCol = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NOTES COLUMN NAME:"));
            notesCol.setHorizontalAlignment(2);
            dbasePanel1.add(notesCol);
            this.DBNotes = new JComboBox();
            this.DBNotes.addItem("");
            this.DBNotes.addItem(AppPreferences.dbNotesCol);
            this.DBNotes.setEditable(true);
            dbasePanel1.add(this.DBNotes);
        }
        if (AppPreferences.dbURLCol.length() > 0) {
            JLabel refCol = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REFERENCE COLUMN NAME:"));
            refCol.setHorizontalAlignment(2);
            dbasePanel1.add(refCol);
            this.DBRef = new JComboBox();
            this.DBRef.addItem("");
            this.DBRef.addItem(AppPreferences.dbURLCol);
            this.DBRef.setEditable(true);
            dbasePanel1.add(this.DBRef);
        }
        if (AppPreferences.dbContextCol.length() > 0) {
            JLabel contextCol = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CONTEXT COLUMN NAME:"));
            contextCol.setHorizontalAlignment(2);
            dbasePanel1.add(contextCol);
            this.DBContext = new JComboBox();
            this.DBContext.addItem("");
            this.DBContext.addItem(AppPreferences.dbContextCol);
            this.DBContext.setEditable(true);
            dbasePanel1.add(this.DBContext);
        }
        JLabel langCols = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LANGUAGES") + ":");
        langCols.setHorizontalAlignment(2);
        dbasePanel1.add(langCols);
        if (AppPreferences.dbOneCol.length() == 0) {
            AppPreferences.dbOneCol = AppPreferences.fileSLang;
        }
        if (AppPreferences.dbTwoCol.length() == 0) {
            AppPreferences.dbTwoCol = AppPreferences.fileTLang;
        }
        this.comboL1 = new JComboBox<String>(LanguageCodes.getNames());
        this.comboL1.insertItemAt("", 0);
        this.comboL1.setEditable(true);
        String val = LanguageCodes.getName(AppPreferences.dbOneCol);
        if (val == null) {
            val = LanguageCodes.getName(AppPreferences.fileSLang);
        }
        if (val != null) {
            this.comboL1.setSelectedItem(val);
        } else {
            this.comboL1.setSelectedItem(AppPreferences.dbOneCol);
        }
        dbasePanel1.add(this.comboL1);
        this.comboL2 = new JComboBox<String>(LanguageCodes.getNames());
        this.comboL2.insertItemAt("", 0);
        this.comboL2.setEditable(true);
        val = LanguageCodes.getName(AppPreferences.dbTwoCol);
        if (val == null) {
            val = LanguageCodes.getName(AppPreferences.fileTLang);
        }
        if (val != null) {
            this.comboL2.setSelectedItem(val);
        } else {
            this.comboL2.setSelectedItem(AppPreferences.dbTwoCol);
        }
        dbasePanel1.add(this.comboL2);
        if (AppPreferences.dbThreeCol.length() > 0) {
            this.comboL3 = new JComboBox<String>(LanguageCodes.getNames());
            this.comboL3.insertItemAt("", 0);
            this.comboL3.setEditable(true);
            this.comboL3.setSelectedIndex(0);
            dbasePanel1.add(this.comboL3);
        }
        if (AppPreferences.dbFourCol.length() > 0) {
            this.comboL4 = new JComboBox<String>(LanguageCodes.getNames());
            this.comboL4.insertItemAt("", 0);
            this.comboL4.setEditable(true);
            this.comboL4.setSelectedIndex(0);
            dbasePanel1.add(this.comboL4);
        }
        if (AppPreferences.dbFiveCol.length() > 0) {
            this.comboL5 = new JComboBox<String>(LanguageCodes.getNames());
            this.comboL5.insertItemAt("", 0);
            this.comboL5.setEditable(true);
            this.comboL5.setSelectedIndex(0);
            dbasePanel1.add(this.comboL5);
        }
        if (AppPreferences.dbSixCol.length() > 0) {
            this.comboL6 = new JComboBox<String>(LanguageCodes.getNames());
            this.comboL6.insertItemAt("", 0);
            this.comboL6.setEditable(true);
            this.comboL6.setSelectedIndex(0);
            dbasePanel1.add(this.comboL6);
        }
        if (AppPreferences.dbSevenCol.length() > 0) {
            this.comboL7 = new JComboBox<String>(LanguageCodes.getNames());
            this.comboL7.insertItemAt("", 0);
            this.comboL7.setEditable(true);
            this.comboL7.setSelectedIndex(0);
            dbasePanel1.add(this.comboL7);
        }
        if (AppPreferences.dbEightCol.length() > 0) {
            this.comboL8 = new JComboBox<String>(LanguageCodes.getNames());
            this.comboL8.insertItemAt("", 0);
            this.comboL8.setEditable(true);
            this.comboL8.setSelectedIndex(0);
            dbasePanel1.add(this.comboL8);
        }
        this.namefield = new JTextField();
        this.namefield.setPreferredSize(new Dimension(200, this.namefield.getPreferredSize().height));
        this.jb1 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jb2 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jb1.addActionListener(this);
        this.jb2.addActionListener(this);
        JPanel panel1 = new JPanel();
        panel1.setOpaque(false);
        panel1.setLayout(new GridLayout(0, 1, 5, 5));
        panel1.setBorder(new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TABLE NAME:")));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridLayout(0, 2, 10, 0));
        panel2.setOpaque(false);
        panel2.setBorder(new EmptyBorder(new Insets(10, 0, 5, 0)));
        JPanel panel3 = (JPanel)this.getContentPane();
        panel3.setBorder(new EmptyBorder(new Insets(10, 10, 0, 10)));
        panel3.setLayout(new BorderLayout());
        this.setResizable(false);
        panel1.add(this.namefield);
        panel2.add(this.jb1);
        panel2.add(this.jb2);
        panel3.add((Component)panel1, "North");
        panel3.add((Component)dbasePanel1, "Center");
        panel3.add((Component)panel2, "South");
        panel3.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableMaker.this.jb1.doClick();
            }
        });
        panel3.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableMaker.this.jb2.doClick();
            }
        });
        panel3.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        panel3.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    private void cancel() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jb2) {
            this.cancel();
        } else if (e.getSource() == this.jb1 && this.connection != null) {
            JProgressBar bar = this.parent.getPretranslateProgressBar();
            bar.setIndeterminate(true);
            bar.setStringPainted(true);
            bar.setString("Creating " + this.namefield.getText() + "...");
            this.setVisible(false);
            this.makeTable();
            DatabaseView dv = this.parent.getDatabaseView();
            List list = dv.getTableNames();
            dv.setTablesMenu(list);
            DashboardView dashboard = this.parent.getDashboardView();
            if (dashboard != null) {
                dashboard.setDatabaseTables(list);
            }
            this.parent.removePretranslateProgressBar(bar);
            this.dispose();
        }
    }

    private void makeTable() {
        String createCommand;
        String s;
        String s2;
        String s3;
        String s4;
        String s5;
        String name;
        StringBuilder langs = new StringBuilder();
        String lang = (String)this.comboL1.getSelectedItem();
        String lang1 = "";
        if (lang.length() > 0) {
            String val = LanguageCodes.getCode(lang);
            lang1 = val != null ? val : lang;
            langs.append(lang1);
        }
        lang = (String)this.comboL2.getSelectedItem();
        String lang2 = "";
        if (lang.length() > 0) {
            String val = LanguageCodes.getCode(lang);
            lang2 = val != null ? val : lang;
            if (langs.length() > 0) {
                langs.append(',');
            }
            langs.append(lang2);
        }
        String lang3 = "";
        if (this.comboL3 != null && (lang = (String)this.comboL3.getSelectedItem()).length() > 0) {
            String val = LanguageCodes.getCode(lang);
            lang3 = val != null ? val : lang;
            if (langs.length() > 0) {
                langs.append(',');
            }
            langs.append(lang3);
        }
        String lang4 = "";
        if (this.comboL4 != null && (lang = (String)this.comboL4.getSelectedItem()).length() > 0) {
            String val = LanguageCodes.getCode(lang);
            lang4 = val != null ? val : lang;
            if (langs.length() > 0) {
                langs.append(',');
            }
            langs.append(lang4);
        }
        String lang5 = "";
        if (this.comboL5 != null && (lang = (String)this.comboL5.getSelectedItem()).length() > 0) {
            String val = LanguageCodes.getCode(lang);
            lang5 = val != null ? val : lang;
            if (langs.length() > 0) {
                langs.append(',');
            }
            langs.append(lang5);
        }
        String lang6 = "";
        if (this.comboL6 != null && (lang = (String)this.comboL6.getSelectedItem()).length() > 0) {
            String val = LanguageCodes.getCode(lang);
            lang6 = val != null ? val : lang;
            if (langs.length() > 0) {
                langs.append(',');
            }
            langs.append(lang6);
        }
        String lang7 = "";
        if (this.comboL7 != null && (lang = (String)this.comboL7.getSelectedItem()).length() > 0) {
            String val = LanguageCodes.getCode(lang);
            lang7 = val != null ? val : lang;
            if (langs.length() > 0) {
                langs.append(',');
            }
            langs.append(lang7);
        }
        String lang8 = "";
        if (this.comboL8 != null && (lang = (String)this.comboL8.getSelectedItem()).length() > 0) {
            String val = LanguageCodes.getCode(lang);
            lang8 = val != null ? val : lang;
            if (langs.length() > 0) {
                langs.append(',');
            }
            langs.append(lang8);
        }
        if ((name = this.namefield.getText()).indexOf("-") != -1) {
            name = name.replaceAll("-", "_");
        }
        if (name.indexOf(" ") != -1) {
            name = name.replaceAll(" ", "_");
        }
        String context = null;
        if (this.DBContext != null && (s5 = (String)this.DBContext.getSelectedItem()).trim().length() > 0) {
            context = s5;
        }
        String subject = null;
        if (this.DBField != null && (s4 = (String)this.DBField.getSelectedItem()).trim().length() > 0) {
            subject = s4;
        }
        String user = null;
        if (this.DBClient != null && (s3 = (String)this.DBClient.getSelectedItem()).trim().length() > 0) {
            user = s3;
        }
        String notes = null;
        if (this.DBNotes != null && (s2 = (String)this.DBNotes.getSelectedItem()).trim().length() > 0) {
            notes = s2;
        }
        String reference = null;
        if (this.DBRef != null && (s = (String)this.DBRef.getSelectedItem()).trim().length() > 0) {
            reference = s;
        }
        StringBuffer sb = new StringBuffer();
        StringBuilder createIndexCommand = null;
        StringBuilder sqlColumns = new StringBuilder("(");
        StringBuilder sqlValues = new StringBuilder("(");
        String driver = this.parent.getDatabaseView().getURL();
        int db = 0;
        boolean H2 = false;
        boolean sqlite = false;
        boolean mysql = false;
        if (driver != null && driver.indexOf("jdbc:h2:") != -1) {
            createCommand = "CREATE TABLE " + name + " (Id INTEGER not null primary key AUTO_INCREMENT,";
            H2 = true;
        } else if (driver != null && driver.indexOf("jdbc:derby:") != -1) {
            createCommand = "CREATE TABLE " + name + " (Id INTEGER not null primary key GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),";
        } else if (driver != null && driver.indexOf("jdbc:hsqldb:") != -1) {
            createCommand = "CREATE CACHED TABLE " + name + " (Id INTEGER GENERATED ALWAYS AS IDENTITY PRIMARY KEY,";
        } else if (driver != null && driver.indexOf("jdbc:oracle") != -1) {
            createCommand = "CREATE TABLE " + name + " (Id INTEGER not null PRIMARY KEY,";
            db = 1;
        } else if (driver != null && driver.indexOf("Microsoft Access") != -1) {
            createCommand = "CREATE TABLE " + name + " (Id AUTOINCREMENT PRIMARY KEY,";
            db = 2;
        } else if (driver != null && driver.indexOf("jdbc:sqlite") != -1) {
            createCommand = "CREATE TABLE " + name + " (Id INTEGER not null PRIMARY KEY,";
            createIndexCommand = new StringBuilder("CREATE VIRTUAL TABLE " + name + " USING fts4(");
            sqlite = true;
        } else if (driver != null && (driver.indexOf("jdbc:mysql") != -1 || driver.indexOf("jdbc:mariadb") != -1)) {
            createCommand = "CREATE TABLE " + name + " (Id INTEGER not null primary key AUTO_INCREMENT,";
            createIndexCommand = new StringBuilder("");
            mysql = true;
        } else {
            createCommand = "CREATE TABLE " + name + " (Id INTEGER not null primary key AUTO_INCREMENT,";
        }
        String tableName = name;
        sb.append(createCommand);
        if (db == 1) {
            sb.append("Day DATE,");
        } else if (db == 2) {
            sb.append("Day DATETIME,");
        } else {
            sb.append("Date DATE,");
        }
        if (user != null) {
            name = user;
            if (name.indexOf("-") != -1) {
                name = name.replaceAll("-", "_");
            }
            sb.append(name + " VARCHAR(100),");
            if (sqlite) {
                createIndexCommand.append(name);
                createIndexCommand.append(", ");
                sqlColumns.append(name);
                sqlColumns.append(",");
                sqlValues.append("'#");
                sqlValues.append(name);
                sqlValues.append("', ");
            } else if (mysql) {
                createIndexCommand.append(" FULLTEXT(");
                createIndexCommand.append(name);
                createIndexCommand.append("),");
            }
        }
        if (subject != null) {
            name = subject;
            if (name.indexOf("-") != -1) {
                name = name.replaceAll("-", "_");
            }
            sb.append(name + " VARCHAR(100),");
            if (sqlite) {
                createIndexCommand.append(name);
                createIndexCommand.append(", ");
                sqlColumns.append(name);
                sqlColumns.append(",");
                sqlValues.append("'#");
                sqlValues.append(name);
                sqlValues.append("', ");
            } else if (mysql) {
                createIndexCommand.append(" FULLTEXT(");
                createIndexCommand.append(name);
                createIndexCommand.append("),");
            }
        }
        if (lang1.trim().length() > 0) {
            name = lang1;
            if (name.indexOf("-") != -1) {
                name = name.replaceAll("-", "_");
            }
            sb.append(name + " VARCHAR(" + AppPreferences.columnSize + "),");
            if (sqlite) {
                createIndexCommand.append(name);
                createIndexCommand.append(", ");
                sqlColumns.append(name);
                sqlColumns.append(",");
                sqlValues.append("'#");
                sqlValues.append(name);
                sqlValues.append("', ");
            } else if (mysql) {
                createIndexCommand.append(" FULLTEXT(");
                createIndexCommand.append(name);
                createIndexCommand.append("),");
            }
        }
        if (lang2.trim().length() > 0) {
            name = lang2;
            if (name.indexOf("-") != -1) {
                name = name.replaceAll("-", "_");
            }
            sb.append(name + " VARCHAR(" + AppPreferences.columnSize + "),");
            if (sqlite) {
                createIndexCommand.append(name);
                createIndexCommand.append(", ");
                sqlColumns.append(name);
                sqlColumns.append(",");
                sqlValues.append("'#");
                sqlValues.append(name);
                sqlValues.append("', ");
            } else if (mysql) {
                createIndexCommand.append(" FULLTEXT(");
                createIndexCommand.append(name);
                createIndexCommand.append("),");
            }
        }
        if (lang3.trim().length() > 0) {
            name = lang3;
            if (name.indexOf("-") != -1) {
                name = name.replaceAll("-", "_");
            }
            sb.append(name + " VARCHAR(" + AppPreferences.columnSize + "),");
            if (sqlite) {
                createIndexCommand.append(name);
                createIndexCommand.append(", ");
                sqlColumns.append(name);
                sqlColumns.append(",");
                sqlValues.append("'#");
                sqlValues.append(name);
                sqlValues.append("', ");
            } else if (mysql) {
                createIndexCommand.append(" FULLTEXT(");
                createIndexCommand.append(name);
                createIndexCommand.append("),");
            }
        }
        if (lang4.trim().length() > 0) {
            name = lang4;
            if (name.indexOf("-") != -1) {
                name = name.replaceAll("-", "_");
            }
            sb.append(name + " VARCHAR(" + AppPreferences.columnSize + "),");
            if (sqlite) {
                createIndexCommand.append(name);
                createIndexCommand.append(", ");
                sqlColumns.append(name);
                sqlColumns.append(",");
                sqlValues.append("'#");
                sqlValues.append(name);
                sqlValues.append("', ");
            } else if (mysql) {
                createIndexCommand.append(" FULLTEXT(");
                createIndexCommand.append(name);
                createIndexCommand.append("),");
            }
        }
        if (lang5.trim().length() > 0) {
            name = lang5;
            if (name.indexOf("-") != -1) {
                name = name.replaceAll("-", "_");
            }
            sb.append(name + " VARCHAR(" + AppPreferences.columnSize + "),");
            if (sqlite) {
                createIndexCommand.append(name);
                createIndexCommand.append(", ");
                sqlColumns.append(name);
                sqlColumns.append(",");
                sqlValues.append("'#");
                sqlValues.append(name);
                sqlValues.append("', ");
            } else if (mysql) {
                createIndexCommand.append(" FULLTEXT(");
                createIndexCommand.append(name);
                createIndexCommand.append("),");
            }
        }
        if (lang6.trim().length() > 0) {
            name = lang6;
            if (name.indexOf("-") != -1) {
                name = name.replaceAll("-", "_");
            }
            sb.append(name + " VARCHAR(" + AppPreferences.columnSize + "),");
            if (sqlite) {
                createIndexCommand.append(name);
                createIndexCommand.append(", ");
                sqlColumns.append(name);
                sqlColumns.append(",");
                sqlValues.append("'#");
                sqlValues.append(name);
                sqlValues.append("', ");
            } else if (mysql) {
                createIndexCommand.append(" FULLTEXT(");
                createIndexCommand.append(name);
                createIndexCommand.append("),");
            }
        }
        if (lang7.trim().length() > 0) {
            name = lang7;
            if (name.indexOf("-") != -1) {
                name = name.replaceAll("-", "_");
            }
            sb.append(name + " VARCHAR(" + AppPreferences.columnSize + "),");
            if (sqlite) {
                createIndexCommand.append(name);
                createIndexCommand.append(", ");
                sqlColumns.append(name);
                sqlColumns.append(",");
                sqlValues.append("'#");
                sqlValues.append(name);
                sqlValues.append("', ");
            } else if (mysql) {
                createIndexCommand.append(" FULLTEXT(");
                createIndexCommand.append(name);
                createIndexCommand.append("),");
            }
        }
        if (lang8.trim().length() > 0) {
            name = lang8;
            if (name.indexOf("-") != -1) {
                name = name.replaceAll("-", "_");
            }
            sb.append(name + " VARCHAR(" + AppPreferences.columnSize + "),");
            if (sqlite) {
                createIndexCommand.append(name);
                createIndexCommand.append(", ");
                sqlColumns.append(name);
                sqlColumns.append(",");
                sqlValues.append("'#");
                sqlValues.append(name);
                sqlValues.append("', ");
            } else if (mysql) {
                createIndexCommand.append(" FULLTEXT(");
                createIndexCommand.append(name);
                createIndexCommand.append("),");
            }
        }
        if (context != null) {
            name = context;
            if (name.indexOf("-") != -1) {
                name = name.replaceAll("-", "_");
            }
            if (db == 2) {
                sb.append(name + " VARCHAR(" + AppPreferences.columnSize + "),");
            } else {
                sb.append(name + " VARCHAR(800),");
            }
            if (sqlite) {
                createIndexCommand.append(name);
                createIndexCommand.append(", ");
                sqlColumns.append(name);
                sqlColumns.append(",");
                sqlValues.append("'#");
                sqlValues.append(name);
                sqlValues.append("', ");
            } else if (mysql) {
                createIndexCommand.append(" FULLTEXT(");
                createIndexCommand.append(name);
                createIndexCommand.append("),");
            }
        }
        if (notes != null) {
            name = notes;
            if (name.indexOf("-") != -1) {
                name = name.replaceAll("-", "_");
            }
            if (db == 2) {
                sb.append(name + " VARCHAR(" + AppPreferences.columnSize + "),");
            } else {
                sb.append(name + " VARCHAR(800),");
            }
            if (sqlite) {
                createIndexCommand.append(name);
                createIndexCommand.append(", ");
                sqlColumns.append(name);
                sqlColumns.append(",");
                sqlValues.append("'#");
                sqlValues.append(name);
                sqlValues.append("', ");
            } else if (mysql) {
                createIndexCommand.append(" FULLTEXT(");
                createIndexCommand.append(name);
                createIndexCommand.append("),");
            }
        }
        if (reference != null) {
            name = reference;
            if (name.indexOf("-") != -1) {
                name = name.replaceAll("-", "_");
            }
            sb.append(name + " VARCHAR(200),");
            if (sqlite) {
                createIndexCommand.append(name);
                createIndexCommand.append(", ");
                sqlColumns.append(name);
                sqlColumns.append(",");
                sqlValues.append("'#");
                sqlValues.append(name);
                sqlValues.append("', ");
            } else if (mysql) {
                createIndexCommand.append(" FULLTEXT(");
                createIndexCommand.append(name);
                createIndexCommand.append("),");
            }
        }
        if (mysql) {
            createIndexCommand.setLength(createIndexCommand.length() - 1);
            sb.append((CharSequence)createIndexCommand);
            createIndexCommand = null;
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(")");
        if (sqlite) {
            createIndexCommand.setLength(createIndexCommand.length() - 2);
            createIndexCommand.append(");");
            if (sqlColumns.length() > 1) {
                sqlColumns.setLength(sqlColumns.length() - 1);
                sqlColumns.append(")");
            }
            if (sqlValues.length() > 2) {
                sqlValues.setLength(sqlValues.length() - 2);
                sqlValues.append(")");
            }
        }
        try {
            Statement stmt = this.connection.createStatement();
            if (sqlite) {
                stmt.executeUpdate(createIndexCommand.toString());
            } else {
                stmt.executeUpdate(sb.toString());
            }
            stmt.close();
            boolean autocommit = this.connection.getAutoCommit();
            if (!autocommit) {
                this.connection.commit();
            }
            if (db == 1) {
                String s1 = "create sequence " + tableName + "_seq\nstart with 1\nincrement by 1\nnomaxvalue";
                String s22 = "create or replace trigger " + tableName + "_trigger before insert on " + tableName + " for each row begin SELECT " + tableName + "_seq.nextval into :new.Id from dual; end;";
                stmt = this.connection.createStatement();
                stmt.executeQuery(s1);
                stmt.executeQuery(s22);
                stmt.close();
            }
            if (H2) {
                String init = "CREATE ALIAS IF NOT EXISTS FT_INIT FOR \"org.h2.fulltext.FullText.init\"";
                String call = "CALL FT_INIT()";
                String cols = langs.toString().toUpperCase().replaceAll("-", "_");
                String q = "CALL FT_CREATE_INDEX('PUBLIC', '" + tableName.toUpperCase() + "','" + cols + "')";
                stmt = this.connection.createStatement();
                stmt.execute(init);
                stmt.execute(call);
                stmt.execute(q);
                stmt.close();
            } else if (sqlite) {
                String sql = "INSERT INTO " + tableName + " " + sqlColumns.toString() + " VALUES " + sqlValues.toString() + ";";
                Statement stmt2 = this.connection.createStatement();
                stmt2.executeUpdate(sql);
                stmt2.close();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(DatabaseView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

