/*
 * Decompiled with CFR 0.152.
 */
package translator.hunspell;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.border.EmptyBorder;
import translator.AppPreferences;
import translator.LanguageCodes;
import translator.MainView;
import translator.hunspell.HunSpellChecker;
import translator.hunspell.SpellingDictionaryInstaller;
import translator.ui.GridPanel;

final class SpellChooser
extends JDialog
implements ActionListener {
    private JComboBox enbox;
    private JButton jb1;
    private JButton jb2;
    private JButton jb3;
    private HunSpellChecker spellchecker;
    private MainView parent;
    private LinkedHashMap langMap;

    SpellChooser(MainView parent, String title, HunSpellChecker spellchecker) {
        super(parent, title, true);
        this.parent = parent;
        this.enableEvents(64L);
        try {
            this.spellchecker = spellchecker;
            this.init();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void init() throws Exception {
        int count;
        this.langMap = new LinkedHashMap();
        this.enbox = new JComboBox();
        Set langs = this.spellchecker.getLanguages();
        String currentLang = this.spellchecker.getCurrentLanguage();
        int currentLangIndex = 0;
        int index = 0;
        if (langs != null && langs.size() > 0) {
            Object[] locs = new String[langs.size()];
            int i = 0;
            Iterator it = langs.iterator();
            while (it.hasNext()) {
                String s = it.next().toString();
                locs[i] = s;
                ++i;
            }
            if (i > 0) {
                Arrays.sort(locs);
                this.enbox = new JComboBox();
                for (int j = 0; j < locs.length; ++j) {
                    Object string = locs[j];
                    if (((String)string).startsWith("user")) continue;
                    if (((String)string).indexOf(95) != -1) {
                        String string2 = ((String)string).replace('_', '-');
                        String name = LanguageCodes.getName(string2);
                        if (name != null) {
                            name = name.substring(0, name.indexOf(40) - 1);
                            this.enbox.addItem(name);
                            this.langMap.put(name, string);
                            if (currentLang != null && currentLang.equals(string)) {
                                currentLangIndex = index;
                            }
                        } else {
                            this.enbox.addItem(string);
                        }
                    } else {
                        this.enbox.addItem(string);
                    }
                    ++index;
                }
            }
        }
        if ((count = this.enbox.getItemCount()) == 0) {
            this.enbox.addItem("No spell-check dictionaries");
        }
        this.enbox.setSelectedIndex(currentLangIndex);
        this.jb1 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jb2 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jb3 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INSTALL DICTIONARY"));
        this.jb1.addActionListener(this);
        this.jb2.addActionListener(this);
        this.jb3.addActionListener(this);
        GridPanel panel3 = new GridPanel();
        this.setContentPane(panel3);
        panel3.setLayout(new FlowLayout());
        this.setResizable(false);
        panel3.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        panel3.add(this.jb3);
        panel3.add(this.enbox);
        panel3.add(this.jb1);
        panel3.add(this.jb2);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    private void cancel() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jb3) {
            this.cancel();
            SpellingDictionaryInstaller dlg = new SpellingDictionaryInstaller(this.parent, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INSTALL DICTIONARY"));
            Dimension dlgSize = dlg.getPreferredSize();
            Dimension frmSize = this.parent.getSize();
            Point loc = this.parent.getLocationOnScreen();
            dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            dlg.setVisible(true);
        } else if (e.getSource() == this.jb2) {
            this.cancel();
        } else if (e.getSource() == this.jb1) {
            int i;
            String s = (String)this.enbox.getSelectedItem();
            if (s != null && (s = (String)this.langMap.get(s)) != null && (i = s.indexOf(95)) != -1) {
                this.spellchecker.setTargetLanguageDictionary(s);
            }
            this.cancel();
        }
    }
}

