/*
 * Decompiled with CFR 0.152.
 */
package translator.mt;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.UUID;
import translator.json.JSONObject;

class BingAPI {
    private String SERVICE_URL2 = "https://api.cognitive.microsofttranslator.com/translate?api-version=3.0";
    private String ENCODING = "UTF-8";
    private String apiKey;
    private String tokenURL = "https://api.cognitive.microsoft.com/sts/v1.0/issueToken?Subscription-Key=";
    private String token;
    private long tokenExpiration = 0L;
    private String TO_LANG = "&to=";
    private String FROM_LANG = "&from=";
    private String TEXT = "&text=";

    BingAPI() {
    }

    public void setKey(String pKey) {
        this.apiKey = pKey;
    }

    public String getKey() {
        return this.apiKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getToken() throws Exception {
        URL url = new URL(this.tokenURL + this.apiKey);
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        uc.setRequestMethod("POST");
        uc.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(uc.getOutputStream());
        wr.flush();
        try {
            int responseCode = uc.getResponseCode();
            String result = this.readStreamToString(uc.getInputStream());
            if (responseCode != 200) {
                throw new Exception("Error from API: " + result);
            }
            String string = result;
            return string;
        }
        finally {
            if (uc != null) {
                uc.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponse(URL url, String text) throws Exception {
        text = JSONObject.quote(text);
        String body = "[{\n\t\"Text\": " + text + "\n}]";
        int len = body.length();
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        uc.setRequestProperty("Content-Type", "application/json");
        uc.setRequestProperty("charset", "utf-8");
        uc.setRequestProperty("Content-Length", String.valueOf(len));
        uc.setRequestProperty("X-ClientTraceId", UUID.randomUUID().toString());
        uc.setRequestProperty("Ocp-Apim-Subscription-Key", this.apiKey);
        uc.setRequestProperty("Accept-Charset", this.ENCODING);
        uc.setRequestMethod("POST");
        uc.setDoOutput(true);
        try {
            uc.getOutputStream().write(body.getBytes("UTF-8"));
            int responseCode = uc.getResponseCode();
            String result = this.readStreamToString(uc.getInputStream());
            if (responseCode != 200) {
                throw new Exception("Error from API: " + result);
            }
            String string = result;
            return string;
        }
        finally {
            if (uc != null) {
                uc.disconnect();
            }
        }
    }

    private String getResponseString(URL url, String text) throws Exception {
        try {
            String response = this.getResponse(url, text);
            return response;
        }
        catch (Exception ex) {
            throw new Exception("Connection error: " + ex.getMessage(), ex);
        }
    }

    private String readStreamToString(InputStream inputStream) throws Exception {
        StringBuilder outputBuilder = new StringBuilder();
        try {
            if (inputStream != null) {
                String string;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, this.ENCODING));
                while (null != (string = reader.readLine())) {
                    outputBuilder.append(string);
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("Connection error: " + ex.getMessage(), ex);
        }
        String r = outputBuilder.toString();
        return r;
    }

    private void validate(String text) throws Exception {
        int byteLength = text.getBytes(this.ENCODING).length;
        if (byteLength > 10240) {
            throw new RuntimeException("The source segment is too long for the request!");
        }
        if (this.apiKey != null && this.apiKey.length() < 16) {
            throw new RuntimeException("Please set the Microsoft Translator key");
        }
    }

    public String translate(String text, String from, String to) throws Exception {
        this.validate(text);
        String p = this.FROM_LANG + URLEncoder.encode(from, this.ENCODING) + this.TO_LANG + URLEncoder.encode(to, this.ENCODING);
        URL url = new URL(this.SERVICE_URL2 + p);
        String r = this.getResponseString(url, text);
        return r;
    }
}

