/*
 * Decompiled with CFR 0.152.
 */
package translator.mt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.Utilities;
import javax.swing.text.html.HTMLDocument;
import translator.AppPreferences;
import translator.DefaultResource;
import translator.MT;
import translator.MainView;
import translator.MatchBoard;
import translator.MySwingWorker;
import translator.Options;
import translator.Placeables;
import translator.Project;
import translator.Prompter;
import translator.ScrollPaneWatermark;
import translator.SourceView;
import translator.TabView;
import translator.TargetView;
import translator.TranslateEvent;
import translator.XMLHelper;
import translator.html.CTHTMLEditorKit;
import translator.mt.GoogleOptions;
import translator.mt.MTRefinement;
import translator.mt.MyMemory;
import translator.tmx.Memory;
import translator.tmx.MemoryView;
import translator.tmx.TMX;
import translator.ui.HTMLFormat;
import translator.ui.UITools;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;

public class Google
extends DefaultResource
implements MT {
    private MainView topui;
    private TabView tview;
    private SourceView sourceview;
    private JPopupMenu pop;
    private JCheckBoxMenuItem menuItemAA;
    private String key;
    private String pair;
    private String info = "";
    private JTextPane mtHTMLPane;
    private boolean running;
    private String resourceName;
    private MySwingWorker worker;
    private HashMap map;
    private HashMap reverseMap;
    private HashMap cache;
    private String[] langs = new String[]{"Afrikaans", "Albanian", "Amharic", "Arabic", "Armenian", "Azerbaijani", "Basque", "Belarusian", "Bengali", "Bosnian", "Bulgarian", "Catalan", "Cebuano", "Chichewa", "Chinese Simplified", "Chinese Traditional", "Corsican", "Croatian", "Czech", "Danish", "Dutch", "English", "Esperanto", "Estonian", "Filipino", "Finnish", "French", "Frisian", "Galician", "Georgian", "German", "Greek", "Gujarati", "Haitian Creole", "Hausa", "Hawaiian", "Hebrew", "Hindi", "Hmong", "Hungarian", "Icelandic", "Igbo", "Indonesian", "Irish", "Italian", "Japanese", "Javanese", "Kannada", "Kazakh", "Khmer", "Korean", "Kurdish (Kurmanji)", "Kyrgyz", "Lao", "Latin", "Latvian", "Lithuanian", "Luxembourgish", "Macedonian", "Malagasy", "Malay", "Malayalam", "Maltese", "Maori", "Marathi", "Mongolian", "Myanmar (Burmese)", "Nepali", "Norwegian", "Pashto", "Persian", "Polish", "Portuguese", "Punjabi", "Romanian", "Russian", "Samoan", "Scottish Gaelic", "Serbian", "Sesotho", "Shona", "Sindhi", "Sinhala", "Slovak", "Slovenian", "Somali", "Spanish", "Sundanese", "Swahili", "Swedish", "Tajik", "Tamil", "Telugu", "Thai", "Turkish", "Ukrainian", "Urdu", "Uzbek", "Vietnamese", "Welsh", "Xhosa", "Yiddish", "Yoruba", "Zulu"};
    String result;
    String result2;
    String charset;
    private Timer timer;
    private boolean canLook = true;
    private boolean pause;
    private String name = "Google Translate";
    private String shortName = "GT";
    private String startResult = "\"translatedText\":";
    private String startURL = "https://translation.googleapis.com/language/translate/v2?key=";
    private Pattern spanPattern = Pattern.compile("[ ]*<span .+?</span>[ ]*", 32);
    private Pattern placeholderPattern = Pattern.compile("[ ]*\\{\\d\\}[ ]*");
    private ArrayList spans = new ArrayList();
    ActionListener timerAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Google.this.canLook = true;
        }
    };

    public Google() {
        String[] langCodes = new String[]{"af", "sq", "am", "ar", "hy", "az", "eu", "be", "bn", "bs", "bg", "ca", "ceb", "ny", "zh-CN", "zh-TW", "co", "hr", "cs", "da", "nl", "en", "eo", "et", "tl", "fi", "fr", "fy", "gl", "ka", "de", "el", "gu", "ht", "ha", "haw", "iw", "hi", "hmn", "hu", "is", "ig", "id", "ga", "it", "ja", "jv", "kn", "kk", "km", "ko", "kmr", "ky", "lo", "la", "lv", "lt", "lb", "mk", "mg", "ms", "ml", "mt", "mi", "mr", "mn", "my", "ne", "no", "ps", "fa", "pl", "pt", "pa", "ro", "ru", "sm", "gd", "sr", "st", "sn", "sd", "si", "sk", "sl", "so", "es", "su", "sw", "sv", "tg", "ta", "te", "th", "tr", "uk", "ur", "uz", "vi", "cy", "xh", "yi", "yo", "zu"};
        this.map = new HashMap();
        this.reverseMap = new HashMap();
        this.cache = new HashMap();
        for (int i = 0; i < this.langs.length; ++i) {
            String lang = this.langs[i];
            String code = langCodes[i];
            this.map.put(lang, code);
            this.reverseMap.put(code, lang);
        }
        this.setLanguagePair(AppPreferences.mtSource, AppPreferences.mtTarget);
        this.resourceName = "Google MT";
        this.timer = new Timer(4000, this.timerAction);
        this.timer.setRepeats(false);
        this.pause = AppPreferences.stopMT;
    }

    @Override
    public void setAPIKey(String k) {
        this.key = k;
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    public void setOptions(Options frame) {
        GoogleOptions dlg = new GoogleOptions(frame, this, this.resourceName);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = frame.getSize();
        Point loc = frame.getLocationOnScreen();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
    }

    @Override
    public void setMainView(MainView topui) {
        this.topui = topui;
        this.tview = topui.getTabView();
        this.sourceview = topui.getSourceView();
        this.setPopup();
        this.createMTTab();
        this.showMessage(this.info);
    }

    private void setPopup() {
        this.pop = new JPopupMenu();
        JMenuItem item = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATE")){

            @Override
            public void actionPerformed(ActionEvent a) {
                JTextPane pane = Google.this.topui.getSourcePane();
                String query = pane.getSelectedText();
                if (query == null) {
                    query = pane.getText();
                }
                if (query.length() > 0) {
                    query = XMLHelper.parseTags(query);
                    Google.this.search(query, null);
                }
            }
        });
        this.pop.add(item);
        JCheckBoxMenuItem item3 = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("STOP AUTOMATIC MT SERVICE"));
        item3.setSelected(this.pause);
        item3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Google.this.pause = true;
                    StringBuilder sb = new StringBuilder();
                    sb.append("<html>");
                    sb.append(HTMLFormat.styles);
                    sb.append("<body>");
                    sb.append("<table align=center WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=1 CELLPADDING=6><tr><td>");
                    sb.append("</tr></td></table></body></html>");
                    String info = sb.toString();
                    Google.this.showMessage(info);
                } else {
                    Google.this.pause = false;
                }
                AppPreferences.stopMT = Google.this.pause;
            }
        });
        this.pop.add(item3);
        JCheckBoxMenuItem item4 = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TEAM AUTO-ASSEMBLING WITH MT"));
        item4.setSelected(AppPreferences.correctAA);
        item4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.correctAA = e.getStateChange() == 1;
            }
        });
        this.pop.add(item4);
        this.menuItemAA = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTOMATIC TRANSFER TO TARGET SEGMENTS"));
        if (AppPreferences.autoTransferMT.equals(this.shortName)) {
            this.menuItemAA.setSelected(true);
        }
        this.menuItemAA.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AppPreferences.autoTransferMT = Google.this.shortName;
                } else if (e.getStateChange() == 2) {
                    AppPreferences.autoTransferMT = "";
                }
            }
        });
        this.pop.add(this.menuItemAA);
        this.pop.addSeparator();
        JMenuItem toTMXItem = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CREATE TMX MEMORY")){

            @Override
            public void actionPerformed(ActionEvent a) {
                Google.this.toTMX();
            }
        });
        this.pop.add(toTMXItem);
        JRadioButtonMenuItem item5 = new JRadioButtonMenuItem("Neural Machine Translation");
        if (AppPreferences.googleMTModel == 0) {
            item5.setSelected(true);
        }
        item5.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AppPreferences.googleMTModel = 0;
                }
            }
        });
        this.pop.addSeparator();
        this.pop.add(item5);
        JRadioButtonMenuItem item6 = new JRadioButtonMenuItem("Phrase-Based Machine Translation");
        if (AppPreferences.googleMTModel == 1) {
            item6.setSelected(true);
        }
        item6.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AppPreferences.googleMTModel = 1;
                }
            }
        });
        this.pop.add(item6);
        ButtonGroup bg = new ButtonGroup();
        bg.add(item5);
        bg.add(item6);
    }

    private void showPopUp(Component comp, int x, int y) {
        this.pop.show(comp, x, y);
    }

    @Override
    public JTextComponent getMTPane() {
        return this.mtHTMLPane;
    }

    @Override
    public String[] getLanguages() {
        return this.langs;
    }

    @Override
    public void setLanguagePair(String source, String target) {
        if (source != null && target != null) {
            Object o1 = this.map.get(source);
            Object o2 = this.map.get(target);
            if (o1 != null && o2 != null) {
                String sourceLang = (String)o1;
                String targetLang = (String)o2;
                this.pair = "&source=" + sourceLang + "&target=" + targetLang;
                StringBuilder sb = new StringBuilder();
                sb.append("<html>");
                sb.append(HTMLFormat.styles);
                sb.append("<body>");
                sb.append("<table align=center WIDTH=50% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=2 CELLPADDING=2><tr>");
                sb.append("<th style=\"color:#FFFFFF; background-color:#006896\">");
                sb.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SOURCE LANGUAGE"));
                sb.append("</th>");
                sb.append("<th style=\"color:#FFFFFF; background-color:#006896\">");
                sb.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TARGET LANGUAGE"));
                sb.append("</th>");
                sb.append("</tr>");
                sb.append("<tr>");
                sb.append(HTMLFormat.defaultRowLeftAlign2);
                sb.append(source);
                sb.append("</td>");
                sb.append(HTMLFormat.defaultRowLeftAlign2);
                sb.append(target);
                sb.append("</td>");
                sb.append("</tr></table></body></html>");
                this.info = sb.toString();
                this.showMessage(this.info);
            }
        }
    }

    @Override
    public void setLanguageCodesPair(String sourceLang, String targetLang) {
        if (sourceLang != null && targetLang != null) {
            int sdash = sourceLang.indexOf("-");
            int tdash = targetLang.indexOf("-");
            if (sdash != -1 && !sourceLang.startsWith("zh-")) {
                sourceLang = sourceLang.substring(0, sdash);
            }
            if (tdash != -1 && !targetLang.startsWith("zh-")) {
                targetLang = targetLang.substring(0, tdash);
            }
            if (sourceLang.equals("nb") || sourceLang.equals("nn")) {
                sourceLang = "no";
            }
            if (targetLang.equals("nb") || targetLang.equals("nn")) {
                targetLang = "no";
            }
            Object o1 = this.reverseMap.get(sourceLang);
            Object o2 = this.reverseMap.get(targetLang);
            if (o1 != null && o2 != null) {
                String source = (String)o1;
                String target = (String)o2;
                this.pair = "&source=" + sourceLang + "&target=" + targetLang;
                AppPreferences.mtSource = source;
                AppPreferences.mtTarget = target;
                StringBuilder sb = new StringBuilder();
                sb.append("<html>");
                sb.append(HTMLFormat.styles);
                sb.append("<body>");
                sb.append("<table align=center WIDTH=50% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=2 CELLPADDING=2><tr>");
                sb.append("<th style=\"color:#FFFFFF; background-color:#006896\">");
                sb.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SOURCE LANGUAGE"));
                sb.append("</th>");
                sb.append("<th style=\"color:#FFFFFF; background-color:#006896\">");
                sb.append(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TARGET LANGUAGE"));
                sb.append("</th>");
                sb.append("</tr>");
                sb.append("<tr>");
                sb.append(HTMLFormat.defaultRowLeftAlign2);
                sb.append(source);
                sb.append("</td>");
                sb.append(HTMLFormat.defaultRowLeftAlign2);
                sb.append(target);
                sb.append("</td>");
                sb.append("</tr></table></body></html>");
                this.info = sb.toString();
                this.showMessage(this.info);
            }
        }
    }

    private void setMatchStatus() {
        XLIFFUnit tu;
        XLIFF xliff = this.topui.getProjectView().getProject().getXLIFF();
        if (xliff != null && (tu = xliff.getWorkflow().getCheckTransUnit()) != null) {
            this.topui.getTargetView().setEdited(false);
            tu.removeMatch(false);
            boolean storeMatch = false;
            if (xliff.isCafeTranXLIFF) {
                storeMatch = true;
            }
            tu.setMatch(-1, 4, storeMatch);
        }
    }

    @Override
    public void apply(boolean auto) {
        this.applyResult(this.result, auto);
    }

    private void applyResult(String r, boolean auto) {
        if (r != null) {
            Document tdoc = this.topui.getTargetPane().getDocument();
            try {
                int len = tdoc.getLength();
                if (len > 0) {
                    if (!auto) {
                        tdoc.remove(0, len);
                    } else {
                        return;
                    }
                }
                TranslateEvent transEvent = this.topui.getMemoryView().getTranslateEvent();
                if (AppPreferences.autotags && transEvent != null) {
                    String source = this.topui.getSourcePane().getText();
                    String s = this.topui.getMatchBoard().transferSegmentTags(source, r, transEvent);
                    s = this.topui.getMatchBoard().matchHiddenNontranslatables(s);
                    tdoc.insertString(0, s, null);
                } else {
                    r = this.topui.getMatchBoard().matchHiddenNontranslatables(r);
                    tdoc.insertString(0, r, null);
                }
                if (auto) {
                    this.topui.getTargetPane().selectAll();
                } else {
                    this.topui.getTargetPane().setCaretPosition(0);
                }
                this.setMatchStatus();
            }
            catch (BadLocationException ex) {
                Logger.getLogger(MyMemory.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void translate(String source) {
        if (!this.pause) {
            this.search(source, null);
        }
    }

    @Override
    public void search(String okey, String rep) {
        if (!this.canLook) {
            return;
        }
        final String key = okey = okey.replaceAll("\\s+", " ");
        this.worker = new MySwingWorker(this){
            final /* synthetic */ Google this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Object construct() {
                this.this$0.find(key, false);
                return null;
            }

            @Override
            public void finished() {
            }
        };
        this.worker.start();
    }

    private String prepareAAQuery(String request) {
        this.spans.clear();
        StringBuilder buff = new StringBuilder();
        Matcher m = this.spanPattern.matcher(request);
        int no = 1;
        int e = 0;
        while (m.find()) {
            int s = m.start();
            if (s > 0) {
                buff.append(request.substring(e, s).trim());
                buff.append("{");
                buff.append(no);
                buff.append("}");
            } else {
                buff.append("{");
                buff.append(no);
                buff.append("}");
            }
            ++no;
            String g = m.group();
            this.spans.add(g);
            e = m.end();
        }
        if (e < request.length()) {
            buff.append(request.substring(e).trim());
        }
        return buff.toString();
    }

    private String insertAAinMT(String res) {
        StringBuffer rb = new StringBuffer();
        Matcher m = this.placeholderPattern.matcher(res);
        int k = 0;
        while (m.find()) {
            if (k < this.spans.size()) {
                String r = (String)this.spans.get(k);
                m.appendReplacement(rb, r);
            }
            ++k;
        }
        m.appendTail(rb);
        return rb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void find(String request, boolean auto) {
        if (this.key == null) {
            StringBuilder html = new StringBuilder();
            html.append("<html>");
            html.append(HTMLFormat.styles);
            html.append("<body>");
            html.append("<table WIDTH=98% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=1 CELLPADDING=6><tr><td><p>");
            html.append("Please set the Google Translate API key!");
            html.append("</p></td></tr></table></body></html>");
            String r = html.toString();
            this.showMessage(r);
            return;
        }
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        if (!auto) {
            this.timer.start();
        }
        this.canLook = false;
        this.result = "";
        this.result2 = "";
        BufferedReader in = null;
        try {
            String json;
            String cs = (String)this.cache.get(request);
            if (cs == null) {
                String erequest = URLEncoder.encode(request, "UTF-8");
                erequest = erequest.replace("+", "%20");
                String query = AppPreferences.googleMTModel == 1 ? this.startURL + this.key + this.pair + "&model=base&q=" + erequest : this.startURL + this.key + this.pair + "&q=" + erequest;
                URL url = new URL(query);
                URLConnection conn = url.openConnection();
                String enc = conn.getContentEncoding();
                if (enc == null) {
                    enc = "UTF-8";
                }
                InputStream ins = conn.getInputStream();
                in = new BufferedReader(new InputStreamReader(ins, enc));
                this.running = true;
                StringBuilder sb = new StringBuilder();
                String eline = "";
                while ((eline = in.readLine()) != null && this.running) {
                    sb.append(eline);
                }
                json = sb.toString();
                if (json != null && json.length() > 0) {
                    this.cache.put(request, json);
                }
            } else {
                json = cs;
            }
            if (json != null && json.length() > 0) {
                String tr = null;
                int sr = json.indexOf(this.startResult);
                if (sr != -1) {
                    int j = json.indexOf("\"", sr + this.startResult.length());
                    int k = json.indexOf("\"\n", j + 1);
                    if (k == -1) {
                        k = json.indexOf("\"}", j + 1);
                    }
                    if (k == -1) {
                        k = json.indexOf("\"", j + 1);
                    }
                    if (j != -1 && k != -1) {
                        tr = json.substring(j + 1, k);
                    }
                }
                if (tr != null && tr.length() > 0) {
                    MatchBoard mb;
                    tr = XMLHelper.hexToUnicode(tr);
                    tr = XMLHelper.resolveEntitiesXML(tr);
                    String trRef = MTRefinement.refineMT(tr);
                    StringBuilder html = new StringBuilder();
                    html.append("<html>");
                    html.append(HTMLFormat.glossaryStyles);
                    html.append("<body>");
                    html.append("<table width=98% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=0 CELLPADDING=10>");
                    if (AppPreferences.correctAA && AppPreferences.fragmentAdjustmentMT && !trRef.equals(tr)) {
                        html.append("<tr><td colspan=\"2\"><p>");
                        html.append("<a class=\"altHref\" href=\"transfer2\">");
                        this.result2 = tr;
                        html.append(tr);
                        html.append("</p></td></tr>");
                    }
                    html.append("<tr><td colspan=\"2\"><p>");
                    html.append("<a class=\"altHref\" href=\"transfer\">");
                    html.append(trRef);
                    html.append("</p></td></tr>");
                    this.result = trRef;
                    html.append("</table>");
                    html.append("</body></html>");
                    String r = html.toString();
                    this.showMessage(r);
                    this.result = Placeables.unmaskTarget(this.result);
                    if (this.result2 != null && this.result2.length() > 0) {
                        this.result2 = Placeables.unmaskTarget(this.result2);
                    }
                    if ((mb = this.topui.getMatchBoard()) != null) {
                        if (AppPreferences.matchBoardShortMatchInfo) {
                            mb.setMTMatch(this.result, "Google", "MT");
                        } else {
                            mb.setMTMatch(this.result, "Google", "MT");
                        }
                    }
                    this.setAutotext(this.result);
                    if (AppPreferences.autoTransferMT.equals(this.shortName)) {
                        this.applyResult(this.result, true);
                    }
                }
            }
            this.canLook = true;
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
        }
        catch (Exception er) {
            er.printStackTrace();
            StringBuilder sb = new StringBuilder();
            sb.append("Google Translate web service is not available!");
            sb.append("<br><br>");
            sb.append(er.toString());
            this.showErrorMessage(sb.toString());
        }
        finally {
            this.closeConnection(in);
        }
    }

    private void toTMX() {
        Project project = this.topui.getProjectView().getProject();
        if (project == null) {
            return;
        }
        final XLIFF xliff = project.getXLIFF();
        if (xliff == null) {
            return;
        }
        MemoryView mv = this.topui.getMemoryView();
        final Memory tmxTM = mv.createSegmentsMemory(true);
        mv.newMemory(tmxTM);
        TMX tmx = tmxTM.getTMX();
        if (tmx == null) {
            return;
        }
        SwingWorker worker = new SwingWorker(this){
            JProgressBar bar;
            final /* synthetic */ Google this$0;
            {
                this.this$0 = this$0;
                this.bar = this.this$0.topui.getPretranslateProgressBar();
            }

            public String doInBackground() {
                int count = 0;
                int dup = tmxTM.getDuplicatesMode();
                List units = xliff.getView().getViewUnits();
                this.bar.setStringPainted(true);
                this.bar.setMinimum(0);
                this.bar.setMaximum(units.size());
                TMX tmx = tmxTM.getTMX();
                for (XLIFFUnit tu : units) {
                    if (!tu.translate) continue;
                    String segment = tu.getSourceText();
                    this.this$0.find(segment, true);
                    if (this.this$0.result != null && this.this$0.result.length() > 0) {
                        tmx.update(segment, this.this$0.result, null, null, null, dup);
                        tmxTM.setNewTU();
                    }
                    this.bar.setValue(++count);
                }
                return null;
            }

            @Override
            protected void done() {
                tmxTM.previousTUS();
                this.this$0.topui.removePretranslateProgressBar(this.bar);
                tmxTM.checkTrialVersionLimit();
                if (!tmxTM.isReadOnly()) {
                    tmxTM.saveMemory(false);
                }
            }
        };
        worker.execute();
    }

    private void closeConnection(BufferedReader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Google.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void stopSearch() {
        this.running = false;
        this.worker.interrupt();
    }

    private void createMTTab() {
        File file;
        this.mtHTMLPane = new JTextPane();
        this.mtHTMLPane.setEditorKitForContentType("text/html", new CTHTMLEditorKit());
        this.mtHTMLPane.putClientProperty("type", "memory");
        this.mtHTMLPane.addHyperlinkListener(new MTHyperactive());
        this.mtHTMLPane.setContentType("text/html");
        Graphics g = this.mtHTMLPane.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        }
        this.mtHTMLPane.setEditable(false);
        Color background = null;
        if (AppPreferences.background != 0 || AppPreferences.pBackgroundIm.length() > 0) {
            background = new Color(AppPreferences.background);
            Color foreground = new Color(AppPreferences.foreground);
            Color selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.tBackgroundIm.length() > 0) {
                selection = this.topui.toAlphaColor(selection, 127);
            }
            this.mtHTMLPane.setCaretColor(foreground);
            this.mtHTMLPane.setBackground(background);
            this.mtHTMLPane.setForeground(foreground);
            this.mtHTMLPane.setSelectionColor(selection);
            this.mtHTMLPane.setSelectedTextColor(foreground);
        }
        this.mtHTMLPane.setFont(new Font(AppPreferences.fontname, AppPreferences.fontstyle, AppPreferences.fontsize));
        this.mtHTMLPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Google.this.topui.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        this.mtHTMLPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    Google.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                boolean ctrl = UITools.isShortcutDown(evt);
                if (!ctrl && evt.getButton() == 1) {
                    String sel;
                    int cc = evt.getClickCount();
                    if (cc < 2 && (sel = Google.this.mtHTMLPane.getSelectedText()) != null && AppPreferences.smartSelection && !AppPreferences.noWordSeparatorTargetLanguage) {
                        try {
                            int spos = Utilities.getWordStart(Google.this.mtHTMLPane, Google.this.mtHTMLPane.getSelectionStart());
                            int epos = Utilities.getWordEnd(Google.this.mtHTMLPane, Google.this.mtHTMLPane.getSelectionEnd() - 1);
                            Google.this.mtHTMLPane.setSelectionStart(spos);
                            Google.this.mtHTMLPane.setSelectionEnd(epos);
                        }
                        catch (BadLocationException ex) {
                            ex.printStackTrace();
                        }
                    }
                    if ((sel = Google.this.mtHTMLPane.getSelectedText()) != null) {
                        sel = Placeables.unmaskTarget(sel);
                        TargetView pview = Google.this.topui.getTargetView();
                        pview.grabSelection(sel);
                    }
                }
                if (evt.isPopupTrigger()) {
                    Google.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane();
        if (background != null) {
            jScrollPane.setBackground(background);
        }
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            jScrollPane.getViewport().setOpaque(false);
            this.mtHTMLPane.setOpaque(false);
            this.mtHTMLPane.setBackground(new Color(0, 0, 0, 0));
        }
        jScrollPane.getViewport().add((Component)this.mtHTMLPane, null);
        if (AppPreferences.alpha == -1 && AppPreferences.pBackgroundIm.length() > 0 && (file = new File(AppPreferences.pBackgroundIm)).exists()) {
            JViewport vp = (JViewport)this.mtHTMLPane.getParent();
            JScrollPane scroll = (JScrollPane)vp.getParent();
            ScrollPaneWatermark viewport = new ScrollPaneWatermark();
            try {
                URL url = file.toURI().toURL();
                viewport.setView(this.mtHTMLPane);
                viewport.setOpaque(false);
                scroll.setViewport(viewport);
                this.topui.setBackgroudImage(url, viewport);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        this.tview.addTab(this, this.resourceName, jScrollPane);
    }

    public void showMessage(String mes) {
        if (this.mtHTMLPane != null) {
            this.mtHTMLPane.setCaretPosition(0);
            HTMLDocument doc = (HTMLDocument)this.mtHTMLPane.getDocument();
            try {
                doc.setInnerHTML(doc.getDefaultRootElement(), mes);
                JViewport vp = (JViewport)this.mtHTMLPane.getParent();
                final JScrollPane scroll = (JScrollPane)vp.getParent();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ Google this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        scroll.getVerticalScrollBar().setValue(0);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void showErrorMessage(String error) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(HTMLFormat.styles);
        sb.append("<body>");
        sb.append("<table align=center WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=8 CELLPADDING=8><tr>");
        sb.append("<td style=\"color:white; background-color:black\">");
        sb.append(error);
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("</body></html>");
        this.info = sb.toString();
        this.showMessage(this.info);
    }

    private DefaultStyledDocument createNewStyledDoc() {
        StyleContext styles = new StyleContext();
        DefaultStyledDocument doc = new DefaultStyledDocument(styles);
        Style style = styles.addStyle("dicPane", null);
        Style underlineStyle = styles.addStyle("underline", null);
        StyleConstants.setUnderline(underlineStyle, true);
        Color selection = new Color(AppPreferences.selection);
        StyleConstants.setBackground(style, selection);
        StyleConstants.setForeground(style, new Color(AppPreferences.foreground));
        return doc;
    }

    @Override
    public void closeResource() {
        this.running = false;
        if (this.worker != null) {
            this.worker.interrupt();
        }
        this.topui.getResourceView().setMT("");
        this.tview.removeTab(this.resourceName);
    }

    private void setAutotext(String entry) {
        Prompter auto = this.sourceview.getPrompter();
        if (auto != null) {
            auto.getMTPhrases(entry);
        }
    }

    private void translateSelection() {
        JTextPane textComp = this.topui.getSourcePane();
        String s = textComp.getSelectedText();
        if (s == null) {
            s = ((JTextComponent)textComp).getText();
        }
        if (s != null && s.length() > 0) {
            s = XMLHelper.parseTags(s);
            this.search(s, null);
        }
    }

    class MTHyperactive
    implements HyperlinkListener {
        MTHyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String s = e.getDescription();
                if (s.equals("transfer")) {
                    Google.this.applyResult(Google.this.result, false);
                } else if (s.equals("transfer2")) {
                    Google.this.applyResult(Google.this.result2, false);
                } else {
                    Google.this.translateSelection();
                }
            }
        }
    }
}

