/*
 * Decompiled with CFR 0.152.
 */
package translator.mt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import javax.swing.text.html.HTMLDocument;
import translator.AppPreferences;
import translator.DefaultResource;
import translator.MT;
import translator.MainView;
import translator.MatchBoard;
import translator.Placeables;
import translator.Prompter;
import translator.ScrollPaneWatermark;
import translator.SourceView;
import translator.TabView;
import translator.TargetView;
import translator.TranslateEvent;
import translator.XMLHelper;
import translator.html.CTHTMLEditorKit;
import translator.mt.MTRefinement;
import translator.mt.MyMemory;
import translator.ui.HTMLFormat;
import translator.ui.UITools;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;

public class SlateDesktop
extends DefaultResource
implements MT {
    static String cachedEngine;
    static Path cachedInputPath;
    static Path xslate;
    private MainView topui;
    private TabView tview;
    private SourceView sourceview;
    private JTextPane mtHTMLPane;
    private JPopupMenu pop;
    private JCheckBoxMenuItem menuItemAA;
    private String result;
    private String result2;
    private boolean pause;
    private HashMap cache;
    private String name = "Slate Desktop";
    private String shortName = "SD";
    private Pattern spanPattern = Pattern.compile("[ ]*<span .+?</span>[ ]*", 32);
    private Pattern placeholderPattern = Pattern.compile("[ ]*\\{\\d\\}[ ]*");
    private ArrayList spans = new ArrayList();
    int queryCount = 0;

    public SlateDesktop() {
        this.cache = new HashMap();
        this.initSettings();
        this.pause = AppPreferences.stopMT;
    }

    @Override
    public void setMainView(MainView topui) {
        this.topui = topui;
        this.tview = topui.getTabView();
        this.sourceview = topui.getSourceView();
        this.setPopup();
        this.createMTTab();
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    public void createMTTab() {
        File file;
        this.mtHTMLPane = new JTextPane();
        this.mtHTMLPane.setEditorKitForContentType("text/html", new CTHTMLEditorKit());
        this.mtHTMLPane.putClientProperty("type", "memory");
        this.mtHTMLPane.addHyperlinkListener(new MTHyperactive());
        this.mtHTMLPane.setContentType("text/html");
        Graphics g = this.mtHTMLPane.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        }
        Color background = null;
        if (AppPreferences.background != 0 || AppPreferences.pBackgroundIm.length() > 0) {
            Color foreground = new Color(AppPreferences.foreground);
            background = new Color(AppPreferences.background);
            Color selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.tBackgroundIm.length() > 0) {
                selection = this.topui.toAlphaColor(selection, 127);
            }
            this.mtHTMLPane.setCaretColor(foreground);
            this.mtHTMLPane.setBackground(background);
            this.mtHTMLPane.setForeground(foreground);
            this.mtHTMLPane.setSelectionColor(selection);
            this.mtHTMLPane.setSelectedTextColor(foreground);
        }
        this.mtHTMLPane.setFont(new Font(AppPreferences.fontname, AppPreferences.fontstyle, AppPreferences.fontsize));
        this.mtHTMLPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SlateDesktop.this.topui.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        this.mtHTMLPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    SlateDesktop.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                boolean ctrl = UITools.isShortcutDown(evt);
                if (!ctrl && evt.getButton() == 1) {
                    String sel;
                    int cc = evt.getClickCount();
                    if (cc < 2 && (sel = SlateDesktop.this.mtHTMLPane.getSelectedText()) != null && AppPreferences.smartSelection && !AppPreferences.noWordSeparatorTargetLanguage) {
                        try {
                            int spos = Utilities.getWordStart(SlateDesktop.this.mtHTMLPane, SlateDesktop.this.mtHTMLPane.getSelectionStart());
                            int epos = Utilities.getWordEnd(SlateDesktop.this.mtHTMLPane, SlateDesktop.this.mtHTMLPane.getSelectionEnd() - 1);
                            SlateDesktop.this.mtHTMLPane.setSelectionStart(spos);
                            SlateDesktop.this.mtHTMLPane.setSelectionEnd(epos);
                        }
                        catch (BadLocationException ex) {
                            ex.printStackTrace();
                        }
                    }
                    if ((sel = SlateDesktop.this.mtHTMLPane.getSelectedText()) != null) {
                        sel = Placeables.unmaskTarget(sel);
                        TargetView pview = SlateDesktop.this.topui.getTargetView();
                        pview.grabSelection(sel);
                    }
                }
                if (evt.isPopupTrigger()) {
                    SlateDesktop.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        this.mtHTMLPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane();
        if (background != null) {
            jScrollPane.setBackground(background);
        }
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            jScrollPane.getViewport().setOpaque(false);
            this.mtHTMLPane.setBackground(new Color(0, 0, 0, 0));
            this.mtHTMLPane.setOpaque(false);
        }
        jScrollPane.getViewport().add((Component)this.mtHTMLPane, null);
        if (AppPreferences.alpha == -1 && AppPreferences.pBackgroundIm.length() > 0 && (file = new File(AppPreferences.pBackgroundIm)).exists()) {
            JViewport vp = (JViewport)this.mtHTMLPane.getParent();
            JScrollPane scroll = (JScrollPane)vp.getParent();
            ScrollPaneWatermark viewport = new ScrollPaneWatermark();
            try {
                URL url = file.toURI().toURL();
                viewport.setView(this.mtHTMLPane);
                viewport.setOpaque(false);
                scroll.setViewport(viewport);
                this.topui.setBackgroudImage(url, viewport);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        this.tview.addTab(this, this.getName(), jScrollPane);
    }

    private void setPopup() {
        this.pop = new JPopupMenu();
        JMenuItem item = new JMenuItem(new AbstractAction(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TRANSLATE")){

            @Override
            public void actionPerformed(ActionEvent a) {
                JTextPane pane = SlateDesktop.this.topui.getSourcePane();
                String query = pane.getSelectedText();
                if (query == null) {
                    query = pane.getText();
                }
                if (query.length() > 0) {
                    query = XMLHelper.parseTags(query);
                    SlateDesktop.this.search(query, null);
                }
            }
        });
        this.pop.add(item);
        JCheckBoxMenuItem item3 = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("STOP AUTOMATIC MT SERVICE"));
        item3.setSelected(this.pause);
        item3.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SlateDesktop.this.pause = true;
                    StringBuilder sb = new StringBuilder();
                    sb.append("<html>");
                    sb.append(HTMLFormat.styles);
                    sb.append("<body>");
                    sb.append("<table align=center WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=1 CELLPADDING=6><tr><td>");
                    sb.append("</tr></td></table></body></html>");
                    String info = sb.toString();
                    SlateDesktop.this.showMessage(info);
                } else {
                    SlateDesktop.this.pause = false;
                }
                AppPreferences.stopMT = SlateDesktop.this.pause;
            }
        });
        this.pop.add(item3);
        JCheckBoxMenuItem item4 = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TEAM AUTO-ASSEMBLING WITH MT"));
        item4.setSelected(AppPreferences.correctAA);
        item4.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                AppPreferences.correctAA = e.getStateChange() == 1;
            }
        });
        this.pop.add(item4);
        this.menuItemAA = new JCheckBoxMenuItem(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("AUTOMATIC TRANSFER TO TARGET SEGMENTS"));
        if (AppPreferences.autoTransferMT.equals(this.shortName)) {
            this.menuItemAA.setSelected(true);
        }
        this.menuItemAA.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AppPreferences.autoTransferMT = SlateDesktop.this.shortName;
                } else if (e.getStateChange() == 2) {
                    AppPreferences.autoTransferMT = "";
                }
            }
        });
        this.pop.add(this.menuItemAA);
        this.pop.addSeparator();
        try {
            String[] engines = SlateDesktop.listEngines();
            if (engines != null) {
                ButtonGroup group = new ButtonGroup();
                for (int i = 0; i < engines.length; ++i) {
                    String en = engines[i];
                    JRadioButtonMenuItem menuItemEngine = new JRadioButtonMenuItem(en);
                    if (en.equals(AppPreferences.SDEngine)) {
                        menuItemEngine.setSelected(true);
                    }
                    menuItemEngine.addItemListener(new ItemListener(){

                        @Override
                        public void itemStateChanged(ItemEvent e) {
                            if (e.getStateChange() == 1) {
                                JRadioButtonMenuItem item = (JRadioButtonMenuItem)e.getItem();
                                AppPreferences.SDEngine = item.getText();
                            }
                        }
                    });
                    group.add(menuItemEngine);
                    this.pop.add(menuItemEngine);
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(SlateDesktop.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void showPopUp(Component comp, int x, int y) {
        this.pop.show(comp, x, y);
    }

    public String getName() {
        return "Slate Desktop";
    }

    private static Path getInputPath(String engine) throws Exception {
        if (engine != cachedEngine) {
            cachedEngine = null;
            cachedInputPath = null;
            String lang = SlateDesktop.extractSourceLanguageFromEngineName(engine);
            String output = SlateDesktop.runXslate("--input-dir", lang);
            cachedInputPath = Paths.get(SlateDesktop.stripNewline(output), new String[0]);
            cachedEngine = engine;
        }
        return cachedInputPath;
    }

    private static Path writeTextFile(String engine, String ... strings) throws Exception {
        Path dir = SlateDesktop.getInputPath(engine);
        Files.createDirectories(dir, new FileAttribute[0]);
        Path path = dir.resolve("cafetran-input.txt");
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            for (String string : strings) {
                writer.write(string);
                writer.newLine();
            }
        }
        return path;
    }

    private static String extractSourceLanguageFromEngineName(String engine) {
        String[] parts = engine.split("-");
        return parts[0];
    }

    private static Path findXslate() throws Exception {
        if (xslate == null) {
            xslate = SlateDesktop.locateSlateDesktop().resolve("xslate");
        }
        return xslate;
    }

    private static String replaceNewline(String line, String replacement) {
        return line.replace("\r\n", replacement).replace("\n", replacement);
    }

    private static String stripNewline(String line) {
        return SlateDesktop.replaceNewline(line, "");
    }

    private static String[] makeXslateCommand(String ... args) throws Exception {
        ArrayList<String> command = new ArrayList<String>();
        command.add(SlateDesktop.getPython().toString());
        command.add(SlateDesktop.findXslate().toString());
        command.addAll(Arrays.asList(args));
        return command.toArray(new String[0]);
    }

    private static String runXslate(String ... args) throws Exception {
        String[] command = SlateDesktop.makeXslateCommand(args);
        ProcessBuilder builder = new ProcessBuilder(command);
        Process proc = builder.start();
        int returncode = proc.waitFor();
        if (returncode != 0) {
            throw new RuntimeException(SlateDesktop.readStream(proc.getErrorStream()));
        }
        return SlateDesktop.readStream(proc.getInputStream());
    }

    public static String[] listEngines() throws Exception {
        return SlateDesktop.runXslate("--list-engines").split("\r?\n");
    }

    private static void deleteFile(Path path) throws IOException {
        if (path != null) {
            Files.deleteIfExists(path);
        }
    }

    private static Path makeTranslationFile(Path input, String engine) throws Exception {
        String out = SlateDesktop.runXslate("--engine", engine, "--translate", input.toString());
        return Paths.get(SlateDesktop.stripNewline(out), new String[0]);
    }

    private static List<String> runTranslate(String ... strings) throws Exception {
        if (AppPreferences.SDEngine.equals("")) {
            throw new RuntimeException("No engine configured.  Set one in the Slate Desktop plugin settings.");
        }
        Path input = SlateDesktop.writeTextFile(AppPreferences.SDEngine, strings);
        Path output = null;
        try {
            output = SlateDesktop.makeTranslationFile(input, AppPreferences.SDEngine);
            List<String> list = SlateDesktop.readTextFile(output);
            return list;
        }
        catch (NoSuchFileException ex) {
            throw new RuntimeException("Slate Desktop did not produce output file '" + ex.getMessage() + "'.");
        }
        finally {
            SlateDesktop.deleteFile(input);
            SlateDesktop.deleteFile(output);
        }
    }

    private static String readStream(InputStream stream) throws Exception {
        try (Scanner s = new Scanner(stream);){
            s.useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }

    private static List<String> readTextFile(Path file) throws IOException {
        return Files.readAllLines(file, StandardCharsets.UTF_8);
    }

    private static boolean isWindows() {
        String os = System.getProperty("os.name", "");
        return os.toLowerCase().startsWith("windows");
    }

    private static Path getPython() {
        String path = SlateDesktop.isWindows() ? "python.exe" : "/usr/bin/python";
        return Paths.get(path, new String[0]);
    }

    private static Path locateLocationFile() {
        String profileDir = SlateDesktop.isWindows() ? System.getenv("ALLUSERSPROFILE") : "/usr/local/etc";
        return Paths.get(profileDir, new String[0]).resolve("slate-desktop/location.conf");
    }

    private static Path readLocationFile(Path locationFile) {
        List<String> lines;
        try {
            lines = SlateDesktop.readTextFile(locationFile);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not find " + locationFile.toString() + ". Is Slate Desktop installed correctly?");
        }
        Path location = null;
        for (String line : lines) {
            if ((line = SlateDesktop.stripNewline(line)).equals("")) continue;
            if (location != null) {
                throw new RuntimeException("Slate Desktop location file " + locationFile.toString() + " should contain just one line with the Slate Desktop installation path, but contains more than one line.");
            }
            location = Paths.get(line, new String[0]);
        }
        if (location == null) {
            throw new RuntimeException("Location file " + locationFile.toString() + " should contain the path where Slate Desktop is installed.  It doesn't.");
        }
        return location;
    }

    private static Path locateSlateDesktop() {
        String override = System.getenv("SLATE_DESKTOP_LOCATION");
        return SlateDesktop.isEmpty(override) ? SlateDesktop.readLocationFile(SlateDesktop.locateLocationFile()) : Paths.get(override, new String[0]);
    }

    private static boolean isEmpty(String str) {
        return str == null || str.equals("");
    }

    private void initSettings() {
        if (AppPreferences.SDEngine.isEmpty()) {
            try {
                String[] engines = SlateDesktop.listEngines();
                if (engines.length > 0) {
                    AppPreferences.SDEngine = engines[0];
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void setAPIKey(String key) {
    }

    @Override
    public void setLanguagePair(String source, String target) {
    }

    @Override
    public void setLanguageCodesPair(String source, String target) {
    }

    @Override
    public String[] getLanguages() {
        return null;
    }

    @Override
    public JTextComponent getMTPane() {
        return this.mtHTMLPane;
    }

    private String prepareAAQuery(String request) {
        this.spans.clear();
        StringBuilder buff = new StringBuilder();
        Matcher m = this.spanPattern.matcher(request);
        int no = 1;
        int e = 0;
        while (m.find()) {
            int s = m.start();
            if (s > 0) {
                buff.append(request.substring(e, s).trim());
                buff.append("{");
                buff.append(no);
                buff.append("}");
            } else {
                buff.append("{");
                buff.append(no);
                buff.append("}");
            }
            ++no;
            String g = m.group();
            this.spans.add(g);
            e = m.end();
        }
        if (e < request.length()) {
            buff.append(request.substring(e).trim());
        }
        return buff.toString();
    }

    @Override
    public void translate(String source) {
        if (!this.pause) {
            this.search(source, null);
        }
    }

    @Override
    public void search(String okey, String rep) {
        final String key = okey = okey.replaceAll("\\s+", " ");
        SwingWorker worker = new SwingWorker(this){
            final /* synthetic */ SlateDesktop this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                this.this$0.find(key);
                return null;
            }

            @Override
            protected void done() {
            }
        };
        worker.execute();
    }

    private String insertAAinMT(String res) {
        StringBuffer rb = new StringBuffer();
        Matcher m = this.placeholderPattern.matcher(res);
        int k = 0;
        while (m.find()) {
            if (k < this.spans.size()) {
                String r = (String)this.spans.get(k);
                m.appendReplacement(rb, r);
            }
            ++k;
        }
        m.appendTail(rb);
        return rb.toString();
    }

    private synchronized void find(String request) {
        MatchBoard mb;
        String json;
        if (AppPreferences.isTrialVersion && this.queryCount > 0) {
            this.showErrorMessage("The connection to Slate Desktop is not available in the free version of CafeTran Espresso.");
            return;
        }
        this.result = "";
        this.result2 = "";
        String cs = (String)this.cache.get(request);
        if (cs == null) {
            List<String> output;
            try {
                output = SlateDesktop.runTranslate(SlateDesktop.replaceNewline(request, " "));
                if (output.size() != 1) {
                    String error = String.format("Unexpected xslate output: expected output file path, got %d lines of text.", output.size());
                    throw new RuntimeException(error);
                }
            }
            catch (Exception ex) {
                this.showErrorMessage(ex.getMessage());
                ex.printStackTrace();
                return;
            }
            json = output.get(0);
            if (json != null && json.length() > 0) {
                this.cache.put(request, json);
            }
        } else {
            json = cs;
        }
        String tr = json;
        String trRef = MTRefinement.refineMT(tr);
        StringBuilder html = new StringBuilder();
        html.append("<html>");
        html.append(HTMLFormat.glossaryStyles);
        html.append("<body>");
        html.append("<table width=98% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=2 CELLPADDING=8>");
        if (AppPreferences.correctAA && AppPreferences.fragmentAdjustmentMT && !trRef.equals(tr)) {
            html.append("<tr><td colspan=\"2\"><p>");
            html.append("<a class=\"altHref\" href=\"transfer2\">");
            this.result2 = tr;
            html.append(tr);
            html.append("</p></td></tr>");
        }
        html.append("<tr><td colspan=\"2\"><p>");
        html.append("<a class=\"altHref\" href=\"transfer\">");
        html.append(trRef);
        html.append("</p></td></tr>");
        this.result = trRef;
        html.append("</table>");
        html.append("</body></html>");
        String r = html.toString();
        this.showMessage(r);
        this.result = Placeables.unmaskTarget(this.result);
        if (this.result2 != null && this.result2.length() > 0) {
            this.result2 = Placeables.unmaskTarget(this.result2);
        }
        if ((mb = this.topui.getMatchBoard()) != null) {
            if (AppPreferences.matchBoardShortMatchInfo) {
                mb.setMTMatch(this.result, "SlateDesktop", "MT");
            } else {
                mb.setMTMatch(this.result, "SlateDesktop", "MT");
            }
        }
        this.setAutotext(this.result);
        if (AppPreferences.autoTransferMT.equals(this.shortName)) {
            this.applyResult(this.result, true);
        }
        ++this.queryCount;
    }

    private void setMatchStatus() {
        XLIFFUnit tu;
        XLIFF xliff = this.topui.getProjectView().getProject().getXLIFF();
        if (xliff != null && (tu = xliff.getWorkflow().getCheckTransUnit()) != null) {
            this.topui.getTargetView().setEdited(false);
            tu.removeMatch(false);
            boolean storeMatch = false;
            if (xliff.isCafeTranXLIFF) {
                storeMatch = true;
            }
            tu.setMatch(-1, 4, storeMatch);
        }
    }

    @Override
    public void apply(boolean auto) {
        this.applyResult(this.result, auto);
    }

    private void applyResult(String r, boolean auto) {
        if (r != null) {
            Document tdoc = this.topui.getTargetPane().getDocument();
            try {
                int len = tdoc.getLength();
                if (len > 0) {
                    if (!auto) {
                        tdoc.remove(0, len);
                    } else {
                        return;
                    }
                }
                TranslateEvent transEvent = this.topui.getMemoryView().getTranslateEvent();
                if (AppPreferences.autotags && transEvent != null) {
                    String source = this.topui.getSourcePane().getText();
                    String s = this.topui.getMatchBoard().transferSegmentTags(source, r, transEvent);
                    s = this.topui.getMatchBoard().matchHiddenNontranslatables(s);
                    tdoc.insertString(0, s, null);
                } else {
                    r = this.topui.getMatchBoard().matchHiddenNontranslatables(r);
                    tdoc.insertString(0, r, null);
                }
                if (auto) {
                    this.topui.getTargetPane().selectAll();
                } else {
                    this.topui.getTargetPane().setCaretPosition(0);
                }
                this.setMatchStatus();
            }
            catch (BadLocationException ex) {
                Logger.getLogger(MyMemory.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void showMessage(String mes) {
        if (this.mtHTMLPane != null) {
            this.mtHTMLPane.setCaretPosition(0);
            HTMLDocument doc = (HTMLDocument)this.mtHTMLPane.getDocument();
            try {
                doc.setInnerHTML(doc.getDefaultRootElement(), mes);
                JViewport vp = (JViewport)this.mtHTMLPane.getParent();
                final JScrollPane scroll = (JScrollPane)vp.getParent();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ SlateDesktop this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        scroll.getVerticalScrollBar().setValue(0);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void showErrorMessage(String error) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(HTMLFormat.styles);
        sb.append("<body>");
        sb.append("<table align=center WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=8 CELLPADDING=8><tr>");
        sb.append("<td style=\"color:white; background-color:black\">");
        sb.append(error);
        sb.append("</td>");
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("</body></html>");
        String info = sb.toString();
        this.showMessage(info);
    }

    @Override
    public void closeResource() {
        this.topui.getResourceView().setMT4("");
        this.tview.removeTab(this.getName());
    }

    private void setAutotext(String entry) {
        Prompter auto = this.sourceview.getPrompter();
        if (auto != null) {
            auto.getMTPhrases(entry);
        }
    }

    private void translateSelection() {
        JTextPane textComp = this.topui.getSourcePane();
        String s = textComp.getSelectedText();
        if (s == null) {
            s = ((JTextComponent)textComp).getText();
        }
        if (s != null && s.length() > 0) {
            s = XMLHelper.parseTags(s);
            this.search(s, null);
        }
    }

    class MTHyperactive
    implements HyperlinkListener {
        MTHyperactive() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String s = e.getDescription();
                if (s.equals("transfer")) {
                    SlateDesktop.this.applyResult(SlateDesktop.this.result, false);
                } else if (s.equals("transfer2")) {
                    SlateDesktop.this.applyResult(SlateDesktop.this.result2, false);
                } else {
                    SlateDesktop.this.translateSelection();
                }
            }
        }
    }
}

