/*
 * Decompiled with CFR 0.152.
 */
package translator.qa;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.TranslationUnit;
import translator.TranslationUnitMap;
import translator.XMLHelper;
import translator.qa.Fixable;
import translator.qa.Issue;
import translator.ttx.TTXUnit;
import translator.xliff.XLIFFUnit;

public final class ExactTermParser {
    private String[][] fstr;
    private Pattern matchPattern;
    private Pattern spacePattern = Pattern.compile("\\s+");
    private String wordSeparator;
    private int index;
    private TranslationUnitMap tumap;
    private boolean running;
    private String exactSeg;
    private String sLang;
    private String tLang;
    private int matchType;
    private String memoryName;
    private Issue issue;
    private Fixable fixable;
    private String target;

    public void setMatchingType(int mtype) {
        this.matchType = mtype;
        if (mtype == 2) {
            this.matchPattern = Pattern.compile("", 16);
            this.wordSeparator = "";
        } else {
            this.matchPattern = Pattern.compile("\\s+");
            this.wordSeparator = " ";
        }
    }

    public void setTUMap(TranslationUnitMap map) {
        this.tumap = map;
    }

    public void setMemoryName(String name) {
        this.memoryName = name;
    }

    private void makeSourceElements(String sent) {
        int i;
        sent = XMLHelper.normalizeSpace(sent);
        sent = sent.replaceAll(AppPreferences.punctuation, "");
        sent = sent.trim();
        sent = sent.replaceAll("\\s+", " ");
        if (this.tumap.isPrefixMatching()) {
            sent = this.makePrefixes(sent);
        }
        this.exactSeg = sent;
        String[] str = this.matchPattern.split(sent);
        if (this.matchType == 2) {
            ArrayList<String> list = new ArrayList<String>();
            for (i = 0; i < str.length; ++i) {
                String string = str[i];
                if (string.length() <= 0) continue;
                list.add(string);
            }
            str = new String[list.size()];
            int n = 0;
            Iterator it = list.iterator();
            while (it.hasNext()) {
                String string;
                str[n] = string = it.next().toString();
                ++n;
            }
        }
        int l = str.length;
        this.fstr = new String[l][l];
        for (i = 0; i < str.length; ++i) {
            String comp;
            this.fstr[i][0] = comp = str[i];
            for (int j = i + 1; j < str.length; ++j) {
                this.fstr[i][j] = comp = comp + this.wordSeparator + str[j];
            }
        }
    }

    public synchronized Fixable translate(Fixable f) {
        String source;
        DefaultXMLElement tu;
        if (f instanceof XLIFFUnit) {
            tu = (XLIFFUnit)f;
            source = ((XLIFFUnit)tu).getSourceText();
            this.target = ((XLIFFUnit)tu).getTargetText();
        } else if (f instanceof TTXUnit) {
            tu = (TTXUnit)f;
            source = ((TTXUnit)tu).getSourceText();
            this.target = ((TTXUnit)tu).getTargetText();
        } else {
            return null;
        }
        if (this.target != null) {
            this.target = XMLHelper.parseCustomTags(this.target);
            this.target = this.target.toLowerCase();
            this.target = XMLHelper.normalizeSpace(this.target);
            this.target = this.target.replaceAll(AppPreferences.punctuation, "");
            this.target = this.target.trim();
            this.target = this.target.replaceAll("\\s+", " ");
        }
        this.fixable = f;
        this.issue = null;
        this.makeSourceElements(source);
        this.sLang = this.tumap.getSourceLang();
        this.tLang = this.tumap.getTargetLang();
        this.running = true;
        if (this.matchType == 0) {
            this.index = 0;
            while (this.index < this.fstr.length && this.running) {
                this.findEntry(this.index, 0);
                ++this.index;
            }
        } else {
            this.index = 0;
            while (this.index < this.fstr.length && this.running) {
                this.findExactEntry(this.index, 0);
                ++this.index;
            }
        }
        if (this.issue != null) {
            return this.fixable;
        }
        return null;
    }

    public void stop() {
        this.running = false;
    }

    private void findEntry(int sindex, int nindex) {
        this.shortTermMemory(sindex, nindex);
        this.findNextEntry(sindex);
    }

    private void findNextEntry(int sindex) {
        for (int nindex = sindex + 1; nindex < this.fstr.length; ++nindex) {
            if (!this.shortTermMemory(sindex, nindex)) continue;
            this.index = nindex;
        }
    }

    private void findExactEntry(int sindex, int nindex) {
        this.shortTermMemory(sindex, nindex);
        this.findNextExactEntry(sindex);
    }

    private void findNextExactEntry(int sindex) {
        for (int nindex = sindex + 1; nindex < this.fstr.length; ++nindex) {
            if (!this.shortTermMemory(sindex, nindex)) continue;
            this.index = nindex;
        }
    }

    private boolean exactMemory() {
        if (this.tumap.getMatch(this.exactSeg) != null) {
            TranslationUnit tu = this.tumap.getCurrentTU();
            String source = tu.getSegment(this.sLang);
            String mtarget = tu.getSegment(this.tLang);
            String mtarget2 = mtarget.toLowerCase();
            mtarget2 = XMLHelper.normalizeSpace(mtarget2);
            mtarget2 = mtarget2.replaceAll(AppPreferences.punctuation, "");
            mtarget2 = mtarget2.trim();
            mtarget2 = mtarget2.replaceAll("\\s+", " ");
            boolean match = false;
            if (AppPreferences.qaTermMatch == 0) {
                match = this.fuzzytermMatch(mtarget2, this.target, AppPreferences.qaTermAccuracy);
            } else {
                int mi = this.target.indexOf(mtarget2);
                if (mi != -1) {
                    match = true;
                }
            }
            if (this.target == null || !match) {
                if (this.issue == null) {
                    this.issue = new Issue(1);
                    this.fixable.addIssue(this.issue);
                }
                String s = this.memoryName != null ? this.memoryName : ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT SEGMENT USE");
                this.issue.addMessage("<u>" + s + "</u><br><br>" + source);
                this.issue.addMessage("<u>" + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT SEGMENT USE") + "</u><br><br>" + mtarget);
            }
            return true;
        }
        return false;
    }

    private boolean shortTermMemory(int sindex, int nindex) {
        if (this.tumap.getMatch(this.fstr[sindex][nindex]) != null) {
            TranslationUnit tu = this.tumap.getCurrentTU();
            String source = tu.getSegment(this.sLang);
            String mtarget = tu.getSegment(this.tLang);
            String mtarget2 = mtarget.toLowerCase();
            mtarget2 = XMLHelper.normalizeSpace(mtarget2);
            mtarget2 = mtarget2.replaceAll(AppPreferences.punctuation, "");
            mtarget2 = mtarget2.trim();
            mtarget2 = mtarget2.replaceAll("\\s+", " ");
            boolean match = false;
            if (AppPreferences.qaTermMatch == 0) {
                match = this.fuzzytermMatch(mtarget2, this.target, AppPreferences.qaTermAccuracy);
            } else {
                int mi = this.target.indexOf(mtarget2);
                if (mi != -1) {
                    match = true;
                }
            }
            if (this.target == null || !match) {
                if (this.issue == null) {
                    this.issue = new Issue(1);
                    this.fixable.addIssue(this.issue);
                }
                String s = this.memoryName != null ? this.memoryName : ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT SEGMENT USE");
                this.issue.addMessage("<u>" + s + "</u><br><br>" + source);
                this.issue.addMessage("<u>" + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INCONSISTENT TERM USE") + "</u><br><br>" + mtarget);
            }
        }
        return false;
    }

    private boolean fuzzytermMatch(String term, String target, int proc) {
        boolean match = false;
        String[] str = this.spacePattern.split(term);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length; ++i) {
            String string = str[i];
            int len = string.length();
            int newlen = len * proc / 100;
            if (newlen == 0) {
                newlen = 1;
            }
            string = string.substring(0, newlen);
            string = Pattern.quote(string);
            sb.append("\\b");
            sb.append(string);
            sb.append("[^\\s]*");
            if (i >= str.length - 1) continue;
            sb.append("(\\s+)");
        }
        Pattern pattern = Pattern.compile(sb.toString());
        Matcher m = pattern.matcher(target);
        if (m.find()) {
            match = true;
        }
        return match;
    }

    private String makePrefixes(String key) {
        int min = AppPreferences.memPrefixLength;
        int proc = AppPreferences.memPrefixAccuracy;
        StringBuilder sb = new StringBuilder();
        String[] arr = key.split(" ");
        for (int i = 0; i < arr.length; ++i) {
            String string = arr[i];
            int[] parr = this.tumap.getPrefixLength(string);
            if (parr != null) {
                int pipe = parr[0];
                int pipe2 = parr[1];
                string = pipe2 != -1 ? string.substring(pipe, pipe2) : string.substring(0, pipe);
            } else {
                int ai = string.indexOf(39);
                if (ai != -1) {
                    String s = string.substring(ai + 1);
                    int len = s.length();
                    if (len >= min) {
                        if (proc == 0) {
                            string = s.substring(0, min);
                        } else {
                            int newlen = len * proc / 100;
                            if (newlen < min) {
                                newlen = min;
                            }
                            string = s.substring(0, newlen);
                        }
                    }
                } else {
                    int len = string.length();
                    if (len >= min) {
                        if (proc == 0) {
                            string = string.substring(0, min);
                        } else {
                            int newlen = len * proc / 100;
                            if (newlen < min) {
                                newlen = min;
                            }
                            string = string.substring(0, newlen);
                        }
                    }
                }
            }
            sb.append(string);
            if (i >= arr.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }
}

