/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import translator.XMLHelper;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXReadOnlyUnit;
import translator.tmx.TMXReadOnlyUnitMap;

public class SDLTMHandler {
    private TMXReadOnlyUnitMap romap;
    private String slang;
    private String tlang;
    Memory memory;
    boolean readOnly;
    TMX tmx;
    String txtString;
    String enc;

    public SDLTMHandler(Memory memory) {
        this.memory = memory;
        this.slang = memory.getSourceLangCode();
        int i = this.slang.indexOf(45);
        if (i != -1) {
            this.slang = this.slang.substring(0, i);
        }
        this.tlang = memory.getTargetLangCode();
        i = this.tlang.indexOf(45);
        if (i != -1) {
            this.tlang = this.tlang.substring(0, i);
        }
        this.readOnly = memory.isReadOnly();
        this.enc = memory.encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadZippedTextFile(ZipFile zfile, String name, String encoding) {
        InputStream is = null;
        try {
            ZipEntry entry = zfile.getEntry(name);
            int size = (int)entry.getSize();
            is = zfile.getInputStream(entry);
            BufferedInputStream bis = new BufferedInputStream(is);
            byte[] buf = new byte[size];
            bis.read(buf, 0, size);
            bis.close();
            this.txtString = new String(buf, 0, buf.length, encoding);
        }
        catch (IOException ex) {
            Logger.getLogger(SDLTMHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                Logger.getLogger(SDLTMHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTextFile(File file, String encoding) {
        FileInputStream fis = null;
        try {
            Charset charset = Charset.isSupported(encoding) ? Charset.forName(encoding) : Charset.forName("UTF-8");
            CharsetDecoder decoder = charset.newDecoder();
            decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            decoder.onMalformedInput(CodingErrorAction.REPLACE);
            fis = new FileInputStream(file);
            FileChannel fc = fis.getChannel();
            int sz = (int)fc.size();
            ByteBuffer bb = ByteBuffer.allocateDirect(sz);
            fc.read(bb);
            ByteBuffer buffer = bb;
            ((Buffer)buffer).flip();
            CharBuffer cb = decoder.decode(bb);
            fc.close();
            this.txtString = cb.toString();
        }
        catch (IOException ex) {
            Logger.getLogger(SDLTMHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                Logger.getLogger(SDLTMHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void parse() {
        this.tmx = this.memory.getTMX();
        if (this.readOnly) {
            this.romap = (TMXReadOnlyUnitMap)this.tmx.getTUMap();
        }
        String tuformat = "(<Segment.+?</Segment>\\d\\d\\d\\d)";
        String segformat = "(<Segment.+?</Segment>)";
        String textformat = "(<Text><Value>.+?</Value></Text>)";
        String cultureformat = "(<CultureName.+?</CultureName>)";
        Pattern tuP = Pattern.compile(tuformat, 34);
        Pattern segP = Pattern.compile(segformat, 34);
        Pattern textP = Pattern.compile(textformat, 2);
        Pattern cultureP = Pattern.compile(cultureformat, 2);
        Matcher tuMatcher = tuP.matcher(this.txtString);
        while (tuMatcher.find()) {
            String unit = tuMatcher.group();
            Matcher mSeg = segP.matcher(unit);
            String source = null;
            String target = null;
            String[] pair = new String[2];
            while (mSeg.find()) {
                String gr = mSeg.group();
                Matcher mmm = cultureP.matcher(gr);
                if (mmm.find()) {
                    int ei;
                    int si;
                    String sslang = null;
                    String ttlang = null;
                    String cgroup = mmm.group();
                    String la = cgroup.substring((si = cgroup.indexOf(62)) + 1, ei = cgroup.indexOf(60, si));
                    int i = la.indexOf(45);
                    if (i != -1) {
                        la = la.substring(0, i);
                    }
                    if (la.equalsIgnoreCase(this.slang)) {
                        sslang = la;
                    } else if (la.equalsIgnoreCase(this.tlang)) {
                        ttlang = la;
                    }
                    Matcher mm = textP.matcher(gr);
                    StringBuilder content = new StringBuilder();
                    while (mm.find()) {
                        int j;
                        String sgr = mm.group();
                        int k = sgr.indexOf("</Value>", j = sgr.indexOf("<Value>"));
                        if (k == -1) continue;
                        sgr = sgr.substring(j + 7, k);
                        sgr = XMLHelper.resolveEntitiesXML(sgr);
                        content.append(sgr.toString());
                    }
                    if (sslang != null) {
                        pair[0] = content.toString();
                    } else if (ttlang != null) {
                        pair[1] = content.toString();
                    }
                }
                source = pair[0];
                target = pair[1];
            }
            if (source == null || target == null) continue;
            if (this.readOnly) {
                TMXReadOnlyUnit tu = new TMXReadOnlyUnit();
                tu.setSegment(this.slang, source);
                tu.setSegment(this.tlang, target);
                this.romap.load(tu);
            } else {
                int dup = this.memory.getDuplicatesMode();
                this.tmx.update(source, target, null, null, null, dup);
                this.memory.setNewTU();
            }
            pair[0] = null;
            pair[1] = null;
        }
    }
}

