/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import translator.AppPreferences;
import translator.MainView;

public final class SegmentSplitter
extends JDialog
implements ActionListener {
    private JTextField sourcefield;
    private JTextField targetfield;
    private JButton jb1;
    private JButton jb2;
    private MainView parent;

    public SegmentSplitter(MainView parent, String title) {
        super(parent, title, true);
        this.parent = parent;
        this.enableEvents(64L);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel panel1 = new JPanel();
        panel1.setOpaque(false);
        panel1.setLayout(new GridLayout(2, 2, 5, 5));
        JLabel fieldCol = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SPLIT POSITION IN THE SOURCE SEGMENT") + ":");
        fieldCol.setHorizontalAlignment(2);
        this.sourcefield = new JTextField();
        this.sourcefield.setPreferredSize(new Dimension(200, this.sourcefield.getPreferredSize().height));
        JLabel fieldCol2 = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SPLIT POSITION IN THE TARGET SEGMENT") + ":");
        fieldCol2.setHorizontalAlignment(2);
        this.targetfield = new JTextField();
        this.targetfield.setPreferredSize(new Dimension(200, this.targetfield.getPreferredSize().height));
        panel1.add(fieldCol);
        panel1.add(this.sourcefield);
        panel1.add(fieldCol2);
        panel1.add(this.targetfield);
        this.jb1 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jb2 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jb1.addActionListener(this);
        this.jb2.addActionListener(this);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridLayout(0, 2, 10, 0));
        panel2.setOpaque(false);
        panel2.setBorder(new EmptyBorder(new Insets(10, 0, 5, 0)));
        JPanel panel3 = (JPanel)this.getContentPane();
        panel3.setBorder(new EmptyBorder(new Insets(10, 10, 0, 10)));
        panel3.setLayout(new BorderLayout());
        this.setResizable(false);
        panel2.add(this.jb1);
        panel2.add(this.jb2);
        panel3.add((Component)panel1, "Center");
        panel3.add((Component)panel2, "South");
        panel3.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SegmentSplitter.this.jb1.doClick();
            }
        });
        panel3.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SegmentSplitter.this.jb2.doClick();
            }
        });
        panel3.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        panel3.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    private void cancel() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jb2) {
            this.cancel();
        } else if (e.getSource() == this.jb1) {
            JProgressBar bar = this.parent.getPretranslateProgressBar();
            bar.setIndeterminate(true);
            bar.setStringPainted(true);
            bar.setString("Splitting segments...");
            this.setVisible(false);
            String s = this.sourcefield.getText();
            String t = this.targetfield.getText();
            if (s.length() > 0 && t.length() > 0) {
                this.parent.getTaskView().splitTMXUnits(s, t);
            }
            this.parent.removePretranslateProgressBar(bar);
            this.dispose();
        }
    }

    private void splitSegments(String s1, String s2) {
    }
}

