/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.io.CharArrayWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;
import translator.DefaultXMLElement;
import translator.XMLElement;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXReadOnlyUnit;
import translator.tmx.TMXReadOnlyUnitMap;

public class TBXHandler
extends DefaultHandler {
    protected CharArrayWriter contents = new CharArrayWriter();
    protected Stack deck = new Stack();
    protected Memory memory;
    protected TMX tmx;
    private TMXReadOnlyUnitMap romap;
    protected String slang;
    protected String tlang;
    boolean readOnly;
    Map properties = new LinkedHashMap();
    private Locator2 locator;

    public TBXHandler(Memory memory) {
        this.memory = memory;
        this.slang = memory.getSourceLangCode();
        int i = this.slang.indexOf(45);
        if (i != -1) {
            this.slang = this.slang.substring(0, i);
        }
        this.tlang = memory.getTargetLangCode();
        i = this.tlang.indexOf(45);
        if (i != -1) {
            this.tlang = this.tlang.substring(0, i);
        }
        this.readOnly = memory.isReadOnly();
        this.tmx = memory.getTMX();
        if (this.readOnly) {
            this.romap = (TMXReadOnlyUnitMap)this.tmx.getTUMap();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (locator instanceof Locator2) {
            this.locator = (Locator2)locator;
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.locator != null) {
            String enc = this.locator.getEncoding();
            if (enc != null && enc.startsWith("UTF-16")) {
                enc = "UTF-16";
            }
            this.memory.encoding = enc;
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
        DefaultXMLElement xml = new DefaultXMLElement(attr.getLength(), 1);
        for (int i = 0; i < attr.getLength(); ++i) {
            xml.setAttribute(attr.getQName(i), attr.getValue(i));
        }
        if (this.contents.size() > 0 && !this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement pxml = (XMLElement)o;
            pxml.addChild(this.contents.toString());
        }
        xml.setName(qName);
        this.deck.push(xml);
        this.contents.reset();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String name;
        XMLElement childXml = (XMLElement)this.deck.pop();
        if (this.contents.size() > 0) {
            childXml.addChild(this.contents.toString());
        }
        if (!this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement xml = (XMLElement)o;
            xml.addChild(childXml);
        }
        if ((name = childXml.getName()).equals("termEntry")) {
            XMLElement sourceElement = null;
            XMLElement targetElement = null;
            List list = childXml.getChildren("langSet");
            for (int i = 0; i < list.size(); ++i) {
                XMLElement xlang = (XMLElement)list.get(i);
                String lang = xlang.getAttribute("xml:lang");
                if (lang == null) {
                    lang = xlang.getAttribute("lang");
                }
                if (lang == null) continue;
                int j = lang.indexOf(45);
                if (j != -1) {
                    lang = lang.substring(0, j);
                }
                if (lang.equalsIgnoreCase(this.slang)) {
                    sourceElement = xlang;
                    continue;
                }
                if (!lang.equalsIgnoreCase(this.tlang)) continue;
                targetElement = xlang;
            }
            if (sourceElement != null && targetElement != null) {
                List sourceList = this.getTerm(sourceElement);
                List targetList = this.getTerm(targetElement);
                for (String source : sourceList) {
                    for (String target : targetList) {
                        if (source.length() <= 0 || target.length() <= 0) continue;
                        if (this.readOnly) {
                            TMXReadOnlyUnit tu = new TMXReadOnlyUnit();
                            tu.setSegment(this.slang, source);
                            tu.setSegment(this.tlang, target);
                            this.romap.load(tu);
                            continue;
                        }
                        this.properties.clear();
                        List notes = childXml.getChildren("note");
                        for (int i = 0; i < notes.size(); ++i) {
                            String s;
                            XMLElement note = (XMLElement)notes.get(i);
                            String type = note.getAttribute("type");
                            if (type == null || (s = (String)note.getContent(0)) == null) continue;
                            this.properties.put(type, s);
                        }
                        int dup = this.memory.getDuplicatesMode();
                        this.tmx.update(source, target, null, this.properties, null, dup);
                        this.memory.setNewTU();
                    }
                }
            }
        }
        this.contents.reset();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.write(ch, start, length);
    }

    private List getTerm(XMLElement element) {
        ArrayList<String> t;
        block7: {
            List tigs;
            block6: {
                t = new ArrayList<String>(2);
                tigs = element.getChildren("ntig");
                if (!tigs.isEmpty()) break block6;
                tigs = element.getChildren("tig");
                if (tigs.isEmpty()) break block7;
                for (XMLElement tig : tigs) {
                    List terms = tig.getChildren("term");
                    StringBuilder sb = new StringBuilder();
                    if (!terms.isEmpty()) {
                        XMLElement term = (XMLElement)terms.get(0);
                        List conts = term.getChildren();
                        for (int i = 0; i < conts.size(); ++i) {
                            Object object = conts.get(i);
                            if (!(object instanceof String)) continue;
                            sb.append(object.toString());
                        }
                    }
                    t.add(sb.toString());
                }
                break block7;
            }
            for (XMLElement tig : tigs) {
                List termGrps = tig.getChildren("termGrp");
                if (termGrps.isEmpty()) continue;
                XMLElement termGrp = (XMLElement)termGrps.get(0);
                List terms = termGrp.getChildren("term");
                StringBuilder sb = new StringBuilder();
                if (!terms.isEmpty()) {
                    XMLElement term = (XMLElement)terms.get(0);
                    List conts = term.getChildren();
                    for (int i = 0; i < conts.size(); ++i) {
                        Object object = conts.get(i);
                        if (!(object instanceof String)) continue;
                        sb.append(object.toString());
                    }
                }
                t.add(sb.toString());
            }
        }
        return t;
    }
}

