/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.XMLElement;
import translator.tmx.Memory;
import translator.tmx.TMXUnit;
import translator.tmx.TMXUnitMap;

public class TMXBody
extends DefaultXMLElement {
    private List extension;
    private TMXUnitMap map;
    private Set pretranslationTUSet;

    TMXBody(int att, int elem) {
        super(att, elem);
    }

    @Override
    public void addChild(Object o) {
        if (o instanceof TMXUnit) {
            if (AppPreferences.isTrialVersion && Memory.totalTUsLoaded > 1000) {
                return;
            }
            super.addChild(o);
            TMXUnit tu = (TMXUnit)o;
            this.map.load(tu);
            ++Memory.totalTUsLoaded;
        } else if (o instanceof XMLElement) {
            if (this.extension == null) {
                this.extension = new ArrayList();
            }
            this.extension.add(o);
        }
    }

    public void setTUMap(TMXUnitMap m) {
        this.map = m;
    }

    public void setTUPretranslationSet(Set s) {
        this.pretranslationTUSet = s;
    }

    public Set getTUPretranslationSet() {
        return this.pretranslationTUSet;
    }

    public List getTransUnits() {
        return this.getChildren();
    }

    public void writeXMLFormat(BufferedWriter awriter) throws IOException {
        String s;
        StringBuilder sb = new StringBuilder();
        String name = this.getName();
        sb.append("<");
        sb.append(name);
        LinkedHashMap attrMap = this.getAttributes();
        if (attrMap != null) {
            Set set = attrMap.keySet();
            Iterator<Object> i = set.iterator();
            while (i.hasNext()) {
                sb.append(" ");
                s = (String)i.next();
                sb.append(s);
                sb.append('=');
                sb.append('\"');
                sb.append((String)attrMap.get(s));
                sb.append('\"');
            }
        }
        sb.append(">");
        if (this.pretranslationTUSet != null) {
            for (Object elem : this.pretranslationTUSet) {
                s = elem.getXMLFormat();
                sb.append(s);
                if (sb.length() <= 1000000) continue;
                awriter.write(sb.toString());
                sb.setLength(0);
            }
        } else {
            List children = this.getChildren();
            if (children != null) {
                for (DefaultXMLElement elem : children) {
                    String s2 = elem.getXMLFormat();
                    sb.append(s2);
                    if (sb.length() <= 1000000) continue;
                    awriter.write(sb.toString());
                    sb.setLength(0);
                }
            }
        }
        if (this.extension != null) {
            for (Object elem : this.extension) {
                s = ((DefaultXMLElement)elem).getXMLFormat();
                sb.append(s);
            }
        }
        sb.append("</");
        sb.append(name);
        sb.append(">");
        awriter.write(sb.toString());
    }
}

