/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import translator.DefaultXMLElement;
import translator.TranslationUnit;
import translator.XMLElement;
import translator.tmx.TMXUnitVariant;

public class TMXUnit
extends DefaultXMLElement
implements TranslationUnit,
Serializable {
    private static final long serialVersionUID = 1L;
    private LinkedHashMap tuvs = new LinkedHashMap(2);
    private TranslationUnit link;
    TranslationUnit previousTU;
    TranslationUnit nextTU;
    private int[] tags;
    private String perfectMatch;
    public boolean state;
    private int projectID;

    public TMXUnit(int projectID) {
        super(4, 0);
        this.projectID = projectID;
    }

    public int getProjectID() {
        return this.projectID;
    }

    @Override
    public boolean getState() {
        return this.state;
    }

    @Override
    public TranslationUnit getPreviousTranslationUnit() {
        return this.previousTU;
    }

    @Override
    public TranslationUnit getNextTranslationUnit() {
        return this.nextTU;
    }

    @Override
    public void setAttribute(String type, String value) {
        super.setAttribute(type, value);
    }

    @Override
    public void addChild(Object o) {
        if (o instanceof XMLElement) {
            XMLElement xml = (XMLElement)o;
            String name = xml.getName();
            if (name.equals("tuv")) {
                TMXUnitVariant tuv = (TMXUnitVariant)xml;
                this.addTUV(tuv);
            } else {
                super.addChild(xml);
            }
        }
    }

    public void addTUV(TMXUnitVariant tuv) {
        String lang = tuv.getLanguage();
        if (lang != null) {
            int i = lang.indexOf(45);
            if (i != -1) {
                this.tuvs.put(lang.substring(0, i).toLowerCase(), tuv);
            } else {
                this.tuvs.put(lang.toLowerCase(), tuv);
            }
        }
        super.addChild(tuv);
    }

    public TMXUnitVariant getTUV(String lang) {
        int i = lang.indexOf(45);
        lang = i != -1 ? lang.substring(0, i).toLowerCase() : lang.toLowerCase();
        TMXUnitVariant tuv = (TMXUnitVariant)this.tuvs.get(lang);
        return tuv;
    }

    public Collection getTMXUnitVariants() {
        return this.tuvs.values();
    }

    @Override
    public String getSegment(String lang) {
        int i = lang.indexOf(45);
        TMXUnitVariant tuv = (TMXUnitVariant)this.tuvs.get(lang = i != -1 ? lang.substring(0, i).toLowerCase() : lang.toLowerCase());
        if (tuv != null) {
            return tuv.getSegmentText();
        }
        return "";
    }

    @Override
    public void setLink(TranslationUnit tu) {
        this.link = tu;
    }

    @Override
    public TranslationUnit getLink() {
        return this.link;
    }

    @Override
    public boolean hasLink() {
        return this.link != null;
    }

    @Override
    public boolean hasParent() {
        return false;
    }

    public void setTags(int[] tags) {
        this.tags = tags;
    }

    public int[] getTags() {
        return this.tags;
    }

    @Override
    public String getPerfectMatch() {
        return this.perfectMatch;
    }

    @Override
    public void setPerfectMatch(String s) {
        this.perfectMatch = s;
    }

    @Override
    public String getXMLFormat() {
        StringBuilder sb = new StringBuilder();
        String name = this.getName();
        sb.append("\n<");
        sb.append(name);
        LinkedHashMap attrMap = this.getAttributes();
        if (attrMap != null) {
            Set set = attrMap.keySet();
            Iterator<Object> i = set.iterator();
            while (i.hasNext()) {
                sb.append(" ");
                String s = (String)i.next();
                sb.append(s);
                sb.append('=');
                sb.append('\"');
                sb.append((String)attrMap.get(s));
                sb.append('\"');
            }
        }
        sb.append(">");
        List children = this.getChildren();
        if (children != null) {
            for (DefaultXMLElement elem : children) {
                String s = elem.getXMLFormat();
                sb.append(s);
            }
        }
        sb.append("</");
        sb.append(name);
        sb.append(">");
        return sb.toString();
    }

    @Override
    public Object[] getProperties() {
        List properties = this.getChildren("prop");
        if (properties.size() > 0) {
            Object[] props = new Object[properties.size()];
            int propIndex = 0;
            for (int i = 0; i < properties.size(); ++i) {
                Object o;
                XMLElement xprop = (XMLElement)properties.get(i);
                String type = xprop.getAttribute("type");
                if (type == null || (o = xprop.getContent(0)) == null) continue;
                String text = o.toString();
                String[] arr = new String[]{type, text};
                props[propIndex] = arr;
                ++propIndex;
            }
            return props;
        }
        return null;
    }
}

