/*
 * Decompiled with CFR 0.152.
 */
package translator.tmx;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.Frequencer;
import translator.MainView;
import translator.Placeables;
import translator.ProjectView;
import translator.Statistics;
import translator.TranslationUnit;
import translator.TranslationUnitMap;
import translator.WordCount;
import translator.XMLElement;
import translator.XMLHelper;
import translator.qa.Issue;
import translator.qa.QAView;
import translator.tmx.Memory;
import translator.tmx.TMX;
import translator.tmx.TMXMenu;
import translator.tmx.TMXUnit;
import translator.tmx.TMXUnitVariant;
import translator.tmx.TMXWorkflow;
import translator.ui.Colors;
import translator.ui.HTMLFormat;

public class TMXView {
    MainView topui;
    private ProjectView prview;
    private int fromIndex;
    private TMX tmx;
    private Memory memory;
    private TMXMenu menu;
    private static List tunitsNestedFilter = new ArrayList();
    private static List tunitsFilter;
    private static List tunitsGlued;
    private static boolean qafilter;
    private String query;
    private int queryType;
    private int currentTUIndex = -1;
    public int currentTUSize = -1;
    private Set<String> extractedResults;
    private static Pattern searchPattern;
    private static String replaceString;
    private static boolean replaceInSource;
    private boolean lastTU;
    Pattern urlPattern = Pattern.compile("(((https?|file)://+|www\\.)[\\w\\d:#@%/;$()~_?\\+-=\\\\\\.&]*)");

    public TMXView(MainView topui, Memory memory) {
        this.topui = topui;
        this.memory = memory;
        this.tmx = memory.getTMX();
        this.prview = topui.getProjectView();
    }

    void setLastTU(boolean last) {
        this.lastTU = last;
    }

    public TMXUnit getUnitInView(String id) {
        int i = Integer.parseInt(id);
        List tus = this.getViewUnits();
        if (tus != null) {
            TMXUnit tu = (TMXUnit)tus.get(i);
            return tu;
        }
        return null;
    }

    public List getViewUnits() {
        ArrayList list = null;
        if (tunitsFilter != null) {
            list = tunitsFilter;
        } else if (tunitsGlued != null) {
            list = tunitsGlued;
        } else {
            Collection col = this.tmx.getTranslationUnits();
            if (col instanceof List) {
                list = (List)col;
            } else {
                list = new ArrayList(col.size());
                list.addAll(col);
            }
        }
        return list;
    }

    public static List getFilteredUnits() {
        return tunitsFilter;
    }

    public int getCurrentUnitsSize() {
        if (tunitsFilter != null) {
            return tunitsFilter.size();
        }
        if (tunitsGlued != null) {
            return tunitsGlued.size();
        }
        List tunits = this.tmx.getBody().getTransUnits();
        if (tunits != null) {
            return tunits.size();
        }
        return 0;
    }

    public static void setQAFilteredUnits(List list) {
        qafilter = true;
        tunitsFilter = list;
    }

    public static boolean hasQAFilter() {
        return qafilter;
    }

    public static void setFilteredWorkflow(boolean flag) {
        if (flag) {
            if (AppPreferences.searchMultiFilter) {
                if (tunitsFilter == null) {
                    tunitsFilter = new ArrayList();
                }
            } else {
                tunitsFilter = new ArrayList();
            }
        } else {
            qafilter = false;
            Map iMap = QAView.getTMXIssuesMap();
            if (iMap != null) {
                iMap.clear();
            }
            tunitsFilter = null;
            AppPreferences.searchMultiFilter = false;
            AppPreferences.replaceAndEdit = false;
            searchPattern = null;
            replaceInSource = false;
            replaceString = null;
        }
    }

    public List getGluedUnits() {
        return tunitsGlued;
    }

    public void setGluedWorkflow(boolean flag) {
        if (flag) {
            tunitsGlued = new ArrayList();
            this.fillGluedArray();
        } else {
            tunitsGlued = null;
        }
    }

    public void cancelGluedWorkflows() {
        if (tunitsGlued != null) {
            tunitsGlued.clear();
            tunitsGlued = null;
        }
    }

    private void fillGluedArray() {
        List files = this.prview.getProject().getProjects();
        if (files != null && files.size() > 0) {
            for (TMX tmx : files) {
                List units;
                if (tmx == null || (units = tmx.getBody().getTransUnits()) == null) continue;
                for (TMXUnit tu : units) {
                    tunitsGlued.add(tu);
                }
            }
        }
    }

    private void fillSortedArray() {
        if (tunitsGlued != null) {
            tunitsFilter = new ArrayList(tunitsGlued);
            return;
        }
        List units = this.tmx.getBody().getTransUnits();
        if (units != null) {
            for (TMXUnit tu : units) {
                tunitsFilter.add(tu);
            }
        }
    }

    public Memory getMemory() {
        return this.memory;
    }

    public TMXMenu getMenu() {
        if (this.menu == null) {
            this.menu = new TMXMenu(this.topui, this.memory);
        }
        return this.menu;
    }

    public void editFile() {
        TMXMenu tmenu = this.getMenu();
        tmenu.showTMX();
    }

    public void showPopUp(Component comp, int x, int y, Object o) {
        TMXMenu fmenu = this.getMenu();
        fmenu.showPopUp(comp, x, y, o);
    }

    public void browseToUnit(int i) {
        this.currentTUIndex = i;
        this.fromIndex = i;
        if (qafilter) {
            if (AppPreferences.windowsLayout != 6 || !this.memory.getEditMode()) {
                String content = this.fetchQAGridContent(-2);
                this.goToContent(content, i);
            } else {
                String[] arr = this.fetchQAGridSplitContent(-2);
                this.goToSplitContent(arr, i);
            }
        } else if (AppPreferences.projectView == 0) {
            if (AppPreferences.windowsLayout != 6 || !this.memory.getEditMode()) {
                String content = this.fetchContent(true, -2);
                this.goToContent(content, i);
            } else {
                String[] arr = this.fetchContentSplit(true, -2);
                this.goToSplitContent(arr, i);
            }
        } else if (AppPreferences.projectView == 1) {
            if (AppPreferences.windowsLayout != 6 || !this.memory.getEditMode()) {
                String content = this.fetchGridContent(-2);
                this.goToContent(content, i);
            } else {
                String[] arr = this.fetchGridSplitContent(-2);
                this.goToSplitContent(arr, i);
            }
        } else if (AppPreferences.projectView == 2) {
            if (AppPreferences.windowsLayout != 6 || !this.memory.getEditMode()) {
                String content = this.fetchContent(false, -2);
                this.goToContent(content, i);
            } else {
                String[] arr = this.fetchContentSplit(false, -2);
                this.goToSplitContent(arr, i);
            }
        }
    }

    public void browseToNextUnit(int i) {
        if (i < this.fromIndex || i > this.fromIndex + AppPreferences.pagesize) {
            this.fromIndex = i - (AppPreferences.pagesize + 1);
            this.nextTUS();
        }
    }

    public void browseToPrevUnit(int i) {
        if (i <= this.fromIndex || i > this.fromIndex + AppPreferences.pagesize) {
            this.fromIndex = i;
            this.previousTUS();
        }
    }

    public void browseToLastUnit() {
        if (qafilter) {
            if (AppPreferences.windowsLayout != 6 || !this.memory.getEditMode()) {
                String content = this.fetchQAGridContent(0);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchQAGridSplitContent(0);
                this.showSplitContent(arr, true);
            }
        } else if (AppPreferences.projectView == 0) {
            if (AppPreferences.windowsLayout != 6 || !this.memory.getEditMode()) {
                String content = this.fetchContent(true, 0);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchContentSplit(true, 0);
                this.showSplitContent(arr, true);
            }
        } else if (AppPreferences.projectView == 1) {
            if (AppPreferences.windowsLayout != 6 || !this.memory.getEditMode()) {
                String content = this.fetchGridContent(0);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchGridSplitContent(0);
                this.showSplitContent(arr, true);
            }
        } else if (AppPreferences.projectView == 2) {
            if (AppPreferences.windowsLayout != 6 || !this.memory.getEditMode()) {
                String content = this.fetchContent(false, 0);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchContentSplit(false, 0);
                this.showSplitContent(arr, true);
            }
        }
    }

    public int getCurrentTUIndex() {
        return this.currentTUIndex;
    }

    public void viewRange(int from, int to) {
        if (!tunitsNestedFilter.isEmpty()) {
            tunitsNestedFilter.clear();
        }
        if (tunitsFilter != null) {
            if (AppPreferences.searchMultiFilter) {
                tunitsNestedFilter.addAll(tunitsFilter);
            }
            tunitsFilter.clear();
        }
        if (--from > to) {
            return;
        }
        List tunits = AppPreferences.searchMultiFilter && !tunitsNestedFilter.isEmpty() ? tunitsNestedFilter : (tunitsGlued != null ? tunitsGlued : this.tmx.getBody().getTransUnits());
        while (from < tunits.size()) {
            Object o = tunits.get(from);
            if (o != null && o instanceof TranslationUnit) {
                TranslationUnit tu = (TranslationUnit)o;
                tunitsFilter.add(tu);
            }
            if (++from != to) continue;
            break;
        }
        if (tunitsFilter != null) {
            if (tunitsFilter.isEmpty()) {
                this.setViewMode(AppPreferences.projectView);
            } else {
                this.prview.getProject().edit("#0");
            }
        } else {
            this.showContent("", true);
        }
    }

    public void sort() {
        if (tunitsFilter != null) {
            if (tunitsFilter.isEmpty()) {
                this.fillSortedArray();
            }
            TranslationUnitMap map = this.tmx.getTUMap();
            final String slang = map.getSourceLang();
            Collections.sort(tunitsFilter, new Comparator<TMXUnit>(){
                final /* synthetic */ TMXView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int compare(TMXUnit tu1, TMXUnit tu2) {
                    String s1 = tu1.getSegment(slang);
                    String s2 = tu2.getSegment(slang);
                    return s1.compareTo(s2);
                }
            });
            if (tunitsFilter.isEmpty()) {
                this.setViewMode(AppPreferences.projectView);
            } else {
                this.prview.getProject().edit("#0");
            }
        }
    }

    void sortByLength(boolean longToShort) {
        if (tunitsFilter != null) {
            if (tunitsFilter.isEmpty()) {
                this.fillSortedArray();
            }
            TranslationUnitMap map = this.tmx.getTUMap();
            final String slang = map.getSourceLang();
            if (!longToShort) {
                Collections.sort(tunitsFilter, new Comparator<TMXUnit>(){
                    final /* synthetic */ TMXView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public int compare(TMXUnit tu1, TMXUnit tu2) {
                        String s1 = tu1.getSegment(slang);
                        String s2 = tu2.getSegment(slang);
                        int len1 = s1.length();
                        int len2 = s2.length();
                        return len1 - len2;
                    }
                });
            } else {
                Collections.sort(tunitsFilter, new Comparator<TMXUnit>(){
                    final /* synthetic */ TMXView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public int compare(TMXUnit tu1, TMXUnit tu2) {
                        String s1 = tu1.getSegment(slang);
                        String s2 = tu2.getSegment(slang);
                        int len1 = s1.length();
                        int len2 = s2.length();
                        return len2 - len1;
                    }
                });
            }
            if (tunitsFilter.isEmpty()) {
                this.setViewMode(AppPreferences.projectView);
            } else {
                this.prview.getProject().edit("#0");
            }
        }
    }

    public void search(String s, String r, int mode) {
        List files;
        qafilter = false;
        Map iMap = QAView.getTMXIssuesMap();
        if (iMap != null) {
            iMap.clear();
        }
        String content = this.fetchSearchGridContent(s, r, mode);
        if (tunitsFilter != null) {
            boolean edit = this.memory.getEditMode();
            if (edit) {
                if (tunitsFilter.isEmpty()) {
                    this.setViewMode(AppPreferences.projectView);
                } else {
                    this.prview.getProject().edit("#0");
                }
            } else {
                this.showContent(content, true);
            }
        } else {
            this.showContent(content, true);
        }
        if (r != null && (files = this.prview.getProject().getProjects()) != null && tunitsGlued != null) {
            for (TMX t : files) {
                t.saved = false;
            }
        }
        if (AppPreferences.searchExtractRegExp && AppPreferences.searchType == 0) {
            String name = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REG. EXP. RESULTS");
            this.topui.getResourceView().showExtractedSearchResults(this.extractedResults, name);
        }
    }

    private String fetchSearchGridContent(String s, String r, int mode) {
        this.query = s;
        this.queryType = mode;
        boolean success = false;
        if (!tunitsNestedFilter.isEmpty()) {
            tunitsNestedFilter.clear();
        }
        if (tunitsFilter != null) {
            if (mode == 4 || mode == 5) {
                AppPreferences.searchMultiFilter = true;
            }
            if (AppPreferences.searchMultiFilter) {
                tunitsNestedFilter.addAll(tunitsFilter);
            }
            tunitsFilter.clear();
        }
        if (mode == 37) {
            s = XMLHelper.normalizeSpace(s);
            s = s.replaceAll(AppPreferences.punctuation, "");
            s = s.trim();
            s = s.replaceAll("\\s+", " ");
            TranslationUnitMap map = this.tmx.getTUMap();
            TranslationUnit tu = map.getTU(s);
            if (tu != null) {
                boolean added = false;
                while (tu.hasLink()) {
                    if (!added && tunitsFilter != null && !tunitsFilter.contains(tu)) {
                        tunitsFilter.add(tu);
                    }
                    TranslationUnit tu1 = tu.getLink();
                    if (tunitsFilter != null && !tunitsFilter.contains(tu1)) {
                        tunitsFilter.add(tu1);
                        added = true;
                    }
                    tu = tu1;
                }
            }
            return "";
        }
        if (mode == 14) {
            Collection tunits = tunitsGlued != null ? tunitsGlued : this.tmx.getTranslationUnits();
            for (Object o : tunits) {
                if (o == null || !(o instanceof TranslationUnit)) continue;
                TranslationUnit tu = (TranslationUnit)o;
                boolean added = false;
                while (tu.hasLink()) {
                    if (!added && tunitsFilter != null && !tunitsFilter.contains(tu)) {
                        tunitsFilter.add(tu);
                    }
                    TranslationUnit tu1 = tu.getLink();
                    if (tunitsFilter != null && !tunitsFilter.contains(tu1)) {
                        tunitsFilter.add(tu1);
                        added = true;
                    }
                    tu = tu1;
                }
            }
            return "";
        }
        StringBuilder html = new StringBuilder();
        html.append(HTMLFormat.startHTML);
        html.append(HTMLFormat.styles);
        html.append(HTMLFormat.startBody);
        html.append(HTMLFormat.startGrid);
        int i = 0;
        Pattern p = AppPreferences.searchCase ? Pattern.compile(s) : Pattern.compile(s, 66);
        if (AppPreferences.replaceAndEdit) {
            searchPattern = p;
            replaceString = r;
            this.query = r;
            r = null;
            replaceInSource = mode == 4;
        }
        int attributeSearch = -1;
        if (mode == 21) {
            if (s.startsWith("\\QCreation ID")) {
                attributeSearch = 0;
            } else if (s.startsWith("\\QCreation Date")) {
                attributeSearch = 1;
            }
        }
        XMLElement tus = null;
        XMLElement tut = null;
        String content = null;
        int j = 0;
        Collection tunits = AppPreferences.searchMultiFilter && !tunitsNestedFilter.isEmpty() ? tunitsNestedFilter : (tunitsGlued != null ? tunitsGlued : this.tmx.getTranslationUnits());
        if (AppPreferences.searchExtractRegExp && AppPreferences.searchType == 0) {
            this.extractedResults = new TreeSet<String>();
        }
        String slang = this.tmx.getTUMap().getSourceLang();
        String tlang = this.tmx.getTUMap().getTargetLang();
        int limit = 0;
        boolean header = false;
        for (TranslationUnit tu : tunits) {
            Matcher m;
            Pattern p2;
            String place;
            Set set;
            String sourceContent;
            String targetContent;
            TMXUnit tux;
            if (mode == 8) {
                List notes;
                if (!(tu instanceof TMXUnit) || (notes = (tux = (TMXUnit)tu).getChildren("note")) == null || notes.size() <= 0) continue;
                block4: for (DefaultXMLElement c : notes) {
                    String con;
                    Object no = c.getContent(0);
                    if (no == null || (con = no.toString()).length() <= 0 || con.equals("propagated")) continue;
                    Matcher ma = p.matcher(con);
                    while (ma.find()) {
                        if (tunitsFilter == null) continue;
                        tunitsFilter.add(tu);
                        continue block4;
                    }
                }
                continue;
            }
            if (mode == 9) {
                boolean state = tu.getState();
                if (!state || tunitsFilter == null) continue;
                tunitsFilter.add(tu);
                continue;
            }
            if (mode == 10) {
                boolean state = tu.getState();
                if (state || tunitsFilter == null) continue;
                tunitsFilter.add(tu);
                continue;
            }
            if (mode == 21) {
                List props;
                Matcher ma;
                String date;
                if (!(tu instanceof TMXUnit)) continue;
                tux = (TMXUnit)tu;
                if (attributeSearch == 0) {
                    Matcher ma2;
                    String id = tux.getAttribute("creationid");
                    if (id != null && id.length() > 0 && (ma2 = p.matcher("Creation ID=" + id)).find() && tunitsFilter != null) {
                        tunitsFilter.add(tu);
                        continue;
                    }
                } else if (attributeSearch == 1 && (date = tux.getAttribute("creationdate")) != null && date.length() > 0 && (ma = p.matcher("Creation Date=" + date)).find() && tunitsFilter != null) {
                    tunitsFilter.add(tu);
                    continue;
                }
                if ((props = tux.getChildren("prop")) == null || props.size() <= 0) continue;
                if (s.startsWith("\\Q*")) {
                    if (tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                    continue;
                }
                block6: for (DefaultXMLElement c : props) {
                    String type = c.getAttribute("type");
                    Object o = c.getContent(0);
                    if (o == null) continue;
                    String value = o.toString();
                    Matcher ma3 = p.matcher(type + "=" + value);
                    while (ma3.find()) {
                        if (tunitsFilter == null) continue;
                        tunitsFilter.add(tu);
                        continue block6;
                    }
                }
                continue;
            }
            if (mode == 12) {
                targetContent = tu.getSegment(tlang);
                if (targetContent != null && targetContent.trim().length() != 0 || tunitsFilter == null) continue;
                tunitsFilter.add(tu);
                continue;
            }
            if (mode == 13) {
                targetContent = tu.getSegment(tlang);
                if (targetContent == null || targetContent.trim().length() <= 0 || tunitsFilter == null) continue;
                tunitsFilter.add(tu);
                continue;
            }
            if (mode == 26) {
                sourceContent = tu.getSegment(slang);
                if (sourceContent == null || sourceContent.trim().length() <= 0) continue;
                set = Placeables.getPlaceablesSet();
                Iterator it2 = set.iterator();
                while (it2.hasNext()) {
                    place = it2.next().toString();
                    if (place.charAt(0) != '|') {
                        if (!sourceContent.equals(place) || tunitsFilter == null) continue;
                        tunitsFilter.add(tu);
                        continue;
                    }
                    String place2 = place.substring(1);
                    p2 = Placeables.getPlaceablePattern(place);
                    if (p2 == null) {
                        p2 = Pattern.compile(place2);
                    }
                    if (!(m = p2.matcher(sourceContent)).matches() || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                }
                continue;
            }
            if (mode == 27) {
                sourceContent = tu.getSegment(slang);
                if (sourceContent == null || sourceContent.trim().length() <= 0) continue;
                set = Placeables.getPlaceablesSet();
                Iterator it2 = set.iterator();
                while (it2.hasNext()) {
                    place = it2.next().toString();
                    if (place.charAt(0) != '|') {
                        if (sourceContent.indexOf(place) == -1 || tunitsFilter == null) continue;
                        tunitsFilter.add(tu);
                        continue;
                    }
                    String place2 = place.substring(1);
                    p2 = Placeables.getPlaceablePattern(place);
                    if (p2 == null) {
                        p2 = Pattern.compile(place2);
                    }
                    if (!(m = p2.matcher(sourceContent)).find() || tunitsFilter == null) continue;
                    tunitsFilter.add(tu);
                }
                continue;
            }
            if (!header) {
                header = true;
                html.append(HTMLFormat.startGrid);
                TMXWorkflow wf = this.tmx.getWorkflow();
                if (wf != null) {
                    html.append(HTMLFormat.sRow);
                    html.append("<TD style='border-width: 0px; border-style: solid; border-color: #CCCCCC' VALIGN=TOP ALIGN=RIGHT COLSPAN=3>");
                    html.append("<p>");
                    html.append("<A HREF=filter_mode_").append(mode).append("><b><u>").append("FILTER</b></u></A>&nbsp;&nbsp;&nbsp;");
                    html.append("<A HREF=#").append("-4").append("><b><u>").append("GO TO CURRENT SEGMENT</b></u></A>");
                    html.append("</p>");
                    html.append("</TD>");
                    html.append(HTMLFormat.eRow);
                }
            }
            StringBuffer sbHTML = new StringBuffer();
            if (mode == 4 || mode == 2) {
                content = tu.getSegment(slang);
            } else if (mode == 5 || mode == 3) {
                content = tu.getSegment(tlang);
            }
            if (content != null && content.length() > 0) {
                if (content.indexOf(124) != -1) {
                    content = content.replaceAll("\\|", "");
                }
                Matcher ma = p.matcher(content);
                boolean tuAdded = false;
                while (ma.find()) {
                    success = true;
                    if (tunitsFilter != null && !tuAdded) {
                        tunitsFilter.add(tu);
                        tuAdded = true;
                    }
                    if (r != null && !this.memory.isReadOnly()) {
                        if (AppPreferences.preserveCaseWithReplacement) {
                            String h;
                            String key = ma.group();
                            String f = XMLHelper.adaptCase(key, r);
                            if (!f.equals(r)) {
                                h = HTMLFormat.matchColorHTML + f + "</span>";
                                ma.appendReplacement(sbHTML, h);
                                continue;
                            }
                            h = HTMLFormat.matchColorHTML + r + "</span>";
                            ma.appendReplacement(sbHTML, h);
                            continue;
                        }
                        String h = HTMLFormat.matchColorHTML + r + "</span>";
                        ma.appendReplacement(sbHTML, h);
                        continue;
                    }
                    String m2 = ma.group();
                    String h = HTMLFormat.matchColorHTML + m2 + "</span>";
                    ma.appendReplacement(sbHTML, h);
                    if (!AppPreferences.searchExtractRegExp || AppPreferences.searchType != 0) continue;
                    this.extractedResults.add(m2);
                }
                if (!this.memory.isReadOnly() && r != null && tu instanceof TMXUnit) {
                    TMXUnit tux2 = (TMXUnit)tu;
                    TMXUnitVariant tuvs = tux2.getTUV(slang);
                    TMXUnitVariant tuvt = tux2.getTUV(tlang);
                    if (tuvs != null) {
                        tus = tuvs.getSegment();
                    }
                    if (tuvt != null) {
                        tut = tuvt.getSegment();
                    }
                    if ((mode == 4 || mode == 2) && tus != null) {
                        XMLHelper.replaceInXML(tus, p, r);
                    } else if ((mode == 5 || mode == 3) && tut != null) {
                        XMLHelper.replaceInXML(tut, p, r);
                    }
                }
                if (sbHTML.length() > 0) {
                    TMXUnit tux3;
                    List notes;
                    ma.appendTail(sbHTML);
                    String result = XMLHelper.resolveXMLEntitiesBetweenSpanTags(sbHTML.toString());
                    result = result.replace("\n", "<br>");
                    int k = i + 1;
                    if (mode == 4 || mode == 2) {
                        content = this.getSegmentXMLText(tu, tlang);
                        html.append(HTMLFormat.sRow);
                        html.append(HTMLFormat.TUContentRightColumn);
                        html.append("<p id=").append(i).append(">");
                        html.append(result);
                        html.append("</p>");
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.TUContentRightColumn);
                        html.append("<p id=").append(i).append(">");
                        html.append(content);
                        html.append("</p>");
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.TUStatusColumn);
                        html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.eRow);
                    } else if (mode == 5 || mode == 3) {
                        content = this.getSegmentXMLText(tu, slang);
                        html.append(HTMLFormat.sRow);
                        html.append(HTMLFormat.TUContentRightColumn);
                        html.append("<p id=").append(i).append(">");
                        html.append(content);
                        html.append("</p>");
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.TUContentRightColumn);
                        html.append("<p id=").append(i).append(">");
                        html.append(result);
                        html.append("</p>");
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.TUStatusColumn);
                        html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.eRow);
                    }
                    if (tu instanceof TMXUnit && (notes = (tux3 = (TMXUnit)tu).getChildren("note")) != null && notes.size() > 0) {
                        for (DefaultXMLElement c : notes) {
                            String con;
                            Object o = c.getContent(0);
                            if (o == null || (con = o.toString()).length() <= 0) continue;
                            html.append(HTMLFormat.sRow);
                            html.append(HTMLFormat.TUNotesColumn);
                            html.append("<p>");
                            html.append("<i>");
                            con = con.replace("\n", "<br>");
                            con = this.findURLLink(con);
                            html.append(con);
                            html.append("</i>");
                            html.append("</p>");
                            html.append(HTMLFormat.eCol);
                            html.append(HTMLFormat.TUStatusColumn);
                            html.append("<a href=#").append(i).append("#").append("><b>").append("N").append("</b></a>");
                            html.append(HTMLFormat.eCol);
                            html.append(HTMLFormat.eRow);
                        }
                    }
                    ++j;
                    ++limit;
                }
            }
            ++i;
            if (AppPreferences.searchExtractRegExp || tunitsFilter != null || r != null || limit < AppPreferences.searchDisplayLimit) continue;
            break;
        }
        html.append(HTMLFormat.endTable);
        if ((success || tunitsFilter != null && !tunitsFilter.isEmpty()) && this.memory != null) {
            this.topui.getTabView().selectMemoryTab(this.memory);
        }
        return html.toString();
    }

    public String fetchTextTargetSegments() {
        ArrayList list;
        if (tunitsFilter != null) {
            list = tunitsFilter;
        } else if (tunitsGlued != null) {
            list = tunitsGlued;
        } else {
            Collection col = this.tmx.getTranslationUnits();
            if (col instanceof List) {
                list = (List)col;
            } else {
                list = new ArrayList(col.size());
                list.addAll(col);
            }
        }
        String tlang = this.tmx.getTUMap().getTargetLang();
        StringBuilder sb = new StringBuilder();
        for (Object o : list) {
            TMXUnit tu;
            String s;
            if (!(o instanceof TMXUnit) || (s = (tu = (TMXUnit)o).getSegment(tlang)) == null || s.length() <= 0) continue;
            sb.append(s);
            sb.append("\n");
        }
        return sb.toString();
    }

    public String fetchHTMLContent() {
        ArrayList list;
        String starthtml = "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head><body style=\"font-family:verdana;font-size:14px;\">";
        String endhtml = "</body></html>";
        String endTable = "</TABLE>";
        String startTable = "<TABLE WIDTH=100% BORDER=1 BORDERCOLOR=#000000 CELLPADDING=4 CELLSPACING=0>";
        String sRow = "<TR>";
        String eRow = "</TR>";
        String noNotesCol = "<TD BORDER=0 VALIGN=TOP ALIGN=LEFT>";
        String notesColumn = "<TD WIDTH=50% BORDER=0 COLOR=BLACK VALIGN=TOP ALIGN=LEFT>";
        String sIDCol = "<TD WIDTH=2% style=\"font-family:verdana;font-size:12px;\" BGCOLOR=#E5D9B7 BORDER=0 VALIGN=CENTER ALIGN=LEFT>";
        String sCol = AppPreferences.projectView != 0 ? "<TD WIDTH=40% BORDER=0 VALIGN=TOP ALIGN=LEFT bgcolor=white>" : "<TD WIDTH=80% BORDER=0 VALIGN=TOP ALIGN=LEFT bgcolor=white>";
        String eCol = "</TD>";
        StringBuilder html = new StringBuilder();
        html.append(starthtml);
        html.append(startTable);
        if (tunitsFilter != null) {
            list = tunitsFilter;
        } else if (tunitsGlued != null) {
            list = tunitsGlued;
        } else {
            Collection col = this.tmx.getTranslationUnits();
            if (col instanceof List) {
                list = (List)col;
            } else {
                list = new ArrayList(col.size());
                list.addAll(col);
            }
        }
        String slang = this.tmx.getTUMap().getSourceLang();
        String tlang = this.tmx.getTUMap().getTargetLang();
        int id = 1;
        int size = list.size();
        html.append("<tr><td colspan=\"4\" align=center COLOR=WHITE BGCOLOR=#E5D9B7><b>").append("TRANSLATION UNITS: ").append(Integer.toString(size)).append("</b></td></tr>");
        for (Object o : list) {
            if (!(o instanceof TranslationUnit)) continue;
            TranslationUnit tu = (TranslationUnit)o;
            html.append("\n");
            html.append(sRow);
            html.append(sIDCol);
            html.append(Integer.toString(id));
            html.append(eCol);
            if (AppPreferences.projectView != 0) {
                html.append(sCol);
                html.append("<p>");
                String source = this.getSegmentXMLText(tu, slang);
                html.append(source);
                html.append("</p>");
                html.append(eCol);
            }
            html.append(sCol);
            html.append("<p>");
            String target = this.getSegmentXMLText(tu, tlang);
            html.append(target);
            html.append("</p>");
            html.append(eCol);
            if (tu instanceof TMXUnit) {
                TMXUnit tux = (TMXUnit)tu;
                List notes = tux.getChildren("note");
                if (notes != null && notes.size() > 0) {
                    html.append(notesColumn);
                    for (DefaultXMLElement c : notes) {
                        String con;
                        Object no = c.getContent(0);
                        if (no == null || (con = no.toString()).length() <= 0) continue;
                        html.append("<p>");
                        html.append("<i>");
                        con = con.replace("\n", "<br>");
                        con = this.findURLLink(con);
                        html.append(con);
                        html.append("</i>");
                        html.append("</p>");
                    }
                } else {
                    html.append(noNotesCol);
                    html.append("<p>");
                    html.append("<br>");
                    html.append("</p>");
                }
            }
            html.append(HTMLFormat.eCol);
            html.append(HTMLFormat.eRow);
            ++id;
        }
        html.append(endTable);
        html.append(endhtml);
        return html.toString();
    }

    public String fetchContent(boolean lang, int mode) {
        int size;
        ArrayList list;
        StringBuilder html = new StringBuilder();
        html.append(HTMLFormat.startHTML);
        html.append(HTMLFormat.styles);
        html.append(HTMLFormat.startBody);
        int i = 0;
        int gap = AppPreferences.pagesize;
        int marked = -1;
        TranslationUnitMap map = this.tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        if (tunitsFilter != null) {
            list = tunitsFilter;
        } else if (tunitsGlued != null) {
            list = tunitsGlued;
        } else {
            Collection col = this.tmx.getTranslationUnits();
            if (col instanceof List) {
                list = (List)col;
            } else {
                list = new ArrayList(col.size());
                list.addAll(col);
            }
        }
        this.currentTUSize = size = list.size();
        if (mode == 0) {
            this.fromIndex = size - gap;
        } else if (mode == 1) {
            this.fromIndex += gap;
        } else if (mode == -1) {
            this.fromIndex = this.fromIndex == 0 ? size - gap : (this.fromIndex < gap ? 0 : (this.fromIndex -= gap));
        } else if (mode == -2) {
            marked = this.fromIndex;
            this.fromIndex = size >= gap && this.fromIndex >= gap ? (this.fromIndex -= gap / 2) : 0;
        }
        if (this.fromIndex >= size || gap >= size) {
            this.fromIndex = 0;
        }
        i = this.fromIndex;
        int j = gap;
        int k = -1;
        html.append(HTMLFormat.startTableTarget);
        while (i < size) {
            k = i + 1;
            Object o = list.get(i);
            if (o instanceof TranslationUnit) {
                TMXUnit tux;
                List notes;
                TranslationUnit tu = (TranslationUnit)o;
                boolean state = tu.getState();
                String source = this.getSegmentXMLText(tu, slang);
                String target = this.getSegmentXMLText(tu, tlang);
                if (source.length() == 0 && target.length() == 0) {
                    ++i;
                    continue;
                }
                String content = lang ? target : source;
                String column = state ? (marked == i ? HTMLFormat.currentTUTargetReviewLeftCol : HTMLFormat.TUTargetReviewLeftCol) : (marked == i ? HTMLFormat.currentTUTargetLeftColumn : HTMLFormat.TUTargetLeftColumn);
                html.append(HTMLFormat.sRow);
                html.append(column);
                if (marked == i) {
                    html.append("<p id=").append(i).append(">");
                    if (tunitsFilter != null && this.queryType == 5 && this.query != null) {
                        StringBuffer sbHTML = new StringBuffer();
                        Pattern p = AppPreferences.searchCase ? Pattern.compile(this.query) : Pattern.compile(this.query, 66);
                        Matcher ma = p.matcher(content);
                        while (ma.find()) {
                            String m = ma.group();
                            String h = HTMLFormat.matchColorHTML + m + "</span>";
                            ma.appendReplacement(sbHTML, h);
                        }
                        ma.appendTail(sbHTML);
                        content = sbHTML.toString();
                    }
                } else {
                    html.append("<p id=").append(i).append(">");
                }
                html.append(content);
                html.append("</p>");
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.TUTargetStatusColumn);
                if (marked == i) {
                    html.append("<A style=\"color:white;background:#FF6600\" HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                } else {
                    html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                }
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.eRow);
                if (tu instanceof TMXUnit && (notes = (tux = (TMXUnit)tu).getChildren("note")) != null && notes.size() > 0) {
                    for (DefaultXMLElement c : notes) {
                        String con;
                        Object no = c.getContent(0);
                        if (no == null || (con = no.toString()).length() <= 0) continue;
                        html.append(HTMLFormat.sRow);
                        html.append(column);
                        html.append("<p>");
                        html.append("<i>");
                        con = con.replace("\n", "<br>");
                        html.append(con);
                        html.append("</i>");
                        html.append("</p>");
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.TUTargetStatusColumn);
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.eRow);
                    }
                }
            } else if (o instanceof XMLElement) {
                XMLElement xml = (XMLElement)o;
                String name = xml.getName();
                html.append(HTMLFormat.sRow);
                html.append(HTMLFormat.TUTargetLeftColumn);
                html.append("<a href=$").append(i).append("<b>").append(name).append("</b></a>");
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.TUTargetLeftColumn);
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.eRow);
            }
            ++i;
            if (--gap != 0) continue;
            break;
        }
        html.append(HTMLFormat.endTable);
        html.append(HTMLFormat.endHTML);
        return html.toString();
    }

    public String[] fetchContentSplit(boolean lang, int mode) {
        int size;
        ArrayList list;
        this.topui.getTargetView().setCurrentTUStatus("", "");
        boolean topGrid = true;
        StringBuilder header1 = new StringBuilder();
        StringBuilder header2 = new StringBuilder();
        header1.append(HTMLFormat.startHTML);
        header1.append(HTMLFormat.styles);
        header1.append(HTMLFormat.startBody);
        header2.append(HTMLFormat.startHTML);
        header2.append(HTMLFormat.styles);
        header2.append(HTMLFormat.startBody);
        int i = 0;
        int gap = AppPreferences.pagesize;
        int marked = -1;
        TranslationUnitMap map = this.tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        if (tunitsFilter != null) {
            list = tunitsFilter;
        } else if (tunitsGlued != null) {
            list = tunitsGlued;
        } else {
            Collection col = this.tmx.getTranslationUnits();
            if (col instanceof List) {
                list = (List)col;
            } else {
                list = new ArrayList(col.size());
                list.addAll(col);
            }
        }
        this.currentTUSize = size = list.size();
        if (mode == 0) {
            this.fromIndex = size - gap;
        } else if (mode == 1) {
            this.fromIndex += gap;
        } else if (mode == -1) {
            this.fromIndex = this.fromIndex == 0 ? size - gap : (this.fromIndex < gap ? 0 : (this.fromIndex -= gap));
        } else if (mode == -2) {
            marked = this.fromIndex;
            if (marked < gap) {
                gap += marked;
            }
            this.fromIndex = size >= gap && this.fromIndex >= gap ? (this.fromIndex -= gap / 2) : 0;
        }
        if (this.fromIndex >= size || gap >= size) {
            this.fromIndex = 0;
        }
        i = this.fromIndex;
        int j = gap;
        int k = -1;
        header1.append(HTMLFormat.startTableTarget);
        header2.append(HTMLFormat.startTableTarget);
        while (i < size) {
            StringBuilder html = new StringBuilder();
            if (i > marked) {
                topGrid = false;
            }
            k = i + 1;
            Object o = list.get(i);
            if (o instanceof TranslationUnit) {
                TMXUnit tux;
                List notes;
                TranslationUnit tu = (TranslationUnit)o;
                boolean state = tu.getState();
                String source = this.getSegmentXMLText(tu, slang);
                String target = this.getSegmentXMLText(tu, tlang);
                if (source.length() == 0 && target.length() == 0) {
                    ++i;
                    continue;
                }
                String content = lang ? target : source;
                String column = state ? HTMLFormat.TUTargetReviewLeftCol : HTMLFormat.TUTargetLeftColumn;
                if (marked != i || this.lastTU) {
                    html.append(HTMLFormat.sRow);
                    html.append(column);
                    html.append("<p id=").append(i).append(">");
                    html.append(content);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.TUTargetStatusColumn);
                    html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                } else {
                    String currentID = "#" + i;
                    StringBuilder statusString = new StringBuilder(64);
                    statusString.append(HTMLFormat.startHTML);
                    statusString.append(HTMLFormat.startBody);
                    statusString.append(HTMLFormat.startStatusTable);
                    statusString.append(HTMLFormat.sRow);
                    if (state) {
                        statusString.append(HTMLFormat.TUReviewStatusColumn);
                    } else {
                        statusString.append(HTMLFormat.TUStatusColumn);
                    }
                    statusString.append(k);
                    statusString.append(HTMLFormat.eCol);
                    statusString.append(HTMLFormat.eRow);
                    statusString.append(HTMLFormat.endTable);
                    statusString.append(HTMLFormat.endHTML);
                    this.topui.getTargetView().setCurrentTUStatus(statusString.toString(), currentID);
                }
                if (tu instanceof TMXUnit && (notes = (tux = (TMXUnit)tu).getChildren("note")) != null && notes.size() > 0) {
                    for (DefaultXMLElement c : notes) {
                        String con;
                        Object no = c.getContent(0);
                        if (no == null || (con = no.toString()).length() <= 0) continue;
                        html.append(HTMLFormat.sRow);
                        html.append(column);
                        html.append("<p>");
                        html.append("<i>");
                        con = con.replace("\n", "<br>");
                        html.append(con);
                        html.append("</i>");
                        html.append("</p>");
                        html.append(HTMLFormat.eCol);
                        html.append("<td>");
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.eRow);
                    }
                }
            } else if (o instanceof XMLElement) {
                XMLElement xml = (XMLElement)o;
                String name = xml.getName();
                html.append(HTMLFormat.sRow);
                html.append(HTMLFormat.TUTargetLeftColumn);
                html.append("<a href=$").append(i).append("<b>").append(name).append("</b></a>");
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.TUTargetLeftColumn);
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.eRow);
            }
            if (topGrid) {
                header1.append((CharSequence)html);
            } else {
                header2.append((CharSequence)html);
            }
            ++i;
            if (--gap != 0) continue;
            break;
        }
        header1.append(HTMLFormat.endTable);
        header1.append(HTMLFormat.endHTML);
        header2.append(HTMLFormat.endTable);
        header2.append(HTMLFormat.endHTML);
        this.lastTU = false;
        String[] arr = new String[]{header1.toString(), header2.toString()};
        return arr;
    }

    public String fetchQAGridContent(int mode) {
        StringBuilder html = new StringBuilder();
        html.append(HTMLFormat.startHTML);
        html.append(HTMLFormat.styles);
        html.append(HTMLFormat.startBody);
        TranslationUnitMap map = this.tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        int i = 0;
        int gap = AppPreferences.pagesize;
        int marked = -1;
        if (tunitsFilter == null) {
            return "";
        }
        List tunits = tunitsFilter;
        int size = tunits.size();
        if (mode == 0) {
            this.fromIndex = size - gap;
        } else if (mode == 1) {
            this.fromIndex += gap;
        } else if (mode == -1) {
            this.fromIndex = this.fromIndex == 0 ? size - gap : (this.fromIndex < gap ? 0 : (this.fromIndex -= gap));
        } else if (mode == -2) {
            marked = this.fromIndex;
            this.fromIndex = size >= gap && this.fromIndex >= gap ? (this.fromIndex -= gap / 2) : 0;
        }
        if (this.fromIndex >= size || gap >= size) {
            this.fromIndex = 0;
        }
        i = this.fromIndex;
        int j = gap;
        int k = -1;
        html.append(HTMLFormat.startTableQA);
        html.append("<tr><th COLOR=WHITE BGCOLOR=").append(Colors.colorMemoryHTML).append(">TRANSLATION UNITS:</th><th COLOR=WHITE BGCOLOR=").append(Colors.colorMemoryHTML).append(">").append(Integer.toString(size)).append("</th><th></th></tr>");
        while (i < size) {
            List issues;
            TMXUnit tu = (TMXUnit)tunits.get(i);
            boolean state = tu.getState();
            String attr = tu.getAttribute("translate");
            if (attr != null && attr.equals("no")) {
                ++i;
                continue;
            }
            String source = this.getSegmentXMLText(tu, slang);
            String target = this.getSegmentXMLText(tu, tlang);
            if (source.length() == 0 && target.length() == 0) {
                ++i;
                continue;
            }
            k = i + 1;
            String column = state ? (marked == i ? HTMLFormat.currentTUReviewLeftCol : HTMLFormat.TUReviewLeftCol) : (marked == i ? HTMLFormat.currentTUContentRightColumn : HTMLFormat.TUContentRightColumn);
            StringBuilder nhtml = null;
            if (tu instanceof TMXUnit) {
                TMXUnit tux = tu;
                List notes = tux.getChildren("note");
                boolean prop = false;
                nhtml = new StringBuilder();
                if (notes != null && notes.size() > 0) {
                    int ncount = -1;
                    Iterator ai = notes.iterator();
                    while (ai.hasNext()) {
                        String con;
                        ++ncount;
                        DefaultXMLElement c = (DefaultXMLElement)ai.next();
                        Object o = c.getContent(0);
                        if (o == null || (con = o.toString()).length() <= 0) continue;
                        if (con.equals("propagated")) {
                            prop = true;
                            continue;
                        }
                        nhtml.append(HTMLFormat.sRow);
                        nhtml.append(HTMLFormat.TUNotesColumn);
                        nhtml.append("<p>");
                        nhtml.append("<i>");
                        con = this.findURLLink(con);
                        nhtml.append(con);
                        nhtml.append("</i>");
                        nhtml.append("</p>");
                        nhtml.append(HTMLFormat.eCol);
                        nhtml.append(HTMLFormat.TUStatusColumn);
                        nhtml.append("<a href=#").append(i).append("#").append("><b>").append("N").append("</b></a>");
                        nhtml.append(HTMLFormat.eCol);
                        nhtml.append(HTMLFormat.eRow);
                    }
                }
            }
            if ((issues = (List)QAView.getTMXIssuesMap().get(tu)) != null) {
                String h;
                String m;
                StringBuffer sbHTML;
                String context;
                TranslationUnit tucontext;
                Matcher qmatcher = null;
                boolean qlang = false;
                boolean firstIssue = true;
                for (Issue issue : issues) {
                    String message;
                    if (qmatcher == null) {
                        qmatcher = issue.getQuery();
                        qlang = issue.getQueryLanguage();
                    }
                    String[] messages = issue.getMessages();
                    for (int l = 0; l < messages.length && (message = messages[l]) != null; ++l) {
                        html.append(HTMLFormat.sRow);
                        html.append(HTMLFormat.TURightColQA);
                        html.append("<p style=\"color:white\">");
                        html.append(message);
                        html.append("</p>");
                        html.append(HTMLFormat.eCol);
                        if (++l < messages.length) {
                            message = messages[l];
                            if (message != null) {
                                html.append(HTMLFormat.TURightColQA);
                                html.append("<p style=\"color:white\">");
                                html.append(message);
                                html.append("</p>");
                                html.append(HTMLFormat.eCol);
                            } else {
                                html.append(HTMLFormat.TULeftColQA);
                                html.append(HTMLFormat.eCol);
                            }
                        } else {
                            html.append(HTMLFormat.TULeftColQA);
                            html.append(HTMLFormat.eCol);
                        }
                        if (marked == i) {
                            html.append(HTMLFormat.TUStatusColumnCurrent);
                        } else {
                            html.append(HTMLFormat.TUStatusColumn);
                        }
                        if (firstIssue) {
                            firstIssue = false;
                            html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                        }
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.eRow);
                    }
                }
                if (marked == i && AppPreferences.contextInFilter && (tucontext = tu.getPreviousTranslationUnit()) != null) {
                    html.append(HTMLFormat.sRow);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    context = this.getSegmentXMLText(tucontext, slang);
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    context = this.getSegmentXMLText(tucontext, tlang);
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                }
                html.append(HTMLFormat.sRow);
                html.append(column);
                if (marked == i) {
                    html.append("<p id=").append(i).append(">");
                    if (qmatcher != null && qlang) {
                        sbHTML = new StringBuffer();
                        qmatcher.reset();
                        while (qmatcher.find()) {
                            m = qmatcher.group();
                            h = HTMLFormat.matchColorHTML + m + "</span>";
                            qmatcher.appendReplacement(sbHTML, h);
                        }
                        qmatcher.appendTail(sbHTML);
                        source = sbHTML.toString();
                    }
                } else {
                    html.append("<p id=").append(i).append(">");
                }
                html.append(source);
                html.append("</p>");
                html.append(HTMLFormat.eCol);
                html.append(column);
                if (marked == i) {
                    html.append("<p id=").append(i).append(">");
                    if (qmatcher != null && !qlang) {
                        sbHTML = new StringBuffer();
                        qmatcher.reset();
                        while (qmatcher.find()) {
                            m = qmatcher.group();
                            h = HTMLFormat.matchColorHTML + m + "</span>";
                            qmatcher.appendReplacement(sbHTML, h);
                        }
                        qmatcher.appendTail(sbHTML);
                        target = sbHTML.toString();
                    }
                } else {
                    html.append("<p id=").append(i).append(">");
                }
                html.append(target);
                html.append("</p>");
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.eRow);
                if (marked == i && AppPreferences.contextInFilter && (tucontext = tu.getNextTranslationUnit()) != null) {
                    html.append(HTMLFormat.sRow);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    context = this.getSegmentXMLText(tucontext, slang);
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    context = this.getSegmentXMLText(tucontext, tlang);
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                }
                if (nhtml != null) {
                    html.append((CharSequence)nhtml);
                }
            }
            ++i;
            if (--gap != 0) continue;
            break;
        }
        html.append(HTMLFormat.endTable);
        html.append(HTMLFormat.endHTML);
        return html.toString();
    }

    public String[] fetchQAGridSplitContent(int mode) {
        boolean topGrid = true;
        StringBuilder header1 = new StringBuilder();
        StringBuilder header2 = new StringBuilder();
        header1.append(HTMLFormat.startHTML);
        header1.append(HTMLFormat.styles);
        header1.append(HTMLFormat.startBody);
        header2.append(HTMLFormat.startHTML);
        header2.append(HTMLFormat.styles);
        header2.append(HTMLFormat.startBody);
        TranslationUnitMap map = this.tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        int i = 0;
        int gap = AppPreferences.pagesize;
        int marked = -1;
        if (tunitsFilter == null) {
            String[] arr = new String[]{"", ""};
            return arr;
        }
        List tunits = tunitsFilter;
        int size = tunits.size();
        if (mode == 0) {
            this.fromIndex = size - gap;
        } else if (mode == 1) {
            this.fromIndex += gap;
        } else if (mode == -1) {
            this.fromIndex = this.fromIndex == 0 ? size - gap : (this.fromIndex < gap ? 0 : (this.fromIndex -= gap));
        } else if (mode == -2) {
            marked = this.fromIndex;
            if (marked < gap) {
                gap += marked;
            }
            this.fromIndex = size >= gap && this.fromIndex >= gap ? (this.fromIndex -= gap / 2) : 0;
        }
        if (this.fromIndex >= size || gap >= size) {
            this.fromIndex = 0;
        }
        i = this.fromIndex;
        int j = gap;
        int k = -1;
        header1.append(HTMLFormat.startTableQA);
        header2.append(HTMLFormat.startTableQA);
        header1.append("<tr><td colspan=2 align=center COLOR=WHITE BGCOLOR=").append(Colors.colorMemoryHTML).append(">TRANSLATION UNITS: ").append(Integer.toString(size)).append("</td></tr>");
        while (i < size) {
            List issues;
            StringBuilder html = new StringBuilder();
            if (i > marked) {
                topGrid = false;
            }
            TMXUnit tu = (TMXUnit)tunits.get(i);
            boolean state = tu.getState();
            String attr = tu.getAttribute("translate");
            if (attr != null && attr.equals("no")) {
                ++i;
                continue;
            }
            String source = this.getSegmentXMLText(tu, slang);
            String target = this.getSegmentXMLText(tu, tlang);
            if (source.length() == 0 && target.length() == 0) {
                ++i;
                continue;
            }
            k = i + 1;
            String column = state ? (marked == i ? HTMLFormat.currentTUReviewLeftCol : HTMLFormat.TUReviewLeftCol) : (marked == i ? HTMLFormat.currentTUContentRightColumn : HTMLFormat.TUContentRightColumn);
            StringBuilder nhtml = null;
            if (tu instanceof TMXUnit) {
                TMXUnit tux = tu;
                List notes = tux.getChildren("note");
                boolean prop = false;
                nhtml = new StringBuilder();
                if (notes != null && notes.size() > 0) {
                    int ncount = -1;
                    Iterator ai = notes.iterator();
                    while (ai.hasNext()) {
                        String con;
                        ++ncount;
                        DefaultXMLElement c = (DefaultXMLElement)ai.next();
                        Object o = c.getContent(0);
                        if (o == null || (con = o.toString()).length() <= 0) continue;
                        if (con.equals("propagated")) {
                            prop = true;
                            continue;
                        }
                        nhtml.append(HTMLFormat.sRow);
                        nhtml.append(HTMLFormat.TUNotesColumn);
                        nhtml.append("<p>");
                        nhtml.append("<i>");
                        con = this.findURLLink(con);
                        nhtml.append(con);
                        nhtml.append("</i>");
                        nhtml.append("</p>");
                        nhtml.append(HTMLFormat.eCol);
                        nhtml.append(HTMLFormat.TUStatusColumn);
                        nhtml.append("<a href=#").append(i).append("#").append("><b>").append("N").append("</b></a>");
                        nhtml.append(HTMLFormat.eCol);
                        nhtml.append(HTMLFormat.eRow);
                    }
                }
            }
            if ((issues = (List)QAView.getTMXIssuesMap().get(tu)) != null) {
                String h;
                String m;
                StringBuffer sbHTML;
                String context;
                TranslationUnit tucontext;
                Matcher qmatcher = null;
                boolean qlang = false;
                boolean firstIssue = true;
                for (Issue issue : issues) {
                    String message;
                    if (qmatcher == null) {
                        qmatcher = issue.getQuery();
                        qlang = issue.getQueryLanguage();
                    }
                    String[] messages = issue.getMessages();
                    for (int l = 0; l < messages.length && (message = messages[l]) != null; ++l) {
                        html.append(HTMLFormat.sRow);
                        html.append(HTMLFormat.TURightColQA);
                        html.append("<p style=\"color:white\">");
                        html.append(message);
                        html.append("</p>");
                        html.append(HTMLFormat.eCol);
                        if (++l < messages.length) {
                            message = messages[l];
                            if (message != null) {
                                html.append(HTMLFormat.TURightColQA);
                                html.append("<p style=\"color:white\">");
                                html.append(message);
                                html.append("</p>");
                                html.append(HTMLFormat.eCol);
                            } else {
                                html.append(HTMLFormat.TULeftColQA);
                                html.append(HTMLFormat.eCol);
                            }
                        } else {
                            html.append(HTMLFormat.TULeftColQA);
                            html.append(HTMLFormat.eCol);
                        }
                        if (marked == i) {
                            html.append(HTMLFormat.TUStatusColumnCurrent);
                        } else {
                            html.append(HTMLFormat.TUStatusColumn);
                        }
                        if (firstIssue) {
                            firstIssue = false;
                            html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                        }
                        html.append(HTMLFormat.eCol);
                        html.append(HTMLFormat.eRow);
                    }
                }
                if (marked == i && AppPreferences.contextInFilter && (tucontext = tu.getPreviousTranslationUnit()) != null) {
                    html.append(HTMLFormat.sRow);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    context = this.getSegmentXMLText(tucontext, slang);
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    context = this.getSegmentXMLText(tucontext, tlang);
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                }
                html.append(HTMLFormat.sRow);
                html.append(column);
                if (marked == i) {
                    html.append("<p id=").append(i).append(">");
                    if (qmatcher != null && qlang) {
                        sbHTML = new StringBuffer();
                        qmatcher.reset();
                        while (qmatcher.find()) {
                            m = qmatcher.group();
                            h = HTMLFormat.matchColorHTML + m + "</span>";
                            qmatcher.appendReplacement(sbHTML, h);
                        }
                        qmatcher.appendTail(sbHTML);
                        source = sbHTML.toString();
                    }
                } else {
                    html.append("<p id=").append(i).append(">");
                }
                html.append(source);
                html.append("</p>");
                html.append(HTMLFormat.eCol);
                html.append(column);
                if (marked == i) {
                    html.append("<p id=").append(i).append(">");
                    if (qmatcher != null && !qlang) {
                        sbHTML = new StringBuffer();
                        qmatcher.reset();
                        while (qmatcher.find()) {
                            m = qmatcher.group();
                            h = HTMLFormat.matchColorHTML + m + "</span>";
                            qmatcher.appendReplacement(sbHTML, h);
                        }
                        qmatcher.appendTail(sbHTML);
                        target = sbHTML.toString();
                    }
                } else {
                    html.append("<p id=").append(i).append(">");
                }
                html.append(target);
                html.append("</p>");
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.eRow);
                if (marked == i && AppPreferences.contextInFilter && (tucontext = tu.getNextTranslationUnit()) != null) {
                    html.append(HTMLFormat.sRow);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    context = this.getSegmentXMLText(tucontext, slang);
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.currentTUContextRightColumn);
                    context = this.getSegmentXMLText(tucontext, tlang);
                    html.append("<p>");
                    html.append(context);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                }
                if (nhtml != null) {
                    html.append((CharSequence)nhtml);
                }
            }
            if (topGrid) {
                header1.append((CharSequence)html);
            } else {
                header2.append((CharSequence)html);
            }
            ++i;
            if (--gap != 0) continue;
            break;
        }
        header1.append(HTMLFormat.endTable);
        header1.append(HTMLFormat.endHTML);
        header2.append(HTMLFormat.endTable);
        header2.append(HTMLFormat.endHTML);
        String[] arr = new String[]{header1.toString(), header2.toString()};
        return arr;
    }

    public String fetchGridContent(int mode) {
        int size;
        ArrayList list;
        StringBuilder html = new StringBuilder();
        html.append(HTMLFormat.startHTML);
        html.append(HTMLFormat.styles);
        html.append(HTMLFormat.startBody);
        html.append(HTMLFormat.startGrid);
        int i = 0;
        int gap = AppPreferences.pagesize;
        int marked = -1;
        TranslationUnitMap map = this.tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        if (tunitsFilter != null) {
            list = tunitsFilter;
        } else if (tunitsGlued != null) {
            list = tunitsGlued;
        } else {
            Collection col = this.tmx.getTranslationUnits();
            if (col instanceof List) {
                list = (List)col;
            } else {
                list = new ArrayList(col.size());
                list.addAll(col);
            }
        }
        this.currentTUSize = size = list.size();
        html.append("<tr><td colspan=2 align=center COLOR=WHITE BGCOLOR=").append(Colors.colorMemoryHTML).append(">TRANSLATION UNITS: ").append(Integer.toString(size)).append("</td></tr>");
        if (mode == 0) {
            this.fromIndex = size - gap;
        } else if (mode == 1) {
            this.fromIndex += gap;
        } else if (mode == -1) {
            this.fromIndex = this.fromIndex == 0 ? size - gap : (this.fromIndex < gap ? 0 : (this.fromIndex -= gap));
        } else if (mode == -2) {
            marked = this.fromIndex;
            this.fromIndex = size >= gap && this.fromIndex >= gap ? (this.fromIndex -= gap / 2) : 0;
        }
        if (this.fromIndex >= size || gap >= size) {
            this.fromIndex = 0;
        }
        i = this.fromIndex;
        int j = gap;
        int k = -1;
        while (i < size) {
            k = i + 1;
            Object o = list.get(i);
            if (o instanceof TranslationUnit) {
                String h;
                String m;
                Matcher ma;
                Pattern p;
                StringBuffer sbHTML;
                TranslationUnit tu = (TranslationUnit)o;
                boolean state = tu.getState();
                String source = this.getSegmentXMLText(tu, slang);
                String target = this.getSegmentXMLText(tu, tlang);
                if (source.length() == 0 && target.length() == 0) {
                    ++i;
                    continue;
                }
                String column = marked == i ? (state ? HTMLFormat.currentTUContentReviewColumn : HTMLFormat.currentTUContentRightColumn) : (state ? HTMLFormat.TUContentReviewColumn : HTMLFormat.TUContentRightColumn);
                html.append(HTMLFormat.sRow);
                html.append(column);
                if (marked == i) {
                    html.append("<p id=").append(i).append(">");
                    if (tunitsFilter != null && this.queryType == 4 && this.query != null) {
                        sbHTML = new StringBuffer();
                        p = AppPreferences.searchCase ? Pattern.compile("<.+?>|" + this.query) : Pattern.compile("<.+?>|" + this.query, 66);
                        ma = p.matcher(source);
                        while (ma.find()) {
                            m = ma.group();
                            if (m.startsWith("<") && m.endsWith(">")) {
                                ma.appendReplacement(sbHTML, m);
                                continue;
                            }
                            if (m.indexOf(36) != -1) {
                                m = m.replace("$", "\\$");
                            }
                            h = HTMLFormat.matchColorHTML + m + "</span>";
                            ma.appendReplacement(sbHTML, h);
                        }
                        ma.appendTail(sbHTML);
                        source = sbHTML.toString();
                    }
                } else {
                    html.append("<p id=").append(i).append(">");
                }
                html.append(source);
                html.append("</p>");
                html.append(HTMLFormat.eCol);
                html.append(column);
                if (marked == i) {
                    html.append("<p id=").append(i).append(">");
                    if (tunitsFilter != null && this.queryType == 5 && this.query != null) {
                        sbHTML = new StringBuffer();
                        p = AppPreferences.searchCase ? Pattern.compile("<.+?>|" + this.query) : Pattern.compile("<.+?>|" + this.query, 66);
                        ma = p.matcher(target);
                        while (ma.find()) {
                            m = ma.group();
                            if (m.startsWith("<") && m.endsWith(">")) {
                                ma.appendReplacement(sbHTML, m);
                                continue;
                            }
                            if (m.indexOf(36) != -1) {
                                m = m.replace("$", "\\$");
                            }
                            h = HTMLFormat.matchColorHTML + m + "</span>";
                            ma.appendReplacement(sbHTML, h);
                        }
                        ma.appendTail(sbHTML);
                        target = sbHTML.toString();
                    }
                } else {
                    html.append("<p id=").append(i).append(">");
                }
                html.append(target);
                html.append("</p>");
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.TUStatusColumn);
                html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.eRow);
                if (tu instanceof TMXUnit) {
                    TMXUnit tux = (TMXUnit)tu;
                    List notes = tux.getChildren("note");
                    if (notes != null && notes.size() > 0) {
                        for (Object c : notes) {
                            String con;
                            Object no = ((DefaultXMLElement)c).getContent(0);
                            if (no == null || (con = no.toString()).length() <= 0) continue;
                            html.append(HTMLFormat.sRow);
                            html.append(HTMLFormat.TUNotesColumn);
                            html.append("<p>");
                            html.append("<i>");
                            con = con.replace("\n", "<br>");
                            con = this.findURLLink(con);
                            html.append(con);
                            html.append("</i>");
                            html.append("</p>");
                            html.append(HTMLFormat.eCol);
                            html.append(HTMLFormat.TUStatusColumn);
                            html.append("<a href=#").append(i).append("#").append("><b>").append("N").append("</b></a>");
                            html.append(HTMLFormat.eCol);
                            html.append(HTMLFormat.eRow);
                        }
                    }
                    if (marked == i) {
                        List props;
                        LinkedHashMap amap = tux.getAttributes();
                        if (amap != null) {
                            Object c;
                            c = amap.entrySet().iterator();
                            while (c.hasNext()) {
                                Map.Entry entry = (Map.Entry)c.next();
                                String type = (String)entry.getKey();
                                String text = null;
                                if (type.equals("creationid")) {
                                    type = "Creation ID";
                                    text = (String)entry.getValue();
                                } else if (type.equals("creationdate")) {
                                    type = "Creation Date";
                                    text = (String)entry.getValue();
                                    StringBuilder builder = new StringBuilder();
                                    char[] arr = text.toCharArray();
                                    int h2 = 0;
                                    for (int w = 0; w < arr.length; ++w) {
                                        char b = arr[w];
                                        if (b == 'T') {
                                            builder.append(", ");
                                        } else if (h2 == 4 || h2 == 6) {
                                            builder.append('-');
                                            builder.append(b);
                                        } else if (h2 == 11 || h2 == 13) {
                                            builder.append(':');
                                            builder.append(b);
                                        } else if (b != 'Z') {
                                            builder.append(b);
                                        }
                                        ++h2;
                                    }
                                    text = builder.toString();
                                }
                                if (text == null || text.length() <= 0) continue;
                                html.append(HTMLFormat.sRow);
                                html.append(column);
                                html.append("<p>");
                                html.append("<A HREF=#").append(i).append("#>").append(type).append("</A>");
                                html.append("</p>");
                                html.append(HTMLFormat.eCol);
                                html.append(column);
                                html.append("<p>");
                                html.append(text);
                                html.append("</p>");
                                html.append(HTMLFormat.eCol);
                                html.append(HTMLFormat.TUStatusColumn);
                                html.append(HTMLFormat.eCol);
                                html.append(HTMLFormat.eRow);
                            }
                        }
                        if ((props = tux.getChildren("prop")) != null && props.size() > 0) {
                            for (DefaultXMLElement c : props) {
                                String type = c.getAttribute("type");
                                if (type == null || type.equals("target_tags")) continue;
                                String text = c.getContent(0).toString();
                                if (type.length() <= 0) continue;
                                html.append(HTMLFormat.sRow);
                                html.append(column);
                                html.append("<p>");
                                html.append("<A HREF=#").append(i).append("#>").append(type).append("</A>");
                                html.append("</p>");
                                html.append(HTMLFormat.eCol);
                                html.append(column);
                                html.append("<p>");
                                html.append(text);
                                html.append("</p>");
                                html.append(HTMLFormat.eCol);
                                html.append(HTMLFormat.TUStatusColumn);
                                html.append(HTMLFormat.eCol);
                                html.append(HTMLFormat.eRow);
                            }
                        }
                    }
                }
            } else if (o instanceof XMLElement) {
                XMLElement xml = (XMLElement)o;
                String name = xml.getName();
                html.append(HTMLFormat.sRow);
                html.append(HTMLFormat.TURightColumn);
                html.append("<a href=$").append(i).append("<b>").append(name).append("</b></a>");
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.TURightColumn);
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.TUStatusColumn);
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.eRow);
            }
            ++i;
            if (--gap != 0) continue;
            break;
        }
        html.append(HTMLFormat.endTable);
        html.append(HTMLFormat.endHTML);
        return html.toString();
    }

    public String[] fetchGridSplitContent(int mode) {
        int size;
        ArrayList list;
        this.topui.getTargetView().setCurrentTUStatus("", "");
        boolean topGrid = true;
        StringBuilder header1 = new StringBuilder();
        StringBuilder header2 = new StringBuilder();
        header1.append(HTMLFormat.startHTML);
        header1.append(HTMLFormat.styles);
        header1.append(HTMLFormat.startBody);
        header1.append(HTMLFormat.startGrid);
        header2.append(HTMLFormat.startHTML);
        header2.append(HTMLFormat.styles);
        header2.append(HTMLFormat.startBody);
        header2.append(HTMLFormat.startGrid);
        int i = 0;
        int gap = AppPreferences.pagesize;
        int marked = -1;
        TranslationUnitMap map = this.tmx.getTUMap();
        String slang = map.getSourceLang();
        String tlang = map.getTargetLang();
        if (tunitsFilter != null) {
            list = tunitsFilter;
        } else if (tunitsGlued != null) {
            list = tunitsGlued;
        } else {
            Collection col = this.tmx.getTranslationUnits();
            if (col instanceof List) {
                list = (List)col;
            } else {
                list = new ArrayList(col.size());
                list.addAll(col);
            }
        }
        this.currentTUSize = size = list.size();
        header1.append("<tr><td WIDTH=100% colspan=2 align=center COLOR=WHITE BGCOLOR=").append(Colors.colorMemoryHTML).append(">TRANSLATION UNITS: ").append(Integer.toString(size)).append("</td></tr>");
        if (mode == 0) {
            this.fromIndex = size - gap;
        } else if (mode == 1) {
            this.fromIndex += gap;
        } else if (mode == -1) {
            this.fromIndex = this.fromIndex == 0 ? size - gap : (this.fromIndex < gap ? 0 : (this.fromIndex -= gap));
        } else if (mode == -2) {
            marked = this.fromIndex;
            if (marked < gap) {
                gap += marked;
            }
            this.fromIndex = size >= gap && this.fromIndex >= gap ? (this.fromIndex -= gap / 2) : 0;
        }
        if (this.fromIndex >= size || gap >= size) {
            this.fromIndex = 0;
        }
        i = this.fromIndex;
        int j = gap;
        int k = -1;
        while (i < size) {
            StringBuilder html = new StringBuilder();
            if (i > marked) {
                topGrid = false;
            }
            k = i + 1;
            Object o = list.get(i);
            if (o instanceof TranslationUnit) {
                TranslationUnit tu = (TranslationUnit)o;
                boolean state = tu.getState();
                String source = this.getSegmentXMLText(tu, slang);
                String target = this.getSegmentXMLText(tu, tlang);
                if (source.length() == 0 && target.length() == 0) {
                    ++i;
                    continue;
                }
                String column = state ? HTMLFormat.TUContentReviewColumn : (marked != i || this.lastTU ? HTMLFormat.TUContentRightColumn : HTMLFormat.TURightColumn);
                if (marked != i || this.lastTU) {
                    html.append(HTMLFormat.sRow);
                    html.append(column);
                    html.append("<p id=").append(i).append(">");
                    html.append(source);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(column);
                    html.append("<p id=").append(i).append(">");
                    html.append(target);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.TUStatusColumn);
                    html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                } else {
                    String currentID = "#" + i;
                    StringBuilder statusString = new StringBuilder(64);
                    statusString.append(HTMLFormat.startHTML);
                    statusString.append(HTMLFormat.startBody);
                    statusString.append(HTMLFormat.startStatusTable);
                    statusString.append(HTMLFormat.sRow);
                    if (state) {
                        statusString.append(HTMLFormat.TUReviewStatusColumn);
                    } else {
                        statusString.append(HTMLFormat.TUStatusColumn);
                    }
                    statusString.append(k);
                    statusString.append(HTMLFormat.eCol);
                    statusString.append(HTMLFormat.eRow);
                    statusString.append(HTMLFormat.endTable);
                    statusString.append(HTMLFormat.endHTML);
                    this.topui.getTargetView().setCurrentTUStatus(statusString.toString(), currentID);
                }
                if (tu instanceof TMXUnit) {
                    TMXUnit tux = (TMXUnit)tu;
                    List notes = tux.getChildren("note");
                    if (notes != null && notes.size() > 0) {
                        int ncount = -1;
                        String notesStatusCell = marked == i ? HTMLFormat.TUStatusColumnCurrent : HTMLFormat.TUStatusColumn;
                        Iterator iterator = notes.iterator();
                        while (iterator.hasNext()) {
                            String con;
                            ++ncount;
                            DefaultXMLElement c = (DefaultXMLElement)iterator.next();
                            Object no = c.getContent(0);
                            if (no == null || (con = no.toString()).length() <= 0) continue;
                            html.append(HTMLFormat.sRow);
                            html.append(HTMLFormat.TUNotesColumn);
                            html.append("<p>");
                            html.append("<i>");
                            con = con.replace("\n", "<br>");
                            con = this.findURLLink(con);
                            html.append(con);
                            html.append("</i>");
                            html.append("</p>");
                            html.append(HTMLFormat.eCol);
                            html.append(notesStatusCell);
                            html.append("<a href=#").append(i).append("#").append("><b>").append("N").append("</b></a>");
                            html.append(HTMLFormat.eCol);
                            html.append(HTMLFormat.eRow);
                        }
                    }
                    if (marked == i) {
                        List props;
                        LinkedHashMap amap = tux.getAttributes();
                        if (amap != null) {
                            for (Map.Entry entry : amap.entrySet()) {
                                String type = (String)entry.getKey();
                                String text = null;
                                if (type.equals("creationid")) {
                                    type = "Creation ID";
                                    text = (String)entry.getValue();
                                } else if (type.equals("creationdate")) {
                                    type = "Creation Date";
                                    text = (String)entry.getValue();
                                    StringBuilder builder = new StringBuilder();
                                    char[] arr = text.toCharArray();
                                    int h = 0;
                                    for (int w = 0; w < arr.length; ++w) {
                                        char b = arr[w];
                                        if (b == 'T') {
                                            builder.append(", ");
                                        } else if (h == 4 || h == 6) {
                                            builder.append('-');
                                            builder.append(b);
                                        } else if (h == 11 || h == 13) {
                                            builder.append(':');
                                            builder.append(b);
                                        } else if (b != 'Z') {
                                            builder.append(b);
                                        }
                                        ++h;
                                    }
                                    text = builder.toString();
                                }
                                if (text == null || text.length() <= 0) continue;
                                html.append(HTMLFormat.sRow);
                                html.append(column);
                                html.append("<p>");
                                html.append("<A HREF=#").append(i).append("#>").append(type).append("</A>");
                                html.append("</p>");
                                html.append(HTMLFormat.eCol);
                                html.append(column);
                                html.append("<p>");
                                html.append(text);
                                html.append("</p>");
                                html.append(HTMLFormat.eCol);
                                html.append("<td>");
                                html.append(HTMLFormat.eCol);
                                html.append(HTMLFormat.eRow);
                            }
                        }
                        if ((props = tux.getChildren("prop")) != null && props.size() > 0) {
                            for (DefaultXMLElement c : props) {
                                String type = c.getAttribute("type");
                                if (type == null || type.equals("target_tags")) continue;
                                String text = c.getContent(0).toString();
                                if (type.length() <= 0) continue;
                                html.append(HTMLFormat.sRow);
                                html.append(column);
                                html.append("<p>");
                                html.append("<A HREF=#").append(i).append("#>").append(type).append("</A>");
                                html.append("</p>");
                                html.append(HTMLFormat.eCol);
                                html.append(column);
                                html.append("<p>");
                                html.append(text);
                                html.append("</p>");
                                html.append(HTMLFormat.eCol);
                                html.append("<td>");
                                html.append(HTMLFormat.eCol);
                                html.append(HTMLFormat.eRow);
                            }
                        }
                    }
                }
            } else if (o instanceof XMLElement) {
                XMLElement xml = (XMLElement)o;
                String name = xml.getName();
                html.append(HTMLFormat.sRow);
                html.append(HTMLFormat.TURightColumn);
                html.append("<a href=$").append(i).append("<b>").append(name).append("</b></a>");
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.TURightColumn);
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.TUStatusColumn);
                html.append(HTMLFormat.eCol);
                html.append(HTMLFormat.eRow);
            }
            if (topGrid) {
                header1.append((CharSequence)html);
            } else {
                header2.append((CharSequence)html);
            }
            ++i;
            if (--gap != 0) continue;
            break;
        }
        header1.append(HTMLFormat.endTable);
        header1.append(HTMLFormat.endHTML);
        header2.append(HTMLFormat.endTable);
        header2.append(HTMLFormat.endHTML);
        this.lastTU = false;
        String[] arr = new String[]{header1.toString(), header2.toString()};
        return arr;
    }

    public Statistics getStatistics() {
        Statistics stats = new Statistics();
        Collection units = tunitsFilter != null ? tunitsFilter : (tunitsGlued != null ? tunitsGlued : this.tmx.getTranslationUnits());
        HashSet<String> set = new HashSet<String>();
        WordCount wordCountAllSource = new WordCount();
        WordCount wordCountAllTarget = new WordCount();
        WordCount wordCountUntranslated = new WordCount();
        WordCount wordCountChecked = new WordCount();
        WordCount wordCountRepetions = new WordCount();
        for (TranslationUnit tu : units) {
            String tlang;
            String t;
            String slang = this.tmx.getTUMap().getSourceLang();
            String s = tu.getSegment(slang);
            ++stats.allSegments;
            if (s.length() > 0) {
                boolean adds = set.add(s);
                if (!adds) {
                    wordCountRepetions.doWordCount(s);
                    stats.repeatedChars += (float)s.length();
                    ++stats.repeatedSegments;
                }
                wordCountAllSource.doWordCount(s);
            }
            if ((t = tu.getSegment(tlang = this.tmx.getTUMap().getTargetLang())) != null && t.length() > 0) {
                wordCountAllTarget.doWordCount(t);
            }
            if (t == null || t.trim().length() == 0) {
                ++stats.untranslatedSegments;
                wordCountUntranslated.doWordCount(s);
                continue;
            }
            ++stats.translatedSegments;
        }
        if (stats.allSegments == 0) {
            return null;
        }
        stats.allSourceWords = wordCountAllSource.getWordCount();
        stats.allSourceChars = wordCountAllSource.getAllCharsCount();
        stats.allSourceCharsNoWhites = wordCountAllSource.getCharsCount();
        stats.allTargetWords = wordCountAllTarget.getWordCount();
        stats.allTargetChars = wordCountAllTarget.getAllCharsCount();
        stats.allTargetCharsNoWhites = wordCountAllTarget.getCharsCount();
        stats.untranslatedWords = wordCountUntranslated.getWordCount();
        stats.untranslatedChars = wordCountUntranslated.getAllCharsCount();
        stats.untranslatedCharsNoWhites = wordCountUntranslated.getCharsCount();
        stats.checkedWords = wordCountChecked.getWordCount();
        stats.checkedChars = wordCountChecked.getAllCharsCount();
        stats.checkedCharsNoWhites = wordCountChecked.getCharsCount();
        stats.translatedWords = stats.allSourceWords - stats.untranslatedWords;
        stats.translatedChars = stats.allSourceChars - stats.untranslatedChars;
        stats.translatedCharsNoWhites = stats.allSourceCharsNoWhites - stats.untranslatedCharsNoWhites;
        stats.repeatedWords = wordCountRepetions.getWordCount();
        stats.repeatedChars = wordCountRepetions.getAllCharsCount();
        stats.repeatedCharsNoWhites = wordCountRepetions.getCharsCount();
        if (!AppPreferences.updateProjectStatistics) {
            Frequencer freq = this.topui.getFrequencer();
            if (freq == null) {
                this.topui.setFrequencer();
                freq = this.topui.getFrequencer();
            }
            freq.findProjectHFWords();
            int[] freqWords = freq.getRepetitions2();
            stats.repeatedInternalWords = freqWords[0];
            stats.repeatedInternalCharsNoWhites = freqWords[1];
            stats.repeatedInternalChars = freqWords[2];
            stats.allSourceInteralChars = freqWords[3];
        }
        stats.setSourceBillingMessage(wordCountAllSource.getCountMessage());
        stats.setTargetBillingMessage(wordCountAllTarget.getCountMessage());
        return stats;
    }

    public String[] fetchCountInfo() {
        String[] counts = new String[29];
        WordCount wordCountAllS = new WordCount();
        WordCount wordCountAllT = new WordCount();
        WordCount wordCountUTS = new WordCount();
        WordCount wordCountRep = new WordCount();
        HashSet<String> set = new HashSet<String>();
        int total = 0;
        int rep = 0;
        int repNo = 0;
        int segments = 0;
        float translated = 0.0f;
        float untranslated = 0.0f;
        Collection units = tunitsFilter != null ? tunitsFilter : (tunitsGlued != null ? tunitsGlued : this.tmx.getTranslationUnits());
        for (TranslationUnit tu : units) {
            String tlang;
            String t;
            String slang = this.tmx.getTUMap().getSourceLang();
            String s = tu.getSegment(slang);
            ++segments;
            if (s.length() > 0) {
                total += s.length();
                boolean adds = set.add(s);
                if (!adds) {
                    wordCountRep.doWordCount(s);
                    rep += s.length();
                    ++repNo;
                }
                wordCountAllS.doWordCount(s);
            }
            if ((t = tu.getSegment(tlang = this.tmx.getTUMap().getTargetLang())) != null && t.length() > 0) {
                wordCountAllT.doWordCount(t);
            }
            if (t == null || t.trim().length() == 0) {
                wordCountUTS.doWordCount(s);
                untranslated += 1.0f;
                continue;
            }
            translated += 1.0f;
        }
        if (segments == 0) {
            return null;
        }
        int allSWords = wordCountAllS.getWordCount();
        float allSWhiteChars = wordCountAllS.getAllCharsCount();
        int allSChars = wordCountAllS.getCharsCount();
        int allTWords = wordCountAllT.getWordCount();
        float allTWhiteChars = wordCountAllT.getAllCharsCount();
        int allTChars = wordCountAllT.getCharsCount();
        int unTrWords = wordCountUTS.getWordCount();
        float unTrWhiteChars = wordCountUTS.getAllCharsCount();
        int unTrChars = wordCountUTS.getCharsCount();
        int trWords = allSWords - unTrWords;
        float trWhiteChars = allSWhiteChars - unTrWhiteChars;
        int trChars = allSChars - unTrChars;
        int repWords = wordCountRep.getWordCount();
        int repWhiteChars = wordCountRep.getAllCharsCount();
        int repChars = wordCountRep.getCharsCount();
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        nf.setMaximumFractionDigits(1);
        nf.setGroupingUsed(false);
        counts[0] = Integer.toString((int)translated);
        counts[1] = Integer.toString(trWords);
        counts[2] = Integer.toString(trChars);
        counts[3] = Integer.toString((int)trWhiteChars);
        float proc = trWhiteChars * 100.0f / allSWhiteChars;
        String procString = nf.format(proc);
        counts[4] = procString + "%";
        counts[5] = Integer.toString((int)untranslated);
        counts[6] = Integer.toString(unTrWords);
        counts[7] = Integer.toString(unTrChars);
        counts[8] = Integer.toString((int)unTrWhiteChars);
        proc = unTrWhiteChars * 100.0f / allSWhiteChars;
        procString = nf.format(proc);
        counts[9] = procString + "%";
        counts[10] = Integer.toString(segments);
        counts[11] = Integer.toString(allSWords);
        counts[12] = Integer.toString(allSChars);
        counts[13] = Integer.toString((int)allSWhiteChars);
        counts[14] = "100%";
        counts[15] = Integer.toString(repNo);
        counts[16] = Integer.toString(repWords);
        counts[17] = Integer.toString(repChars);
        counts[18] = Integer.toString(repWhiteChars);
        if (total > 0) {
            int iproc = rep * 100 / total;
            procString = Integer.toString(iproc);
            counts[19] = procString + "%";
        }
        if (!AppPreferences.updateProjectStatistics) {
            Frequencer freq = this.topui.getFrequencer();
            if (freq == null) {
                this.topui.setFrequencer();
                freq = this.topui.getFrequencer();
            }
            freq.findProjectHFWords();
            int[] freqWords = freq.getRepetitions2();
            counts[20] = Integer.toString(freqWords[0]);
            counts[21] = Integer.toString(freqWords[1]);
            counts[22] = Integer.toString(freqWords[2]);
            counts[23] = Integer.toString(freqWords[3]) + "%";
        }
        counts[24] = Integer.toString(allTWords);
        counts[25] = Integer.toString(allTChars);
        counts[26] = Integer.toString((int)allTWhiteChars);
        counts[27] = wordCountAllS.getCountMessage();
        counts[28] = wordCountAllT.getCountMessage();
        return counts;
    }

    public void replaceBeforeEdit(TMXUnitVariant tuvs, TMXUnitVariant tuvt) {
        if (!this.memory.isReadOnly() && replaceString != null) {
            XMLElement tut;
            if (replaceInSource) {
                XMLElement tus;
                if (tuvs != null && (tus = tuvs.getSegment()) != null) {
                    XMLHelper.replaceInXML(tus, searchPattern, replaceString);
                }
            } else if (tuvt != null && (tut = tuvt.getSegment()) != null) {
                XMLHelper.replaceInXML(tut, searchPattern, replaceString);
            }
        }
    }

    public void scrollToSegment(final JTextPane pane, final int dot) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ TMXView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    Rectangle2D r0 = pane.modelToView2D(dot);
                    Rectangle r = pane.getVisibleRect();
                    int w = (int)r.getWidth();
                    int h = (int)r.getHeight();
                    int x = (int)r.getX();
                    int y0 = (int)r0.getY();
                    r = new Rectangle(x, y0 - h / 3, w, h);
                    pane.scrollRectToVisible(r);
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(ProjectView.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
    }

    public void goToContent(String s, int i) {
        try {
            JTextPane pane = !this.memory.getEditMode() ? this.memory.getMemoryPane() : this.topui.getProjectView().getProjectPane();
            String type = pane.getContentType();
            if (!type.equals("text/html")) {
                pane.setContentType("text/html");
            }
            HTMLDocument htmldoc = (HTMLDocument)pane.getDocument();
            htmldoc.setInnerHTML(htmldoc.getDefaultRootElement(), s);
            String text = htmldoc.getText(0, htmldoc.getLength());
            String ii = Integer.toString(i + 1) + "\u200b";
            int index = text.indexOf(ii);
            if (index != -1) {
                if (!this.memory.getEditMode()) {
                    this.scrollToSegment(pane, index);
                } else {
                    this.prview.scrollToSegment(index);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void goToSplitContent(String[] arr, int i) {
        try {
            JTextPane pane = !this.memory.getEditMode() ? this.memory.getMemoryPane() : this.topui.getProjectView().getProjectPane();
            String type = pane.getContentType();
            if (!type.equals("text/html")) {
                pane.setContentType("text/html");
            }
            HTMLDocument htmldoc = (HTMLDocument)pane.getDocument();
            htmldoc.setInnerHTML(htmldoc.getDefaultRootElement(), arr[0]);
            JViewport vp = (JViewport)pane.getParent();
            final JScrollPane scroll = (JScrollPane)vp.getParent();
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ TMXView this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    JScrollBar bar = scroll.getVerticalScrollBar();
                    bar.setValue(bar.getMaximum());
                }
            });
            JTextPane pane2 = this.prview.getProjectPane2();
            if (pane2 != null) {
                type = pane2.getContentType();
                if (!type.equals("text/html")) {
                    pane2.setContentType("text/html");
                }
                htmldoc = (HTMLDocument)pane2.getDocument();
                htmldoc.setInnerHTML(htmldoc.getDefaultRootElement(), arr[1]);
                JViewport vp2 = (JViewport)pane2.getParent();
                final JScrollPane scroll2 = (JScrollPane)vp2.getParent();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ TMXView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        scroll2.getVerticalScrollBar().setValue(0);
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showContent(String s, boolean start) {
        try {
            JTextPane pane = !this.memory.getEditMode() ? this.memory.getMemoryPane() : this.topui.getProjectView().getProjectPane();
            String type = pane.getContentType();
            if (!type.equals("text/html")) {
                pane.setContentType("text/html");
            }
            HTMLDocument htmldoc = (HTMLDocument)pane.getDocument();
            htmldoc.setInnerHTML(htmldoc.getDefaultRootElement(), s);
            if (start) {
                JViewport vp = (JViewport)pane.getParent();
                final JScrollPane scroll = (JScrollPane)vp.getParent();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ TMXView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        scroll.getVerticalScrollBar().setValue(0);
                    }
                });
            } else {
                JViewport vp = (JViewport)pane.getParent();
                final JScrollPane scroll = (JScrollPane)vp.getParent();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ TMXView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        JScrollBar bar = scroll.getVerticalScrollBar();
                        bar.setValue(bar.getMaximum());
                    }
                });
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void showSplitContent(String[] arr, boolean start) {
        try {
            JScrollPane scroll;
            JViewport vp;
            JTextPane pane = !this.memory.getEditMode() ? this.memory.getMemoryPane() : this.topui.getProjectView().getProjectPane();
            String type = pane.getContentType();
            if (!type.equals("text/html")) {
                pane.setContentType("text/html");
            }
            HTMLDocument htmldoc = (HTMLDocument)pane.getDocument();
            htmldoc.setInnerHTML(htmldoc.getDefaultRootElement(), arr[0]);
            if (start) {
                vp = (JViewport)pane.getParent();
                scroll = (JScrollPane)vp.getParent();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ TMXView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        scroll.getVerticalScrollBar().setValue(0);
                    }
                });
            } else {
                vp = (JViewport)pane.getParent();
                scroll = (JScrollPane)vp.getParent();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ TMXView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        JScrollBar bar = scroll.getVerticalScrollBar();
                        bar.setValue(bar.getMaximum());
                    }
                });
            }
            JTextPane pane2 = this.prview.getProjectPane2();
            if (pane2 != null) {
                type = pane2.getContentType();
                if (!type.equals("text/html")) {
                    pane2.setContentType("text/html");
                }
                htmldoc = (HTMLDocument)pane2.getDocument();
                htmldoc.setInnerHTML(htmldoc.getDefaultRootElement(), arr[1]);
                JViewport vp2 = (JViewport)pane2.getParent();
                final JScrollPane scroll2 = (JScrollPane)vp2.getParent();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ TMXView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        scroll2.getVerticalScrollBar().setValue(0);
                    }
                });
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setViewMode(int mode) {
        if (qafilter) {
            if (AppPreferences.windowsLayout != 6 || !this.memory.getEditMode()) {
                String content = this.fetchQAGridContent(0);
                this.showContent(content, false);
            } else {
                String[] arr = this.fetchQAGridSplitContent(0);
                this.showSplitContent(arr, false);
            }
        } else if (mode == 1) {
            if (AppPreferences.windowsLayout != 6 || !this.memory.getEditMode()) {
                String content = this.fetchGridContent(0);
                this.showContent(content, false);
            } else {
                String[] arr = this.fetchGridSplitContent(0);
                this.showSplitContent(arr, false);
            }
        } else if (mode == 0) {
            if (AppPreferences.windowsLayout != 6 || !this.memory.getEditMode()) {
                String content = this.fetchContent(true, 0);
                this.showContent(content, false);
            } else {
                String[] arr = this.fetchContentSplit(true, 0);
                this.showSplitContent(arr, false);
            }
        } else if (mode == 2) {
            if (AppPreferences.windowsLayout != 6 || !this.memory.getEditMode()) {
                String content = this.fetchContent(false, 0);
                this.showContent(content, false);
            } else {
                String[] arr = this.fetchContentSplit(false, 0);
                this.showSplitContent(arr, false);
            }
        }
    }

    public void refreshView() {
        if (this.currentTUIndex != -1) {
            this.browseToUnit(this.currentTUIndex);
        } else {
            this.setViewMode(AppPreferences.projectView);
        }
    }

    public void nextTUS() {
        if (qafilter) {
            if (AppPreferences.windowsLayout != 6 || !this.memory.getEditMode()) {
                String content = this.fetchQAGridContent(1);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchQAGridSplitContent(1);
                this.showSplitContent(arr, true);
            }
        } else if (AppPreferences.projectView == 0) {
            if (AppPreferences.windowsLayout != 6 || !this.memory.getEditMode()) {
                String content = this.fetchContent(true, 1);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchContentSplit(true, 1);
                this.showSplitContent(arr, true);
            }
        } else if (AppPreferences.projectView == 1) {
            if (AppPreferences.windowsLayout != 6 || !this.memory.getEditMode()) {
                String content = this.fetchGridContent(1);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchGridSplitContent(1);
                this.showSplitContent(arr, true);
            }
        } else if (AppPreferences.projectView == 2) {
            if (AppPreferences.windowsLayout != 6 || !this.memory.getEditMode()) {
                String content = this.fetchContent(false, 1);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchContentSplit(false, 1);
                this.showSplitContent(arr, true);
            }
        }
    }

    public void previousTUS() {
        if (qafilter) {
            if (AppPreferences.windowsLayout != 6 || !this.memory.getEditMode()) {
                String content = this.fetchQAGridContent(-1);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchQAGridSplitContent(-1);
                this.showSplitContent(arr, true);
            }
        } else if (AppPreferences.projectView == 0) {
            if (AppPreferences.windowsLayout != 6) {
                String content = this.fetchContent(true, -1);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchContentSplit(true, -1);
                this.showSplitContent(arr, true);
            }
        } else if (AppPreferences.projectView == 1) {
            if (AppPreferences.windowsLayout != 6 || !this.memory.getEditMode()) {
                String content = this.fetchGridContent(-1);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchGridSplitContent(-1);
                this.showSplitContent(arr, true);
            }
        } else if (AppPreferences.projectView == 2) {
            if (AppPreferences.windowsLayout != 6 || !this.memory.getEditMode()) {
                String content = this.fetchContent(false, -1);
                this.showContent(content, true);
            } else {
                String[] arr = this.fetchContentSplit(false, -1);
                this.showSplitContent(arr, true);
            }
        }
    }

    public void updateContentView() {
        JTextPane pane = !this.memory.getEditMode() ? this.memory.getMemoryPane() : this.topui.getProjectView().getProjectPane();
        try {
            HTMLDocument doc = (HTMLDocument)pane.getDocument();
            int index = this.tmx.getTranslationUnits().size() - 1;
            int k = index + 1;
            String html = "<TR><TD BORDER=0 NOWRAP VALIGN=CENTER ALIGN=CENTER><A HREF=#" + index + "<b>" + k + "</b></A></TD></TR>";
            int ne = doc.getDefaultRootElement().getElement(0).getElement(1).getElementCount();
            Element elem = doc.getDefaultRootElement().getElement(0).getElement(1).getElement(ne - 1);
            if (elem != null) {
                doc.insertBeforeEnd(elem, html);
                JViewport vp = (JViewport)pane.getParent();
                final JScrollPane scroll = (JScrollPane)vp.getParent();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ TMXView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        JScrollBar bar = scroll.getVerticalScrollBar();
                        bar.setValue(bar.getMaximum());
                    }
                });
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(TMXView.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(TMXView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String getSegmentXMLText(TranslationUnit tu, String lang) {
        if (tu instanceof TMXUnit) {
            List list;
            XMLElement elem;
            TMXUnit tux = (TMXUnit)tu;
            StringBuilder sb = new StringBuilder();
            TMXUnitVariant tuv = tux.getTUV(lang);
            if (tuv != null && (elem = tuv.getSegment()) != null && (list = elem.getChildren()).size() > 0) {
                this.getXMLTextContent(list, sb);
            }
            return sb.toString();
        }
        String s = tu.getSegment(lang);
        s = XMLHelper.resolveXMLEntities(s);
        return s;
    }

    private void getXMLTextContent(List children, StringBuilder sb) {
        for (Object object : children) {
            if (object instanceof String) {
                String s = object.toString();
                s = XMLHelper.resolveXMLEntities(s);
                sb.append(s);
                continue;
            }
            XMLElement elem = (XMLElement)object;
            List list = elem.getChildren();
            if (list.size() <= 0) continue;
            this.getXMLTextContent(list, sb);
        }
    }

    private String findURLLink(String string) {
        Matcher m = this.urlPattern.matcher(string);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String group = m.group();
            StringBuilder sb2 = new StringBuilder();
            sb2.append("<a color=blue href=").append(group).append(">").append(group).append("</a>");
            m.appendReplacement(sb, sb2.toString());
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

