/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextPane;
import javax.swing.text.GapContent;
import javax.swing.text.StyleContext;
import translator.FormatChooser;
import translator.Translatable;
import translator.text.ParagraphStyledDocument;
import translator.translatables.TextDocument;

public class FramemakerMIFDocument
extends TextDocument
implements Translatable {
    @Override
    public void loadFile(File file, String format, String encoding) {
        String regExp = FormatChooser.getFormatRegEx(format);
        ArrayList<String> stories = new ArrayList<String>();
        this.edit = true;
        String outString = this.loadTextFile(file, encoding);
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
        }
        stories.add(outString);
        if (skeleton != null && skeleton.size() > 0) {
            this.skeletons.add(skeleton);
            this.edit = false;
        }
        GapContent gap = new GapContent(outString.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
    }

    @Override
    public void openFile(File file, String format, String encoding) {
        String regExp = FormatChooser.getFormatRegEx(format);
        ArrayList<String> stories = new ArrayList<String>();
        this.edit = true;
        String outString = this.loadTextFile(file, encoding);
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
        }
        stories.add(outString);
        if (skeleton != null && skeleton.size() > 0) {
            this.skeletons.add(skeleton);
            this.edit = false;
        }
        GapContent gap = new GapContent(outString.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        List docs = this.topui.getResourceLoader().getDocumentLoaderList();
        if (!docs.contains(path)) {
            docs.add(path);
        }
        this.openEditorTab(this.doc);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
        JTextPane pane = this.getTextPane();
        if (pane != null) {
            pane.setCaretPosition(0);
        }
    }

    @Override
    String getContent(String xhtml, LinkedHashMap skeleton, String format) {
        this.isMIF = true;
        xhtml = this.removeSoftHyphnes(xhtml);
        String aaformat = "<String `.+?'>";
        Pattern p = Pattern.compile(format, 34);
        Pattern gp = Pattern.compile(aaformat, 34);
        Matcher matcher = p.matcher(xhtml);
        StringBuffer content = new StringBuffer();
        String group = "";
        int from = 0;
        int to = 0;
        int index = 1;
        StringBuffer inline = new StringBuffer();
        while (matcher.find()) {
            from = matcher.start();
            inline.append(xhtml.substring(to, from));
            group = matcher.group();
            int tag = group.indexOf("<TblTag ");
            if (tag != -1 && (group.indexOf("<TblTag `Mapping Table'>", tag) != -1 || group.indexOf("<TblTag `UnstructMasterPageMaps'>", tag) != -1 || group.indexOf("<TblTag `StructMasterPageMaps'>", tag) != -1)) {
                inline.append(group);
                to = matcher.end();
                continue;
            }
            tag = group.indexOf("<TFTag ");
            if (tag != -1 && (group.indexOf("<TFTag `TOC'>", tag) != -1 || group.indexOf("<TFTag `IX'>", tag) != -1 || group.indexOf("<TFTag `LOT'>", tag) != -1 || group.indexOf("<TFTag `LOF'>", tag) != -1 || group.indexOf("<TFTag `AIX'>", tag) != -1 || group.indexOf("<TFTag `AML'>", tag) != -1 || group.indexOf("<TFTag `LOP'>", tag) != -1 || group.indexOf("<TFTag `SIX'>", tag) != -1 || group.indexOf("<TFTag `MasterPageMaps'>", tag) != -1)) {
                inline.append(group);
                to = matcher.end();
                continue;
            }
            Matcher gmatcher = gp.matcher(group);
            int from2 = 0;
            int to2 = 0;
            boolean isBreak = true;
            boolean xref = false;
            while (gmatcher.find()) {
                int fontstart;
                int xre;
                boolean isSpace = false;
                String cont = gmatcher.group();
                from2 = gmatcher.start();
                String inl = group.substring(to2, from2);
                int xr = inl.indexOf("<XRef ");
                if (xr != -1) {
                    xref = true;
                } else {
                    xr = 0;
                }
                if (xref && (xre = inl.indexOf("<XRefEnd ", xr)) != -1) {
                    xref = false;
                }
                if (xref) {
                    to2 = gmatcher.end();
                    inline.append(inl);
                    inline.append(cont);
                    continue;
                }
                int style = 0;
                if (inl.trim().endsWith("# end of Font") && (fontstart = inl.lastIndexOf("<Font ")) != -1) {
                    int ul;
                    if (inl.indexOf("<FWeight `Bold'>", fontstart) != -1) {
                        style = 2;
                    }
                    if (inl.indexOf("<FAngle `Italic'>", fontstart) != -1) {
                        style += 4;
                    }
                    if ((ul = inl.indexOf("<FUnderlining ", fontstart)) != -1) {
                        if (inl.indexOf("<FUnderlining FSingle>", ul) != -1) {
                            style += 8;
                        } else if (inl.indexOf("<FUnderlining FDouble>", ul) != -1) {
                            style += 8;
                        } else if (inl.indexOf("<FUnderlining FNumeric>", ul) != -1) {
                            style += 8;
                        }
                    }
                    if (inl.indexOf("<FPosition FSubscript>", fontstart) != -1) {
                        style = 16;
                    } else if (inl.indexOf("<FPosition FSuperscript>", fontstart) != -1) {
                        style = 18;
                    }
                    if (inl.indexOf("<FStrike Yes>", fontstart) != -1) {
                        style = 20;
                    }
                }
                if (inl.indexOf("<Para ") != -1 || inl.indexOf("<Char HardReturn>") != -1) {
                    isBreak = true;
                } else if (inl.indexOf("<Char Tab>") != -1 || inl.indexOf("<Char HardSpace>") != -1) {
                    isSpace = true;
                }
                inline.append(inl);
                inline.append("<String `");
                String contt = cont.substring(9, cont.length() - 2);
                contt = this.resolveEntitiesMIF(contt);
                if (contt.trim().length() > 0) {
                    String s;
                    StringBuilder typebuilder = new StringBuilder();
                    String equivtext = null;
                    if (isBreak) {
                        typebuilder.append("break");
                        equivtext = " ";
                    } else if (isSpace) {
                        equivtext = " ";
                    }
                    if (style > 0 && (s = this.createStyleAttribute(style)) != null) {
                        if (typebuilder.length() > 0) {
                            typebuilder.append(';');
                        }
                        typebuilder.append(s);
                    }
                    StringBuilder tagbuilder = new StringBuilder("<x id=\"");
                    tagbuilder.append(index);
                    tagbuilder.append("\"");
                    if (typebuilder.length() > 0) {
                        tagbuilder.append(" ctype=\"x-");
                        tagbuilder.append((CharSequence)typebuilder);
                        tagbuilder.append("\"");
                    }
                    if (equivtext != null) {
                        tagbuilder.append(" equiv-text=\"");
                        tagbuilder.append(equivtext);
                        tagbuilder.append("\"");
                    }
                    tagbuilder.append("/>");
                    String tags = tagbuilder.toString();
                    ++index;
                    skeleton.put(tags, inline.toString());
                    this.styles.put(tags, style);
                    content.append(tags);
                    content.append(contt);
                    inline.setLength(0);
                } else {
                    inline.append(contt);
                }
                inline.append(cont.substring(cont.length() - 2));
                to2 = gmatcher.end();
                isBreak = false;
            }
            if (to2 < group.length()) {
                inline.append(group.substring(to2));
            }
            to = matcher.end();
        }
        if (to < xhtml.length()) {
            inline.append(xhtml.substring(to));
            String tags = "<x id=\"" + index + "\" ctype=\"x-break\"/>";
            skeleton.put(tags, inline.toString());
            inline.setLength(0);
            content.append(tags);
        }
        return content.toString();
    }

    private String resolveEntitiesMIF(String e) {
        StringBuffer sb = new StringBuffer();
        int ind = 0;
        int i = -1;
        String tail = null;
        String head = null;
        String code = null;
        while ((i = e.indexOf("\\", ind)) != -1) {
            int k;
            tail = e.substring(ind, i);
            head = e.substring(i);
            ind = i + 1;
            if (head.startsWith("\\t")) {
                k = 1;
                sb.append(tail);
                sb.append("\t");
                ind += k;
                continue;
            }
            if (head.startsWith("\\>")) {
                k = 1;
                sb.append(tail);
                sb.append(">");
                ind += k;
                continue;
            }
            if (head.startsWith("\\q")) {
                k = 1;
                sb.append(tail);
                sb.append("'");
                ind += k;
                continue;
            }
            if (head.startsWith("\\Q")) {
                k = 1;
                sb.append(tail);
                sb.append("`");
                ind += k;
                continue;
            }
            if (head.startsWith("\\\\")) {
                k = 1;
                sb.append(tail);
                sb.append("\\");
                ind += k;
                continue;
            }
            if (!head.startsWith("\\x")) continue;
            k = head.indexOf(32);
            sb.append(tail);
            code = head.substring(2, k);
            char c = (char)Integer.parseInt(code, 16);
            sb.append(c);
            ind += k;
        }
        if (ind != -1 && sb.length() > 0) {
            sb.append(e.substring(ind));
            return sb.toString();
        }
        return e;
    }

    private String removeSoftHyphnes(String s) {
        Pattern p = Pattern.compile("'>\\s+<Char SoftHyphen>\\s+> # end of ParaLine\\s+<ParaLine\\s+<String `");
        Matcher m = p.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

