/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleContext;
import translator.AppPreferences;
import translator.FileFilters;
import translator.FormatChooser;
import translator.Project;
import translator.Translatable;
import translator.text.ParagraphStyledDocument;
import translator.translatables.TextDocument;

public class GZipDocument
extends TextDocument
implements Translatable {
    @Override
    public void loadFile(File file, String format, String encoding) {
        String regExp = FormatChooser.getFormatRegEx(format);
        ArrayList<String> stories = new ArrayList<String>();
        this.edit = true;
        String outString = this.loadGZipFile(file, encoding);
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
        }
        stories.add(outString);
        if (skeleton != null && skeleton.size() > 0) {
            this.skeletons.add(skeleton);
            this.edit = false;
        }
        GapContent gap = new GapContent(outString.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
    }

    @Override
    public void openFile(File file, String format, String encoding) {
        String regExp = FormatChooser.getFormatRegEx(format);
        ArrayList<String> stories = new ArrayList<String>();
        this.edit = true;
        String outString = this.loadGZipFile(file, encoding);
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
        }
        stories.add(outString);
        if (skeleton != null && skeleton.size() > 0) {
            this.skeletons.add(skeleton);
            this.edit = false;
        }
        GapContent gap = new GapContent(outString.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        List docs = this.topui.getResourceLoader().getDocumentLoaderList();
        if (!docs.contains(path)) {
            docs.add(path);
        }
        this.openEditorTab(this.doc);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
        JTextPane pane = this.getTextPane();
        if (pane != null) {
            pane.setCaretPosition(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadGZipFile(File file, String encoding) {
        GZIPInputStream in = null;
        try {
            String outString;
            int len;
            in = new GZIPInputStream(new FileInputStream(file));
            byte[] buf = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((len = in.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            buf = baos.toByteArray();
            in.close();
            baos.close();
            String string = outString = new String(buf, 0, buf.length, encoding);
            return string;
        }
        catch (IOException ex) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    private boolean saveFile() {
        Document doc = null;
        doc = this.getDocument();
        Boolean state = (Boolean)doc.getProperty("state");
        if (!state.booleanValue()) {
            return false;
        }
        String path = (String)doc.getProperty("path");
        if (path == null) {
            return this.saveAsFile();
        }
        if (path.length() == 0) {
            return false;
        }
        Boolean save = (Boolean)doc.getProperty("save");
        if (save == null || !save.booleanValue()) {
            return false;
        }
        File file = new File(path);
        return this.saveGZipFile(file, doc);
    }

    private boolean saveGZipFile(File file, Document doc) {
        try {
            String[] texts = null;
            String text = "";
            if (this.skeletons.size() > 0) {
                texts = this.insertContent(doc);
                if (texts == null) {
                    JOptionPane.showMessageDialog(this.topui, "The original source language document has been modified. Export may fail or be incomplete.");
                    return false;
                }
                for (int i = 0; i < texts.length; ++i) {
                    String string = texts[i];
                    text = text + string;
                }
            } else {
                text = doc.getText(0, doc.getLength());
            }
            File tempFile = File.createTempFile("Exp", file.getName(), file.getParentFile());
            this.storeGZipFile(tempFile, text, AppPreferences.en);
            if (file.exists()) {
                file.delete();
            }
            if (tempFile.renameTo(file)) {
                Boolean state = false;
                doc.putProperty("state", state);
            } else {
                JOptionPane.showMessageDialog(this.topui, "CafeTran cannot rename the file to " + file.getName());
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.topui, e.getMessage());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.topui, "The original source language document has been modified. Export may fail or be incomplete.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeGZipFile(File tempFile, String text, String enc) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(tempFile);
            GZIPOutputStream out = new GZIPOutputStream(fos);
            byte[] arr = text.getBytes(enc);
            out.write(arr, 0, arr.length);
            out.close();
            fos.close();
        }
        catch (IOException ex) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private boolean saveAsFile() {
        Document doc = this.getDocument();
        Boolean save = (Boolean)doc.getProperty("save");
        if (save == null || !save.booleanValue()) {
            return false;
        }
        JFileChooser jFileChooser = new JFileChooser();
        FileFilters filters = new FileFilters();
        String filterName = AppPreferences.format;
        filters.setFileFilters(FormatChooser.formatType, filterName, jFileChooser);
        jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE DOCUMENT"));
        jFileChooser.setCurrentDirectory(new File(AppPreferences.fileDirectory));
        String fs = (String)doc.getProperty("path");
        String tlang = (String)doc.getProperty("target-lang");
        if (fs == null) {
            fs = "";
        }
        if (tlang != null) {
            int ind = fs.lastIndexOf(".");
            if (ind != -1) {
                String ext = fs.substring(ind);
                fs = fs.substring(0, ind) + "_" + tlang + ext;
            } else {
                fs = fs + tlang;
            }
        }
        jFileChooser.setSelectedFile(new File(fs));
        jFileChooser.repaint();
        if (0 == jFileChooser.showSaveDialog(this.topui)) {
            int i;
            File newFile = jFileChooser.getSelectedFile();
            AppPreferences.fileDirectory = newFile.getParent();
            String oldpath = (String)doc.getProperty("path");
            String path = newFile.getPath();
            doc.putProperty("path", path);
            doc.putProperty("file", newFile);
            List docs = this.topui.getResourceLoader().getDocumentLoaderList();
            if (oldpath != null) {
                docs.remove(oldpath);
            }
            docs.add(path);
            String oname = (String)doc.getProperty("name");
            String name = newFile.getName();
            JTabbedPane tabpane = this.tview.getTabbedPane();
            if (oname != null && (i = tabpane.indexOfTab(oname)) != -1) {
                tabpane.setTitleAt(i, name);
            }
            doc.putProperty("name", name);
            return this.saveGZipFile(newFile, doc);
        }
        return false;
    }

    @Override
    public void preview(Project pr, String spath) {
        Document sdoc = this.getDocument();
        String path = (String)sdoc.getProperty("path");
        String prev = pr.preview(sdoc);
        if (prev != null && path != null) {
            String prevFilePath;
            PlainDocument tdoc = new PlainDocument();
            try {
                tdoc.insertString(0, prev, null);
                if (sdoc.getProperty("skeleton") != null) {
                    LinkedHashMap skeleton = (LinkedHashMap)sdoc.getProperty("skeleton");
                    tdoc.putProperty("skeleton", skeleton);
                }
                if (sdoc.getProperty("zname") != null) {
                    String name = (String)sdoc.getProperty("zname");
                    tdoc.putProperty("zname", name);
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
            File file = new File(path);
            String name = file.getName();
            String extention = null;
            int i = name.lastIndexOf(".");
            extention = i != -1 ? name.substring(i, name.length()).toLowerCase() : "";
            String parent = file.getParent();
            if (spath == null) {
                prevFilePath = parent + AppPreferences.fs + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIEW") + extention;
            } else {
                prevFilePath = spath.toLowerCase().endsWith(extention) ? spath : spath + extention;
                if (prevFilePath.equalsIgnoreCase(path)) {
                    JOptionPane.showMessageDialog(this.topui, "Never overwrite the original source language document!");
                    return;
                }
            }
            File previewFile = new File(prevFilePath);
            boolean save = this.saveGZipFile(previewFile, tdoc);
            if (!save) {
                this.preview2(pr, spath);
            } else if (spath == null) {
                this.topui.getResourceView().viewFile(previewFile);
            }
        }
    }

    @Override
    public void preview2(Project pr, String spath) {
        Document sdoc = this.getDocument();
        String path = (String)sdoc.getProperty("path");
        String prev = pr.preview2(sdoc);
        if (prev != null && path != null) {
            String prevFilePath;
            PlainDocument tdoc = new PlainDocument();
            try {
                tdoc.insertString(0, prev, null);
                if (sdoc.getProperty("skeleton") != null) {
                    LinkedHashMap skeleton = (LinkedHashMap)sdoc.getProperty("skeleton");
                    tdoc.putProperty("skeleton", skeleton);
                }
                if (sdoc.getProperty("zname") != null) {
                    String name = (String)sdoc.getProperty("zname");
                    tdoc.putProperty("zname", name);
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
            File file = new File(path);
            String name = file.getName();
            String extention = null;
            int i = name.lastIndexOf(".");
            extention = i != -1 ? name.substring(i, name.length()).toLowerCase() : "";
            String parent = file.getParent();
            if (spath == null) {
                prevFilePath = parent + AppPreferences.fs + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIEW") + extention;
            } else {
                prevFilePath = spath.toLowerCase().endsWith(extention) ? spath : spath + extention;
                if (prevFilePath.equalsIgnoreCase(path)) {
                    JOptionPane.showMessageDialog(this.topui, "Never overwrite the original source language document!");
                    return;
                }
            }
            File previewFile = new File(prevFilePath);
            boolean save = this.saveGZipFile(previewFile, tdoc);
            if (save && spath == null) {
                this.topui.getResourceView().viewFile(previewFile);
            }
        }
    }

    @Override
    public boolean setTargetContent(Project p) {
        this.cancelSegmentStyle();
        ParagraphStyledDocument sdoc = (ParagraphStyledDocument)this.getDocument();
        String s = this.translate(sdoc, p);
        if (s != null && s.length() > 0) {
            try {
                sdoc.remove(0, sdoc.getLength());
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.insertStringTags(sdoc, s);
            sdoc.setContents();
            JTextPane pane = this.getTextPane();
            if (pane != null) {
                pane.setCaretPosition(0);
            }
            this.saveResource();
            return true;
        }
        return false;
    }

    private boolean okToAbandon() {
        Document doc = this.getDocument();
        Boolean state = (Boolean)doc.getProperty("state");
        if (!state.booleanValue()) {
            return true;
        }
        int value = JOptionPane.showConfirmDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE CHANGES IN THE DOCUMENT?"), "CafeTran", 1);
        switch (value) {
            case 0: {
                return this.saveFile();
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void saveAsResource() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GZipDocument.this.saveAsFile();
            }
        });
    }

    @Override
    public void saveResource() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GZipDocument.this.saveFile();
            }
        });
    }

    @Override
    public void closeResource() {
        if (!this.okToAbandon()) {
            return;
        }
        Object o = this.getDocument().getProperty("path");
        if (o != null) {
            String path = o.toString();
            List docs = this.topui.getResourceLoader().getDocumentLoaderList();
            docs.remove(path);
        }
        this.tview = this.topui.getTabView();
        this.tview.removeTab(this.name);
    }
}

