/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.JTextPane;
import javax.swing.text.GapContent;
import javax.swing.text.StyleContext;
import translator.AppPreferences;
import translator.FormatChooser;
import translator.NaturalOrderComparator;
import translator.Translatable;
import translator.XMLHelper;
import translator.text.ParagraphStyledDocument;
import translator.translatables.ZipDocument;

public class IndesignIDMLDocument
extends ZipDocument
implements Translatable {
    int tagIndex = 0;
    Map styles = new HashMap();

    /*
     * WARNING - void declaration
     */
    @Override
    public void loadFile(File file, String format, String encoding, String zName) {
        void var13_19;
        int j;
        int i;
        String outString;
        String s;
        ZipFile zipFile;
        String regExp = FormatChooser.getFormatRegEx(format);
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ArrayList<? extends ZipEntry> list = Collections.list(entries);
        HashSet hiddenLayers = new HashSet();
        HashSet hiddenStories = new HashSet();
        String storyList = null;
        for (ZipEntry zipEntry : list) {
            s = zipEntry.getName();
            if (!s.equals("designmap.xml")) continue;
            String string = s;
            outString = this.loadZipFile(zipFile, string, encoding);
            hiddenLayers = this.getHiddenLayers(outString);
            i = outString.indexOf("StoryList=\"");
            if (i == -1 || (j = outString.indexOf("\"", i += 11)) == -1) break;
            storyList = outString.substring(i, j) + " ";
            break;
        }
        if (list.size() > 1 && storyList != null) {
            final String storiesString = storyList;
            Collections.sort(list, new NaturalOrderComparator(this){
                final /* synthetic */ IndesignIDMLDocument this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public int compare(Object o1, Object o2) {
                    ZipEntry entry1 = (ZipEntry)o1;
                    ZipEntry entry2 = (ZipEntry)o2;
                    String s1 = entry1.getName();
                    String s2 = entry2.getName();
                    if (s1.startsWith("Stories/Story_") && s2.startsWith("Stories/Story_")) {
                        int j2;
                        int i1 = s1.lastIndexOf(46);
                        int i2 = s2.lastIndexOf(46);
                        String u1 = s1.substring(14, i1) + " ";
                        String u2 = s2.substring(14, i2) + " ";
                        int j1 = storiesString.indexOf(u1);
                        int k = j1 > (j2 = storiesString.indexOf(u2)) ? 1 : (j2 > j1 ? -1 : 0);
                        return k;
                    }
                    return s1.compareTo(s2);
                }
            });
        }
        if (!hiddenLayers.isEmpty()) {
            for (ZipEntry zipEntry : list) {
                s = zipEntry.getName();
                if (!s.startsWith("Spreads/Spread")) continue;
                String string = s;
                outString = this.loadZipFile(zipFile, string, encoding);
                hiddenStories = this.getHiddenStories(outString, hiddenLayers, hiddenStories);
            }
        }
        ArrayList<String> stories = new ArrayList<String>();
        boolean bl = false;
        for (ZipEntry zipEntry : list) {
            String s2 = zipEntry.getName();
            if (s2.startsWith("Stories/")) {
                String id;
                if (!hiddenStories.isEmpty() && (i = s2.indexOf(95)) != -1 && hiddenStories.contains(id = s2.substring(i + 1, j = s2.indexOf(".xml")))) continue;
                String zipname2 = s2;
                String outString2 = this.loadZipFile(zipFile, zipname2, encoding);
                LinkedHashMap skeleton = null;
                if (regExp.length() <= 0 || (outString2 = this.getContent(outString2, skeleton = new LinkedHashMap(), regExp)).trim().length() <= 0) continue;
                var13_19 += outString2.length();
                this.skeletons.add(skeleton);
                stories.add(outString2);
                this.zipNames.add(zipname2);
                continue;
            }
            if (!s2.equals("Resources/Styles.xml")) continue;
            String zipname3 = s2;
            String outString3 = this.loadZipFile(zipFile, zipname3, encoding);
            this.setStyles(outString3);
        }
        try {
            zipFile.close();
        }
        catch (IOException ex) {
            Logger.getLogger(IndesignIDMLDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        GapContent gap = new GapContent((int)var13_19);
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String string = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", string);
        this.doc.putProperty("name", name);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void openFile(File file, String format, String encoding, String zName) {
        void var12_18;
        String outString;
        String s;
        ZipFile zipFile;
        String regExp = FormatChooser.getFormatRegEx(format);
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ArrayList<? extends ZipEntry> list = Collections.list(entries);
        if (list.size() > 1) {
            Collections.sort(list, new NaturalOrderComparator(){

                @Override
                public int compare(Object o1, Object o2) {
                    ZipEntry entry1 = (ZipEntry)o1;
                    ZipEntry entry2 = (ZipEntry)o2;
                    String s1 = entry1.getName();
                    String s2 = entry2.getName();
                    return s1.compareTo(s2);
                }
            });
        }
        HashSet hiddenLayers = new HashSet();
        HashSet hiddenStories = new HashSet();
        for (ZipEntry zipEntry : list) {
            s = zipEntry.getName();
            if (!s.equals("designmap.xml")) continue;
            String string = s;
            outString = this.loadZipFile(zipFile, string, encoding);
            hiddenLayers = this.getHiddenLayers(outString);
            break;
        }
        if (!hiddenLayers.isEmpty()) {
            for (ZipEntry zipEntry : list) {
                s = zipEntry.getName();
                if (!s.startsWith("Spreads/Spread")) continue;
                String string = s;
                outString = this.loadZipFile(zipFile, string, encoding);
                hiddenStories = this.getHiddenStories(outString, hiddenLayers, hiddenStories);
            }
        }
        ArrayList<String> stories = new ArrayList<String>();
        boolean bl = false;
        for (ZipEntry zipEntry : list) {
            String s2 = zipEntry.getName();
            if (s2.startsWith("Stories/")) {
                int j;
                String id;
                int i;
                if (!hiddenStories.isEmpty() && (i = s2.indexOf(95)) != -1 && hiddenStories.contains(id = s2.substring(i + 1, j = s2.indexOf(".xml")))) continue;
                String zipname2 = s2;
                String outString2 = this.loadZipFile(zipFile, zipname2, encoding);
                LinkedHashMap skeleton = null;
                if (regExp.length() <= 0 || (outString2 = this.getContent(outString2, skeleton = new LinkedHashMap(), regExp)).trim().length() <= 0) continue;
                var12_18 += outString2.length();
                this.skeletons.add(skeleton);
                stories.add(outString2);
                this.zipNames.add(zipname2);
                continue;
            }
            if (!s2.equals("Resources/Styles.xml")) continue;
            String zipname3 = s2;
            String outString3 = this.loadZipFile(zipFile, zipname3, encoding);
            this.setStyles(outString3);
        }
        try {
            zipFile.close();
        }
        catch (IOException ex) {
            Logger.getLogger(IndesignIDMLDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        GapContent gap = new GapContent((int)var12_18);
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String string = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", string);
        this.doc.putProperty("name", name);
        String loadedPath = string;
        List docs = this.topui.getResourceLoader().getDocumentLoaderList();
        if (!docs.contains(loadedPath)) {
            docs.add(loadedPath);
        }
        this.openEditorTab(this.doc);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
        JTextPane pane = this.getTextPane();
        if (pane != null) {
            pane.setCaretPosition(0);
        }
    }

    @Override
    String getContent(String xhtml, LinkedHashMap skeleton, String format) {
        this.isXML = true;
        String aaformat = "(\u2029)+|(<[^>]*>)";
        Pattern p = Pattern.compile(format, 34);
        Pattern gp = Pattern.compile(aaformat, 34);
        Matcher matcher = p.matcher(xhtml);
        StringBuilder content = new StringBuilder();
        if (!matcher.find()) {
            return "";
        }
        matcher.reset();
        int from = 0;
        int to = 0;
        int index = this.tagIndex;
        boolean hasContent = false;
        boolean isPage = false;
        boolean footnote = false;
        if (this.tagIndex > 0) {
            isPage = true;
        }
        String group = "";
        ++index;
        StringBuilder inline = new StringBuilder();
        while (matcher.find()) {
            int csre;
            from = matcher.start();
            String in = xhtml.substring(to, from);
            inline.append(in);
            group = matcher.group();
            Matcher gmatcher = gp.matcher(group);
            int from2 = 0;
            int to2 = 0;
            boolean isBreak = false;
            if (in.indexOf("<Br/>") != -1 || in.indexOf("<Br />") != -1 || in.indexOf("</Cell>") != -1) {
                isBreak = true;
            }
            if (in.indexOf("Footnote>") != -1) {
                footnote = true;
            }
            int style = 0;
            int csrs = in.lastIndexOf("<CharacterStyleRange");
            if (csrs != -1 && (csre = in.indexOf("</CharacterStyleRange>", csrs)) == -1) {
                int et;
                int st;
                int pos;
                int u;
                int fs = in.indexOf("FontStyle=", csrs);
                if (fs != -1) {
                    int i = in.indexOf("Bold", fs);
                    if (i != -1) {
                        style = 2;
                    }
                    if ((i = in.indexOf("Italic", fs)) != -1) {
                        style += 4;
                    }
                }
                if ((u = in.indexOf("Underline=\"true\"", csrs)) != -1) {
                    style += 8;
                }
                if ((pos = in.indexOf("Position=", csrs)) != -1) {
                    int i = in.indexOf("Subscript", pos);
                    if (i != -1) {
                        style = 16;
                    }
                    if ((i = in.indexOf("Superscript", pos)) != -1) {
                        style = 18;
                    }
                }
                if ((st = in.indexOf("StrikeThru=\"true\"", csrs)) != -1) {
                    style = 20;
                }
                if (style == 0 && (et = in.indexOf(62, csrs)) > csrs) {
                    String k = in.substring(csrs, et + 1);
                    style = this.getStyle(k);
                }
            }
            while (gmatcher.find()) {
                String subgroup = gmatcher.group();
                from2 = gmatcher.start();
                if (from2 > 0) {
                    String cont = group.substring(to2, from2);
                    if ((cont = XMLHelper.resolveEntitiesXML(cont)).trim().length() > 0) {
                        String s;
                        if (footnote) {
                            isBreak = true;
                            footnote = false;
                        }
                        if (!hasContent) {
                            hasContent = true;
                        }
                        StringBuilder typebuilder = new StringBuilder();
                        String equivtext = null;
                        if (isPage) {
                            typebuilder.append("page");
                            isPage = false;
                        } else if (isBreak) {
                            typebuilder.append("break");
                            equivtext = " ";
                        }
                        if (style > 0 && (s = this.createStyleAttribute(style)) != null) {
                            if (typebuilder.length() > 0) {
                                typebuilder.append(';');
                            }
                            typebuilder.append(s);
                        }
                        StringBuilder tagbuilder = new StringBuilder("<x id=\"");
                        tagbuilder.append(index);
                        tagbuilder.append("\"");
                        if (typebuilder.length() > 0) {
                            tagbuilder.append(" ctype=\"x-");
                            tagbuilder.append((CharSequence)typebuilder);
                            tagbuilder.append("\"");
                        }
                        if (equivtext != null) {
                            tagbuilder.append(" equiv-text=\"");
                            tagbuilder.append(equivtext);
                            tagbuilder.append("\"");
                        }
                        tagbuilder.append("/>");
                        String tags = tagbuilder.toString();
                        ++index;
                        skeleton.put(tags, inline.toString());
                        this.styles.put(tags, style);
                        content.append(tags);
                        content.append(cont);
                        inline.setLength(0);
                    } else {
                        inline.append(cont);
                    }
                    inline.append(subgroup);
                } else {
                    inline.append(subgroup);
                }
                if (subgroup.charAt(0) == '\u2029') {
                    isBreak = true;
                } else if (from2 > 0) {
                    isBreak = false;
                }
                to2 = gmatcher.end();
            }
            to = matcher.end();
        }
        if (!hasContent) {
            return "";
        }
        if (to < xhtml.length()) {
            inline.append(xhtml.substring(to));
            String tags = "<x id=\"" + index + "\" ctype=\"x-break\"/>";
            skeleton.put(tags, inline.toString());
            inline.setLength(0);
            content.append(tags);
        }
        this.tagIndex = index;
        return content.toString();
    }

    private void setStyles(String s) {
        String p = "<CharacterStyle Self=\".+?>";
        Pattern pat = Pattern.compile(p);
        Matcher m = pat.matcher(s);
        while (m.find()) {
            int j;
            String g = m.group();
            int i = g.indexOf(34);
            if (i <= 0 || (j = g.indexOf(34, ++i)) <= i) continue;
            this.styles.put(g.substring(i, j), g);
        }
    }

    private HashSet getHiddenStories(String s, HashSet hl, HashSet hs) {
        String regEx = "<TextFrame.+?>";
        Pattern pat = Pattern.compile(regEx);
        Matcher m = pat.matcher(s);
        while (m.find()) {
            int k;
            String id;
            String g = m.group();
            int j = g.indexOf("ItemLayer=");
            if (j == -1 || !hl.contains(id = g.substring(j += 11, k = g.indexOf("\"", j))) || (j = g.indexOf("ParentStory=")) == -1) continue;
            k = g.indexOf("\"", j += 13);
            id = g.substring(j, k);
            hs.add(id);
        }
        return hs;
    }

    private HashSet getHiddenLayers(String s) {
        HashSet<String> hl = new HashSet<String>();
        String regEx = "<Layer.+?>";
        Pattern pat = Pattern.compile(regEx);
        Matcher m = pat.matcher(s);
        while (m.find()) {
            int j;
            String g = m.group();
            int i = g.indexOf("Visible=\"false\"");
            if (i <= 0 || (j = g.indexOf("Self=")) == -1) continue;
            int k = g.indexOf("\"", j += 6);
            String id = g.substring(j, k);
            hl.add(id);
        }
        return hl;
    }

    private int getStyle(String s) {
        String key;
        String in;
        int k;
        String a = "AppliedCharacterStyle=\"";
        int style = 0;
        int j = s.indexOf(a);
        if (j != -1 && (k = s.indexOf(34, j += a.length())) > j && (in = (String)this.styles.get(key = s.substring(j, k))) != null) {
            int st;
            int pos;
            int u;
            int csrs = 0;
            int fs = in.indexOf("FontStyle=", csrs);
            if (fs != -1) {
                int i = in.indexOf("Bold", fs);
                if (i != -1) {
                    style = 2;
                }
                if ((i = in.indexOf("Italic", fs)) != -1) {
                    style += 4;
                }
            }
            if ((u = in.indexOf("Underline=\"true\"", csrs)) != -1) {
                style += 8;
            }
            if ((pos = in.indexOf("Position=", csrs)) != -1) {
                int i = in.indexOf("Subscript", pos);
                if (i != -1) {
                    style = 16;
                }
                if ((i = in.indexOf("Superscript", pos)) != -1) {
                    style = 18;
                }
            }
            if ((st = in.indexOf("StrikeThru=\"true\"", csrs)) != -1) {
                style = 20;
            }
        }
        return style;
    }
}

