/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextPane;
import javax.swing.text.GapContent;
import javax.swing.text.StyleContext;
import translator.AppPreferences;
import translator.FormatChooser;
import translator.Translatable;
import translator.XMLHelper;
import translator.text.ParagraphStyledDocument;
import translator.translatables.TextDocument;

public class MSOfficeXMLDocument
extends TextDocument
implements Translatable {
    private String tags;

    public MSOfficeXMLDocument() {
        this.isWord = true;
    }

    @Override
    public void loadFile(File file, String format, String encoding) {
        String regExp = FormatChooser.getFormatRegEx(format);
        ArrayList<String> stories = new ArrayList<String>();
        this.edit = true;
        String outString = this.loadTextFile(file, encoding);
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
        }
        stories.add(outString);
        if (skeleton != null && skeleton.size() > 0) {
            this.skeletons.add(skeleton);
            this.edit = false;
        }
        GapContent gap = new GapContent(outString.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
    }

    @Override
    public void openFile(File file, String format, String encoding) {
        String regExp = FormatChooser.getFormatRegEx(format);
        ArrayList<String> stories = new ArrayList<String>();
        this.edit = true;
        String outString = this.loadTextFile(file, encoding);
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
        }
        stories.add(outString);
        if (skeleton != null && skeleton.size() > 0) {
            this.skeletons.add(skeleton);
            this.edit = false;
        }
        GapContent gap = new GapContent(outString.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        List docs = this.topui.getResourceLoader().getDocumentLoaderList();
        if (!docs.contains(path)) {
            docs.add(path);
        }
        this.openEditorTab(this.doc);
        boolean i = false;
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
        JTextPane pane = this.getTextPane();
        if (pane != null) {
            pane.setCaretPosition(0);
        }
    }

    @Override
    String getContent(String xhtml, LinkedHashMap skeleton, String aformat) {
        this.isXML = true;
        if (aformat.startsWith("#")) {
            aformat = aformat.substring(1);
            this.isUncleaned = true;
        } else {
            this.isUncleaned = false;
        }
        Pattern p = Pattern.compile(aformat, 34);
        Matcher matcher = p.matcher(xhtml);
        StringBuffer content = new StringBuffer();
        String group = "";
        String lastGroup = "";
        int from = 0;
        int to = 0;
        int index = 1;
        StringBuffer inline = new StringBuffer();
        StringBuffer fgr = new StringBuffer();
        StringBuffer coll = new StringBuffer();
        int format = -1;
        int wstyle = 0;
        int textStyle = 0;
        int wpPropStyle = 0;
        boolean wrstyle = false;
        boolean wrProp = false;
        int wrPropStyle = 0;
        boolean wpProp = false;
        String standaloneSpace = null;
        boolean change = false;
        boolean docSpace = false;
        boolean pexternal = false;
        boolean rexternal = false;
        String colorGroup = null;
        boolean colorChange = false;
        String fontGroup = null;
        boolean fontChange = false;
        String sizeGroup = null;
        boolean sizeChange = false;
        boolean XE = false;
        while (matcher.find()) {
            char ch;
            from = matcher.start();
            group = matcher.group();
            if (group.startsWith("<w:instrText")) {
                if (group.indexOf("XE \"<") != -1) {
                    XE = true;
                } else if (XE) {
                    int j;
                    XE = false;
                    int i = group.indexOf(62) + 1;
                    String m = group.substring(i, j = group.indexOf(60, i));
                    if (m.trim().length() > 0) {
                        String s;
                        int style;
                        String sgroup = group.substring(0, i);
                        String ssgroup = group.substring(j);
                        inline.append(sgroup);
                        StringBuilder typebuilder = new StringBuilder();
                        String equivtext = null;
                        if (AppPreferences.segmentTags || this.isBreak(inline)) {
                            typebuilder.append("break");
                            equivtext = " ";
                        }
                        if ((style = wpPropStyle > 0 ? wpPropStyle : wstyle) > 0 && (s = this.createStyleAttribute(style)) != null) {
                            if (typebuilder.length() > 0) {
                                typebuilder.append(';');
                            }
                            typebuilder.append(s);
                        }
                        StringBuilder tagbuilder = new StringBuilder("<x id=\"");
                        tagbuilder.append(index);
                        tagbuilder.append("\"");
                        if (typebuilder.length() > 0) {
                            tagbuilder.append(" ctype=\"x-");
                            tagbuilder.append((CharSequence)typebuilder);
                            tagbuilder.append("\"");
                        }
                        if (equivtext != null) {
                            tagbuilder.append(" equiv-text=\"");
                            tagbuilder.append(equivtext);
                            tagbuilder.append("\"");
                        }
                        tagbuilder.append("/>");
                        this.tags = tagbuilder.toString();
                        ++index;
                        skeleton.put(this.tags, inline.toString());
                        this.styles.put(this.tags, wstyle);
                        inline.setLength(0);
                        fgr.setLength(0);
                        m = XMLHelper.resolveEntitiesXML(m);
                        if (coll.length() > 0) {
                            content.append(coll.toString());
                            coll.setLength(0);
                        }
                        content.append(this.tags);
                        if (standaloneSpace != null) {
                            content.append(standaloneSpace);
                        }
                        content.append(m);
                        inline.append(ssgroup);
                        fgr.append(ssgroup);
                        change = false;
                        format = -1;
                        docSpace = false;
                        standaloneSpace = null;
                        to = matcher.end();
                        continue;
                    }
                }
            }
            if (group.endsWith("Style w:val=\"tw4winExternal\"/>") || !this.isUncleaned && group.startsWith("<w:vanish")) {
                if (group.startsWith("<w:rStyle") || wrProp) {
                    rexternal = true;
                    change = true;
                } else {
                    pexternal = true;
                }
            }
            if (group.equals("</w:p>")) {
                pexternal = false;
                rexternal = false;
                sizeGroup = null;
                colorGroup = null;
                fontGroup = null;
                wpPropStyle = 0;
            }
            if (group.startsWith("<w:t") && ((ch = group.charAt(4)) == '>' || ch == ' ')) {
                if (colorGroup != null && !colorChange) {
                    colorGroup = null;
                    change = true;
                }
                if (fontGroup != null && !fontChange) {
                    fontGroup = null;
                    change = true;
                }
                if (sizeGroup != null && !sizeChange) {
                    sizeGroup = null;
                    change = true;
                }
            }
            if (group.equals("<w:rPr>")) {
                rexternal = false;
                wrProp = true;
            } else if (group.equals("</w:rPr>")) {
                wrProp = false;
                wrPropStyle = 0;
            } else if (group.equals("</w:r>")) {
                rexternal = false;
                colorChange = false;
                fontChange = false;
                sizeChange = false;
            } else if (group.equals("<w:pPr>")) {
                wpProp = true;
            } else if (group.equals("</w:pPr>")) {
                wpProp = false;
                wstyle = 0;
                wrstyle = false;
            } else if (group.equals("<w:t xml:space=\"preserve\">")) {
                docSpace = true;
            } else if (group.indexOf("<w:tab") != -1 || group.equals("</w:p>") || group.equals("<w:br/>") || group.indexOf("<w:footnoteReference") != -1 || group.indexOf("<w:endnoteReference") != -1 || group.indexOf("<w:fldChar") != -1 || group.indexOf("<w:noBreakHyphen/>") != -1) {
                format = 0;
                wstyle = 0;
            } else if (group.equals("<w:b/>")) {
                if (wrPropStyle > 0 || lastGroup.equals("<w:i/>") || lastGroup.startsWith("<w:u ")) {
                    change = (wstyle += 2) != textStyle;
                } else if (wstyle != 2 && wstyle != 14) {
                    change = true;
                    wstyle = 2;
                } else {
                    wstyle = 2;
                }
                if (wrProp) {
                    wrPropStyle = 2;
                }
                if (wpProp) {
                    wpPropStyle += 2;
                }
            } else if (group.equals("<w:i/>")) {
                if (wrPropStyle > 0 || lastGroup.equals("<w:b/>") || lastGroup.startsWith("<w:u ")) {
                    change = (wstyle += 4) != textStyle;
                } else if (wstyle != 4) {
                    change = true;
                    wstyle = 4;
                } else {
                    wstyle = 4;
                }
                if (wrProp) {
                    wrPropStyle = 4;
                }
                if (wpProp) {
                    wpPropStyle += 4;
                }
            } else if (group.startsWith("<w:u ") || group.startsWith("<w:rStyle w:val=\"Hyperlink\"") || group.startsWith("<w:hlink ")) {
                if (wrPropStyle > 0 || lastGroup.equals("<w:b/>") || lastGroup.equals("<w:i/>")) {
                    wstyle += 8;
                } else if (wstyle != 8) {
                    change = true;
                    wstyle = 8;
                } else {
                    wstyle = 8;
                }
                if (wrProp) {
                    wrPropStyle = 8;
                }
                if (wpProp) {
                    wpPropStyle += 8;
                }
            } else if (group.startsWith("<w:vertAlign w:val=\"subscript\"")) {
                wstyle = 16;
                format = 0;
            } else if (group.startsWith("<w:vertAlign w:val=\"superscript\"")) {
                wstyle = 18;
                format = 0;
            } else if (group.equals("<w:strike/>")) {
                wstyle = 20;
                format = 0;
            } else if (group.equals("<w:caps/>")) {
                wstyle = 22;
                format = 0;
            } else if (group.equals("<w:smallCaps/>")) {
                wstyle = 24;
                format = 0;
            } else if (group.startsWith("<w:color") || group.startsWith("<w:highlight") || group.startsWith("<w:shd")) {
                if (colorGroup == null || !group.equals(colorGroup)) {
                    change = true;
                }
                colorGroup = group;
                colorChange = true;
            } else if (group.startsWith("<w:rFonts")) {
                if (fontGroup == null || !group.equals(fontGroup)) {
                    change = true;
                }
                fontGroup = group;
                fontChange = true;
            } else if (group.startsWith("<w:szCs ") || group.startsWith("<w:sz ")) {
                String val = group.substring(group.indexOf(32) + 1);
                if (sizeGroup == null || !val.equals(sizeGroup)) {
                    change = true;
                }
                sizeGroup = val;
                sizeChange = true;
            } else if (group.startsWith("<w:txbxContent>") || group.startsWith("<w:sym ")) {
                change = true;
            }
            if (to == from) {
                inline.append(group);
                fgr.append(group);
                to = matcher.end();
            } else {
                String match = xhtml.substring(to, from);
                if (pexternal || rexternal) {
                    inline.append(match);
                    inline.append(group);
                    fgr.append(match);
                    fgr.append(group);
                    to = matcher.end();
                    continue;
                }
                String aftbreak = fgr.toString();
                if (wstyle > 0 && fgr.indexOf("<w:b/>") == -1 && fgr.indexOf("<w:i/>") == -1 && fgr.indexOf("<w:u ") == -1 && fgr.indexOf("<w:hlink ") == -1 && fgr.indexOf("<w:rStyle w:val=\"Hyperlink\"") == -1 && fgr.indexOf("<w:vertAlign") == -1 && fgr.indexOf("<w:strike/>") == -1 && fgr.indexOf("<w:caps/>") == -1 && fgr.indexOf("<w:smallCaps/>") == -1) {
                    wstyle = 0;
                    change = true;
                }
                if (!(wrstyle || this.isUncleaned || change || format != -1 || match.length() <= 0 || !aftbreak.startsWith("</w:t></w:r><w:r") && !aftbreak.startsWith("</w:t></w:r><w:proofErr"))) {
                    match = XMLHelper.resolveEntitiesXML(match);
                    coll.append(match);
                    fgr.setLength(0);
                    inline.append(group);
                    fgr.append(group);
                    to = matcher.end();
                    change = false;
                    lastGroup = group;
                    continue;
                }
                int i = aftbreak.indexOf("<w:rStyle ");
                if (i == -1) {
                    i = aftbreak.indexOf("<w:vertAlign");
                }
                if (i != -1) {
                    if (aftbreak.indexOf("</w:r>", i) == -1) {
                        wrstyle = true;
                    } else {
                        wrstyle = false;
                        wstyle = 0;
                    }
                } else {
                    wrstyle = false;
                }
                if (match.trim().length() > 0) {
                    String s;
                    int style;
                    String inl;
                    if (docSpace && this.tags != null && (inl = (String)skeleton.get(this.tags)) != null && inl.endsWith("<w:t>")) {
                        StringBuffer sb = new StringBuffer(inl);
                        sb = sb.insert(sb.length() - 1, " xml:space=\"preserve\"");
                        skeleton.put(this.tags, sb.toString());
                    }
                    match = XMLHelper.resolveEntitiesXML(match);
                    StringBuilder typebuilder = new StringBuilder();
                    String equivtext = null;
                    if (AppPreferences.segmentTags || this.isBreak(inline)) {
                        typebuilder.append("break");
                        equivtext = " ";
                    }
                    if ((style = wpPropStyle > 0 ? wpPropStyle : wstyle) > 0 && (s = this.createStyleAttribute(style)) != null) {
                        if (typebuilder.length() > 0) {
                            typebuilder.append(';');
                        }
                        typebuilder.append(s);
                    }
                    StringBuilder tagbuilder = new StringBuilder("<x id=\"");
                    tagbuilder.append(index);
                    tagbuilder.append("\"");
                    if (typebuilder.length() > 0) {
                        tagbuilder.append(" ctype=\"x-");
                        tagbuilder.append((CharSequence)typebuilder);
                        tagbuilder.append("\"");
                    }
                    if (equivtext != null) {
                        tagbuilder.append(" equiv-text=\"");
                        tagbuilder.append(equivtext);
                        tagbuilder.append("\"");
                    }
                    tagbuilder.append("/>");
                    this.tags = tagbuilder.toString();
                    if (docSpace && inline.toString().endsWith("<w:t>")) {
                        inline = inline.insert(inline.length() - 1, " xml:space=\"preserve\"");
                    }
                    skeleton.put(this.tags, inline.toString());
                    this.styles.put(this.tags, wstyle);
                    textStyle = wstyle;
                    inline.setLength(0);
                    fgr.setLength(0);
                    if (coll.length() > 0) {
                        content.append(coll.toString());
                        coll.setLength(0);
                    }
                    content.append(this.tags);
                    if (standaloneSpace != null) {
                        content.append(standaloneSpace);
                    }
                    content.append(match);
                    inline.append(group);
                    fgr.append(group);
                    ++index;
                    change = false;
                    format = -1;
                    docSpace = false;
                    standaloneSpace = null;
                } else {
                    if (match.length() > 0 && (content.length() > 0 || docSpace)) {
                        standaloneSpace = match;
                    }
                    inline.append(group);
                    fgr.append(group);
                }
                to = matcher.end();
            }
            lastGroup = group;
        }
        if (coll.length() > 0) {
            content.append(coll.toString());
            coll.setLength(0);
        }
        if (inline.length() > 0) {
            String tags = "<x id=\"" + index + "\" ctype=\"x-break\"/>";
            skeleton.put(tags, inline.toString());
            this.styles.put(tags, wstyle);
            content.append(tags);
        }
        return content.toString();
    }

    boolean isBreak(StringBuffer group) {
        boolean br = false;
        if (group.indexOf("<w:tab") != -1 || group.indexOf("</w:p>") != -1 || group.indexOf("<w:br/>") != -1 || group.indexOf("</Data>") != -1 || group.indexOf("</t>") != -1 || group.indexOf("</a:p>") != -1 || group.indexOf("<w:txbxContent>") != -1) {
            br = true;
        }
        return br;
    }
}

