/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleContext;
import translator.AppPreferences;
import translator.FormatChooser;
import translator.Project;
import translator.Translatable;
import translator.XMLHelper;
import translator.text.ParagraphStyledDocument;
import translator.translatables.IndesignIDMLDocument;
import translator.translatables.TextDocument;
import translator.translatables.ZipDocument;
import translator.ui.Colors;
import translator.xliff.XLIFF;

public class OpenOfficeDocument
extends ZipDocument
implements Translatable {
    private List ctnotes;
    private HashMap styleMap;
    private HashMap colorMap;
    int tagIndex = 0;
    int officeApplicationType;
    private String targetLanguage;
    private String targetCountry;
    private String styleDefinition = "<style:style style:name=\"T101\" style:family=\"text\"><style:text-properties fo:font-weight=\"bold\" style:font-weight-asian=\"bold\" style:font-weight-complex=\"bold\"/></style:style><style:style style:name=\"T102\" style:family=\"text\"><style:text-properties fo:font-style=\"italic\" style:font-style-asian=\"italic\" style:font-style-complex=\"italic\"/></style:style><style:style style:name=\"T103\" style:family=\"text\"><style:text-properties style:text-underline-style=\"solid\" style:text-underline-width=\"auto\" style:text-underline-color=\"font-color\"/></style:style><style:style style:name=\"T104\" style:family=\"text\"><style:text-properties style:text-position=\"sub 58%\"/></style:style><style:style style:name=\"T105\" style:family=\"text\"><style:text-properties style:text-position=\"super 58%\"/></style:style><style:style style:name=\"T106\" style:family=\"text\"><style:text-properties fo:font-style=\"italic\" fo:font-weight=\"bold\" style:font-style-asian=\"italic\" style:font-weight-asian=\"bold\" style:font-style-complex=\"italic\" style:font-weight-complex=\"bold\"/></style:style><style:style style:name=\"T107\" style:family=\"text\"><style:text-properties fo:font-style=\"italic\" style:text-underline-style=\"solid\" style:text-underline-width=\"auto\" style:text-underline-color=\"font-color\" style:font-style-asian=\"italic\" style:font-style-complex=\"italic\"/></style:style><style:style style:name=\"T108\" style:family=\"text\"><style:text-properties style:text-underline-style=\"solid\" style:text-underline-width=\"auto\" style:text-underline-color=\"font-color\" fo:font-weight=\"bold\" style:font-weight-asian=\"bold\" style:font-weight-complex=\"bold\"/></style:style><style:style style:name=\"T109\" style:family=\"text\"><style:text-properties fo:font-style=\"italic\" style:text-underline-style=\"solid\" style:text-underline-width=\"auto\" style:text-underline-color=\"font-color\" fo:font-weight=\"bold\" style:font-style-asian=\"italic\" style:font-weight-asian=\"bold\" style:font-style-complex=\"italic\" style:font-weight-complex=\"bold\"/></style:style><style:style style:name=\"T110\" style:family=\"text\"><style:text-properties fo:background-color=\"" + Colors.highlightColorHTML + "\" loext:char-shading-value=\"0\"/></style:style>";
    private Pattern notesPattern = Pattern.compile("(&lt;/*?(ctnote)&gt;)+");
    private Pattern notesPatternCalc = Pattern.compile("<text:p>.*?&lt;(ctnote)&gt;|&lt;/(ctnote)&gt;");
    private String wBreak = "<text:line-break/>";
    private String wNoteStart = "<office:annotation><dc:creator>#</dc:creator><dc:date>$</dc:date><text:p text:style-name=\"P1\"><text:span text:style-name=\"T1\">";
    private String wNoteEnd = "</text:span></text:p></office:annotation>";
    private String wSegmentStart = "</text:span></text:p><text:p text:style-name=\"P1\"><text:span text:style-name=\"T1\">---source---</text:span></text:p><text:p text:style-name=\"P1\"><text:span text:style-name=\"T1\">";
    int noteIndex = 0;

    public int getOfficeApplicationType() {
        return this.officeApplicationType;
    }

    public void previewWithNotes(Project pr, String spath) {
        String prev;
        Document sdoc = this.getDocument();
        String path = (String)sdoc.getProperty("path");
        if (this.isUncleaned) {
            prev = pr.previewUnclean(sdoc);
        } else {
            XLIFF xliff = pr.getXLIFF();
            prev = xliff.previewWithNotes(sdoc);
            this.ctnotes = xliff.getCTNotes();
        }
        if (prev != null && path != null) {
            String prevFilePath;
            PlainDocument tdoc = new PlainDocument();
            try {
                tdoc.insertString(0, prev, null);
                if (sdoc.getProperty("skeleton") != null) {
                    LinkedHashMap skeleton = (LinkedHashMap)sdoc.getProperty("skeleton");
                    tdoc.putProperty("skeleton", skeleton);
                }
                if (sdoc.getProperty("zname") != null) {
                    String name = (String)sdoc.getProperty("zname");
                    tdoc.putProperty("zname", name);
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
            File file = new File(path);
            String name = file.getName();
            int i = name.lastIndexOf(".");
            String extention = i != -1 ? name.substring(i, name.length()).toLowerCase() : "";
            String parent = file.getParent();
            if (spath == null) {
                prevFilePath = parent + AppPreferences.fs + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIEW") + extention;
            } else {
                prevFilePath = spath.toLowerCase().endsWith(extention) ? spath : spath + extention;
                if (prevFilePath.equalsIgnoreCase(path)) {
                    return;
                }
            }
            File previewFile = new File(prevFilePath);
            boolean save = this.saveZipXMLFileWithNotes(previewFile, file, tdoc);
            if (save && spath == null) {
                this.topui.getResourceView().viewFile(previewFile);
            }
        }
    }

    private boolean saveZipXMLFileWithNotes(File newFile, File oldFile, Document doc) {
        try {
            ZipFile zipFile = oldFile == null ? new ZipFile(newFile) : new ZipFile(oldFile);
            String[] texts = this.insertContentWithNotes(doc);
            File tempFile = File.createTempFile("Exp", newFile.getName(), newFile.getParentFile());
            String[] names = new String[this.zipNames.size()];
            int index = 0;
            Iterator it = this.zipNames.iterator();
            while (it.hasNext()) {
                String zname;
                names[index] = zname = (String)it.next();
                ++index;
            }
            this.storeZipFile(tempFile, zipFile, names, texts);
            if (newFile.exists()) {
                newFile.delete();
            }
            if (tempFile.renameTo(newFile)) {
                Boolean state = false;
                doc.putProperty("state", state);
            } else {
                JOptionPane.showMessageDialog(this.topui, "CafeTran cannot rename the file to " + newFile.getName());
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.topui, e.getMessage());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.topui, "Source segments replacement error. The original source language document might have been changed.");
        }
        return false;
    }

    public void loadFile(File file, String format, String encoding, String zName, Map filters) {
        ZipFile zipFile;
        String s;
        int ind;
        Object oi;
        this.setCustomFormatMap(format);
        String regExp = FormatChooser.getFormatRegEx(format);
        if (filters != null && (oi = filters.get("target-language")) != null && (ind = (s = oi.toString()).indexOf(45)) != -1) {
            String lan = s.substring(0, ind);
            String country = s.substring(ind + 1);
            this.targetLanguage = "fo:language=\"" + lan + "\"";
            this.targetCountry = "fo:country=\"" + country + "\"";
        }
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ArrayList<String> stories = new ArrayList<String>();
        int len = 0;
        int i = 0;
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String s2 = entry.getName();
            if (s2.equals("content.xml") || s2.equals("styles.xml")) {
                String zipname = s2;
                String outString = this.loadZipFile(zipFile, zipname, encoding);
                LinkedHashMap skeleton = null;
                if (regExp.length() > 0 && (outString = this.getContent(outString, skeleton = new LinkedHashMap(), regExp)).trim().length() > 0) {
                    len += outString.length();
                    this.skeletons.add(skeleton);
                    stories.add(outString);
                    this.zipNames.add(zipname);
                }
            }
            ++i;
        }
        try {
            zipFile.close();
        }
        catch (IOException ex) {
            Logger.getLogger(IndesignIDMLDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        GapContent gap = new GapContent(len);
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        if (name.endsWith(".odt")) {
            this.officeApplicationType = 0;
        } else if (name.endsWith(".ods")) {
            this.officeApplicationType = 1;
        } else if (name.endsWith(".odp")) {
            this.officeApplicationType = 2;
        } else if (name.endsWith(".odg")) {
            this.officeApplicationType = 3;
        }
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
    }

    public void openFile(File file, String format, String encoding, String zName, Map filters) {
        ZipFile zipFile;
        String s;
        int ind;
        Object oi;
        this.setCustomFormatMap(format);
        String regExp = FormatChooser.getFormatRegEx(format);
        if (filters != null && (oi = filters.get("target-language")) != null && (ind = (s = oi.toString()).indexOf(45)) != -1) {
            String lan = s.substring(0, ind);
            String country = s.substring(ind + 1);
            this.targetLanguage = "fo:language=\"" + lan + "\"";
            this.targetCountry = "fo:country=\"" + country + "\"";
        }
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        ArrayList<String> stories = new ArrayList<String>();
        int len = 0;
        int i = 0;
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String s2 = entry.getName();
            if (s2.equals("content.xml") || s2.equals("styles.xml")) {
                String zipname = s2;
                String outString = this.loadZipFile(zipFile, zipname, encoding);
                LinkedHashMap skeleton = null;
                if (regExp.length() > 0 && (outString = this.getContent(outString, skeleton = new LinkedHashMap(), regExp)).trim().length() > 0) {
                    len += outString.length();
                    this.skeletons.add(skeleton);
                    stories.add(outString);
                    this.zipNames.add(zipname);
                }
            }
            ++i;
        }
        try {
            zipFile.close();
        }
        catch (IOException ex) {
            Logger.getLogger(IndesignIDMLDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        GapContent gap = new GapContent(len);
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        String loadedPath = path;
        List docs = this.topui.getResourceLoader().getDocumentLoaderList();
        if (!docs.contains(loadedPath)) {
            docs.add(loadedPath);
        }
        this.openEditorTab(this.doc);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
        JTextPane pane = this.getTextPane();
        if (pane != null) {
            pane.setCaretPosition(0);
        }
    }

    String[] insertContentWithNotes(Document doc) throws BadLocationException {
        int le;
        this.noteIndex = 0;
        int skelindex = 0;
        String[] contents = new String[this.skeletons.size()];
        LinkedHashMap skeleton = (LinkedHashMap)this.skeletons.get(skelindex);
        StringBuilder all = new StringBuilder();
        String content = doc.getText(0, doc.getLength());
        String tsegFormat = "(<x id=[^>]*>+?)";
        Pattern ttags = Pattern.compile(tsegFormat);
        Matcher ma = ttags.matcher(content);
        int st = 0;
        String inline = null;
        while (ma.find()) {
            int b = ma.start();
            int e = ma.end();
            String group = ma.group();
            String cont = content.substring(st, b);
            if (group.indexOf("x-page") != -1 && all.length() > 0) {
                cont = "";
                contents[skelindex] = all.toString();
                all.setLength(0);
                if (++skelindex < this.skeletons.size()) {
                    skeleton = (LinkedHashMap)this.skeletons.get(skelindex);
                }
            }
            if (cont.length() > 0) {
                if (this.isXML) {
                    cont = XMLHelper.resolveXMLEntities(cont);
                }
                if (this.customFormatMap != null) {
                    cont = this.applyCustomFormat(cont, inline);
                }
                if (this.officeApplicationType == 0) {
                    cont = this.applyNotesinWriter(cont);
                }
            }
            if ((inline = (String)skeleton.get(group)) != null) {
                all.append(cont);
                all.append(inline);
            }
            st = e;
        }
        if (all.length() > 0) {
            String s = all.toString();
            if (this.officeApplicationType == 1) {
                s = this.applyNotesinCalc(s);
            }
            contents[skelindex] = s;
            all.setLength(0);
            if (++skelindex < this.skeletons.size()) {
                skeleton = (LinkedHashMap)this.skeletons.get(skelindex);
            }
        }
        if (st < (le = content.length())) {
            String cont = content.substring(st, le);
            if (this.isXML) {
                cont = XMLHelper.resolveXMLEntities(cont);
            }
            if (this.customFormatMap != null) {
                cont = this.applyCustomFormat(cont, inline);
            }
            if (this.officeApplicationType == 0) {
                cont = this.applyNotesinWriter(cont);
            }
            all.append(cont);
            String s = all.toString();
            if (this.officeApplicationType == 1) {
                s = this.applyNotesinCalc(s);
            }
            contents[skelindex] = s;
            all.setLength(0);
        }
        return contents;
    }

    private String applyNotesinWriter(String s) {
        if (this.ctnotes != null) {
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SS");
            String date = sdf.format(cal.getTime()).toString();
            String author = AppPreferences.userid.length() > 0 ? AppPreferences.userid : "CafeTran";
            Matcher m = this.notesPattern.matcher(s);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String g = m.group();
                if (g.equals("&lt;ctnote&gt;") && this.noteIndex < this.ctnotes.size()) {
                    String wwNoteStart = this.wNoteStart.replace("#", author);
                    wwNoteStart = wwNoteStart.replace("$", date);
                    String note = (String)this.ctnotes.get(this.noteIndex);
                    if (AppPreferences.includeSourceinNotes) {
                        note = note.replace("-seg-", this.wSegmentStart);
                    }
                    note = note.replace("\n", this.wBreak);
                    wwNoteStart = wwNoteStart + note;
                    wwNoteStart = wwNoteStart + this.wNoteEnd;
                    m.appendReplacement(sb, wwNoteStart);
                    ++this.noteIndex;
                    continue;
                }
                if (!g.equals("&lt;/ctnote&gt;")) continue;
                m.appendReplacement(sb, "");
            }
            m.appendTail(sb);
            return sb.toString();
        }
        return s;
    }

    private String applyNotesinCalc(String s) {
        if (this.ctnotes != null) {
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SS");
            String date = sdf.format(cal.getTime()).toString();
            String author = AppPreferences.userid.length() > 0 ? AppPreferences.userid : "CafeTran";
            Matcher m = this.notesPatternCalc.matcher(s);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String g = m.group();
                int ei = g.indexOf("&lt;ctnote&gt;");
                if (ei != -1 && this.noteIndex < this.ctnotes.size()) {
                    String gr = g.substring(0, ei);
                    String wwNoteStart = this.wNoteStart.replace("#", author);
                    wwNoteStart = wwNoteStart.replace("$", date);
                    String note = (String)this.ctnotes.get(this.noteIndex);
                    if (AppPreferences.includeSourceinNotes) {
                        note = note.replace("-seg-", this.wSegmentStart);
                    }
                    wwNoteStart = wwNoteStart + note;
                    wwNoteStart = wwNoteStart + this.wNoteEnd + gr;
                    m.appendReplacement(sb, wwNoteStart);
                    ++this.noteIndex;
                    continue;
                }
                if (!g.equals("&lt;/ctnote&gt;")) continue;
                m.appendReplacement(sb, "");
            }
            m.appendTail(sb);
            return sb.toString();
        }
        return s;
    }

    @Override
    String getContent(String xhtml, LinkedHashMap skeleton, String aformat) {
        this.isXML = true;
        Pattern languagePattern = Pattern.compile("fo:language=\".+?\"");
        Pattern countryPattern = Pattern.compile("fo:country=\".+?\"");
        if (aformat.startsWith("#")) {
            aformat = aformat.substring(1);
            this.isUncleaned = true;
        } else {
            this.isUncleaned = false;
        }
        Pattern p = Pattern.compile(aformat, 34);
        Matcher matcher = p.matcher(xhtml);
        StringBuffer content = new StringBuffer();
        String group = "";
        int from = 0;
        int to = 0;
        int index = this.tagIndex;
        StringBuffer inline = new StringBuffer();
        StringBuffer fgr = new StringBuffer();
        int ostyle = -1;
        int oostyle = -1;
        String ooColors = null;
        String oColors = null;
        boolean isPage = false;
        boolean hasContent = false;
        if (index > 0) {
            isPage = true;
        }
        ++index;
        while (matcher.find()) {
            from = matcher.start();
            group = matcher.group();
            if (group.startsWith("<style:text-properties ") && this.targetLanguage != null && this.targetCountry != null) {
                group = languagePattern.matcher(group).replaceFirst(this.targetLanguage);
                group = countryPattern.matcher(group).replaceFirst(this.targetCountry);
            }
            if (group.startsWith("<office:automatic-styles")) {
                if (group.equals("<office:automatic-styles>")) {
                    inline.append(group);
                    inline.append(this.styleDefinition);
                    fgr.append(group);
                    fgr.append(this.styleDefinition);
                } else if (group.equals("<office:automatic-styles/>")) {
                    inline.append("<office:automatic-styles>");
                    inline.append(this.styleDefinition);
                    inline.append("</office:automatic-styles>");
                    fgr.append("<office:automatic-styles>");
                    fgr.append(this.styleDefinition);
                    fgr.append("</office:automatic-styles>");
                } else {
                    inline.append(group);
                    fgr.append(group);
                }
                to = matcher.end();
                continue;
            }
            if (group.equals("</style:style>")) {
                int sInd = fgr.lastIndexOf("<style:style ");
                if (sInd != -1) {
                    String styleDecl = fgr.substring(sInd);
                    this.putOOStyle(styleDecl);
                }
            } else if (group.indexOf(" text:style-name=") != -1) {
                int i = group.indexOf(" text:style-name=");
                int sname = group.indexOf("\"", i);
                int ename = group.indexOf("\"", sname + 1);
                if (sname != -1 && ename != -1) {
                    Object o;
                    String name = group.substring(sname + 1, ename);
                    if (this.styleMap != null) {
                        o = this.styleMap.get(name);
                        oostyle = o != null ? (Integer)o : 0;
                    }
                    if (this.colorMap != null) {
                        o = this.colorMap.get(name);
                        ooColors = o != null ? (String)o : null;
                    }
                }
            } else if (group.indexOf(" xlink:href=") != -1) {
                oostyle = 8;
            }
            if (to == from) {
                if (oostyle != -1) {
                    ostyle = oostyle;
                }
                if (ooColors != null) {
                    oColors = ooColors;
                }
                inline.append(group);
                fgr.append(group);
                to = matcher.end();
            } else {
                String match = xhtml.substring(to, from);
                if (match.length() > 0) {
                    String s;
                    if (!hasContent) {
                        hasContent = true;
                    }
                    match = XMLHelper.resolveEntitiesXML(match);
                    StringBuilder typebuilder = new StringBuilder();
                    String equivtext = null;
                    if (isPage) {
                        typebuilder.append("page");
                        isPage = false;
                    } else if (AppPreferences.segmentTags || this.isBreak(inline)) {
                        typebuilder.append("break");
                        equivtext = " ";
                    }
                    if (ostyle > 0 && (s = this.createStyleAttribute(ostyle)) != null) {
                        if (typebuilder.length() > 0) {
                            typebuilder.append(';');
                        }
                        typebuilder.append(s);
                    }
                    if (oColors != null) {
                        if (typebuilder.length() > 0) {
                            typebuilder.append(';');
                        }
                        typebuilder.append(oColors);
                    }
                    StringBuilder tagbuilder = new StringBuilder("<x id=\"");
                    tagbuilder.append(index);
                    tagbuilder.append("\"");
                    if (typebuilder.length() > 0) {
                        tagbuilder.append(" ctype=\"x-");
                        tagbuilder.append((CharSequence)typebuilder);
                        tagbuilder.append("\"");
                    }
                    if (equivtext != null) {
                        tagbuilder.append(" equiv-text=\"");
                        tagbuilder.append(equivtext);
                        tagbuilder.append("\"");
                    }
                    tagbuilder.append("/>");
                    String tags = tagbuilder.toString();
                    ++index;
                    skeleton.put(tags, inline.toString());
                    if (ostyle != -1) {
                        this.styles.put(tags, ostyle);
                    }
                    inline.setLength(0);
                    fgr.setLength(0);
                    content.append(tags);
                    content.append(match);
                    inline.append(group);
                    fgr.append(group);
                    if (oostyle != -1) {
                        ostyle = oostyle;
                    }
                    if (ooColors != null) {
                        oColors = ooColors;
                    }
                } else {
                    if (match.length() > 0 && content.length() > 0) {
                        inline.append(match);
                    }
                    inline.append(group);
                    fgr.append(group);
                }
                to = matcher.end();
            }
            if (!group.equals("</text:span>") && !group.equals("</text:p>")) continue;
            ostyle = -1;
            oostyle = -1;
            ooColors = null;
            oColors = null;
        }
        if (!hasContent) {
            return "";
        }
        if (inline.length() > 0) {
            String tags = "<x id=\"" + index + "\" ctype=\"x-break\"/>";
            skeleton.put(tags, inline.toString());
            if (ostyle != -1) {
                this.styles.put(tags, ostyle);
            }
            content.append(tags);
        }
        this.tagIndex = index;
        return content.toString();
    }

    private void putOOStyle(String styleXML) {
        int nameInd = styleXML.indexOf(" style:name=");
        if (nameInd != -1) {
            int sname = styleXML.indexOf("\"", nameInd);
            int ename = styleXML.indexOf("\"", sname + 1);
            if (sname != -1 && ename != -1) {
                String c;
                int i;
                String name = styleXML.substring(sname + 1, ename);
                int style = 0;
                int bold = styleXML.indexOf("fo:font-weight=\"bold\"", ename);
                int abold = styleXML.indexOf("style:font-weight-asian=\"bold\"", ename);
                int italic = styleXML.indexOf("fo:font-style=\"italic\"");
                int aitalic = styleXML.indexOf("style:font-style-asian=\"italic\"", ename);
                int underline = styleXML.indexOf("style:text-underline-style=\"solid\"", ename);
                int sup = styleXML.indexOf("style:text-properties style:text-position=\"super ", ename);
                int sub = styleXML.indexOf("style:text-properties style:text-position=\"sub ", ename);
                int fcolor = styleXML.indexOf("fo:color=", ename);
                int hcolor = styleXML.indexOf("fo:background-color=", ename);
                if (bold != -1 || abold != -1) {
                    style = 2;
                }
                if (italic != -1 || aitalic != -1) {
                    style += 4;
                }
                if (underline != -1) {
                    style += 8;
                }
                if (sub != -1) {
                    style = 16;
                } else if (sup != -1) {
                    style = 18;
                }
                if (this.styleMap == null) {
                    this.styleMap = new HashMap();
                }
                this.styleMap.put(name, style);
                StringBuilder colors = new StringBuilder();
                if (fcolor != -1) {
                    i = styleXML.indexOf(34, fcolor + 10);
                    c = styleXML.substring(fcolor + 10, i);
                    colors.append("fcolor:").append(c);
                }
                if (hcolor != -1) {
                    i = styleXML.indexOf(34, hcolor + 21);
                    c = styleXML.substring(hcolor + 21, i);
                    if (colors.length() > 0) {
                        colors.append(';');
                    }
                    colors.append("hcolor:").append(c);
                }
                if (colors.length() > 0) {
                    if (this.colorMap == null) {
                        this.colorMap = new HashMap();
                    }
                    this.colorMap.put(name, colors.toString());
                }
            }
        }
    }

    boolean isBreak(StringBuffer group) {
        boolean br = false;
        if (group.indexOf("<office:annotation ") != -1) {
            br = false;
        } else if (group.indexOf("</text:p>") != -1 || group.indexOf("text:note-citation>") != -1 || group.indexOf("<text:tab/>") != -1 || group.indexOf("<text:line-break/>") != -1 || group.indexOf("</text:h>") != -1) {
            br = true;
        }
        return br;
    }
}

