/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import translator.DefaultXMLElement;
import translator.XMLElement;
import translator.translatables.Row;

public class Sheet
extends DefaultXMLElement {
    private List rows = new ArrayList();
    private Set hiddenColums;
    private String name;
    private int id;
    private boolean hidden;
    private Map notesMap = new HashMap();

    public Sheet(String name) {
        this.name = name;
    }

    public void setID(int uid) {
        this.id = uid;
    }

    public void setHidden() {
        this.hidden = true;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addChild(Object o) {
        if (o instanceof XMLElement) {
            XMLElement xml = (XMLElement)o;
            String name = xml.getName();
            if (name.equals("sheetData")) {
                this.rows = xml.getChildren("row");
            }
            super.addChild(xml);
        }
    }

    public List getRows() {
        return this.rows;
    }

    public Row getRow(int i) {
        if (i < this.rows.size()) {
            Row r = (Row)this.rows.get(i);
            return r;
        }
        return null;
    }

    public String getSourceContent(String icol, String ecol, String ncol) {
        int fromRow = -1;
        int toRow = -1;
        int fromColumn = -1;
        int toColumn = -1;
        HashSet<Integer> rangeColumns = null;
        int i = icol.indexOf(58);
        if (i != -1) {
            char ch;
            int j;
            String from = icol.substring(0, i);
            String to = icol.substring(i + 1);
            char[] arr = from.toCharArray();
            for (j = 0; j < arr.length; ++j) {
                ch = arr[j];
                if (ch >= 'A' && ch <= 'Z') {
                    fromColumn = ch - 65;
                    if (j == 0) {
                        ++fromColumn;
                        continue;
                    }
                    fromColumn += j * 26;
                    continue;
                }
                String fr = from.substring(j);
                fromRow = Integer.parseInt(fr);
                break;
            }
            arr = to.toCharArray();
            for (j = 0; j < arr.length; ++j) {
                ch = arr[j];
                if (ch >= 'A' && ch <= 'Z') {
                    toColumn = ch - 65;
                    if (j == 0) {
                        ++toColumn;
                        continue;
                    }
                    toColumn += j * 26;
                    continue;
                }
                String tr = to.substring(j);
                toRow = Integer.parseInt(tr);
                break;
            }
            if (fromColumn != -1) {
                rangeColumns = new HashSet<Integer>();
                while (fromColumn <= toColumn) {
                    rangeColumns.add(fromColumn);
                    ++fromColumn;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<sheet>");
        int count = 0;
        for (Object object : this.rows) {
            if (!(object instanceof Row)) continue;
            Row row = (Row)object;
            if (fromRow != -1 && (++count < fromRow || count > toRow)) {
                row.setHidden(true);
            }
            String rid = row.getAttribute("r");
            String rowTag = "<row r=\"" + rid + "\">";
            sb.append(rowTag);
            if (!row.isHidden()) {
                String n;
                String s = row.getSource(icol, ecol, ncol, this.hiddenColums, rangeColumns);
                sb.append(s);
                if (ncol.length() > 0 && (n = row.getNote()) != null) {
                    this.notesMap.put(rowTag, n);
                }
            }
            sb.append("</row>");
        }
        sb.append("</sheet>");
        return sb.toString();
    }

    public String getBilingualContent(String icol, String ecol, String ncol, String slang, String tlang) {
        StringBuilder sb = new StringBuilder();
        int rowID = 0;
        for (Object object : this.rows) {
            String s;
            Row row;
            if (object instanceof Row && !(row = (Row)object).isHidden() && (s = row.getSourceAndTarget(icol, ecol, ncol, slang, tlang)).length() > 0) {
                sb.append("<trans-unit id=\"");
                sb.append(rowID);
                sb.append("\" resname=\"");
                sb.append(this.id);
                sb.append("\">");
                sb.append(s);
                sb.append("</trans-unit>");
            }
            ++rowID;
        }
        return sb.toString();
    }

    public void addHiddenColumn(String min, String max) {
        if (this.hiddenColums == null) {
            this.hiddenColums = new HashSet();
        }
        int ma = Integer.parseInt(max);
        for (int mi = Integer.parseInt(min); mi <= ma; ++mi) {
            this.hiddenColums.add(mi);
        }
    }

    public Map getNotesMap() {
        return this.notesMap;
    }
}

