/*
 * Decompiled with CFR 0.152.
 */
package translator.translatables;

import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleContext;
import translator.AppPreferences;
import translator.FileFilters;
import translator.FormatChooser;
import translator.Project;
import translator.Translatable;
import translator.text.ParagraphStyledDocument;
import translator.translatables.IndesignIDMLDocument;
import translator.translatables.TextDocument;
import translator.translatables.ZipFileSelector;

public class ZipDocument
extends TextDocument
implements Translatable {
    List zipNames = new ArrayList();

    public void loadFile(File file, String format, String encoding, String zName) {
        ZipFile zipFile;
        if (format.startsWith("iWork")) {
            this.isXML = true;
        }
        String regExp = FormatChooser.getFormatRegEx(format);
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        int esize = zipFile.size();
        String[] names = new String[esize];
        String zipname = null;
        int i = 0;
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String s = entry.getName();
            if (zName != null && zName.equalsIgnoreCase(s)) {
                zipname = s;
                break;
            }
            names[i] = s;
            ++i;
        }
        if (zipname == null) {
            ZipFileSelector dlg = new ZipFileSelector(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE FILE"), names, true);
            Dimension dlgSize = dlg.getPreferredSize();
            Dimension frmSize = this.topui.getSize();
            Point loc = this.topui.getLocation();
            dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            dlg.setVisible(true);
            zipname = dlg.fname;
        }
        ArrayList<String> stories = new ArrayList<String>();
        String outString = this.loadZipFile(zipFile, zipname, encoding);
        try {
            zipFile.close();
        }
        catch (IOException ex) {
            Logger.getLogger(IndesignIDMLDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
            this.skeletons.add(skeleton);
        }
        stories.add(outString);
        this.zipNames.add(zipname);
        GapContent gap = new GapContent(outString.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        this.doc.putProperty("zname", zipname);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        this.setDocumentProperties(this.doc);
    }

    public void openFile(File file, String format, String encoding, String zName) {
        ZipFile zipFile;
        if (format.startsWith("iWork")) {
            this.isXML = true;
        }
        String regExp = FormatChooser.getFormatRegEx(format);
        try {
            zipFile = new ZipFile(file);
        }
        catch (ZipException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        catch (IOException ex) {
            Logger.getLogger(ZipDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        int esize = zipFile.size();
        String[] names = new String[esize];
        String zipname = null;
        int i = 0;
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String s = entry.getName();
            if (zName != null && zName.equalsIgnoreCase(s)) {
                zipname = s;
                break;
            }
            names[i] = s;
            ++i;
        }
        if (zipname == null) {
            ZipFileSelector dlg = new ZipFileSelector(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE FILE"), names, true);
            Dimension dlgSize = dlg.getPreferredSize();
            Dimension frmSize = this.topui.getSize();
            Point loc = this.topui.getLocation();
            dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
            dlg.setVisible(true);
            zipname = dlg.fname;
        }
        ArrayList<String> stories = new ArrayList<String>();
        String outString = this.loadZipFile(zipFile, zipname, encoding);
        try {
            zipFile.close();
        }
        catch (IOException ex) {
            Logger.getLogger(IndesignIDMLDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        LinkedHashMap skeleton = null;
        if (regExp.length() > 0) {
            skeleton = new LinkedHashMap();
            outString = this.getContent(outString, skeleton, regExp);
            this.skeletons.add(skeleton);
        }
        stories.add(outString);
        this.zipNames.add(zipname);
        GapContent gap = new GapContent(outString.length());
        this.doc = new ParagraphStyledDocument(gap, new StyleContext());
        String path = file.getPath();
        String name = file.getName();
        this.doc.putProperty("file", file);
        this.doc.putProperty("path", path);
        this.doc.putProperty("name", name);
        this.doc.putProperty("zname", zipname);
        String loadedPath = path;
        List docs = this.topui.getResourceLoader().getDocumentLoaderList();
        if (!docs.contains(loadedPath)) {
            docs.add(loadedPath);
        }
        this.openEditorTab(this.doc);
        for (String story : stories) {
            this.insertStringTags(this.doc, story);
        }
        this.doc.setContents();
        JTextPane pane = this.getTextPane();
        if (pane != null) {
            pane.setCaretPosition(0);
        }
        this.setDocumentProperties(this.doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadZipFile(ZipFile zfile, String name, String encoding) {
        InputStream is = null;
        try {
            String outString;
            ZipEntry entry = zfile.getEntry(name);
            int size = (int)entry.getSize();
            is = zfile.getInputStream(entry);
            BufferedInputStream bis = new BufferedInputStream(is);
            byte[] buf = new byte[size];
            bis.read(buf, 0, size);
            bis.close();
            String string = outString = new String(buf, 0, buf.length, encoding);
            return string;
        }
        catch (IOException ex) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            this.statusBar.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ERROR OPENING FILE"));
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    private boolean saveFile() {
        Document doc = null;
        doc = this.getDocument();
        Boolean state = (Boolean)doc.getProperty("state");
        if (!state.booleanValue()) {
            return false;
        }
        String path = (String)doc.getProperty("path");
        if (path == null) {
            return this.saveAsFile();
        }
        if (path.length() == 0) {
            return false;
        }
        Boolean save = (Boolean)doc.getProperty("save");
        if (save == null || !save.booleanValue()) {
            return false;
        }
        File file = new File(path);
        return this.saveZipXMLFile(file, null, doc);
    }

    private boolean saveZipXMLFile(File newFile, File oldFile, Document doc) {
        try {
            ZipFile zipFile = oldFile == null ? new ZipFile(newFile) : new ZipFile(oldFile);
            String[] texts = this.insertContent(doc);
            if (texts == null) {
                JOptionPane.showMessageDialog(this.topui, "The original source language document has been modified. Export may fail or be incomplete.");
                return false;
            }
            File tempFile = File.createTempFile("Exp", newFile.getName(), newFile.getParentFile());
            String[] names = new String[this.zipNames.size()];
            int index = 0;
            Iterator it = this.zipNames.iterator();
            while (it.hasNext()) {
                String zname;
                names[index] = zname = (String)it.next();
                ++index;
            }
            this.storeZipFile(tempFile, zipFile, names, texts);
            if (newFile.exists()) {
                newFile.delete();
            }
            if (tempFile.renameTo(newFile)) {
                Boolean state = false;
                doc.putProperty("state", state);
            } else {
                JOptionPane.showMessageDialog(this.topui, "CafeTran cannot rename the file to " + newFile.getName());
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.topui, e.getMessage());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this.topui, "The original source language document has been modified. Export may fail or be incomplete.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeZipFile(File tempFile, ZipFile zipFile, String[] names, String[] texts) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(tempFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            byte[] buffer = new byte[1024];
            InputStream is = null;
            while (entries.hasMoreElements()) {
                int bytesRead;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String oname = entry.getName();
                boolean con = false;
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i];
                    if (!oname.equals(name)) continue;
                    con = true;
                }
                if (con) continue;
                is = zipFile.getInputStream(entry);
                zos.putNextEntry(new ZipEntry(oname));
                while ((bytesRead = is.read(buffer)) != -1) {
                    zos.write(buffer, 0, bytesRead);
                }
            }
            if (is != null) {
                is.close();
            }
            zipFile.close();
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                ZipEntry entry = new ZipEntry(name);
                zos.putNextEntry(entry);
                String text = texts[i];
                byte[] buf = text.getBytes("UTF-8");
                zos.write(buf, 0, buf.length);
            }
            zos.close();
        }
        catch (IOException ex) {
            Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private boolean saveAsFile() {
        Document doc = this.getDocument();
        Boolean save = (Boolean)doc.getProperty("save");
        if (save == null || !save.booleanValue()) {
            return false;
        }
        JFileChooser jFileChooser = new JFileChooser();
        FileFilters filters = new FileFilters();
        String filterName = AppPreferences.format;
        filters.setFileFilters(FormatChooser.formatType, filterName, jFileChooser);
        jFileChooser.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE DOCUMENT"));
        jFileChooser.setCurrentDirectory(new File(AppPreferences.fileDirectory));
        String fs = (String)doc.getProperty("path");
        String tlang = (String)doc.getProperty("target-lang");
        if (fs == null) {
            fs = "";
        }
        if (tlang != null) {
            int ind = fs.lastIndexOf(".");
            if (ind != -1) {
                String ext = fs.substring(ind);
                fs = fs.substring(0, ind) + "_" + tlang + ext;
            } else {
                fs = fs + tlang;
            }
        }
        jFileChooser.setSelectedFile(new File(fs));
        jFileChooser.repaint();
        if (0 == jFileChooser.showSaveDialog(this.topui)) {
            int i;
            File newFile = jFileChooser.getSelectedFile();
            AppPreferences.fileDirectory = newFile.getParent();
            String oldpath = (String)doc.getProperty("path");
            String path = newFile.getPath();
            doc.putProperty("path", path);
            doc.putProperty("file", newFile);
            List docs = this.topui.getResourceLoader().getDocumentLoaderList();
            if (oldpath != null) {
                docs.remove(oldpath);
            }
            docs.add(path);
            String oname = (String)doc.getProperty("name");
            String name = newFile.getName();
            JTabbedPane tabpane = this.tview.getTabbedPane();
            if (oname != null && (i = tabpane.indexOfTab(oname)) != -1) {
                tabpane.setTitleAt(i, name);
            }
            doc.putProperty("name", name);
            File oldFile = new File(oldpath);
            return this.saveZipXMLFile(newFile, oldFile, doc);
        }
        return false;
    }

    @Override
    public void preview(Project pr, String spath) {
        Document sdoc = this.getDocument();
        String path = (String)sdoc.getProperty("path");
        String prev = this.isUncleaned ? pr.previewUnclean(sdoc) : pr.preview(sdoc);
        if (prev != null && path != null) {
            String prevFilePath;
            PlainDocument tdoc = new PlainDocument();
            try {
                tdoc.insertString(0, prev, null);
                if (sdoc.getProperty("skeleton") != null) {
                    LinkedHashMap skeleton = (LinkedHashMap)sdoc.getProperty("skeleton");
                    tdoc.putProperty("skeleton", skeleton);
                }
                if (sdoc.getProperty("zname") != null) {
                    String name = (String)sdoc.getProperty("zname");
                    tdoc.putProperty("zname", name);
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
            File file = new File(path);
            String name = file.getName();
            String extention = null;
            int i = name.lastIndexOf(".");
            extention = i != -1 ? name.substring(i, name.length()).toLowerCase() : "";
            String parent = file.getParent();
            if (spath == null) {
                prevFilePath = parent + AppPreferences.fs + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIEW") + extention;
            } else {
                prevFilePath = spath.toLowerCase().endsWith(extention) ? spath : spath + extention;
                if (prevFilePath.equalsIgnoreCase(path)) {
                    JOptionPane.showMessageDialog(this.topui, "Never overwrite the original source language document!");
                    return;
                }
            }
            File previewFile = new File(prevFilePath);
            boolean save = this.saveZipXMLFile(previewFile, file, tdoc);
            if (!save) {
                this.preview2(pr, spath);
            } else if (spath == null) {
                this.topui.getResourceView().viewFile(previewFile);
            }
        }
    }

    @Override
    public void preview2(Project pr, String spath) {
        Document sdoc = this.getDocument();
        String path = (String)sdoc.getProperty("path");
        if (this.isUncleaned) {
            return;
        }
        String prev = pr.preview2(sdoc);
        if (prev != null && path != null) {
            String prevFilePath;
            PlainDocument tdoc = new PlainDocument();
            try {
                tdoc.insertString(0, prev, null);
                if (sdoc.getProperty("skeleton") != null) {
                    LinkedHashMap skeleton = (LinkedHashMap)sdoc.getProperty("skeleton");
                    tdoc.putProperty("skeleton", skeleton);
                }
                if (sdoc.getProperty("zname") != null) {
                    String name = (String)sdoc.getProperty("zname");
                    tdoc.putProperty("zname", name);
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
            File file = new File(path);
            String name = file.getName();
            String extention = null;
            int i = name.lastIndexOf(".");
            extention = i != -1 ? name.substring(i, name.length()).toLowerCase() : "";
            String parent = file.getParent();
            if (spath == null) {
                prevFilePath = parent + AppPreferences.fs + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIEW") + extention;
            } else {
                prevFilePath = spath.toLowerCase().endsWith(extention) ? spath : spath + extention;
                if (prevFilePath.equalsIgnoreCase(path)) {
                    JOptionPane.showMessageDialog(this.topui, "Never overwrite the original source language document!");
                    return;
                }
            }
            File previewFile = new File(prevFilePath);
            boolean save = this.saveZipXMLFile(previewFile, file, tdoc);
            if (save && spath == null) {
                this.topui.getResourceView().viewFile(previewFile);
            }
        }
    }

    @Override
    public boolean setTargetContent(Project p) {
        ParagraphStyledDocument sdoc = (ParagraphStyledDocument)this.getDocument();
        String s = this.translate(sdoc, p);
        if (s != null && s.length() > 0) {
            try {
                sdoc.remove(0, sdoc.getLength());
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TextDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.insertStringTags(sdoc, s);
            sdoc.setContents();
            JTextPane pane = this.getTextPane();
            if (pane != null) {
                this.cancelSegmentStyle();
                pane.setCaretPosition(0);
            }
            this.saveResource();
            return true;
        }
        return false;
    }

    private boolean okToAbandon() {
        Document doc = this.getDocument();
        Boolean state = (Boolean)doc.getProperty("state");
        if (!state.booleanValue()) {
            return true;
        }
        int value = JOptionPane.showConfirmDialog(this.topui, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE CHANGES IN THE DOCUMENT?"), "CafeTran", 1);
        switch (value) {
            case 0: {
                return this.saveFile();
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void saveAsResource() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ZipDocument.this.saveAsFile();
            }
        });
    }

    @Override
    public void saveResource() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ZipDocument.this.saveFile();
            }
        });
    }

    @Override
    public void closeResource() {
        if (!this.okToAbandon()) {
            return;
        }
        Object o = this.getDocument().getProperty("path");
        if (o != null) {
            String path = o.toString();
            List docs = this.topui.getResourceLoader().getDocumentLoaderList();
            docs.remove(path);
        }
        this.tview = this.topui.getTabView();
        this.tview.removeTab(this.name);
    }
}

