/*
 * Decompiled with CFR 0.152.
 */
package translator.ttx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import translator.AppPreferences;
import translator.MainView;
import translator.Project;
import translator.XMLElement;
import translator.ttx.Raw;
import translator.ttx.TTX;
import translator.ttx.TTXMenu;
import translator.ui.GridPanel;

public class TTXEditor
extends JDialog
implements ActionListener {
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private XMLElement header;
    Project project;
    TTX ttx;
    XMLElement tool;
    XMLElement user;
    private LinkedHashMap attr;
    public boolean cancelled = false;
    private MainView owner;

    public TTXEditor(MainView jowner, TTXMenu fview, Project project, String title) {
        super(jowner, title, true);
        JTextField field;
        JLabel label;
        String display;
        String value;
        Set keys;
        this.setResizable(false);
        this.ttx = project.getTTX();
        this.header = this.ttx.getHeader();
        this.owner = jowner;
        this.project = project;
        this.jPanel1 = new GridPanel();
        this.jPanel1.setLayout(new GridLayout(0, 2, 5, 5));
        this.jPanel1.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.jPanel2 = new GridPanel();
        this.jPanel2.setLayout(new GridLayout(0, 2, 5, 5));
        this.jPanel2.setBorder(new EmptyBorder(new Insets(0, 10, 10, 10)));
        JPanel con = (JPanel)this.getContentPane();
        con.add((Component)this.jPanel1, "North");
        List list = this.header.getChildren("ToolSettings");
        if (list.size() > 0) {
            this.tool = (XMLElement)list.get(0);
            if (this.tool != null) {
                this.attr = this.tool.getAttributes();
                if (this.attr != null) {
                    keys = this.attr.keySet();
                    for (String name : keys) {
                        value = (String)this.attr.get(name);
                        display = name.substring(0, 1).toUpperCase() + name.substring(1) + ":";
                        label = new JLabel(display);
                        label.setName(name);
                        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
                        field = new JTextField(value);
                        field.setCaretPosition(0);
                        field.setMargin(new Insets(0, 2, 0, 0));
                        field.setFont(field.getFont().deriveFont(1));
                        field.setPreferredSize(new Dimension(250, 24));
                        this.jPanel1.add(label);
                        this.jPanel1.add(field);
                    }
                }
            }
        }
        if ((list = this.header.getChildren("UserSettings")).size() > 0) {
            this.user = (XMLElement)list.get(0);
            if (this.user != null) {
                this.attr = this.user.getAttributes();
                if (this.attr != null) {
                    keys = this.attr.keySet();
                    for (String name : keys) {
                        value = (String)this.attr.get(name);
                        display = name.substring(0, 1).toUpperCase() + name.substring(1) + ":";
                        label = new JLabel(display);
                        label.setName(name);
                        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
                        field = new JTextField(value);
                        field.setCaretPosition(0);
                        field.setMargin(new Insets(0, 2, 0, 0));
                        field.setFont(field.getFont().deriveFont(1));
                        field.setPreferredSize(new Dimension(250, 24));
                        this.jPanel2.add(label);
                        this.jPanel2.add(field);
                    }
                }
            }
        }
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)this.jPanel2, "Center");
        con.add((Component)jPanel5, "Center");
        this.jPanel3 = new JPanel();
        this.jPanel3.setLayout(new FlowLayout(2));
        this.jPanel3.setBorder(new EmptyBorder(new Insets(0, 10, 5, 10)));
        con.add((Component)this.jPanel3, "South");
        this.jButton1 = new JButton();
        float fs = 10.0f;
        Font font = this.jButton1.getFont().deriveFont(1, fs);
        this.jButton1.setFont(font);
        this.jButton1.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("OK"));
        this.jButton1.addActionListener(this);
        this.jButton2 = new JButton();
        this.jButton2.setFont(font);
        this.jButton2.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jButton2.addActionListener(this);
        this.jButton3 = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REMOVE SOURCE=TARGET"));
        this.jButton3.setFont(font);
        this.jButton3.addActionListener(this);
        this.jPanel3.add(this.jButton3);
        this.jPanel3.add(Box.createHorizontalStrut(150));
        this.jPanel3.add(this.jButton1);
        this.jPanel3.add(this.jButton2);
        con.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TTXEditor.this.jButton1.doClick();
            }
        });
        con.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TTXEditor.this.jButton2.doClick();
            }
        });
        con.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        con.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TTXEditor.this.cancelled = true;
                TTXEditor.this.closeDialog();
            }
        });
        this.pack();
        String val = this.user.getAttribute("TargetLanguage");
        if (val == null || val.length() == 0) {
            JOptionPane.showMessageDialog(this.owner, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET TARGET LANGUAGE!"));
            return;
        }
    }

    void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jButton1) {
            JComponent field;
            JButton but;
            JLabel lab;
            String value;
            String type;
            int i;
            Component[] comps = this.jPanel1.getComponents();
            for (i = 0; i < comps.length; ++i) {
                type = null;
                value = null;
                if (comps[i] instanceof JLabel) {
                    lab = (JLabel)comps[i];
                    type = lab.getName();
                    ++i;
                } else if (comps[i] instanceof JButton) {
                    but = (JButton)comps[i];
                    type = but.getName();
                    ++i;
                }
                if (comps[i] instanceof JTextField) {
                    field = (JTextField)comps[i];
                    value = ((JTextComponent)field).getText();
                } else if (comps[i] instanceof JComboBox) {
                    field = (JComboBox)comps[i];
                    value = (String)((JComboBox)field).getSelectedItem();
                }
                if (type == null || value == null || this.tool == null) continue;
                this.tool.setAttribute(type, value);
            }
            comps = this.jPanel2.getComponents();
            for (i = 0; i < comps.length; ++i) {
                type = null;
                value = null;
                if (comps[i] instanceof JLabel) {
                    lab = (JLabel)comps[i];
                    type = lab.getName();
                    ++i;
                } else if (comps[i] instanceof JButton) {
                    but = (JButton)comps[i];
                    type = but.getName();
                    ++i;
                }
                if (comps[i] instanceof JTextField) {
                    field = (JTextField)comps[i];
                    value = ((JTextComponent)field).getText();
                } else if (comps[i] instanceof JComboBox) {
                    field = (JComboBox)comps[i];
                    value = (String)((JComboBox)field).getSelectedItem();
                }
                if (type == null || value == null || this.user == null) continue;
                this.user.setAttribute(type, value);
            }
            String val = this.user.getAttribute("TargetLanguage");
            if (val == null || val.length() == 0) {
                JOptionPane.showMessageDialog(this.owner, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SET TARGET LANGUAGE!"));
                return;
            }
            Raw file = this.ttx.getCurrentFile();
            if (file != null) {
                this.ttx.setCurrentFile(file);
            }
            this.closeDialog();
        } else if (e.getSource() == this.jButton2) {
            this.cancelled = true;
            this.closeDialog();
        } else if (e.getSource() == this.jButton3) {
            List list = this.project.getProjects();
            if (list != null) {
                for (Object object : list) {
                    if (!(object instanceof TTX)) continue;
                    TTX tt = (TTX)object;
                    tt.removeTargetElements();
                }
            } else {
                this.ttx.removeTargetElements();
            }
            this.ttx.getView().browseToUnit(0);
            this.cancelled = true;
            this.closeDialog();
        }
    }
}

