/*
 * Decompiled with CFR 0.152.
 */
package translator.ttx;

import java.awt.Component;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import translator.AppPreferences;
import translator.Frequencer;
import translator.MainView;
import translator.Placeables;
import translator.ProjectView;
import translator.Statistics;
import translator.WordCount;
import translator.XMLElement;
import translator.XMLHelper;
import translator.qa.Issue;
import translator.ttx.Raw;
import translator.ttx.TTX;
import translator.ttx.TTXMenu;
import translator.ttx.TTXUnit;
import translator.ui.Colors;
import translator.ui.HTMLFormat;

public class TTXView {
    MainView topui;
    private ProjectView prview;
    private int fromIndex;
    private TTX ttx;
    private TTXMenu menu;
    private static List tunitsFilter;
    private static List tunitsNestedFilter;
    private static List tunitsGlued;
    private static boolean qafilter;
    private String query;
    private int queryType;
    private int currentTUIndex = -1;
    public int currentTUSize = -1;
    private Set<String> extractedResults;
    private static Pattern searchPattern;
    private static String replaceString;
    private static boolean replaceInSource;

    public TTXView(MainView topui, TTX ttx) {
        this.topui = topui;
        this.prview = topui.getProjectView();
        this.ttx = ttx;
    }

    public List getCurrentUnits() {
        if (tunitsFilter != null) {
            return tunitsFilter;
        }
        if (tunitsGlued != null) {
            return tunitsGlued;
        }
        Raw file = this.ttx.getCurrentFile();
        if (file != null) {
            return file.getTransUnits();
        }
        return null;
    }

    public int getCurrentUnitsSize() {
        if (tunitsFilter != null) {
            return tunitsFilter.size();
        }
        if (tunitsGlued != null) {
            return tunitsGlued.size();
        }
        Raw file = this.ttx.getCurrentFile();
        if (file != null) {
            return file.getTransUnits().size();
        }
        return 0;
    }

    public List getViewUnits() {
        Raw file = this.ttx.getCurrentFile();
        if (file != null) {
            List tunits = tunitsFilter != null ? tunitsFilter : (tunitsGlued != null ? tunitsGlued : file.getTransUnits());
            return tunits;
        }
        return null;
    }

    public List getFilteredUnits() {
        return tunitsFilter;
    }

    public static void setQAFilteredUnits(List list) {
        qafilter = true;
        tunitsFilter = list;
    }

    public static boolean hasQAFilter() {
        return qafilter;
    }

    public static void setFilteredWorkflow(boolean flag) {
        if (flag) {
            if (AppPreferences.searchMultiFilter) {
                if (tunitsFilter == null) {
                    tunitsFilter = new ArrayList();
                }
            } else {
                tunitsFilter = new ArrayList();
            }
        } else {
            qafilter = false;
            tunitsFilter = null;
            AppPreferences.searchMultiFilter = false;
            AppPreferences.replaceAndEdit = false;
            searchPattern = null;
            replaceInSource = false;
            replaceString = null;
        }
    }

    public List getGluedUnits() {
        return tunitsGlued;
    }

    public void setGluedWorkflow(boolean flag) {
        if (flag) {
            tunitsGlued = new ArrayList();
            this.fillGluedArray();
        } else {
            tunitsGlued = null;
        }
    }

    public void cancelGluedWorkflows() {
        if (tunitsGlued != null) {
            tunitsGlued.clear();
            tunitsGlued = null;
        }
    }

    private void fillGluedArray() {
        List files = this.prview.getProject().getProjects();
        if (files != null && files.size() > 0) {
            for (TTX ttx : files) {
                Raw currentFile = ttx.getCurrentFile();
                if (currentFile == null) continue;
                List units = currentFile.getTransUnits();
                for (TTXUnit tu : units) {
                    tunitsGlued.add(tu);
                }
            }
        }
    }

    private void fillSortedArray() {
        if (tunitsGlued != null) {
            tunitsFilter = new ArrayList(tunitsGlued);
            return;
        }
        Raw currentFile = this.ttx.getCurrentFile();
        if (currentFile != null) {
            List units = currentFile.getTransUnits();
            for (TTXUnit tu : units) {
                tunitsFilter.add(tu);
            }
        }
    }

    public TTXMenu getMenu() {
        if (this.menu == null) {
            this.menu = new TTXMenu(this.topui, this.prview.getProject());
        }
        return this.menu;
    }

    public void editFile() {
        Raw file = this.ttx.getCurrentFile();
        if (file != null) {
            TTXMenu tmenu = this.getMenu();
            tmenu.showTTX();
        }
    }

    public void showPopUp(Component comp, int x, int y, Object o) {
        TTXMenu fmenu = this.getMenu();
        fmenu.showPopUp(comp, x, y, o);
    }

    public void browseToUnit(int i) {
        this.currentTUIndex = i;
        this.fromIndex = i;
        if (qafilter) {
            String content = this.fetchQAGridContent(-2);
            this.goToContent(content, i);
        } else if (AppPreferences.projectView == 0) {
            String content = this.fetchContent(true, -2);
            this.goToContent(content, i);
        } else if (AppPreferences.projectView == 1) {
            String content = this.fetchGridContent(-2);
            this.goToContent(content, i);
        } else if (AppPreferences.projectView == 2) {
            String content = this.fetchContent(false, -2);
            this.goToContent(content, i);
        }
    }

    public void browseToNextUnit(int i) {
        if (i < this.fromIndex || i > this.fromIndex + AppPreferences.pagesize) {
            this.fromIndex = i - (AppPreferences.pagesize + 1);
            this.nextTUS();
        }
    }

    public void browseToPrevUnit(int i) {
        if (i <= this.fromIndex || i > this.fromIndex + AppPreferences.pagesize) {
            this.fromIndex = i;
            this.previousTUS();
        }
    }

    public void browseToLastUnit() {
        if (qafilter) {
            String content = this.fetchQAGridContent(0);
            this.showContent(content, true);
        } else if (AppPreferences.projectView == 0) {
            String content = this.fetchContent(true, 0);
            this.showContent(content, true);
        } else if (AppPreferences.projectView == 1) {
            String content = this.fetchGridContent(0);
            this.showContent(content, true);
        } else if (AppPreferences.projectView == 2) {
            String content = this.fetchContent(false, 0);
            this.showContent(content, true);
        }
    }

    public int getCurrentTUIndex() {
        return this.currentTUIndex;
    }

    public void sort() {
        if (tunitsFilter != null) {
            if (tunitsFilter.isEmpty()) {
                this.fillSortedArray();
            }
            Collections.sort(tunitsFilter);
            if (tunitsFilter.isEmpty()) {
                this.setViewMode(AppPreferences.projectView);
            } else {
                this.prview.getProject().edit("#0");
            }
        }
    }

    void sortByLength(boolean longToShort) {
        if (tunitsFilter != null) {
            if (tunitsFilter.isEmpty()) {
                this.fillSortedArray();
            }
            if (!longToShort) {
                Collections.sort(tunitsFilter, new Comparator<TTXUnit>(){

                    @Override
                    public int compare(TTXUnit tu1, TTXUnit tu2) {
                        String s1 = tu1.getSourceText();
                        String s2 = tu2.getSourceText();
                        int len1 = s1.length();
                        int len2 = s2.length();
                        return len1 - len2;
                    }
                });
            } else {
                Collections.sort(tunitsFilter, new Comparator<TTXUnit>(){

                    @Override
                    public int compare(TTXUnit tu1, TTXUnit tu2) {
                        String s1 = tu1.getSourceText();
                        String s2 = tu2.getSourceText();
                        int len1 = s1.length();
                        int len2 = s2.length();
                        return len2 - len1;
                    }
                });
            }
            if (tunitsFilter.isEmpty()) {
                this.setViewMode(AppPreferences.projectView);
            } else {
                this.prview.getProject().edit("#0");
            }
        }
    }

    public void viewRange(int from, int to) {
        List tunits;
        if (!tunitsNestedFilter.isEmpty()) {
            tunitsNestedFilter.clear();
        }
        if (tunitsFilter != null) {
            if (AppPreferences.searchMultiFilter) {
                tunitsNestedFilter.addAll(tunitsFilter);
            }
            tunitsFilter.clear();
        }
        if (--from > to) {
            return;
        }
        if (AppPreferences.searchMultiFilter && !tunitsNestedFilter.isEmpty()) {
            tunits = tunitsNestedFilter;
        } else if (tunitsGlued != null) {
            tunits = tunitsGlued;
        } else {
            Raw file = this.ttx.getCurrentFile();
            if (file != null) {
                tunits = file.getTransUnits();
            } else {
                return;
            }
        }
        while (from < tunits.size()) {
            Object o = tunits.get(from);
            if (o != null && o instanceof TTXUnit) {
                TTXUnit tu = (TTXUnit)o;
                tunitsFilter.add(tu);
            }
            if (++from != to) continue;
            break;
        }
        if (tunitsFilter != null) {
            if (tunitsFilter.isEmpty()) {
                this.setViewMode(AppPreferences.projectView);
            } else {
                this.prview.getProject().edit("#0");
            }
        } else {
            this.showContent("", true);
        }
    }

    public void search(String s, String r, int mode) {
        List files;
        qafilter = false;
        String content = this.fetchSearchGridContent(s, r, mode);
        if (tunitsFilter != null) {
            if (tunitsFilter.isEmpty()) {
                this.setViewMode(AppPreferences.projectView);
            } else {
                this.prview.getProject().edit("#0");
            }
        } else {
            this.showContent(content, true);
        }
        if (r != null && (files = this.prview.getProject().getProjects()) != null && tunitsGlued != null) {
            for (TTX t : files) {
                t.saved = false;
            }
        }
        if (AppPreferences.searchExtractRegExp && AppPreferences.searchType == 0) {
            String name = ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REG. EXP. RESULTS");
            this.topui.getResourceView().showExtractedSearchResults(this.extractedResults, name);
        }
    }

    private String fetchSearchGridContent(String s, String r, int mode) {
        this.query = s;
        this.queryType = mode;
        if (!tunitsNestedFilter.isEmpty()) {
            tunitsNestedFilter.clear();
        }
        if (tunitsFilter != null) {
            if (mode == 4 || mode == 5) {
                AppPreferences.searchMultiFilter = true;
            }
            if (AppPreferences.searchMultiFilter) {
                tunitsNestedFilter.addAll(tunitsFilter);
            }
            tunitsFilter.clear();
        }
        StringBuilder html = new StringBuilder();
        html.append(HTMLFormat.startHTML);
        html.append(HTMLFormat.styles);
        html.append(HTMLFormat.startBody);
        html.append(HTMLFormat.startGrid);
        Raw file = this.ttx.getCurrentFile();
        if (file != null) {
            int i = 0;
            Pattern p = AppPreferences.searchCase ? Pattern.compile(s) : Pattern.compile(s, 66);
            if (AppPreferences.replaceAndEdit) {
                searchPattern = p;
                replaceString = r;
                this.query = r;
                r = null;
                replaceInSource = mode == 4;
            }
            XMLElement tus = null;
            XMLElement tut = null;
            String content = null;
            int j = 0;
            List tunits = AppPreferences.searchMultiFilter && !tunitsNestedFilter.isEmpty() ? tunitsNestedFilter : (tunitsGlued != null ? tunitsGlued : file.getTransUnits());
            if (AppPreferences.searchExtractRegExp && AppPreferences.searchType == 0) {
                this.extractedResults = new TreeSet<String>();
            }
            for (Object o : tunits) {
                if (o instanceof TTXUnit) {
                    Matcher m;
                    Pattern p2;
                    String place;
                    TTXUnit tu = (TTXUnit)o;
                    String match = "";
                    String per = tu.getAttribute("MatchPercent");
                    if (per != null) {
                        match = per + "%";
                    }
                    if (mode == 9) {
                        tut = tu.getTarget();
                        if (tut == null) continue;
                        String target = tu.getTargetXMLText();
                        if (!match.equals("100%") || target.length() <= 0 || tunitsFilter == null) continue;
                        tunitsFilter.add(tu);
                        continue;
                    }
                    if (mode == 10) {
                        tut = tu.getTarget();
                        if (tut == null) continue;
                        String target = tu.getTargetXMLText();
                        if (match.equals("100%") && target.length() != 0 || tunitsFilter == null) continue;
                        tunitsFilter.add(tu);
                        continue;
                    }
                    if (mode == 11) {
                        if (!tu.bookmark || tunitsFilter == null) continue;
                        tunitsFilter.add(tu);
                        continue;
                    }
                    if (mode == 31) {
                        if (tu.bookmark || tunitsFilter == null) continue;
                        tunitsFilter.add(tu);
                        continue;
                    }
                    if (mode == 12) {
                        String targetContent = tu.getTargetText();
                        if (targetContent != null && targetContent.trim().length() != 0 || tunitsFilter == null) continue;
                        tunitsFilter.add(tu);
                        continue;
                    }
                    if (mode == 13) {
                        String targetContent = tu.getTargetText();
                        if (targetContent == null || targetContent.trim().length() <= 0 || tunitsFilter == null) continue;
                        tunitsFilter.add(tu);
                        continue;
                    }
                    if (mode == 36) {
                        int t = tu.getMatchType();
                        if (t != 2 || tunitsFilter == null) continue;
                        tunitsFilter.add(tu);
                        continue;
                    }
                    if (mode == 15) {
                        int t = tu.getMatchType();
                        int m2 = tu.getMatch();
                        if (m2 <= 99 || t != 1 || tunitsFilter == null) continue;
                        tunitsFilter.add(tu);
                        continue;
                    }
                    if (mode == 16) {
                        int m3 = tu.getMatch();
                        if (m3 <= 100 || tunitsFilter == null) continue;
                        tunitsFilter.add(tu);
                        continue;
                    }
                    if (mode == 17) {
                        int m4 = tu.getMatch();
                        if (m4 <= 101 || tunitsFilter == null) continue;
                        tunitsFilter.add(tu);
                        continue;
                    }
                    if (mode == 18) {
                        int m5 = tu.getMatch();
                        if (m5 >= 102 || tunitsFilter == null) continue;
                        tunitsFilter.add(tu);
                        continue;
                    }
                    if (mode == 19) {
                        int m6 = tu.getMatch();
                        if (m6 >= 101 || tunitsFilter == null) continue;
                        tunitsFilter.add(tu);
                        continue;
                    }
                    if (mode == 20) {
                        int t = tu.getMatchType();
                        int m7 = tu.getMatch();
                        if (m7 > 99 && t != 1) {
                            m7 = 99;
                        }
                        if (m7 >= 100 || tunitsFilter == null) continue;
                        tunitsFilter.add(tu);
                        continue;
                    }
                    if (mode == 26) {
                        String sourceContent = tu.getSourceText();
                        if (sourceContent == null || sourceContent.trim().length() <= 0) continue;
                        Set set = Placeables.getPlaceablesSet();
                        Iterator it2 = set.iterator();
                        while (it2.hasNext()) {
                            place = it2.next().toString();
                            if (place.charAt(0) != '|') {
                                if (!sourceContent.equals(place) || tunitsFilter == null) continue;
                                tunitsFilter.add(tu);
                                continue;
                            }
                            String place2 = place.substring(1);
                            p2 = Placeables.getPlaceablePattern(place);
                            if (p2 == null) {
                                p2 = Pattern.compile(place2);
                            }
                            if (!(m = p2.matcher(sourceContent)).matches() || tunitsFilter == null) continue;
                            tunitsFilter.add(tu);
                        }
                        continue;
                    }
                    if (mode == 27) {
                        String sourceContent = tu.getSourceText();
                        if (sourceContent == null || sourceContent.trim().length() <= 0) continue;
                        Set set = Placeables.getPlaceablesSet();
                        Iterator it2 = set.iterator();
                        while (it2.hasNext()) {
                            place = it2.next().toString();
                            if (place.charAt(0) != '|') {
                                if (sourceContent.indexOf(place) == -1 || tunitsFilter == null) continue;
                                tunitsFilter.add(tu);
                                continue;
                            }
                            String place2 = place.substring(1);
                            p2 = Placeables.getPlaceablePattern(place);
                            if (p2 == null) {
                                p2 = Pattern.compile(place2);
                            }
                            if (!(m = p2.matcher(sourceContent)).find() || tunitsFilter == null) continue;
                            tunitsFilter.add(tu);
                        }
                        continue;
                    }
                    StringBuffer sbHTML = new StringBuffer();
                    if (mode == 4) {
                        content = tu.getSourceText();
                    } else if (mode == 5) {
                        content = tu.getTargetText();
                    }
                    if (content != null) {
                        Matcher ma = p.matcher(content);
                        boolean tuAdded = false;
                        while (ma.find()) {
                            if (tunitsFilter != null && !tuAdded) {
                                tunitsFilter.add(tu);
                                tuAdded = true;
                            }
                            if (r != null) {
                                if (AppPreferences.preserveCaseWithReplacement) {
                                    String h;
                                    String key = ma.group();
                                    String f = XMLHelper.adaptCase(key, r);
                                    if (!f.equals(r)) {
                                        h = HTMLFormat.matchColorHTML + f + "</span>";
                                        ma.appendReplacement(sbHTML, h);
                                        continue;
                                    }
                                    h = HTMLFormat.matchColorHTML + r + "</span>";
                                    ma.appendReplacement(sbHTML, h);
                                    continue;
                                }
                                String h = HTMLFormat.matchColorHTML + r + "</span>";
                                ma.appendReplacement(sbHTML, h);
                                continue;
                            }
                            String m8 = ma.group();
                            String h = HTMLFormat.matchColorHTML + m8 + "</span>";
                            ma.appendReplacement(sbHTML, h);
                            if (!AppPreferences.searchExtractRegExp || AppPreferences.searchType != 0) continue;
                            this.extractedResults.add(m8);
                        }
                        if (r != null) {
                            this.ttx.saved = false;
                            if (mode == 4) {
                                tus = tu.getSource();
                                if (tus != null) {
                                    XMLHelper.replaceInXML(tus, p, r);
                                }
                            } else if (mode == 5 && (tut = tu.getTarget()) != null) {
                                XMLHelper.replaceInXML(tut, p, r);
                            }
                        }
                        if (sbHTML.length() > 0) {
                            ma.appendTail(sbHTML);
                            String result = XMLHelper.resolveXMLEntitiesBetweenSpanTags(sbHTML.toString());
                            result = result.replace("\n", "<br>");
                            int k = i + 1;
                            if (mode == 4) {
                                html.append(HTMLFormat.sRow);
                                html.append(HTMLFormat.TUContentRightColumn);
                                html.append("<p id=").append(i).append(">");
                                html.append(result);
                                html.append("</p>");
                                html.append(HTMLFormat.eCol);
                                html.append(HTMLFormat.TUContentRightColumn);
                                html.append("<p id=").append(i).append(">");
                                String target = tu.getTargetXMLText();
                                html.append(target);
                                html.append("</p>");
                                html.append(HTMLFormat.eCol);
                                html.append(HTMLFormat.TUStatusColumn);
                                html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                                html.append(HTMLFormat.eCol);
                                html.append(HTMLFormat.eRow);
                            } else if (mode == 5) {
                                html.append(HTMLFormat.sRow);
                                html.append(HTMLFormat.TUContentRightColumn);
                                html.append("<p id=").append(i).append(">");
                                String source = tu.getSourceXMLText();
                                html.append(source);
                                html.append("</p>");
                                html.append(HTMLFormat.eCol);
                                html.append(HTMLFormat.TUContentRightColumn);
                                html.append("<p id=").append(i).append(">");
                                html.append(result.toString());
                                html.append("</p>");
                                html.append(HTMLFormat.eCol);
                                html.append(HTMLFormat.TUStatusColumn);
                                html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                                html.append(HTMLFormat.eCol);
                                html.append(HTMLFormat.eRow);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            html.append(HTMLFormat.endTable);
            if (mode == 5 && r != null) {
                this.topui.getTargetView().replaceText(p, r);
            }
        }
        return html.toString();
    }

    public String fetchHTMLContent() {
        String starthtml = "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head><body style=\"font-family:verdana;font-size:14px;\">";
        String endhtml = "</body></html>";
        String endTable = "</TABLE>";
        String startTable = "<TABLE WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLPADDING=2 CELLSPACING=2>";
        String sRow = "<TR>";
        String eRow = "</TR>";
        String notesCol = "<TD BGCOLOR=E5D9B7 BORDER=0 VALIGN=TOP ALIGN=LEFT>";
        String sIDCol = "<TD WIDTH=2% style=\"font-family:verdana;font-size:12px;\" BGCOLOR=#E5D9B7 BORDER=0 VALIGN=CENTER ALIGN=LEFT>";
        String sCol = AppPreferences.projectView != 0 ? "<TD WIDTH=40% BORDER=0 VALIGN=TOP ALIGN=LEFT bgcolor=white>" : "<TD WIDTH=80% BORDER=0 VALIGN=TOP ALIGN=LEFT bgcolor=white>";
        String eCol = "</TD>";
        StringBuilder html = new StringBuilder();
        html.append(starthtml);
        html.append(startTable);
        Raw file = this.ttx.getCurrentFile();
        if (file != null) {
            int id = 1;
            List tunits = file.getTransUnits();
            for (Object o : tunits) {
                if (!(o instanceof TTXUnit)) continue;
                TTXUnit tu = (TTXUnit)o;
                html.append("\n");
                html.append(sRow);
                html.append(sIDCol);
                html.append(Integer.toString(id));
                html.append(eCol);
                html.append(sCol);
                html.append("<p>");
                String source = tu.getSourceXMLText();
                html.append(source);
                html.append("</p>");
                html.append(eCol);
                html.append(sCol);
                html.append("<p>");
                String target = tu.getTargetXMLText();
                html.append(target);
                html.append("</p>");
                html.append(eCol);
                html.append(eRow);
                ++id;
            }
        }
        html.append(endTable);
        html.append(endhtml);
        return html.toString();
    }

    public String fetchQAGridContent(int mode) {
        StringBuilder html = new StringBuilder();
        html.append(HTMLFormat.startHTML);
        html.append(HTMLFormat.styles);
        html.append(HTMLFormat.startBody);
        Raw file = this.ttx.getCurrentFile();
        if (file != null) {
            int i = 0;
            int gap = AppPreferences.pagesize;
            int marked = -1;
            if (tunitsFilter == null) {
                return "";
            }
            List list = tunitsFilter;
            int size = list.size();
            if (mode == 0) {
                this.fromIndex = size - gap;
            } else if (mode == 1) {
                this.fromIndex += gap;
            } else if (mode == -1) {
                this.fromIndex = this.fromIndex == 0 ? size - gap : (this.fromIndex < gap ? 0 : (this.fromIndex -= gap));
            } else if (mode == -2) {
                marked = this.fromIndex;
                this.fromIndex = size >= gap && this.fromIndex >= gap ? (this.fromIndex -= gap / 2) : 0;
            }
            if (this.fromIndex >= size || gap >= size) {
                this.fromIndex = 0;
            }
            i = this.fromIndex;
            int j = gap;
            int k = -1;
            html.append(HTMLFormat.startTableQA);
            html.append("<tr><th COLOR=WHITE BGCOLOR=").append(Colors.colorProjectHTML).append(">TRANSLATION UNITS:</th><th COLOR=WHITE BGCOLOR=").append(Colors.colorProjectHTML).append(">").append(Integer.toString(size)).append("</th><th></th></tr>");
            while (i < size) {
                k = i + 1;
                Object o = list.get(i);
                if (o instanceof TTXUnit) {
                    TTXUnit tu = (TTXUnit)o;
                    String match = "";
                    String per = tu.getAttribute("MatchPercent");
                    if (per != null) {
                        match = per + "%";
                    }
                    String target = tu.getTargetXMLText();
                    String source = tu.getSourceXMLText();
                    if (source.length() == 0 && target.length() == 0) {
                        ++i;
                        continue;
                    }
                    html.append(HTMLFormat.sRow);
                    html.append(HTMLFormat.TUStatusColQA);
                    if (tu.bookmark) {
                        html.append("<span style=\"color:red;font:bold\">B </span>");
                    }
                    if (marked == i) {
                        html.append("<A style=\"color:white;background:#FF6600\" HREF=#").append(i).append("><b>").append(match).append(" ").append(k).append("\u200b</b></A>");
                    } else {
                        html.append("<A HREF=#").append(i).append("><b>").append(match).append(" ").append(k).append("\u200b</b></A>");
                    }
                    html.append(HTMLFormat.eCol);
                    XMLElement tut = tu.getTarget();
                    String column = tut != null ? (match.equals("100%") && target.length() > 0 ? (marked == i ? HTMLFormat.currentTUReviewLeftCol : HTMLFormat.TUReviewLeftCol) : (marked == i ? HTMLFormat.currentTUContentRightColumn : HTMLFormat.TUContentRightColumn)) : (marked == i ? HTMLFormat.currentTUContentRightColumn : HTMLFormat.TURightColumn);
                    boolean firstIssue = false;
                    List issues = tu.getIssues();
                    for (Issue issue : issues) {
                        String message;
                        String[] messages = issue.getMessages();
                        for (int l = 0; l < messages.length && (message = messages[l]) != null; ++l) {
                            if (!firstIssue) {
                                if (marked == i) {
                                    html.append(HTMLFormat.TULeftColQA);
                                    html.append("<p style=\"color:white\">");
                                } else {
                                    html.append(HTMLFormat.TULeftColQA);
                                    html.append("<p style=\"color:white\">");
                                }
                                html.append(message);
                                html.append("</p>");
                                html.append(HTMLFormat.eCol);
                                html.append(HTMLFormat.eRow);
                                firstIssue = true;
                                continue;
                            }
                            html.append(HTMLFormat.sRow);
                            if (marked == i) {
                                html.append(HTMLFormat.TULeftColQA);
                                html.append("<p style=\"color:white\">");
                            } else {
                                html.append(HTMLFormat.TULeftColQA);
                                html.append("<p style=\"color:white\">");
                            }
                            html.append(message);
                            html.append("</p>");
                            html.append(HTMLFormat.eCol);
                            if (++l < messages.length) {
                                message = messages[l];
                                if (message != null) {
                                    if (marked == i) {
                                        html.append(HTMLFormat.TULeftColQA);
                                        html.append("<p style=\"color:white\">");
                                    } else {
                                        html.append(HTMLFormat.TULeftColQA);
                                        html.append("<p style=\"color:white\">");
                                    }
                                    html.append(message);
                                    html.append("</p>");
                                    html.append(HTMLFormat.eCol);
                                } else {
                                    html.append(HTMLFormat.TULeftColQA);
                                    html.append(HTMLFormat.eCol);
                                }
                            } else {
                                html.append(HTMLFormat.TULeftColQA);
                                html.append(HTMLFormat.eCol);
                            }
                            html.append(HTMLFormat.eRow);
                        }
                    }
                    html.append(HTMLFormat.sRow);
                    html.append(column);
                    if (marked == i) {
                        html.append("<p><b>");
                    } else {
                        html.append("<p id=").append(i).append(">");
                    }
                    html.append(source);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(column);
                    if (marked == i) {
                        html.append("<p><b>");
                    } else {
                        html.append("<p id=").append(i).append(">");
                    }
                    html.append(target);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                }
                ++i;
                if (--gap != 0) continue;
                break;
            }
            html.append(HTMLFormat.endTable);
            html.append(HTMLFormat.endHTML);
        }
        return html.toString();
    }

    public String fetchGridContent(int mode) {
        StringBuilder html = new StringBuilder();
        html.append(HTMLFormat.startHTML);
        html.append(HTMLFormat.styles);
        html.append(HTMLFormat.startBody);
        Raw file = this.ttx.getCurrentFile();
        if (file != null) {
            int size;
            html.append(HTMLFormat.startGrid);
            int i = 0;
            int gap = AppPreferences.pagesize;
            int marked = -1;
            List list = tunitsFilter != null ? tunitsFilter : (tunitsGlued != null ? tunitsGlued : file.getTransUnits());
            this.currentTUSize = size = list.size();
            html.append("<tr><th COLOR=WHITE BGCOLOR=").append(Colors.colorProjectHTML).append(">TRANSLATION UNITS:</th><th COLOR=WHITE BGCOLOR=").append(Colors.colorProjectHTML).append(">").append(Integer.toString(size)).append("</th><th></th></tr>");
            if (mode == 0) {
                this.fromIndex = size - gap;
            } else if (mode == 1) {
                this.fromIndex += gap;
            } else if (mode == -1) {
                this.fromIndex = this.fromIndex == 0 ? size - gap : (this.fromIndex < gap ? 0 : (this.fromIndex -= gap));
            } else if (mode == -2) {
                marked = this.fromIndex;
                this.fromIndex = size >= gap && this.fromIndex >= gap ? (this.fromIndex -= gap / 2) : 0;
            }
            if (this.fromIndex >= size || gap >= size) {
                this.fromIndex = 0;
            }
            i = this.fromIndex;
            int k = -1;
            while (i < size) {
                k = i + 1;
                Object o = list.get(i);
                if (o instanceof TTXUnit) {
                    String h;
                    String m;
                    Matcher ma;
                    Pattern p;
                    StringBuffer sbHTML;
                    TTXUnit tu = (TTXUnit)o;
                    String match = "";
                    String per = tu.getAttribute("MatchPercent");
                    if (per != null) {
                        match = per + "%";
                    }
                    String target = tu.getTargetXMLText();
                    String source = tu.getSourceXMLText();
                    if (source.length() == 0 && target.length() == 0) {
                        ++i;
                        continue;
                    }
                    int mm = tu.getMatch();
                    String column = marked == i ? HTMLFormat.currentTUContentRightColumn : HTMLFormat.TUContentRightColumn;
                    html.append(HTMLFormat.sRow);
                    html.append(column);
                    if (marked == i) {
                        html.append("<p>");
                        if (tunitsFilter != null && this.queryType == 4 && this.query != null) {
                            sbHTML = new StringBuffer();
                            p = AppPreferences.searchCase ? Pattern.compile(this.query) : Pattern.compile(this.query, 66);
                            ma = p.matcher(source);
                            while (ma.find()) {
                                m = ma.group();
                                if (m.indexOf(36) != -1) {
                                    m = m.replace("$", "\\$");
                                }
                                h = HTMLFormat.matchColorHTML + m + "</span>";
                                ma.appendReplacement(sbHTML, h);
                            }
                            ma.appendTail(sbHTML);
                            source = sbHTML.toString();
                        }
                    } else {
                        html.append("<p id=").append(i).append(">");
                    }
                    html.append(source);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(column);
                    if (marked == i) {
                        html.append("<p>");
                        if (tunitsFilter != null && this.queryType == 5 && this.query != null) {
                            sbHTML = new StringBuffer();
                            p = AppPreferences.searchCase ? Pattern.compile(this.query) : Pattern.compile(this.query, 66);
                            ma = p.matcher(target);
                            while (ma.find()) {
                                m = ma.group();
                                if (m.indexOf(36) != -1) {
                                    m = m.replace("$", "\\$");
                                }
                                h = HTMLFormat.matchColorHTML + m + "</span>";
                                ma.appendReplacement(sbHTML, h);
                            }
                            ma.appendTail(sbHTML);
                            target = sbHTML.toString();
                        }
                    } else {
                        html.append("<p id=").append(i).append(">");
                    }
                    html.append(target);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    if (match.equals("100%") && target.length() > 0) {
                        html.append(HTMLFormat.TUReviewStatusColumn);
                        html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                        if (tu.bookmark) {
                            html.append(HTMLFormat.subStart);
                            html.append('B');
                            html.append(HTMLFormat.subEnd);
                        }
                        html.append("<br>");
                        html.append(HTMLFormat.match100SDL);
                        html.append(match);
                        html.append("</span>");
                    } else {
                        int t;
                        html.append(HTMLFormat.TUStatusColumn);
                        html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                        if (tu.bookmark) {
                            html.append(HTMLFormat.subStart);
                            html.append('B');
                            html.append(HTMLFormat.subEnd);
                        }
                        html.append("<br>");
                        if (mm > 99 && (t = tu.getMatchType()) == 1) {
                            if (mm < 101) {
                                html.append(HTMLFormat.match100);
                            } else if (mm == 101) {
                                html.append(HTMLFormat.match101);
                            } else if (mm == 102) {
                                html.append(HTMLFormat.match102);
                            }
                            html.append(mm);
                            html.append("%");
                            html.append("</span>");
                        }
                    }
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                } else if (o instanceof XMLElement) {
                    XMLElement xml = (XMLElement)o;
                    String name = xml.getName();
                    html.append(HTMLFormat.sRow);
                    html.append(HTMLFormat.TURightColumn);
                    html.append("<a href=$").append(i).append("<b>").append(name).append("</b></a>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.TURightColumn);
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.TUStatusColumn);
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                }
                ++i;
                if (--gap != 0) continue;
                break;
            }
            html.append(HTMLFormat.endTable);
            html.append(HTMLFormat.endHTML);
        }
        return html.toString();
    }

    public String fetchContent(boolean lang, int mode) {
        StringBuilder html = new StringBuilder();
        html.append(HTMLFormat.startHTML);
        html.append(HTMLFormat.styles);
        html.append(HTMLFormat.startBody);
        Raw file = this.ttx.getCurrentFile();
        if (file != null) {
            int size;
            int i = 0;
            int gap = AppPreferences.pagesize;
            int marked = -1;
            List list = tunitsFilter != null ? tunitsFilter : (tunitsGlued != null ? tunitsGlued : file.getTransUnits());
            this.currentTUSize = size = list.size();
            if (mode == 0) {
                this.fromIndex = size - gap;
            } else if (mode == 1) {
                this.fromIndex += gap;
            } else if (mode == -1) {
                this.fromIndex = this.fromIndex == 0 ? size - gap : (this.fromIndex < gap ? 0 : (this.fromIndex -= gap));
            } else if (mode == -2) {
                marked = this.fromIndex;
                this.fromIndex = size >= gap && this.fromIndex >= gap ? (this.fromIndex -= gap / 2) : 0;
            }
            if (this.fromIndex >= size || gap >= size) {
                this.fromIndex = 0;
            }
            i = this.fromIndex;
            int j = gap;
            int k = -1;
            html.append(HTMLFormat.startTableTarget);
            while (i < size) {
                k = i + 1;
                Object o = list.get(i);
                if (o instanceof TTXUnit) {
                    TTXUnit tu = (TTXUnit)o;
                    String match = "";
                    String per = tu.getAttribute("MatchPercent");
                    if (per != null) {
                        match = per + "%";
                    }
                    String target = tu.getTargetXMLText();
                    String source = tu.getSourceXMLText();
                    if (source.length() == 0 && target.length() == 0) {
                        ++i;
                        continue;
                    }
                    String content = lang ? target : source;
                    XMLElement tut = tu.getTarget();
                    String column = tut != null ? (match.equals("100%") && target.length() > 0 ? (marked == i ? HTMLFormat.currentTUTargetReviewLeftCol : HTMLFormat.TUTargetReviewLeftCol) : (marked == i ? HTMLFormat.currentTUTargetLeftColumn : HTMLFormat.TUTargetLeftColumn)) : (marked == i ? HTMLFormat.currentTUTargetLeftColumn : HTMLFormat.TUTargetLeftColumn);
                    html.append(HTMLFormat.sRow);
                    html.append(column);
                    if (marked == i) {
                        html.append("<p><b>");
                        if (tunitsFilter != null && this.queryType == 5 && this.query != null) {
                            StringBuffer sbHTML = new StringBuffer();
                            Pattern p = AppPreferences.searchCase ? Pattern.compile(this.query) : Pattern.compile(this.query, 66);
                            Matcher ma = p.matcher(content);
                            while (ma.find()) {
                                String m = ma.group();
                                String h = HTMLFormat.matchColorHTML + m + "</span>";
                                ma.appendReplacement(sbHTML, h);
                            }
                            ma.appendTail(sbHTML);
                            content = sbHTML.toString();
                        }
                    } else {
                        html.append("<p id=").append(i).append(">");
                    }
                    html.append(content);
                    html.append("</p>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.TUTargetStatusColumn);
                    if (tu.bookmark) {
                        html.append("<div style=\"color:red;font:bold\">B</div>");
                    }
                    if (marked == i) {
                        html.append("<A style=\"color:white;background:#FF6600\" HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                    } else {
                        html.append("<A HREF=#").append(i).append("><b>").append(k).append("\u200b</b></A>");
                    }
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                } else if (o instanceof XMLElement) {
                    XMLElement xml = (XMLElement)o;
                    String name = xml.getName();
                    html.append(HTMLFormat.sRow);
                    html.append(HTMLFormat.TUTargetLeftColumn);
                    html.append("<a href=$").append(i).append("<b>").append(name).append("</b></a>");
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.TUTargetLeftColumn);
                    html.append(HTMLFormat.eCol);
                    html.append(HTMLFormat.eRow);
                }
                ++i;
                if (--gap != 0) continue;
                break;
            }
            html.append(HTMLFormat.endTable);
            html.append(HTMLFormat.endHTML);
        }
        return html.toString();
    }

    public Statistics getStatistics() {
        ArrayList files;
        Statistics stats = new Statistics();
        List pr = this.prview.getProject().getProjects();
        if (pr != null && tunitsGlued != null) {
            files = new ArrayList();
            for (Object object : pr) {
                if (!(object instanceof TTX)) continue;
                TTX x = (TTX)object;
                files.addAll(x.getFiles());
            }
        } else {
            files = this.ttx.getFiles();
        }
        if (files.size() > 0) {
            WordCount wordCountAllSource = new WordCount();
            WordCount wordCountAllTarget = new WordCount();
            WordCount wordCountUntranslated = new WordCount();
            WordCount wordCountChecked = new WordCount();
            WordCount wordCountRepetions = new WordCount();
            HashSet<String> set = new HashSet<String>();
            for (Raw currentFile : files) {
                List units = tunitsFilter != null ? tunitsFilter : currentFile.getTransUnits();
                for (TTXUnit tu : units) {
                    String t;
                    String s;
                    ++stats.allSegments;
                    int status = tu.getState();
                    if (status == 1) {
                        ++stats.checkedSegments;
                    }
                    if ((s = tu.getSourceText()).length() > 0) {
                        boolean adds = set.add(s);
                        if (!adds) {
                            wordCountRepetions.doWordCount(s);
                            stats.repeatedChars += (float)s.length();
                            ++stats.repeatedSegments;
                        }
                        wordCountAllSource.doWordCount(s);
                        if (status == 1) {
                            wordCountChecked.doWordCount(s);
                        }
                    }
                    if ((t = tu.getTargetText()) != null && t.length() > 0) {
                        wordCountAllTarget.doWordCount(t);
                    }
                    if (t == null || t.trim().length() == 0) {
                        ++stats.untranslatedSegments;
                        wordCountUntranslated.doWordCount(s);
                        continue;
                    }
                    ++stats.translatedSegments;
                }
                if (tunitsFilter == null) continue;
                break;
            }
            if (stats.allSegments == 0) {
                return null;
            }
            stats.allSourceWords = wordCountAllSource.getWordCount();
            stats.allSourceChars = wordCountAllSource.getAllCharsCount();
            stats.allSourceCharsNoWhites = wordCountAllSource.getCharsCount();
            stats.allTargetWords = wordCountAllTarget.getWordCount();
            stats.allTargetChars = wordCountAllTarget.getAllCharsCount();
            stats.allTargetCharsNoWhites = wordCountAllTarget.getCharsCount();
            stats.untranslatedWords = wordCountUntranslated.getWordCount();
            stats.untranslatedChars = wordCountUntranslated.getAllCharsCount();
            stats.untranslatedCharsNoWhites = wordCountUntranslated.getCharsCount();
            stats.checkedWords = wordCountChecked.getWordCount();
            stats.checkedChars = wordCountChecked.getAllCharsCount();
            stats.checkedCharsNoWhites = wordCountChecked.getCharsCount();
            stats.translatedWords = stats.allSourceWords - stats.untranslatedWords;
            stats.translatedChars = stats.allSourceChars - stats.untranslatedChars;
            stats.translatedCharsNoWhites = stats.allSourceCharsNoWhites - stats.untranslatedCharsNoWhites;
            stats.repeatedWords = wordCountRepetions.getWordCount();
            stats.repeatedChars = wordCountRepetions.getAllCharsCount();
            stats.repeatedCharsNoWhites = wordCountRepetions.getCharsCount();
            if (!AppPreferences.updateProjectStatistics) {
                Frequencer freq = this.topui.getFrequencer();
                if (freq == null) {
                    this.topui.setFrequencer();
                    freq = this.topui.getFrequencer();
                }
                freq.findProjectHFWords();
                int[] freqWords = freq.getRepetitions2();
                stats.repeatedInternalWords = freqWords[0];
                stats.repeatedInternalCharsNoWhites = freqWords[1];
                stats.repeatedInternalChars = freqWords[2];
                stats.allSourceInteralChars = freqWords[3];
            }
            stats.setSourceBillingMessage(wordCountAllSource.getCountMessage());
            stats.setTargetBillingMessage(wordCountAllTarget.getCountMessage());
            return stats;
        }
        return null;
    }

    public String[] fetchCountInfo() {
        ArrayList files;
        String[] counts = new String[29];
        List pr = this.prview.getProject().getProjects();
        if (pr != null && tunitsGlued != null) {
            files = new ArrayList();
            for (Object object : pr) {
                if (!(object instanceof TTX)) continue;
                TTX x = (TTX)object;
                files.addAll(x.getFiles());
            }
        } else {
            files = this.ttx.getFiles();
        }
        if (files.size() > 0) {
            WordCount wordCountAllS = new WordCount();
            WordCount wordCountAllT = new WordCount();
            WordCount wordCountUTS = new WordCount();
            WordCount wordCountRep = new WordCount();
            HashSet<String> set = new HashSet<String>();
            int total = 0;
            int rep = 0;
            int repNo = 0;
            int segments = 0;
            float translated = 0.0f;
            float untranslated = 0.0f;
            for (Raw currentFile : files) {
                List units = tunitsFilter != null ? tunitsFilter : currentFile.getTransUnits();
                for (TTXUnit tu : units) {
                    String t;
                    ++segments;
                    String s = tu.getSourceText();
                    if (s.length() > 0) {
                        total += s.length();
                        boolean adds = set.add(s);
                        if (!adds) {
                            wordCountRep.doWordCount(s);
                            rep += s.length();
                            ++repNo;
                        }
                        wordCountAllS.doWordCount(s);
                    }
                    if ((t = tu.getTargetText()) != null && t.length() > 0) {
                        wordCountAllT.doWordCount(t);
                    }
                    if (t == null || t.trim().length() == 0) {
                        wordCountUTS.doWordCount(s);
                        untranslated += 1.0f;
                        continue;
                    }
                    translated += 1.0f;
                }
                if (tunitsFilter == null) continue;
                break;
            }
            if (segments == 0) {
                return null;
            }
            int allSWords = wordCountAllS.getWordCount();
            float allSWhiteChars = wordCountAllS.getAllCharsCount();
            int allSChars = wordCountAllS.getCharsCount();
            int allTWords = wordCountAllT.getWordCount();
            float allTWhiteChars = wordCountAllT.getAllCharsCount();
            int allTChars = wordCountAllT.getCharsCount();
            int unTrWords = wordCountUTS.getWordCount();
            float unTrWhiteChars = wordCountUTS.getAllCharsCount();
            int unTrChars = wordCountUTS.getCharsCount();
            int trWords = allSWords - unTrWords;
            float trWhiteChars = allSWhiteChars - unTrWhiteChars;
            int trChars = allSChars - unTrChars;
            int repWords = wordCountRep.getWordCount();
            int repWhiteChars = wordCountRep.getAllCharsCount();
            int repChars = wordCountRep.getCharsCount();
            NumberFormat nf = NumberFormat.getInstance(Locale.US);
            nf.setMaximumFractionDigits(1);
            nf.setGroupingUsed(false);
            counts[0] = Integer.toString((int)translated);
            counts[1] = Integer.toString(trWords);
            counts[2] = Integer.toString(trChars);
            counts[3] = Integer.toString((int)trWhiteChars);
            float proc = trWhiteChars * 100.0f / allSWhiteChars;
            String procString = nf.format(proc);
            counts[4] = procString + "%";
            counts[5] = Integer.toString((int)untranslated);
            counts[6] = Integer.toString(unTrWords);
            counts[7] = Integer.toString(unTrChars);
            counts[8] = Integer.toString((int)unTrWhiteChars);
            proc = unTrWhiteChars * 100.0f / allSWhiteChars;
            procString = nf.format(proc);
            counts[9] = procString + "%";
            counts[10] = Integer.toString(segments);
            counts[11] = Integer.toString(allSWords);
            counts[12] = Integer.toString(allSChars);
            counts[13] = Integer.toString((int)allSWhiteChars);
            counts[14] = "100%";
            counts[15] = Integer.toString(repNo);
            counts[16] = Integer.toString(repWords);
            counts[17] = Integer.toString(repChars);
            counts[18] = Integer.toString(repWhiteChars);
            if (total > 0) {
                int iproc = rep * 100 / total;
                procString = Integer.toString(iproc);
                counts[19] = procString + "%";
            }
            if (!AppPreferences.updateProjectStatistics) {
                Frequencer freq = this.topui.getFrequencer();
                if (freq == null) {
                    this.topui.setFrequencer();
                    freq = this.topui.getFrequencer();
                }
                freq.findProjectHFWords();
                int[] freqWords = freq.getRepetitions2();
                counts[20] = Integer.toString(freqWords[0]);
                counts[21] = Integer.toString(freqWords[1]);
                counts[22] = Integer.toString(freqWords[2]);
                counts[23] = Integer.toString(freqWords[3]) + "%";
            }
            counts[24] = Integer.toString(allTWords);
            counts[25] = Integer.toString(allTChars);
            counts[26] = Integer.toString((int)allTWhiteChars);
            counts[27] = wordCountAllS.getCountMessage();
            counts[28] = wordCountAllT.getCountMessage();
            return counts;
        }
        return null;
    }

    public void replaceBeforeEdit(TTXUnit tu) {
        if (replaceString != null) {
            if (replaceInSource) {
                XMLElement tus = tu.getSource();
                if (tus != null) {
                    XMLHelper.replaceInXML(tus, searchPattern, replaceString);
                }
            } else {
                XMLElement tut = tu.getTarget();
                if (tut != null) {
                    XMLHelper.replaceInXML(tut, searchPattern, replaceString);
                }
            }
        }
    }

    public void goToContent(String s, int i) {
        try {
            JTextPane pane = this.prview.getProjectPane();
            String type = pane.getContentType();
            if (!type.equals("text/html")) {
                pane.setContentType("text/html");
            }
            HTMLDocument htmldoc = (HTMLDocument)pane.getDocument();
            htmldoc.setInnerHTML(htmldoc.getDefaultRootElement(), s);
            String text = htmldoc.getText(0, htmldoc.getLength());
            String ii = Integer.toString(i + 1) + "\u200b";
            int index = text.indexOf(ii);
            if (index != -1) {
                this.prview.scrollToSegment(index);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showContent(String s, boolean start) {
        try {
            JTextPane pane = this.prview.getProjectPane();
            String type = pane.getContentType();
            if (!type.equals("text/html")) {
                pane.setContentType("text/html");
            }
            HTMLDocument htmldoc = (HTMLDocument)pane.getDocument();
            htmldoc.setInnerHTML(htmldoc.getDefaultRootElement(), s);
            if (start) {
                JViewport vp = (JViewport)pane.getParent();
                final JScrollPane scroll = (JScrollPane)vp.getParent();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ TTXView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        scroll.getVerticalScrollBar().setValue(0);
                    }
                });
            } else {
                JViewport vp = (JViewport)pane.getParent();
                final JScrollPane scroll = (JScrollPane)vp.getParent();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ TTXView this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        JScrollBar bar = scroll.getVerticalScrollBar();
                        bar.setValue(bar.getMaximum());
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setViewMode(int mode) {
        if (qafilter) {
            String content = this.fetchQAGridContent(0);
            this.showContent(content, false);
        } else if (mode == 1) {
            String content = this.fetchGridContent(0);
            this.showContent(content, false);
        } else if (mode == 0) {
            String content = this.fetchContent(true, 0);
            this.showContent(content, false);
        } else if (mode == 2) {
            String content = this.fetchContent(false, 0);
            this.showContent(content, false);
        }
    }

    public void refreshView() {
        if (this.currentTUIndex != -1) {
            this.browseToUnit(this.currentTUIndex);
        } else {
            this.setViewMode(AppPreferences.projectView);
        }
    }

    void viewContent(final TTXUnit tu) {
        SwingUtilities.invokeLater(new Runnable(){
            final /* synthetic */ TTXView this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                JTextPane sourceTextArea = this.this$0.topui.getSourcePane();
                JTextPane targetTextArea = this.this$0.topui.getTargetPane();
                if (sourceTextArea.getClientProperty("content") == null) {
                    sourceTextArea.putClientProperty("content", sourceTextArea.getText());
                }
                if (targetTextArea.getClientProperty("content") == null) {
                    targetTextArea.putClientProperty("content", targetTextArea.getText());
                }
                String word = this.this$0.topui.getResourceView().getLookUpText();
                String source = tu.getSourceText();
                sourceTextArea.setText(source);
                sourceTextArea.setCaretPosition(0);
                if (word != null && word.length() > 0) {
                    this.this$0.topui.getSourceView().highlightWord(word);
                }
                String target = tu.getTargetText();
                targetTextArea.setText(target);
                targetTextArea.setCaretPosition(0);
                if (word != null && word.length() > 0) {
                    this.this$0.topui.getTargetView().highlightWord(word);
                }
            }
        });
    }

    public void nextTUS() {
        if (qafilter) {
            String content = this.fetchQAGridContent(1);
            this.showContent(content, true);
        } else if (AppPreferences.projectView == 0) {
            String content = this.fetchContent(true, 1);
            this.showContent(content, true);
        } else if (AppPreferences.projectView == 1) {
            String content = this.fetchGridContent(1);
            this.showContent(content, true);
        } else if (AppPreferences.projectView == 2) {
            String content = this.fetchContent(false, 1);
            this.showContent(content, true);
        }
    }

    public void previousTUS() {
        if (qafilter) {
            String content = this.fetchQAGridContent(-1);
            this.showContent(content, true);
        } else if (AppPreferences.projectView == 0) {
            String content = this.fetchContent(true, -1);
            this.showContent(content, true);
        } else if (AppPreferences.projectView == 1) {
            String content = this.fetchGridContent(-1);
            this.showContent(content, true);
        } else if (AppPreferences.projectView == 2) {
            String content = this.fetchContent(false, -1);
            this.showContent(content, true);
        }
    }

    public void updateContentView() {
        Raw currentFile = this.ttx.getCurrentFile();
        if (currentFile != null) {
            try {
                JTextPane pane = this.prview.getProjectPane();
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                int index = currentFile.getTransUnits().size() - 1;
                int k = index + 1;
                String html = "<TR><TD BORDER=0 NOWRAP VALIGN=CENTER ALIGN=CENTER><A HREF=#" + index + "<b>" + k + "</b></A></TD></TR>";
                int ne = doc.getDefaultRootElement().getElement(0).getElement(1).getElementCount();
                Element elem = doc.getDefaultRootElement().getElement(0).getElement(1).getElement(ne - 1);
                if (elem != null) {
                    doc.insertBeforeEnd(elem, html);
                    JViewport vp = (JViewport)pane.getParent();
                    final JScrollPane scroll = (JScrollPane)vp.getParent();
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ TTXView this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            JScrollBar bar = scroll.getVerticalScrollBar();
                            bar.setValue(bar.getMaximum());
                        }
                    });
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(TTXView.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(TTXView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    static {
        tunitsNestedFilter = new ArrayList();
    }
}

