/*
 * Decompiled with CFR 0.152.
 */
package translator.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private Image tileimage;
    private int tilewidth;
    private int tileheight;
    private Rectangle rb;
    private Insets ri;

    public ImagePanel(Image tile) {
        this.setTileImage(tile);
        this.setOpaque(true);
        this.rb = new Rectangle(0, 0, 1, 1);
        this.ri = new Insets(0, 0, 0, 0);
    }

    public ImagePanel(Image tile, LayoutManager mgr, boolean isDB) {
        super(mgr, isDB);
        this.setTileImage(tile);
        this.setOpaque(true);
        this.rb = new Rectangle(0, 0, 1, 1);
        this.ri = new Insets(0, 0, 0, 0);
    }

    public Image getTileImage() {
        return this.tileimage;
    }

    public void setTileImage(Image tile) {
        this.tileimage = tile;
        this.tilewidth = 0;
        this.tileheight = 0;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.tileimage != null && this.tilewidth <= 0) {
            this.tileheight = this.tileimage.getHeight(this);
            this.tilewidth = this.tileimage.getWidth(this);
        }
        if (this.tileimage != null && this.tilewidth > 0) {
            Color bg = this.getBackground();
            this.getBounds(this.rb);
            Insets riv = this.getInsets(this.ri);
            this.rb.translate(riv.left, riv.top);
            this.rb.width -= riv.left + riv.right;
            this.rb.height -= riv.top + riv.bottom;
            Shape ccache = g.getClip();
            g.clipRect(this.rb.x, this.rb.y, this.rb.width, this.rb.height);
            for (int yp = this.rb.y; yp < this.rb.y + this.rb.height; yp += this.tileheight) {
                for (int xp = this.rb.x; xp < this.rb.x + this.rb.width; xp += this.tilewidth) {
                    g.drawImage(this.tileimage, xp, yp, bg, this);
                }
            }
            g.setClip(ccache);
        }
    }
}

