/*
 * Decompiled with CFR 0.152.
 */
package translator.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.border.Border;

public class RoundedBorder
implements Border {
    Color color = new Color(250, 250, 250);
    Color background = new Color(255, 255, 255);
    Stroke smallStroke = new BasicStroke(4.0f);
    Stroke largeStroke = new BasicStroke(15.0f);
    int thickness = 4;
    int insetThickness = 5;
    Insets insets = new Insets(this.insetThickness, this.insetThickness, this.insetThickness, this.insetThickness);

    public RoundedBorder(Color color, Color background, int thickness) {
        this.smallStroke = new BasicStroke(thickness);
        this.color = color;
        this.background = background;
        this.largeStroke = new BasicStroke(thickness * 2);
        this.thickness = thickness;
    }

    public RoundedBorder(Color color, Color background, int thickness, int insetThickness) {
        this.insetThickness = insetThickness;
        this.insets = new Insets(insetThickness, insetThickness, insetThickness, insetThickness);
        this.smallStroke = new BasicStroke(thickness);
        this.color = color;
        this.background = background;
        this.largeStroke = new BasicStroke(thickness * 2 + 2);
        this.thickness = thickness;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.background);
        g2.setStroke(this.largeStroke);
        g2.drawRoundRect(x - 1, y - 1, width + 1, height + 1, 10, 10);
        g2.setStroke(this.smallStroke);
        g2.setColor(this.color);
        g2.drawRoundRect(x + 1, y + 1, width - 2, height - 2, 10, 10);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Rectangle bounds = g.getClipBounds();
    }
}

