/*
 * Decompiled with CFR 0.152.
 */
package translator.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import translator.AppPreferences;
import translator.MainView;
import translator.ui.EventSwitchSelected;

public class SwitchButton
extends JComponent {
    private MainView topui;
    private Timer timer;
    private float location;
    private boolean selected;
    private boolean mouseOver;
    private float speed = 0.1f;
    private List<EventSwitchSelected> events;

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.timer.start();
        this.runEvent();
    }

    public void setTopUI(MainView topui) {
        this.topui = topui;
    }

    public SwitchButton() {
        this.setBackground(new Color(AppPreferences.iconsColor));
        this.setPreferredSize(new Dimension(48, 24));
        this.setForeground(new Color(AppPreferences.toolBarsBackground));
        this.setCursor(new Cursor(12));
        this.events = new ArrayList<EventSwitchSelected>();
        this.location = 2.0f;
        this.timer = new Timer(0, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (SwitchButton.this.isSelected()) {
                    int endLocation = SwitchButton.this.getWidth() - SwitchButton.this.getHeight() + 2;
                    if (SwitchButton.this.location < (float)endLocation) {
                        SwitchButton.this.location += SwitchButton.this.speed;
                        SwitchButton.this.repaint();
                    } else {
                        SwitchButton.this.timer.stop();
                        SwitchButton.this.location = endLocation;
                        SwitchButton.this.repaint();
                    }
                } else {
                    int endLocation = 2;
                    if (SwitchButton.this.location > (float)endLocation) {
                        SwitchButton.this.location -= SwitchButton.this.speed;
                        SwitchButton.this.repaint();
                    } else {
                        SwitchButton.this.timer.stop();
                        SwitchButton.this.location = endLocation;
                        SwitchButton.this.repaint();
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                SwitchButton.this.mouseOver = true;
            }

            @Override
            public void mouseExited(MouseEvent me) {
                SwitchButton.this.mouseOver = false;
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (SwingUtilities.isLeftMouseButton(me) && SwitchButton.this.mouseOver) {
                    SwitchButton.this.selected = !SwitchButton.this.selected;
                    SwitchButton.this.timer.start();
                    SwitchButton.this.runEvent();
                    if (SwitchButton.this.topui != null) {
                        SwitchButton.this.topui.getProjectView().pauseSession();
                    }
                }
            }
        });
    }

    @Override
    public void paint(Graphics grphcs) {
        Graphics2D g2 = (Graphics2D)grphcs;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = this.getWidth();
        int height = this.getHeight();
        float alpha = this.getAlpha();
        if (alpha < 1.0f) {
            g2.setColor(Color.GRAY);
            g2.fillRoundRect(0, 0, width, height, 25, 25);
        }
        g2.setComposite(AlphaComposite.getInstance(3, alpha));
        g2.setColor(this.getBackground());
        g2.fillRoundRect(0, 0, width, height, 25, 25);
        g2.setColor(this.getForeground());
        g2.setComposite(AlphaComposite.SrcOver);
        g2.fillOval((int)this.location, 2, height - 4, height - 4);
        super.paint(grphcs);
    }

    private float getAlpha() {
        float width = this.getWidth() - this.getHeight();
        float alpha = (this.location - 2.0f) / width;
        if (alpha < 0.0f) {
            alpha = 0.0f;
        }
        if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        return alpha;
    }

    private void runEvent() {
        for (EventSwitchSelected event : this.events) {
            event.onSelected(this.selected);
        }
    }

    public void addEventSelected(EventSwitchSelected event) {
        this.events.add(event);
    }
}

