/*
 * Decompiled with CFR 0.152.
 */
package translator.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import translator.ui.DnDTabbedPane;
import translator.ui.TabDragSourceListener;
import translator.ui.TabTransferable;

class TabDragGestureListener
implements DragGestureListener {
    TabDragGestureListener() {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        Component c = e.getComponent();
        if (!(c instanceof DnDTabbedPane)) {
            return;
        }
        DnDTabbedPane tabbedPane = (DnDTabbedPane)c;
        if (tabbedPane.getTabCount() <= 1) {
            return;
        }
        Point tabPt = e.getDragOrigin();
        tabbedPane.dragTabIndex = tabbedPane.indexAtLocation(tabPt.x, tabPt.y);
        if (tabbedPane.dragTabIndex < 0 || !tabbedPane.isEnabledAt(tabbedPane.dragTabIndex)) {
            return;
        }
        tabbedPane.initGlassPane(e.getDragOrigin());
        try {
            e.startDrag(DragSource.DefaultMoveDrop, new TabTransferable(c), new TabDragSourceListener());
        }
        catch (InvalidDnDOperationException idoe) {
            idoe.printStackTrace();
        }
    }
}

