/*
 * Decompiled with CFR 0.152.
 */
package translator.ui.kodo;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class KodoProgressBarUI
extends BasicProgressBarUI {
    @Override
    protected void paintDeterminate(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g.create();
        int width = this.progressBar.getWidth();
        int height = this.progressBar.getHeight();
        Color color = this.progressBar.getForeground();
        Color color2 = color.brighter();
        int arc = height / 2;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(new Color(30, 30, 30));
        g2.fillRoundRect(0, 0, width, height, arc, arc);
        int fillWidth = (int)((double)width * this.progressBar.getPercentComplete());
        GradientPaint redGradient = new GradientPaint(0.0f, 0.0f, color, fillWidth, height, color2);
        g2.setPaint(redGradient);
        g2.fillRoundRect(0, 0, fillWidth, height, arc, arc);
        int glowRadius = 20;
        int glowCenter = fillWidth;
        if (fillWidth > 0 && fillWidth < width - 5) {
            for (int i = 0; i < 5; ++i) {
                float opacity = 0.08f * (float)(5 - i);
                g2.setColor(new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), (int)(opacity * 255.0f)));
                g2.fillOval(glowCenter - glowRadius / 2 - i, height / 2 - glowRadius / 2 - i, glowRadius + i * 2, glowRadius + i * 2);
            }
        }
        if (this.progressBar.isStringPainted()) {
            g2.setColor(Color.WHITE);
            String text = this.progressBar.getString();
            FontMetrics fm = g2.getFontMetrics();
            int x = (width - fm.stringWidth(text)) / 2;
            int y = (height + fm.getAscent() - fm.getDescent()) / 2;
            g2.drawString(text, x, y);
        }
        g2.dispose();
    }

    @Override
    protected void paintIndeterminate(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g.create();
        int width = this.progressBar.getWidth();
        int height = this.progressBar.getHeight();
        int arc = height / 2;
        Color color = this.progressBar.getForeground();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(new Color(30, 30, 30));
        g2.fillRect(0, 0, width, height);
        int boxWidth = 80;
        long time = System.currentTimeMillis();
        int x = (int)(time / 5L % (long)(width + boxWidth)) - boxWidth;
        GradientPaint redSweep = new GradientPaint(x, 0.0f, new Color(160, 0, 0, 0), (float)x + (float)boxWidth / 2.0f, 0.0f, color, true);
        g2.setPaint(redSweep);
        g2.fillRoundRect(x, 0, boxWidth, height, arc, arc);
        for (int i = 1; i <= 3; ++i) {
            int trailX = x - i * 10;
            int alpha = 60 - i * 15;
            if (trailX + boxWidth <= 0) continue;
            g2.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), Math.max(alpha, 0)));
            g2.fillRoundRect(trailX, 0, boxWidth, height, arc, arc);
        }
        g2.dispose();
    }

    protected void paintNewIndeterminate(Graphics g, JComponent c) {
        Graphics2D g2 = (Graphics2D)g.create();
        int width = this.progressBar.getWidth();
        int height = this.progressBar.getHeight();
        int arc = height / 2;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(new Color(30, 30, 30));
        g2.fillRect(0, 0, width, height);
        int boxWidth = 80;
        long time = System.currentTimeMillis();
        int x = (int)(time / 5L % (long)(width + boxWidth)) - boxWidth;
        GradientPaint redSweep = new GradientPaint(x, 0.0f, new Color(255, 50, 50, 0), (float)x + (float)boxWidth / 2.0f, 0.0f, new Color(255, 80, 80, 180), true);
        g2.setPaint(redSweep);
        g2.fillRoundRect(x, 0, boxWidth, height, arc, arc);
        for (int i = 1; i <= 3; ++i) {
            int trailX = x - i * 10;
            int alpha = 60 - i * 15;
            if (trailX + boxWidth <= 0) continue;
            g2.setColor(new Color(255, 60, 60, Math.max(alpha, 0)));
            g2.fillRoundRect(trailX, 0, boxWidth, height, arc, arc);
        }
        float pulse = (float)Math.sin((double)System.currentTimeMillis() / 300.0) * 0.5f + 0.5f;
        int glowSize = height * 2;
        int glowX = width / 2 - glowSize / 2;
        int glowY = height / 2 - glowSize / 2;
        Color glowColor = new Color(255, 50, 50, (int)(pulse * 80.0f));
        g2.setColor(glowColor);
        g2.fillOval(glowX, glowY, glowSize, glowSize);
        g2.dispose();
    }
}

