/*
 * Decompiled with CFR 0.152.
 */
package translator.web;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.SpringLayout;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;
import translator.DefaultResource;
import translator.MainView;
import translator.Options;
import translator.TabView;
import translator.WorkflowView;
import translator.XMLHelper;
import translator.ui.Colors;
import translator.ui.GridPanel;
import translator.ui.UITools;
import translator.web.AmazonTTSAPI;
import translator.web.AmazonTTSOptions;

public class AmazonTTS
extends DefaultResource {
    private String resourceName = "Amazon Polly";
    private AmazonTTSAPI api = new AmazonTTSAPI();
    private MainView topui;
    private TabView tview;
    private GridPanel mainPanel;
    private JComboBox voicesBox;
    private JLabel statusLabel;
    private String[] voices;
    int count = 0;

    @Override
    public void setMainView(MainView topui) {
        this.topui = topui;
        this.tview = topui.getTabView();
        this.mainPanel = new GridPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setOpaque(false);
        this.statusLabel = new JLabel("");
        this.statusLabel.setHorizontalAlignment(4);
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JPanel panel1 = new JPanel();
        if (AppPreferences.alpha != -1) {
            panel1.setOpaque(false);
        } else {
            panel1.setOpaque(true);
        }
        if (AppPreferences.tbackground2 != 0) {
            if (!AppPreferences.backGrid) {
                panel1.setBackground(topui.getMainPanelBackgroundColor());
            } else {
                panel1.setBackground(GridPanel.darker(topui.getMainPanelBackgroundColor(), 0.92));
            }
        }
        panel1.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        panel1.setLayout(new SpringLayout());
        JLabel voicesLabel = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("VOICE") + ":");
        voicesLabel.setForeground(new Color(AppPreferences.toolBarsForeground));
        this.voicesBox = new JComboBox();
        this.voicesBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (AmazonTTS.this.voicesBox.isEnabled() && e.getStateChange() == 1) {
                    String s = (String)e.getItem();
                    if (AmazonTTS.this.voices != null) {
                        for (int i = 0; i < AmazonTTS.this.voices.length; ++i) {
                            String voice = AmazonTTS.this.voices[i];
                            if (!s.equals(voice)) continue;
                            AppPreferences.amazonPollyVoice = i;
                        }
                    }
                }
            }
        });
        JLabel engineLabel = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ENGINE") + ":");
        engineLabel.setForeground(new Color(AppPreferences.toolBarsForeground));
        String[] engines = new String[]{"Standard", "Neural"};
        JComboBox<String> engineBox = new JComboBox<String>(engines);
        engineBox.setSelectedIndex(AppPreferences.amazonPollyEngine);
        engineBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String s = (String)e.getItem();
                    if (s.equals("Neural")) {
                        AppPreferences.amazonPollyEngine = 1;
                        AppPreferences.amazonPollyVoice = 13;
                    } else {
                        AppPreferences.amazonPollyEngine = 0;
                        AppPreferences.amazonPollyVoice = 26;
                    }
                    AmazonTTS.this.connectToService();
                }
            }
        });
        JLabel speakLabel = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SPEAK") + ":");
        speakLabel.setForeground(new Color(AppPreferences.toolBarsForeground));
        String[] sp = new String[]{"Source", "Target", "Selection", "Chat"};
        JComboBox<String> speakBox = new JComboBox<String>(sp);
        if (AppPreferences.ttsSpeak < sp.length) {
            speakBox.setSelectedIndex(AppPreferences.ttsSpeak);
        }
        speakBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String s = (String)e.getItem();
                    if (s.equals("Source")) {
                        AppPreferences.ttsSpeak = 0;
                    } else if (s.equals("Target")) {
                        AppPreferences.ttsSpeak = 1;
                    } else if (s.equals("Selection")) {
                        AppPreferences.ttsSpeak = 2;
                    } else if (s.equals("Chat")) {
                        AppPreferences.ttsSpeak = 3;
                    }
                }
            }
        });
        JButton speakButton = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SPEAK"));
        speakButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AmazonTTS.this.speakSelectedText();
            }
        });
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_TEXT_TO_SPEECH, (int)(speakButton.getFont().getSize() + 4), (Color)Colors.getIconsColor());
        speakButton.setIcon((Icon)ficon);
        panel1.add(voicesLabel);
        panel1.add(this.voicesBox);
        panel1.add(engineLabel);
        panel1.add(engineBox);
        panel1.add(speakLabel);
        panel1.add(speakBox);
        panel1.add(new JLabel());
        panel1.add(speakButton);
        UITools.makeCompactGrid(panel1, 4, 2, 0, 0, 10, 5);
        this.mainPanel.add((Component)panel1, "North");
        this.mainPanel.add((Component)this.statusLabel, "Center");
        this.tview.addTab(this, this.resourceName, this.mainPanel);
    }

    public void setOptions(Options frame) {
        AmazonTTSOptions dlg = new AmazonTTSOptions(frame, this, this.resourceName);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = frame.getSize();
        Point loc = frame.getLocationOnScreen();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
    }

    public void connectToService() {
        this.voicesBox.removeAllItems();
        final JProgressBar bar = this.topui.getPretranslateProgressBar();
        bar.setIndeterminate(true);
        bar.setStringPainted(true);
        bar.setString("Connecting to Amazon Polly...");
        SwingWorker worker = new SwingWorker(this){
            String exception = null;
            final /* synthetic */ AmazonTTS this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                try {
                    AmazonTTS.access$102(this.this$0, this.this$0.api.getVoices());
                }
                catch (Exception ex) {
                    this.exception = ex.getMessage();
                }
                return null;
            }

            @Override
            protected void done() {
                this.this$0.topui.removePretranslateProgressBar(bar);
                if (this.this$0.voices != null && this.this$0.voices.length > 0) {
                    Object[] sortedVoices = Arrays.copyOf(this.this$0.voices, this.this$0.voices.length);
                    Arrays.sort(sortedVoices);
                    this.this$0.voicesBox.setEnabled(false);
                    for (int i = 0; i < sortedVoices.length; ++i) {
                        Object sortedVoice = sortedVoices[i];
                        this.this$0.voicesBox.addItem(sortedVoice);
                    }
                    this.this$0.voicesBox.setEnabled(true);
                    if (AppPreferences.amazonPollyVoice < this.this$0.voices.length) {
                        String s = this.this$0.voices[AppPreferences.amazonPollyVoice];
                        this.this$0.voicesBox.setSelectedItem(s);
                    }
                    this.this$0.statusLabel.setText("");
                } else if (this.exception != null) {
                    this.this$0.statusLabel.setText(this.exception);
                }
            }
        };
        worker.execute();
    }

    private void speakSelectedText() {
        String q;
        Document doc;
        String s;
        JTextPane tps = this.topui.getSourcePane();
        JTextPane tpt = this.topui.getTargetPane();
        if (AppPreferences.ttsSpeak == 0) {
            s = tps.getSelectedText();
            doc = tps.isShowing() ? tpt.getDocument() : tps.getDocument();
        } else if (AppPreferences.ttsSpeak == 1) {
            s = tpt.getSelectedText();
            doc = tpt.isShowing() ? tpt.getDocument() : tps.getDocument();
        } else {
            s = tps.getSelectedText();
            if (s == null) {
                s = tpt.getSelectedText();
            }
            doc = tps.isShowing() ? tps.getDocument() : tpt.getDocument();
        }
        if (s == null) {
            try {
                s = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException ex) {
                Logger.getLogger(WorkflowView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if ((q = XMLHelper.parseTags(s)).length() > 0) {
            this.talk(q);
        }
    }

    public void talk(final String text) {
        if (AppPreferences.isTrialVersion && this.count >= 15) {
            String s = "CafeTran trial version limit of 15 spoken segments has been reached.";
            this.statusLabel.setText(s);
            return;
        }
        SwingWorker worker = new SwingWorker(this){
            String exception = null;
            final /* synthetic */ AmazonTTS this$0;
            {
                this.this$0 = this$0;
            }

            public String doInBackground() {
                try {
                    this.this$0.api.talk(text, AppPreferences.amazonPollyVoice);
                    ++this.this$0.count;
                }
                catch (Exception ex) {
                    this.exception = ex.getMessage();
                }
                return null;
            }

            @Override
            protected void done() {
                if (this.exception != null) {
                    this.this$0.statusLabel.setText(this.exception);
                } else if (this.this$0.voices == null) {
                    this.this$0.connectToService();
                } else {
                    this.this$0.statusLabel.setText("");
                }
            }
        };
        worker.execute();
    }

    @Override
    public void closeResource() {
        this.topui.getResourceView().setAmazonTTSService(-1);
        this.tview.removeTab(this.resourceName);
    }

    static /* synthetic */ String[] access$102(AmazonTTS x0, String[] x1) {
        x0.voices = x1;
        return x1;
    }
}

