/*
 * Decompiled with CFR 0.152.
 */
package translator.web;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class FileUploadUtility {
    private final String boundary = "===" + System.currentTimeMillis() + "===";
    private HttpURLConnection httpConn;
    private OutputStream outputStream;
    private PrintWriter writer;
    private static final String LINE_FEED = "\r\n";

    public FileUploadUtility(String requestURL, String token) throws IOException {
        URL url = new URL(requestURL);
        this.httpConn = (HttpURLConnection)url.openConnection();
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
        this.httpConn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
        if (token != null) {
            this.httpConn.setRequestProperty("Authorization", "Bearer " + token);
            this.httpConn.setRequestMethod("POST");
        }
        this.outputStream = this.httpConn.getOutputStream();
    }

    public void addFilePart(String token, String fileName, String fileType, String tagList) throws IOException {
        this.writer = new PrintWriter(new OutputStreamWriter(this.outputStream, "UTF-8"));
        if (token != null) {
            this.writer.println("--" + this.boundary);
            this.writer.println("Content-Disposition: form-data; name=\"access_token\"");
            this.writer.println("Content-Type: text/plain; charset=UTF-8");
            this.writer.println();
            this.writer.println(token);
        }
        if (tagList != null) {
            this.writer.println("--" + this.boundary);
            this.writer.println("Content-Disposition: form-data; name=\"tag_list\"");
            this.writer.println("Content-Type: text/plain; charset=UTF-8");
            this.writer.println();
            this.writer.println(tagList);
        }
        if (fileType != null) {
            if (fileType.equals("media")) {
                this.writer.append("--" + this.boundary).append(LINE_FEED);
                this.writer.append("Content-Disposition: form-data; name=\"media\"; filename=\"" + fileName + "\"").append(LINE_FEED);
                this.writer.append("Content-Type: " + URLConnection.guessContentTypeFromName(fileName)).append(LINE_FEED);
                this.writer.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
                this.writer.append(LINE_FEED);
                this.writer.flush();
            } else {
                this.writer.println("--" + this.boundary);
                this.writer.println("Content-Disposition: form-data; name=\"file_type\"");
                this.writer.println("Content-Type: text/plain; charset=UTF-8");
                this.writer.println();
                this.writer.println(fileType);
                this.writer.println("--" + this.boundary);
                this.writer.println("Content-Disposition: form-data; name=\"file\"; filename=\"" + fileName + "\"");
                this.writer.println("Content-Type: text/plain; charset=UTF-8");
                this.writer.println();
            }
        }
    }

    public void writeFileBytes(byte[] bytes, int offset, int length) throws IOException {
        this.outputStream.write(bytes, offset, length);
    }

    public void writeLine(String line) throws IOException {
        this.writer.println(line);
    }

    public String finish() throws IOException {
        this.outputStream.flush();
        this.writer.append(LINE_FEED);
        this.writer.flush();
        this.writer.println("--" + this.boundary + "--");
        this.writer.close();
        int status = this.httpConn.getResponseCode();
        if (status == 201) {
            String s;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.httpConn.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((s = reader.readLine()) != null) {
                sb.append(s);
            }
            reader.close();
            this.httpConn.disconnect();
            return sb.toString();
        }
        throw new IOException("Server returned non-OK status: " + status);
    }
}

