/*
 * Decompiled with CFR 0.152.
 */
package translator.web;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import translator.AppPreferences;
import translator.MainView;
import translator.browser.Browser;
import translator.browser.WebPane;
import translator.json.JSONObject;
import translator.web.Proz;
import translator.web.ProzAskQuestion;

public class ProzAskQuestionView
extends JFrame {
    private MainView topui;
    private URL url;
    private WebPane webPane;
    private String html;
    private String sourceLang;
    private String targetLang;
    private Map languageCodes;
    private Proz proz;

    public ProzAskQuestionView(Proz proz, ProzAskQuestion question) {
        String proBox;
        String easyBox;
        this.proz = proz;
        this.languageCodes = proz.getLanguageCodesMap();
        StringBuilder htmlLangs = new StringBuilder();
        Set set = this.languageCodes.entrySet();
        for (Map.Entry entry : set) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            htmlLangs.append("<option value=\"");
            htmlLangs.append(val);
            htmlLangs.append("\">");
            htmlLangs.append(key);
            htmlLangs.append("</option>");
        }
        StringBuilder htmlGenDisc = new StringBuilder();
        Map gdisc = proz.getGeneralDisciplinesMap();
        Set set3 = gdisc.entrySet();
        for (Map.Entry entry : set3) {
            int key = (Integer)entry.getKey();
            String val = (String)entry.getValue();
            htmlGenDisc.append("<option value=\"");
            htmlGenDisc.append(key);
            htmlGenDisc.append("\">");
            htmlGenDisc.append(val);
            htmlGenDisc.append("</option>");
        }
        StringBuilder htmlSpecDisc = new StringBuilder();
        Map sdisc = proz.getSpecificDisciplinesMap();
        Set set2 = sdisc.entrySet();
        for (Map.Entry entry : set2) {
            int key = (Integer)entry.getKey();
            String val = (String)entry.getValue();
            htmlSpecDisc.append("<option value=\"");
            htmlSpecDisc.append(key);
            htmlSpecDisc.append("\">");
            htmlSpecDisc.append(val);
            htmlSpecDisc.append("</option>");
        }
        if (AppPreferences.prozKudozAskQuestionLevel) {
            easyBox = "<input type=radio name=\"level\" value=\"easy\">";
            proBox = "<input type=radio name=\"level\" value=\"pro\" checked=\"checked\">";
        } else {
            easyBox = "<input type=radio name=\"level\" value=\"easy\" checked=\"checked\">";
            proBox = "<input type=radio name=\"level\" value=\"pro\">";
        }
        String term = question.getTerm();
        String context = question.getContext();
        this.sourceLang = question.getSourceLanguage();
        this.targetLang = question.getTargetLanguage();
        this.html = "<html><head></head><body bgcolor=\"#EEEEEE\"><table align=\"center\" class=\"standard\" id=\"answer_form\" cellpadding=\"5\" cellspacing=\"1\" style=\"border: 1px solid #00BCD4; font-family: verdana,arial,helvetica,sans-serif; font-size:14px\" rules=\"all\" width=\"90%\"> <tbody><form name=\"kudoz_ask\" method=post><tr> <td  align=\"center\">Languages </td> <td align=\"left\"> <select name=\"from\" id=\"from\"> <option value=\"\"></option>" + htmlLangs + " </select>&nbsp;&nbsp;<b>&gt;</b>&nbsp;&nbsp; <select name=\"to\" id=\"to\"> <option value=\"\"></option>" + htmlLangs + " </select> </td> </tr> <tr> <td align=\"center\">Field (broad)<br />(Required) <a href=\"javascript:createInfoWindow('kz_disc', '1');\"><img src=\"http://cdn1.proz.com/images/pftv6/info.gif\" border=\"0\" alt=\"Determining general field\" title=\"Determining general field\"></a> </td> <td align=\"left\"> <select name=disc size=1> <option value=\"\"> - Select - </option>" + htmlGenDisc + " </select> </td> </tr> <tr> <td align=\"center\">Field (specific)<br />";
        String html2 = "(Required)<a href=\"javascript:createInfoWindow('kz_disc_spec', '1');\"><img src=\"http://cdn1.proz.com/images/pftv6/info.gif\" border=\"0\" alt=\"Determining specific field\" title=\"Determining specific field\"></a> </td> <td align=\"left\"> <select name=\"disc_spec_id\"><option value=\"\">- Select -</option>" + htmlSpecDisc + "</select> </td> </tr> <tr> <td align=\"center\">Write-in field<br />(For further specification) <a href=\"javascript:createInfoWindow('kz_disc_writein', '1');\"><img src=\"http://cdn1.proz.com/images/pftv6/info.gif\" border=\"0\" alt=\"Writing in more specific category\" title=\"Writing in more specific category\"></a> </td> <td align=\"left\"><input type=\"text\" name=\"disc_specific\" size=\"60\" maxlength=\"255\" id=\"write_in_further\" value=\"" + AppPreferences.prozKudozAskQuestionWriteInDiscipline + "\"></td> </tr> <tr> <td align=\"center\"> <b>Term or phrase</b> </td> <td align=\"left\"> <input type=text name=\"fields[term]\" style=\"font-size:12pt;\" size=\"80\" maxlength=\"160\" id=\"term\" value=\"" + term + "\"> </td> </tr> <tr> <td align=\"center\">Explanation / Context<br />(Required)</td> <td align=\"left\"> <textarea autofocus name=\"fields[term_context]\" style=\"width:100%;height:150px;font-size:12pt;\" wrap=\"virtual\" id=\"term_context\">" + context + "</textarea></td></tr> <tr id=\"level_div\"> <td  align=\"center\">Level <a href=\"javascript:createInfoWindow('easy_vs_pro', '1');\"><img src=\"http://cdn1.proz.com/images/pftv6/info.gif\" border=\"0\" alt=\"How to decide between PRO and Non-PRO\" title=\"How to decide between PRO and Non-PRO\"></a> </td> <td align=\"left\"> <label>" + proBox + "PRO - a question that is suitable for professional translators</label> <br> <label>" + easyBox + "Non-PRO - a question that can be answered by any bilingual person without the aid of a dictionary </label> </td> </tr> <tr id=\"preferred_div\"> <td  align=\"center\">Language preferred<br />(For answer explanations)  <a href=\"javascript:createInfoWindow('kudoz_lang_expl', '1');\"><img src=\"http://cdn1.proz.com/images/pftv6/info.gif\" border=\"0\" alt=\"What is this?\" title=\"What is this?\"></a> </td> <td align=\"left\"><select name=asker_lang> <option value=>Any</option>" + htmlLangs + " </select> </td> </tr><tr> <td bgcolor=\"#00BCD4\" align=\"center\" colspan=2> <input type=\"submit\" name=\"submit_question\" id=\"submit_question2\" value=\"Ask a KudoZ question\"> </td> </tr></form></tbody></table></body></html>";
        this.html = this.html + html2;
    }

    public void setMainView(MainView topui) {
        this.topui = topui;
        this.createView();
        this.showAskForm();
    }

    private void showAskForm() {
        this.webPane.getBrowser().loadHTML(this.html);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadForm() {
        String request = "http://www.proz.com/ask";
        BufferedReader in = null;
        try {
            int j;
            String eline;
            String post = null;
            this.url = new URL(request);
            String form = null;
            StringBuilder line = new StringBuilder();
            in = this.getBufferedReader(this.url, post);
            while ((eline = in.readLine()) != null) {
                line.append(eline);
                line.append("\n");
            }
            int i = line.indexOf("<form name=\"kudoz_ask\"");
            if (i != -1 && (j = line.indexOf("</form>", i)) != -1) {
                form = line.substring(i, j + 7);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("<html><body>");
            sb.append("<table width=\"100%\"> <tbody><tr> <td align=\"center\" valign=\"top\"> <br>");
            sb.append(form);
            sb.append("</tbody></table>");
            sb.append("</body></html>");
            System.out.println(sb.toString());
            this.webPane.getBrowser().loadHTML(sb.toString());
            this.closeConnection(in);
        }
        catch (Exception er) {
            er.printStackTrace();
        }
        finally {
            this.closeConnection(in);
        }
    }

    private void closeConnection(BufferedReader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void createView() {
        this.webPane = new WebPane(new Browser(true));
        this.webPane.getBrowser().getEngine().documentProperty().addListener((ChangeListener)new ChangeListener<Document>(){

            public void changed(ObservableValue<? extends Document> ov, Document oldValue, Document newValue) {
                if (null != newValue) {
                    ProzAskQuestionView.this.setOKAction();
                }
            }
        });
        this.setTitle("Ask a KudoZ question");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.webPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
        Dimension frmSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(1200, 600);
        Dimension dlgSize = this.getSize();
        Point loc = this.topui.getLocationOnScreen();
        this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        this.setVisible(true);
    }

    protected BufferedReader getBufferedReader(URL page, String post) throws IOException {
        String enc;
        URLConnection conn = page.openConnection();
        conn.setRequestProperty("User-Agent", "Mozilla 5.0");
        conn.setDoOutput(true);
        if (post != null) {
            OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
            out.write(post);
            out.close();
        }
        if (conn instanceof HttpURLConnection) {
            boolean redirect;
            HttpURLConnection hconn = (HttpURLConnection)conn;
            hconn.setInstanceFollowRedirects(false);
            int response = hconn.getResponseCode();
            boolean bl = redirect = response >= 300 && response <= 399;
            if (redirect) {
                String loc = conn.getHeaderField("Location");
                page = loc.startsWith("http", 0) ? new URL(loc) : new URL(page, loc);
                return this.getBufferedReader(page, post);
            }
        }
        if ((enc = conn.getContentEncoding()) == null) {
            enc = "UTF-8";
        }
        InputStream in = conn.getInputStream();
        BufferedReader r = new BufferedReader(new InputStreamReader(in, enc));
        return r;
    }

    private void setOKAction() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String tl;
                EventListener listener = new EventListener(){

                    @Override
                    public void handleEvent(Event evt) {
                        String v;
                        String s;
                        int i;
                        Object term = null;
                        Document doc = ProzAskQuestionView.this.webPane.getBrowser().getEngine().getDocument();
                        NodeList els = doc.getElementsByTagName("select");
                        for (i = 0; i < els.getLength(); ++i) {
                            String v2 = (String)ProzAskQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('select')[" + i + "].value");
                            String n = (String)ProzAskQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('select')[" + i + "].name");
                            if (n.equals("from")) {
                                AppPreferences.prozKudozAskQuestionSourceLanguage = v2;
                                continue;
                            }
                            if (n.equals("to")) {
                                AppPreferences.prozKudozAskQuestionTargetLanguage = v2;
                                continue;
                            }
                            if (n.equals("disc")) {
                                AppPreferences.prozKudozAskQuestionGeneralDiscipline = v2;
                                continue;
                            }
                            if (n.equals("disc_spec_id")) {
                                AppPreferences.prozKudozAskQuestionSpecificDiscipline = v2;
                                continue;
                            }
                            if (!n.equals("asker_lang")) continue;
                            AppPreferences.prozKudozAskQuestionAskerLanguage = v2;
                        }
                        els = doc.getElementsByTagName("input");
                        for (i = 0; i < els.getLength(); ++i) {
                            String n;
                            Object v3;
                            Element elem = (Element)els.item(i);
                            s = elem.getAttribute("type");
                            if (s.equals("radio")) {
                                v3 = (Boolean)ProzAskQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].checked");
                                if (!((Boolean)v3).booleanValue()) continue;
                                n = (String)ProzAskQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].value");
                                if (n.equals("pro")) {
                                    AppPreferences.prozKudozAskQuestionLevel = true;
                                    continue;
                                }
                                AppPreferences.prozKudozAskQuestionLevel = false;
                                continue;
                            }
                            if (!s.equals("text")) continue;
                            v3 = (String)ProzAskQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].value");
                            n = (String)ProzAskQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('input')[" + i + "].name");
                            if (!n.equals("fields[term]")) continue;
                            term = v3;
                        }
                        AppPreferences.prozKudozAskQuestionWriteInDiscipline = v = (String)ProzAskQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementById('write_in_further').value");
                        String context = (String)ProzAskQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementById('term_context').value");
                        if (term == null || ((String)term).trim().length() == 0 || context.trim().length() == 0 || AppPreferences.prozKudozAskQuestionSourceLanguage.length() == 0 || AppPreferences.prozKudozAskQuestionTargetLanguage.length() == 0 || AppPreferences.prozKudozAskQuestionGeneralDiscipline.length() == 0 || AppPreferences.prozKudozAskQuestionSpecificDiscipline.length() == 0) {
                            Alert alert = new Alert(Alert.AlertType.INFORMATION, "Please provide the required information.", new ButtonType[0]);
                            Optional result = alert.showAndWait();
                            return;
                        }
                        StringBuilder request = new StringBuilder();
                        request.append("{");
                        request.append("\"source_term\": ");
                        term = JSONObject.quote((String)term);
                        request.append((String)term);
                        request.append(", ");
                        request.append("\"language_pair\": ");
                        request.append("\"");
                        request.append(AppPreferences.prozKudozAskQuestionSourceLanguage).append("_").append(AppPreferences.prozKudozAskQuestionTargetLanguage);
                        request.append("\", ");
                        request.append("\"level\": ");
                        request.append("\"");
                        if (AppPreferences.prozKudozAskQuestionLevel) {
                            request.append("pro");
                        } else {
                            request.append("non-pro");
                        }
                        request.append("\", ");
                        if (AppPreferences.prozKudozAskQuestionAskerLanguage.length() > 0) {
                            request.append("\"preferred_language\": ");
                            request.append("\"");
                            request.append(AppPreferences.prozKudozAskQuestionAskerLanguage);
                            request.append("\", ");
                        }
                        request.append("\"disc_gen_id\": ");
                        request.append(AppPreferences.prozKudozAskQuestionGeneralDiscipline);
                        request.append(", ");
                        request.append("\"disc_spec_id\": ");
                        request.append(AppPreferences.prozKudozAskQuestionSpecificDiscipline);
                        request.append(", ");
                        if (AppPreferences.prozKudozAskQuestionWriteInDiscipline.length() > 0) {
                            request.append("\"disc_write_in\": ");
                            s = JSONObject.quote(AppPreferences.prozKudozAskQuestionWriteInDiscipline);
                            request.append(s);
                            request.append(", ");
                        }
                        request.append("\"context\": ");
                        context = JSONObject.quote(context);
                        request.append(context);
                        request.append(", ");
                        request.append("\"no_points\": false, \"may_offend\": false, \"from_test\": false, \"from_non_pro\": false, \"auto_close\": false, \"translator_requirements\": {\"native_language\": null, \"language_pair\": null, \"disc_level\": null, \"members_only\": null}");
                        request.append("}");
                        s = request.toString();
                        SwingUtilities.invokeLater(new Runnable(){
                            final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            @Override
                            public void run() {
                                this.this$2.ProzAskQuestionView.this.proz.askKudoZQuestion(s);
                                this.this$2.ProzAskQuestionView.this.closeFrame();
                            }
                        });
                    }
                };
                Document doc = ProzAskQuestionView.this.webPane.getBrowser().getEngine().getDocument();
                Element el2 = doc.getElementById("submit_question2");
                ((EventTarget)((Object)el2)).addEventListener("click", listener, false);
                String sl = (String)ProzAskQuestionView.this.languageCodes.get(ProzAskQuestionView.this.sourceLang);
                if (sl == null) {
                    sl = "";
                }
                if ((tl = (String)ProzAskQuestionView.this.languageCodes.get(ProzAskQuestionView.this.targetLang)) == null) {
                    tl = "";
                }
                ProzAskQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('select')[0].value='" + sl + "'");
                ProzAskQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('select')[1].value='" + tl + "'");
                ProzAskQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('select')[2].value='" + AppPreferences.prozKudozAskQuestionGeneralDiscipline + "'");
                ProzAskQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('select')[3].value='" + AppPreferences.prozKudozAskQuestionSpecificDiscipline + "'");
                ProzAskQuestionView.this.webPane.getBrowser().getEngine().executeScript("document.getElementsByTagName('select')[4].value='" + AppPreferences.prozKudozAskQuestionAskerLanguage + "'");
            }
        });
    }

    private void closeFrame() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }
}

