/*
 * Decompiled with CFR 0.152.
 */
package translator.xliff;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;
import org.kordamp.ikonli.swing.FontIcon;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.MainView;
import translator.ResourceView;
import translator.XMLHelper;
import translator.translatables.TextDocument;
import translator.translatables.ZipDocument;
import translator.ui.CustomTabbedPaneUI;
import translator.ui.GridPanel;
import translator.xliff.Billing;
import translator.xliff.InvoiceEditor;

public class BillingEditor
extends JDialog
implements ActionListener {
    private MainView owner;
    private JTabbedPane jTab;
    private Billing elem;
    private DefaultXMLElement order;
    private DefaultXMLElement doc;
    private DefaultXMLElement job;
    private DefaultXMLElement reg;
    public boolean cancelled = false;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButtonIn;
    private JTextField nofield;
    private JTextField datefield;
    private JTextField returnfield;
    private JTextField payfield;
    private JTextPane jtextArea1;
    private JTextField dnamefield;
    private JTextField desfield;
    private JTextField dlangfield;
    private JTextField creafield;
    private JTextPane jtextArea2;
    private JTextField typefield;
    private JTextField jlangfield;
    private JTextField pagefield;
    private JTextField copyfield;
    private JTextField filefield;
    private JTextField layfield;

    public BillingEditor(MainView frame, Billing elem, String title) {
        super(frame, title, true);
        String notes;
        String client;
        this.owner = frame;
        this.setResizable(false);
        this.elem = elem;
        JPanel con = (JPanel)this.getContentPane();
        con.setBorder(new EmptyBorder(new Insets(10, 10, 0, 10)));
        this.jTab = new JTabbedPane();
        if (AppPreferences.laf.equals("Windows")) {
            this.jTab.setUI(new CustomTabbedPaneUI());
        }
        this.jTab.setBorder(new EmptyBorder(new Insets(5, 0, 0, 0)));
        this.jButton2 = new JButton();
        this.jButton2.setOpaque(false);
        this.jButton2.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
        this.jButton2.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANCEL"));
        this.jButton2.addActionListener(this);
        this.jButton3 = new JButton();
        this.jButton3.setOpaque(false);
        this.jButton3.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
        this.jButton3.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("SAVE"));
        this.jButton3.setMnemonic(82);
        this.jButton3.addActionListener(this);
        this.jButton4 = new JButton();
        this.jButton4.setOpaque(false);
        this.jButton4.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
        this.jButton4.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT"));
        this.jButton4.addActionListener(this);
        this.jButtonIn = new JButton();
        this.jButtonIn.setOpaque(false);
        this.jButtonIn.setBorder(BorderFactory.createEmptyBorder(AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize, AppPreferences.borderSize));
        this.jButtonIn.setText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INVOICE"));
        this.jButtonIn.setMnemonic(86);
        this.jButtonIn.addActionListener(this);
        FontIcon ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CLOSE, (int)(this.jButton2.getFont().getSize() + 4), (Color)this.jButton2.getForeground());
        this.jButton2.setIcon((Icon)ficon);
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FLOPPY, (int)(this.jButton3.getFont().getSize() + 4), (Color)this.jButton3.getForeground());
        this.jButton3.setIcon((Icon)ficon);
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_FILE_EXCEL, (int)(this.jButton4.getFont().getSize() + 4), (Color)this.jButton4.getForeground());
        this.jButton4.setIcon((Icon)ficon);
        ficon = FontIcon.of((Ikon)MaterialDesign.MDI_CASH, (int)(this.jButtonIn.getFont().getSize() + 4), (Color)this.jButtonIn.getForeground());
        this.jButtonIn.setIcon((Icon)ficon);
        JToolBar jPanel0 = new JToolBar();
        jPanel0.setFloatable(false);
        jPanel0.add(this.jButton2);
        jPanel0.add(this.jButton3);
        jPanel0.add(this.jButton4);
        jPanel0.add(this.jButtonIn);
        con.add((Component)jPanel0, "North");
        this.order = elem.getOrder();
        GridPanel jPanel2 = new GridPanel();
        jPanel2.setPreferredSize(new Dimension(800, 400));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(new Insets(10, 5, 5, 5)));
        JPanel inPanel = new JPanel();
        inPanel.setOpaque(false);
        inPanel.setLayout(new GridLayout(0, 2, 10, 5));
        JLabel label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ORDER NUMBER:"));
        label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLUE));
        label.setHorizontalAlignment(4);
        label.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("LAST ORDER NUMBER:") + " " + AppPreferences.orderNumber);
        this.nofield = new JTextField();
        if (this.order != null) {
            this.nofield.setText(this.order.getAttribute("number"));
        }
        this.nofield.setCaretPosition(0);
        this.nofield.setMargin(new Insets(0, 2, 0, 0));
        this.nofield.setFont(this.nofield.getFont().deriveFont(1));
        inPanel.add(label);
        inPanel.add(this.nofield);
        label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DATE:"));
        label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLUE));
        label.setHorizontalAlignment(4);
        this.datefield = new JTextField();
        if (this.order != null) {
            this.datefield.setText(this.order.getAttribute("date"));
        }
        this.datefield.setCaretPosition(0);
        this.datefield.setMargin(new Insets(0, 2, 0, 0));
        this.datefield.setFont(this.datefield.getFont().deriveFont(1));
        inPanel.add(label);
        inPanel.add(this.datefield);
        label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("RETURN DATE:"));
        label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLUE));
        label.setHorizontalAlignment(4);
        this.returnfield = new JTextField();
        if (this.order != null) {
            this.returnfield.setText(this.order.getAttribute("return-date"));
        }
        this.returnfield.setCaretPosition(0);
        this.returnfield.setMargin(new Insets(0, 2, 0, 0));
        this.returnfield.setFont(this.returnfield.getFont().deriveFont(1));
        inPanel.add(label);
        inPanel.add(this.returnfield);
        label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PAY:"));
        label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLUE));
        label.setHorizontalAlignment(4);
        this.payfield = new JTextField();
        if (this.order != null) {
            this.payfield.setText(this.order.getAttribute("pay"));
        }
        this.payfield.setCaretPosition(0);
        this.payfield.setMargin(new Insets(0, 2, 0, 0));
        this.payfield.setFont(this.payfield.getFont().deriveFont(1));
        inPanel.add(label);
        inPanel.add(this.payfield);
        JPanel isPanel = new JPanel();
        isPanel.setOpaque(false);
        isPanel.setLayout(new BorderLayout());
        isPanel.setBorder(new CompoundBorder(new EmptyBorder(new Insets(5, 0, 0, 0)), new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLIENT"))));
        this.jtextArea1 = new JTextPane();
        if (this.order != null && (client = this.order.getContent(0).toString()) != null) {
            this.jtextArea1.setText(client);
        }
        this.jtextArea1.setCaretPosition(0);
        this.jtextArea1.setFont(new Font(AppPreferences.fontname, 1, AppPreferences.fontsize));
        if (AppPreferences.background != 0) {
            Color background = new Color(AppPreferences.background);
            Color foreground = new Color(AppPreferences.foreground);
            this.jtextArea1.setCaretColor(foreground);
            this.jtextArea1.setBackground(background);
            this.jtextArea1.setForeground(foreground);
        }
        this.jtextArea1.setMargin(new Insets(3, 3, 3, 3));
        JScrollPane jScrollPane = new JScrollPane(this.jtextArea1);
        isPanel.add(jScrollPane);
        jPanel2.add((Component)inPanel, "North");
        jPanel2.add((Component)isPanel, "Center");
        this.jTab.addTab(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("ORDER"), jPanel2);
        this.doc = elem.getDocument();
        GridPanel jPanel3 = new GridPanel();
        jPanel3.setPreferredSize(new Dimension(800, 400));
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(new EmptyBorder(new Insets(10, 5, 5, 5)));
        inPanel = new JPanel();
        inPanel.setOpaque(false);
        inPanel.setLayout(new GridLayout(0, 2, 10, 5));
        label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NAME:"));
        label.setHorizontalAlignment(4);
        label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLUE));
        this.dnamefield = new JTextField();
        if (this.doc != null) {
            this.dnamefield.setText(this.doc.getAttribute("name"));
        }
        this.dnamefield.setCaretPosition(0);
        this.dnamefield.setMargin(new Insets(0, 2, 0, 0));
        this.dnamefield.setFont(this.dnamefield.getFont().deriveFont(1));
        inPanel.add(label);
        inPanel.add(this.dnamefield);
        label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DESIGNATION:"));
        label.setHorizontalAlignment(4);
        label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLUE));
        this.desfield = new JTextField();
        if (this.doc != null) {
            this.desfield.setText(this.doc.getAttribute("designation"));
        }
        this.desfield.setCaretPosition(0);
        this.desfield.setMargin(new Insets(0, 2, 0, 0));
        this.desfield.setFont(this.desfield.getFont().deriveFont(1));
        inPanel.add(label);
        inPanel.add(this.desfield);
        label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CREATOR:"));
        label.setHorizontalAlignment(4);
        label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLUE));
        this.creafield = new JTextField();
        if (this.doc != null) {
            this.creafield.setText(this.doc.getAttribute("creator"));
        }
        this.creafield.setCaretPosition(0);
        this.creafield.setMargin(new Insets(0, 2, 0, 0));
        this.creafield.setFont(this.creafield.getFont().deriveFont(1));
        inPanel.add(label);
        inPanel.add(this.creafield);
        label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCUMENT LANGUAGE:"));
        label.setHorizontalAlignment(4);
        label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLUE));
        label.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLICK HERE TO SWITCH THE LANGUAGES"));
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                String slang = BillingEditor.this.dlangfield.getText();
                String tlang = BillingEditor.this.jlangfield.getText();
                BillingEditor.this.dlangfield.setText(tlang);
                BillingEditor.this.jlangfield.setText(slang);
            }
        });
        this.dlangfield = new JTextField();
        if (this.doc != null) {
            this.dlangfield.setText(this.doc.getAttribute("language"));
        }
        this.dlangfield.setCaretPosition(0);
        this.dlangfield.setMargin(new Insets(0, 2, 0, 0));
        this.dlangfield.setFont(this.dlangfield.getFont().deriveFont(1));
        inPanel.add(label);
        inPanel.add(this.dlangfield);
        isPanel = new JPanel();
        isPanel.setOpaque(false);
        isPanel.setLayout(new BorderLayout());
        isPanel.setBorder(new CompoundBorder(new EmptyBorder(new Insets(5, 0, 0, 0)), new TitledBorder(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NOTES"))));
        this.jtextArea2 = new JTextPane();
        if (this.doc != null && (notes = this.doc.getContent(0).toString()) != null) {
            this.jtextArea2.setText(notes);
        }
        this.jtextArea2.setCaretPosition(0);
        this.jtextArea2.setFont(new Font(AppPreferences.fontname, 1, AppPreferences.fontsize));
        if (AppPreferences.background != 0) {
            Color background = new Color(AppPreferences.background);
            Color foreground = new Color(AppPreferences.foreground);
            this.jtextArea2.setCaretColor(foreground);
            this.jtextArea2.setBackground(background);
            this.jtextArea2.setForeground(foreground);
        }
        this.jtextArea2.setMargin(new Insets(3, 3, 3, 3));
        jScrollPane = new JScrollPane(this.jtextArea2);
        isPanel.add(jScrollPane);
        jPanel3.add((Component)inPanel, "North");
        jPanel3.add((Component)isPanel, "Center");
        this.jTab.addTab(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("DOCUMENT"), jPanel3);
        this.job = elem.getJob();
        jPanel2 = new GridPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(new Insets(10, 5, 5, 5)));
        inPanel = new JPanel();
        inPanel.setOpaque(false);
        inPanel.setLayout(new GridLayout(4, 2, 10, 5));
        label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("TYPE OF JOB:"));
        label.setHorizontalAlignment(4);
        label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLUE));
        this.typefield = new JTextField();
        if (this.job != null) {
            this.typefield.setText(this.job.getAttribute("type"));
        }
        this.typefield.setCaretPosition(0);
        this.typefield.setMargin(new Insets(0, 2, 0, 0));
        this.typefield.setFont(this.typefield.getFont().deriveFont(1));
        inPanel.add(label);
        inPanel.add(this.typefield);
        label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("JOB LANGUAGE:"));
        label.setHorizontalAlignment(4);
        label.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CLICK HERE TO SWITCH THE LANGUAGES"));
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                String slang = BillingEditor.this.dlangfield.getText();
                String tlang = BillingEditor.this.jlangfield.getText();
                BillingEditor.this.dlangfield.setText(tlang);
                BillingEditor.this.jlangfield.setText(slang);
            }
        });
        label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLUE));
        this.jlangfield = new JTextField();
        if (this.job != null) {
            this.jlangfield.setText(this.job.getAttribute("language"));
        }
        this.jlangfield.setCaretPosition(0);
        this.jlangfield.setMargin(new Insets(0, 2, 0, 0));
        this.jlangfield.setFont(this.jlangfield.getFont().deriveFont(1));
        inPanel.add(label);
        inPanel.add(this.jlangfield);
        label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PAGES:"));
        label.setHorizontalAlignment(4);
        label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLUE));
        this.pagefield = new JTextField();
        if (this.job != null) {
            this.pagefield.setText(this.job.getAttribute("pages"));
        }
        this.pagefield.setCaretPosition(0);
        this.pagefield.setMargin(new Insets(0, 2, 0, 0));
        this.pagefield.setFont(this.pagefield.getFont().deriveFont(1));
        inPanel.add(label);
        inPanel.add(this.pagefield);
        label = new JLabel(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("COPIES:"));
        label.setHorizontalAlignment(4);
        label.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.BLUE));
        this.copyfield = new JTextField();
        if (this.job != null) {
            this.copyfield.setText(this.job.getAttribute("copies"));
        }
        this.copyfield.setCaretPosition(0);
        this.copyfield.setMargin(new Insets(0, 2, 0, 0));
        this.copyfield.setFont(this.copyfield.getFont().deriveFont(1));
        inPanel.add(label);
        inPanel.add(this.copyfield);
        jPanel2.add((Component)inPanel, "North");
        this.jTab.addTab(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("JOB"), jPanel2);
        this.reg = elem.getRegister();
        jPanel2 = new GridPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(new Insets(10, 5, 5, 5)));
        inPanel = new JPanel();
        inPanel.setOpaque(false);
        inPanel.setLayout(new GridLayout(2, 2, 10, 5));
        JButton layoutButton = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REGISTER TEMPLATE") + "...");
        layoutButton.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE REGISTER TEMPLATE"));
        layoutButton.setHorizontalAlignment(2);
        layoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AppPreferences.isJavaFXReady()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                File file;
                                FileChooser fileChooser = new FileChooser();
                                fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE REGISTER TEMPLATE"));
                                File f = new File(AppPreferences.packagePath + "layouts/register");
                                if (f.isDirectory() && f.canRead()) {
                                    fileChooser.setInitialDirectory(f);
                                }
                                if ((file = fileChooser.showOpenDialog(null)) != null) {
                                    SwingUtilities.invokeLater(new Runnable(){
                                        final /* synthetic */ 1 this$2;
                                        {
                                            this.this$2 = this$2;
                                        }

                                        @Override
                                        public void run() {
                                            this.this$2.BillingEditor.this.layfield.setText(file.getName());
                                        }
                                    });
                                }
                            }
                            catch (Exception ex) {
                                final String s = ex.getMessage();
                                SwingUtilities.invokeLater(new Runnable(){
                                    final /* synthetic */ 1 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(this.this$2.BillingEditor.this.owner, s);
                                    }
                                });
                            }
                        }
                    });
                } else {
                    JFileChooser jch = new JFileChooser(AppPreferences.packagePath + "layouts/register");
                    jch.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE REGISTER TEMPLATE"));
                    if (0 == jch.showOpenDialog(BillingEditor.this.owner)) {
                        File file = jch.getSelectedFile();
                        BillingEditor.this.layfield.setText(file.getName());
                    }
                }
            }
        });
        this.layfield = new JTextField();
        if (this.reg != null) {
            this.layfield.setText(this.reg.getAttribute("layout"));
        }
        this.layfield.setCaretPosition(0);
        this.layfield.setMargin(new Insets(0, 2, 0, 0));
        this.layfield.setFont(this.layfield.getFont().deriveFont(1));
        inPanel.add(layoutButton);
        inPanel.add(this.layfield);
        JButton fileButton = new JButton(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REGISTER FILE") + "...");
        fileButton.setToolTipText(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE REGISTER FILE"));
        fileButton.setHorizontalAlignment(2);
        fileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String loc;
                File f;
                final String rpath = AppPreferences.registerFile.length() == 0 ? (!(f = new File(loc = System.getProperty("user.home") + AppPreferences.fs + "Documents")).exists() ? System.getProperty("user.home") : loc) : AppPreferences.registerFile;
                if (AppPreferences.isJavaFXReady()) {
                    Platform.runLater((Runnable)new Runnable(){
                        final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            try {
                                File file;
                                FileChooser fileChooser = new FileChooser();
                                fileChooser.setTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE REGISTER FILE"));
                                File f = new File(rpath);
                                if (f.isDirectory() && f.canRead()) {
                                    fileChooser.setInitialDirectory(f);
                                }
                                if ((file = fileChooser.showOpenDialog(null)) != null) {
                                    SwingUtilities.invokeLater(new Runnable(){
                                        final /* synthetic */ 1 this$2;
                                        {
                                            this.this$2 = this$2;
                                        }

                                        @Override
                                        public void run() {
                                            String path = file.getPath();
                                            this.this$2.this$1.BillingEditor.this.filefield.setText(path);
                                        }
                                    });
                                }
                            }
                            catch (Exception ex) {
                                final String s = ex.getMessage();
                                SwingUtilities.invokeLater(new Runnable(){
                                    final /* synthetic */ 1 this$2;
                                    {
                                        this.this$2 = this$2;
                                    }

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(this.this$2.this$1.BillingEditor.this.owner, s);
                                    }
                                });
                            }
                        }
                    });
                } else {
                    JFileChooser jch = new JFileChooser(rpath);
                    jch.setDialogTitle(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE REGISTER FILE"));
                    if (0 == jch.showOpenDialog(BillingEditor.this.owner)) {
                        File file = jch.getSelectedFile();
                        String path = file.getPath();
                        BillingEditor.this.filefield.setText(path);
                    }
                }
            }
        });
        this.filefield = new JTextField();
        if (this.reg != null) {
            this.filefield.setText(this.reg.getAttribute("file"));
        }
        this.filefield.setCaretPosition(0);
        this.filefield.setMargin(new Insets(0, 2, 0, 0));
        this.filefield.setFont(this.filefield.getFont().deriveFont(1));
        inPanel.add(fileButton);
        inPanel.add(this.filefield);
        jPanel2.add((Component)inPanel, "North");
        this.jTab.addTab(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("REGISTER"), jPanel2);
        con.add((Component)this.jTab, "Center");
        con.getActionMap().put("ENTER", new AbstractAction("ENTER"){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        });
        con.getActionMap().put("ESC", new AbstractAction("ESC"){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        });
        con.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        con.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "ESC");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                BillingEditor.this.cancelled = true;
                BillingEditor.this.closeDialog();
            }
        });
        this.pack();
        this.nofield.requestFocusInWindow();
    }

    void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    void save() {
        if (this.order != null) {
            this.order.setAttribute("number", this.nofield.getText());
            AppPreferences.orderNumber = this.nofield.getText();
            this.order.setAttribute("date", this.datefield.getText());
            this.order.setAttribute("return-date", this.returnfield.getText());
            this.order.setAttribute("pay", this.payfield.getText());
            this.order.setContent(0, this.jtextArea1.getText());
        }
        if (this.doc != null) {
            this.doc.setAttribute("name", this.dnamefield.getText());
            this.doc.setAttribute("designation", this.desfield.getText());
            this.doc.setAttribute("language", this.dlangfield.getText());
            AppPreferences.billingSource = this.dlangfield.getText();
            this.doc.setAttribute("creator", this.creafield.getText());
            this.doc.setContent(0, this.jtextArea2.getText());
        }
        if (this.job != null) {
            this.job.setAttribute("type", this.typefield.getText());
            AppPreferences.billingService = this.typefield.getText();
            this.job.setAttribute("language", this.jlangfield.getText());
            AppPreferences.billingTarget = this.jlangfield.getText();
            this.job.setAttribute("pages", this.pagefield.getText());
            this.job.setAttribute("copies", this.copyfield.getText());
        }
        if (this.reg != null) {
            this.reg.setAttribute("layout", this.layfield.getText());
            AppPreferences.registerLayout = this.layfield.getText();
            this.reg.setAttribute("file", this.filefield.getText());
            AppPreferences.registerFile = this.filefield.getText();
        }
    }

    String replaceTemplate(String lay) {
        Date d = new Date();
        String date = DateFormat.getDateTimeInstance().format(d);
        lay = lay.replaceFirst("#register-date", date);
        if (this.order != null) {
            String onumber = this.order.getAttribute("number");
            String odate = this.order.getAttribute("date");
            String oreturn = this.order.getAttribute("return-date");
            String opay = this.order.getAttribute("pay");
            String oclient = this.order.getContent(0).toString();
            lay = lay.replaceFirst("#order-no", onumber);
            lay = lay.replaceFirst("#order-date", odate);
            lay = lay.replaceFirst("#return-date", oreturn);
            lay = lay.replaceFirst("#pay", opay);
            lay = lay.replaceFirst("#client-name", oclient);
        }
        if (this.doc != null) {
            String dname = this.doc.getAttribute("name");
            String ddes = this.doc.getAttribute("designation");
            String dlang = this.doc.getAttribute("language");
            String dcrea = this.doc.getAttribute("creator");
            String dnotes = this.doc.getContent(0).toString();
            lay = lay.replaceFirst("#document-name", dname);
            lay = lay.replaceFirst("#designation", ddes);
            lay = lay.replaceFirst("#source-language", dlang);
            lay = lay.replaceFirst("#creator", dcrea);
            lay = lay.replaceFirst("#notes", dnotes);
        }
        if (this.job != null) {
            String type = this.job.getAttribute("type");
            String jlang = this.job.getAttribute("language");
            String pages = this.job.getAttribute("pages");
            String copies = this.job.getAttribute("copies");
            lay = lay.replaceFirst("#type", type);
            lay = lay.replaceFirst("#target-language", jlang);
            lay = lay.replaceFirst("#pages", pages);
            lay = lay.replaceFirst("#copies", copies);
        }
        return lay;
    }

    String[] getAllAttributes() {
        String[] attrs = new String[14];
        if (this.order != null) {
            String opay;
            String oclient;
            String oreturn;
            String odate;
            String onumber;
            attrs[0] = onumber = this.order.getAttribute("number");
            attrs[1] = odate = this.order.getAttribute("date");
            attrs[2] = oreturn = this.order.getAttribute("return-date");
            attrs[3] = oclient = this.order.getContent(0).toString();
            attrs[4] = opay = this.order.getAttribute("pay");
        }
        if (this.doc != null) {
            String dnotes;
            String dlang;
            String dcrea;
            String ddes;
            String dname;
            attrs[5] = dname = this.doc.getAttribute("name");
            attrs[6] = ddes = this.doc.getAttribute("designation");
            attrs[7] = dcrea = this.doc.getAttribute("creator");
            attrs[8] = dlang = this.doc.getAttribute("language");
            attrs[9] = dnotes = this.doc.getContent(0).toString();
        }
        if (this.job != null) {
            String copies;
            String pages;
            String jlang;
            String type;
            attrs[10] = type = this.job.getAttribute("type");
            attrs[11] = jlang = this.job.getAttribute("language");
            attrs[12] = pages = this.job.getAttribute("pages");
            attrs[13] = copies = this.job.getAttribute("copies");
        }
        return attrs;
    }

    String makeCalcRow(String[] attrs) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<table:table-row>");
        String[] letters = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N"};
        for (int k = 0; k < letters.length; ++k) {
            String cell;
            String attr = attrs[k];
            if (attr != null && attr.length() > 0) {
                attr = XMLHelper.resolveXMLEntities(attr);
                cell = "<table:table-cell table:style-name=\"Default\" office:value-type=\"string\"><text:p>";
                buffer.append(cell);
                buffer.append(attr);
                cell = "</text:p></table:table-cell>";
                buffer.append(cell);
                continue;
            }
            cell = "<table:table-cell table:style-name=\"Default\"></table:table-cell>";
            buffer.append(cell);
        }
        buffer.append("</table:table-row>");
        return buffer.toString();
    }

    String makeExcelRow(String[] attrs, int i, int j) {
        StringBuffer buffer = new StringBuffer();
        String rowNo = Integer.toString(++i);
        buffer.append("<row r=\"" + rowNo + "\">");
        String[] letters = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N"};
        int sh = j;
        for (int k = 0; k < letters.length; ++k) {
            String cell;
            String letter = letters[k];
            String attr = attrs[k];
            String shS = Integer.toString(sh);
            if (attr != null && attr.length() > 0) {
                cell = "<c r=\"" + letter + rowNo + "\" t=\"s\"><v>" + shS + "</v></c>";
                buffer.append(cell);
                ++sh;
                continue;
            }
            cell = "<c r=\"" + letter + rowNo + "\" t=\"s\"><v></v></c>";
            buffer.append(cell);
        }
        buffer.append("</row>");
        return buffer.toString();
    }

    String makeshareString(String[] attrs, int i, int j) {
        StringBuffer buffer = new StringBuffer();
        for (int k = 0; k < attrs.length; ++k) {
            String attr = attrs[k];
            if (attr == null || attr.length() <= 0) continue;
            attr = XMLHelper.resolveXMLEntities(attr);
            String cell = "<si><t>" + attr + "</t></si>";
            buffer.append(cell);
        }
        return buffer.toString();
    }

    private void editRegister() {
        String path = this.reg.getAttribute("file");
        File regFile = new File(path);
        if (regFile.exists()) {
            ResourceView rv = this.owner.getResourceView();
            rv.viewFile(regFile);
        } else {
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILE DOES NOT EXIST!"));
        }
    }

    /*
     * Unable to fully structure code
     */
    void saveExcelRegister(File file) {
        block12: {
            path = this.reg.getAttribute("file");
            state = this.reg.getAttribute("state");
            if (!state.equals("new")) break block12;
            try {
                rename = false;
                tempFile = new File(path);
                if (tempFile.exists()) ** GOTO lbl26
                fname = JOptionPane.showInputDialog(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE REGISTER NAME"), (Object)"");
                if (fname != null && fname.length() > 0) {
                    try {
                        loc = System.getProperty("user.home") + AppPreferences.fs + "Documents";
                        f = new File(loc);
                        if (!f.exists()) {
                            loc = System.getProperty("user.home");
                        }
                        if (!(t = (tempFile = new File(npath = loc + AppPreferences.fs + fname + ".xlsx")).createNewFile())) ** GOTO lbl34
                        npath = tempFile.getPath();
                        this.reg.setAttribute("file", npath);
                        AppPreferences.registerFile = npath;
                    }
                    catch (IOException ex) {
                        Logger.getLogger(BillingEditor.class.getName()).log(Level.SEVERE, null, ex);
                        JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANNOT CREATE REGISTER!"));
                        return;
                    }
                } else {
                    JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO REGISTER NAME!"));
                    return;
lbl26:
                    // 1 sources

                    fpath = tempFile.getPath();
                    counter = new Random().nextInt() & 65535;
                    file = new File(fpath + Integer.toString(counter));
                    if (tempFile.renameTo(file)) {
                        tempFile = new File(fpath);
                        rename = true;
                    } else {
                        throw new IOException();
                    }
                }
lbl34:
                // 3 sources

                stringsDoc = "xl/sharedStrings.xml";
                sheetDoc = "xl/worksheets/sheet1.xml";
                zfile = new ZipFile(file);
                tr = new ZipDocument();
                strings = tr.loadZipFile(zfile, stringsDoc, "UTF-8");
                zfile = new ZipFile(file);
                sheet = tr.loadZipFile(zfile, sheetDoc, "UTF-8");
                i = sheet.lastIndexOf("<row r=\"") + 8;
                j = sheet.indexOf("\"", i);
                rowNo = sheet.substring(i, j);
                i = strings.indexOf("uniqueCount=\"") + 13;
                j = strings.indexOf("\"", i);
                stringNo = strings.substring(i, j);
                i = Integer.parseInt(rowNo);
                j = Integer.parseInt(stringNo);
                attrs = this.getAllAttributes();
                row = this.makeExcelRow(attrs, i, j);
                lrow = sheet.lastIndexOf("</row>") + 6;
                start = sheet.substring(0, lrow);
                end = sheet.substring(lrow);
                sheet = start + row + end;
                buffer = new StringBuffer();
                ic = 0;
                for (k = 0; k < attrs.length; ++k) {
                    attr = attrs[k];
                    if (attr == null || attr.length() <= 0) continue;
                    cell = "<si><t>" + attr + "</t></si>";
                    buffer.append(cell);
                    ++ic;
                }
                lrow = strings.lastIndexOf("</si>") + 5;
                start = strings.substring(0, lrow);
                end = strings.substring(lrow);
                strings = start + buffer.toString() + end;
                sic = Integer.toString(ic += j);
                count = "count=\"" + sic + "\" uniqueCount=\"" + sic + "\"";
                srow = strings.indexOf("count");
                erow = strings.indexOf(">", srow);
                ocount = strings.substring(srow, erow);
                strings = strings.replaceFirst(ocount, count);
                zfile = new ZipFile(file);
                names = new String[]{sheetDoc, stringsDoc};
                texts = new String[]{sheet, strings};
                tr.storeZipFile(tempFile, zfile, names, texts);
                if (rename) {
                    file.deleteOnExit();
                }
                this.filefield.setText(this.reg.getAttribute("file"));
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("THE ORDER REGISTERED SUCCESSFULLY!"));
            }
            catch (ZipException ex) {
                Logger.getLogger(BillingEditor.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(BillingEditor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void saveCalcRegister(File file) {
        block15: {
            block14: {
                path = this.reg.getAttribute("file");
                state = this.reg.getAttribute("state");
                if (!state.equals("new")) break block14;
                try {
                    rename = false;
                    tempFile = new File(path);
                    if (tempFile.exists()) ** GOTO lbl26
                    fname = JOptionPane.showInputDialog(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE REGISTER NAME"), (Object)"");
                    if (fname != null && fname.length() > 0) {
                        try {
                            loc = System.getProperty("user.home") + AppPreferences.fs + "Documents";
                            f = new File(loc);
                            if (!f.exists()) {
                                loc = System.getProperty("user.home");
                            }
                            if (!(t = (tempFile = new File(npath = loc + AppPreferences.fs + fname + ".ods")).createNewFile())) ** GOTO lbl34
                            npath = tempFile.getPath();
                            this.reg.setAttribute("file", npath);
                            AppPreferences.registerFile = npath;
                        }
                        catch (IOException ex) {
                            Logger.getLogger(BillingEditor.class.getName()).log(Level.SEVERE, null, ex);
                            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANNOT CREATE REGISTER!"));
                            return;
                        }
                    } else {
                        JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO REGISTER NAME!"));
                        return;
lbl26:
                        // 1 sources

                        fpath = tempFile.getPath();
                        counter = new Random().nextInt() & 65535;
                        file = new File(fpath + Integer.toString(counter));
                        if (tempFile.renameTo(file)) {
                            tempFile = new File(fpath);
                            rename = true;
                        } else {
                            throw new IOException();
                        }
                    }
lbl34:
                    // 3 sources

                    sheetDoc = "content.xml";
                    zfile = new ZipFile(file);
                    tr = new ZipDocument();
                    zfile = new ZipFile(file);
                    sheet = tr.loadZipFile(zfile, sheetDoc, "UTF-8");
                    attrs = this.getAllAttributes();
                    row = this.makeCalcRow(attrs);
                    ind = sheet.lastIndexOf("</text:p>");
                    lrow = sheet.indexOf("</table:table-row>", ind) + 18;
                    start = sheet.substring(0, lrow);
                    end = sheet.substring(lrow);
                    sheet = start + row + end;
                    zfile = new ZipFile(file);
                    names = new String[]{sheetDoc};
                    texts = new String[]{sheet};
                    tr.storeZipFile(tempFile, zfile, names, texts);
                    if (rename) {
                        file.deleteOnExit();
                    }
                    this.filefield.setText(this.reg.getAttribute("file"));
                    JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("THE ORDER REGISTERED SUCCESSFULLY!"));
                }
                catch (ZipException ex) {
                    Logger.getLogger(BillingEditor.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(BillingEditor.class.getName()).log(Level.SEVERE, null, ex);
                }
                break block15;
            }
            if (state.equals("registered") && (i = JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT THE REGISTER FILE?"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FORMAT: LIBREOFFICE CALC"), 0)) == 0) {
                regFile = new File(path);
                if (regFile.exists()) {
                    rv = this.owner.getResourceView();
                    rv.viewFile(regFile);
                } else {
                    JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILE DOES NOT EXIST!"));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    void saveTextRegister(File file) {
        path = this.reg.getAttribute("file");
        state = this.reg.getAttribute("state");
        if (state.equals("new")) {
            tr = new TextDocument();
            layout = tr.loadTextFile(file, "UTF-8");
            layout = this.replaceTemplate(layout);
            tempFile = new File(path);
            if (!tempFile.exists()) {
                fname = JOptionPane.showInputDialog(ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CHOOSE REGISTER NAME"), (Object)"");
                if (fname != null && fname.length() > 0) {
                    try {
                        loc = System.getProperty("user.home") + AppPreferences.fs + "Documents";
                        f = new File(loc);
                        if (!f.exists()) {
                            loc = System.getProperty("user.home");
                        }
                        if (!(t = (tempFile = new File(npath = loc + AppPreferences.fs + fname + ".txt")).createNewFile())) ** GOTO lbl27
                        npath = tempFile.getPath();
                        this.reg.setAttribute("file", npath);
                        AppPreferences.registerFile = npath;
                    }
                    catch (IOException ex) {
                        Logger.getLogger(BillingEditor.class.getName()).log(Level.SEVERE, null, ex);
                        JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("CANNOT CREATE REGISTER!"));
                        return;
                    }
                } else {
                    JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("NO REGISTER NAME!"));
                    return;
                }
            }
lbl27:
            // 4 sources

            tr.storeFile(tempFile, layout, "UTF-8");
            this.filefield.setText(this.reg.getAttribute("file"));
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("THE ORDER REGISTERED SUCCESSFULLY!"));
        } else if (state.equals("registered") && (i = JOptionPane.showConfirmDialog(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("EDIT THE REGISTER FILE?"), ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FORMAT: TEXT UTF-8"), 0)) == 0) {
            this.editTextRegister(path);
        }
    }

    void register() {
        File file = this.getRegisterLayout();
        if (file == null) {
            return;
        }
        String name = file.getName();
        if (name.endsWith(".txt")) {
            this.saveTextRegister(file);
        } else if (name.endsWith(".xlsx")) {
            this.saveExcelRegister(file);
        } else if (name.endsWith(".ods")) {
            this.saveCalcRegister(file);
        }
    }

    private void editTextRegister(String path) {
        if (this.owner instanceof MainView) {
            MainView mview = this.owner;
            ResourceView rview = mview.getResourceView();
            File file = new File(path);
            if (file.exists()) {
                String format = "";
                AppPreferences.en = "UTF-8";
                rview.openDocument(file, format, AppPreferences.en, null);
            } else {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("FILE DOES NOT EXIST!"));
            }
        }
    }

    File getRegisterLayout() {
        File file;
        if (this.reg == null) {
            return null;
        }
        String lpath = AppPreferences.packagePath + "layouts/register/";
        String name = this.reg.getAttribute("layout");
        if (name != null && name.length() > 0) {
            file = new File(lpath + name);
            if (!file.exists()) {
                file = new File(lpath + "english.ods");
            }
        } else {
            file = new File(lpath + "english.ods");
        }
        return file;
    }

    public boolean showInvoice(Billing bill, DefaultXMLElement binv) {
        InvoiceEditor dlg = new InvoiceEditor(this, this.owner, bill, binv, ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("INVOICE EDITOR"));
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.owner.getSize();
        Point loc = this.owner.getLocation();
        dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setVisible(true);
        return dlg.cancelled;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jButton3) {
            this.save();
            this.register();
        } else if (e.getSource() == this.jButton4) {
            this.editRegister();
            this.closeDialog();
        } else if (e.getSource() == this.jButton2) {
            this.cancelled = true;
            this.closeDialog();
        } else if (e.getSource() == this.jButtonIn) {
            boolean cancel;
            DefaultXMLElement inv = this.elem.getInvoice();
            if (inv == null) {
                inv = new DefaultXMLElement();
                inv.setName("bill:invoice");
                Date d = new Date();
                String date = DateFormat.getDateInstance().format(d);
                String time = DateFormat.getTimeInstance().format(d);
                try {
                    int number = Integer.parseInt(AppPreferences.billingNumber);
                    inv.setAttribute("number", Integer.toString(++number));
                }
                catch (NumberFormatException nfe) {
                    inv.setAttribute("number", "");
                }
                inv.setAttribute("price-per-unit", AppPreferences.billingPrice);
                inv.setAttribute("date", date);
                inv.setAttribute("currency", AppPreferences.billingCurrency);
                inv.setAttribute("time", time);
                inv.setAttribute("sub-total", "");
                inv.setAttribute("service", this.typefield.getText());
                inv.setAttribute("tax", AppPreferences.billingTax);
                inv.setAttribute("job", "");
                inv.setAttribute("total", "");
                inv.setAttribute("source-language", this.dlangfield.getText());
                inv.setAttribute("payment", AppPreferences.billingPayment);
                inv.setAttribute("target-language", this.jlangfield.getText());
                inv.setAttribute("layout", AppPreferences.billingLayout);
                DefaultXMLElement client = new DefaultXMLElement();
                client.setName("bill:client");
                client.setContent(0, this.jtextArea1.getText());
                inv.addChild(client);
                DefaultXMLElement comp = new DefaultXMLElement();
                comp.setName("bill:company");
                comp.setContent(0, "");
                inv.addChild(comp);
            }
            if (cancel = this.showInvoice(this.elem, inv)) {
                return;
            }
            this.elem.setInvoice(inv);
        }
    }
}

