/*
 * Decompiled with CFR 0.152.
 */
package translator.xliff;

import java.util.List;
import translator.DefaultXMLElement;
import translator.XMLElement;
import translator.xliff.Billing;
import translator.xliff.Glossary;
import translator.xliff.PhaseGroup;
import translator.xliff.Reference;
import translator.xliff.Skeleton;

public class FileHeader
extends DefaultXMLElement {
    Billing bill;
    Skeleton skl;

    @Override
    public void addChild(Object o) {
        if (o instanceof XMLElement) {
            XMLElement xml = (XMLElement)o;
            String name = xml.getName();
            if (name.equals("bill:billing")) {
                this.setBilling(xml);
            } else if (name.equals("skl")) {
                this.setSkeleton(xml);
            } else {
                List elements = super.getChildren("bill:billing");
                int esize = elements.size();
                if (esize > 0) {
                    esize = super.getChildren().size();
                    super.getChildren().add(esize - 1, xml);
                } else {
                    super.addChild(xml);
                }
            }
        }
    }

    public void setSkeleton(XMLElement s) {
        this.skl = (Skeleton)s;
        super.getChildren().add(0, this.skl);
    }

    public Skeleton getSkeleton() {
        return this.skl;
    }

    public void setBilling(XMLElement b) {
        this.bill = (Billing)b;
        super.addChild(b);
    }

    public Billing getBilling() {
        return this.bill;
    }

    public void addReference(String rhref, String ruid) {
        List refs = this.getReferences();
        if (refs != null) {
            for (Reference r : refs) {
                XMLElement ext = r.getExternalFile();
                if (ext == null) continue;
                String href = ext.getAttribute("href");
                String uid = ext.getAttribute("uid");
                if (href == null || !rhref.equals(href)) continue;
                if (ruid != null && uid != null) {
                    if (!ruid.equals(uid)) continue;
                    return;
                }
                return;
            }
        }
        Reference reference = new Reference();
        reference.setName("reference");
        DefaultXMLElement ext = new DefaultXMLElement();
        ext.setName("external-file");
        ext.setAttribute("href", rhref);
        if (ruid != null) {
            ext.setAttribute("uid", ruid);
        }
        reference.setExternalFile(ext);
        this.addChild(reference);
    }

    public void addGlossary(String rhref, String ruid) {
        List glossaries = this.getGlossaries();
        if (glossaries != null) {
            for (Glossary glossary : glossaries) {
                XMLElement ext = glossary.getExternalFile();
                if (ext == null) continue;
                String href = ext.getAttribute("href");
                String uid = ext.getAttribute("uid");
                if (href == null || !rhref.equals(href)) continue;
                if (ruid != null && uid != null) {
                    if (!ruid.equals(uid)) continue;
                    return;
                }
                return;
            }
        }
        Glossary gloss = new Glossary();
        gloss.setName("glossary");
        DefaultXMLElement ext = new DefaultXMLElement();
        ext.setName("external-file");
        ext.setAttribute("href", rhref);
        if (ruid != null) {
            ext.setAttribute("uid", ruid);
        }
        gloss.setExternalFile(ext);
        this.addChild(gloss);
    }

    public List getNotes() {
        return this.getChildren("note");
    }

    public List getGlossaries() {
        return this.getChildren("glossary");
    }

    public List getReferences() {
        return this.getChildren("reference");
    }

    public Reference getReference(String uid) {
        Reference ref = null;
        List refs = this.getReferences();
        if (refs != null) {
            for (Reference r : refs) {
                String id;
                XMLElement ext = r.getExternalFile();
                if (ext == null || (id = ext.getAttribute("uid")) == null || !id.equals(uid)) continue;
                ref = r;
                break;
            }
        }
        return ref;
    }

    public void setPhaseGroup(XMLElement phgr) {
        this.addChild(phgr);
    }

    public PhaseGroup getPhaseGroup() {
        PhaseGroup phases = null;
        List list = this.getChildren("phase-group");
        if (list.size() > 0) {
            phases = (PhaseGroup)list.get(0);
        }
        return phases;
    }

    public List getCountGroups() {
        return this.getChildren("count-group");
    }

    public List getTools() {
        return this.getChildren("tool");
    }

    public void setSkeletonReference(String href) {
        Skeleton skel = this.getSkeleton();
        XMLElement exfile = null;
        if (skel == null) {
            skel = new Skeleton();
            skel.setName("skl");
            exfile = new DefaultXMLElement();
            exfile.setName("external-file");
            skel.setExternalFile(exfile);
            this.setSkeleton(skel);
        } else {
            exfile = skel.getExternalFile();
        }
        if (exfile != null) {
            exfile.setAttribute("href", href);
        }
    }

    public String getSkeletonReference() {
        XMLElement exfile;
        String ref = null;
        Skeleton skel = this.getSkeleton();
        if (skel != null && (exfile = skel.getExternalFile()) != null) {
            ref = exfile.getAttribute("href");
        }
        return ref;
    }
}

