/*
 * Decompiled with CFR 0.152.
 */
package translator.xliff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.Project;
import translator.XMLElement;
import translator.xliff.ContextGroup;
import translator.xliff.FileBody;
import translator.xliff.FileHeader;
import translator.xliff.Skeleton;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;
import translator.xliff.XliffFile;

public class POHandler {
    private Project project;
    private XLIFF xliff;
    private Pattern p1;
    private Pattern p2;
    private Pattern p3;
    private Pattern p4;

    public POHandler(Project project) {
        this.project = project;
        this.xliff = project.getXLIFF();
        this.p1 = Pattern.compile("^\"|\"\\s*$", 8);
        this.p2 = Pattern.compile("^msgstr\\[\\d\\] ", 8);
        this.p3 = Pattern.compile("^\\s*$|^[^#]+$", 8);
        this.p4 = Pattern.compile("^\\s*$|^.+$", 8);
    }

    public void parsePOFormatSingle() {
        File f;
        String po;
        String path;
        XliffFile next = this.xliff.getCurrentFile();
        if (next != null && (path = next.getAttribute("original")) != null && (po = this.getPOString(f = new File(path), "UTF-8")) != null) {
            this.parse(next, po);
            next.setCurrentPhase("Review");
            this.project.setTitleForFile(next.getShortName());
        }
    }

    public void parsePOFormat() {
        List files = this.xliff.getFiles();
        for (XliffFile next : files) {
            File f;
            String po;
            String path = next.getAttribute("original");
            if (path == null || (po = this.getPOString(f = new File(path), "UTF-8")) == null) continue;
            this.parse(next, po);
            next.setCurrentPhase("Review");
            this.project.setTitleForFile(next.getShortName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPOString(File file, String encoding) {
        String po = null;
        FileInputStream fis = null;
        try {
            Charset charset = Charset.isSupported(encoding) ? Charset.forName(encoding) : Charset.forName("UTF-8");
            CharsetDecoder decoder = charset.newDecoder();
            decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            decoder.onMalformedInput(CodingErrorAction.REPLACE);
            fis = new FileInputStream(file);
            FileChannel fc = fis.getChannel();
            int sz = (int)fc.size();
            ByteBuffer bb = ByteBuffer.allocateDirect(sz);
            fc.read(bb);
            ByteBuffer buffer = bb;
            ((Buffer)buffer).flip();
            CharBuffer cb = decoder.decode(bb);
            fc.close();
            po = cb.toString();
        }
        catch (IOException ex) {
            Logger.getLogger(POHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException ex) {
                Logger.getLogger(POHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return po;
    }

    public void parse(XliffFile xfile, String poString) {
        FileBody body = xfile.getBody();
        int counter = 0;
        String whitespace = ".+?(^\\s*$|\\z)";
        Pattern tuP = Pattern.compile(whitespace, 40);
        Matcher m = tuP.matcher(poString);
        int msgid_pluralIndex = -1;
        int msgidIndex = -1;
        int msgstrIndex = -1;
        while (m.find()) {
            DefaultXMLElement note;
            int j;
            String comment = null;
            String context = null;
            String msgidStr = null;
            String msgStr = null;
            String msgidStrPlural = null;
            String msgStrPlural = null;
            String gr = m.group().trim();
            msgidIndex = gr.indexOf("msgid ");
            if (msgidIndex == -1) continue;
            if (msgidIndex > 0 && (comment = gr.substring(0, msgidIndex).trim()).length() > 0 && (j = comment.lastIndexOf("msgctxt ")) != -1) {
                context = comment.substring(j);
                comment = comment.substring(0, j).trim();
            }
            if ((msgid_pluralIndex = gr.indexOf("msgid_plural ", msgidIndex)) != -1) {
                msgidStr = gr.substring(msgidIndex, msgid_pluralIndex).trim();
                msgstrIndex = gr.indexOf("msgstr[", msgidIndex);
                int startSingular = gr.length() - 1;
                int startPlural = -1;
                int count = 0;
                while (msgstrIndex != -1) {
                    if (count != 0) {
                        startPlural = msgstrIndex;
                        break;
                    }
                    startSingular = msgstrIndex;
                    msgstrIndex = gr.indexOf("msgstr[", msgstrIndex + 1);
                    ++count;
                }
                msgidStrPlural = gr.substring(msgid_pluralIndex, startSingular);
                if (startPlural != -1) {
                    msgStr = gr.substring(startSingular, startPlural).trim();
                    msgStrPlural = gr.substring(startPlural).trim();
                }
            } else {
                msgstrIndex = gr.indexOf("msgstr ", msgidIndex);
                if (msgstrIndex != -1) {
                    msgidStr = gr.substring(msgidIndex, msgstrIndex).trim();
                    msgStr = gr.substring(msgstrIndex);
                }
            }
            if (counter == 0 && msgidStr != null && msgidStr.equals("msgid \"\"")) {
                this.xliff.setCurrentFile(xfile);
                XLIFFUnit tu = this.prepareTransUnit();
                XMLElement tus = tu.getSource();
                tus.addChild("HEADER. DO NOT TRANSLATE!");
                XMLElement tut = tu.getTarget();
                tut.addChild("HEADER. DO NOT TRANSLATE!");
                note = new DefaultXMLElement();
                note.setContent(0, gr);
                note.setName("note");
                if (AppPreferences.userid.length() > 0) {
                    note.setAttribute("from", AppPreferences.userid);
                }
                tu.addChild(note);
                tu.setLock(true, true);
                body.addTransUnit(tu);
            } else if (msgidStr != null) {
                XLIFFUnit tu = this.prepareTransUnit();
                if (msgidStrPlural != null) {
                    tu.setAttribute("resname", "msgid_singular");
                } else {
                    tu.setAttribute("resname", "msgid");
                }
                XMLElement tus = tu.getSource();
                msgidStr = this.getSourceString(msgidStr);
                tus.addChild(msgidStr);
                XMLElement tut = tu.getTarget();
                if (msgStr != null) {
                    msgStr = this.getTargetString(msgStr);
                    tut.addChild(msgStr);
                }
                body.addTransUnit(tu);
                if (comment != null && comment.length() > 0) {
                    note = new DefaultXMLElement();
                    note.setContent(0, comment);
                    note.setName("note");
                    if (AppPreferences.userid.length() > 0) {
                        note.setAttribute("from", AppPreferences.userid);
                    }
                    tu.addChild(note);
                }
                if (context != null && context.length() > 0) {
                    ContextGroup cgroup = new ContextGroup();
                    cgroup.setName("context-group");
                    DefaultXMLElement ctx = new DefaultXMLElement();
                    ctx.setName("context");
                    ctx.setAttribute("context-type", "x-msgctxt");
                    ctx.setContent(0, context);
                    cgroup.addChild(ctx);
                    tu.addChild(cgroup);
                    tu.setContext(context);
                }
                if (msgidStrPlural != null) {
                    tu = this.prepareTransUnit();
                    tu.setAttribute("resname", "msgid_plural");
                    tus = tu.getSource();
                    msgidStrPlural = this.getSourceString(msgidStrPlural);
                    tus.addChild(msgidStrPlural);
                    tut = tu.getTarget();
                    if (msgStrPlural != null) {
                        msgStrPlural = this.getTargetString(msgStrPlural);
                        tut.addChild(msgStrPlural);
                    }
                    note = new DefaultXMLElement();
                    note.setContent(0, "Plural");
                    note.setName("note");
                    note.setAttribute("from", "cafetran");
                    tu.addChild(note);
                    body.addTransUnit(tu);
                }
            }
            ++counter;
        }
    }

    private String getSourceString(String s) {
        if (s.startsWith("msgid ")) {
            s = s.substring(6);
        } else if (s.startsWith("msgid_plural ")) {
            s = s.substring(13);
        }
        StringBuilder sb = new StringBuilder();
        Matcher m = this.p1.matcher(s);
        while (m.find()) {
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String getTargetString(String s) {
        Matcher m;
        StringBuilder sb;
        if (s.startsWith("msgstr ")) {
            s = s.substring(7);
        } else if (s.startsWith("msgstr[")) {
            sb = new StringBuilder();
            m = this.p2.matcher(s);
            while (m.find()) {
                m.appendReplacement(sb, "");
            }
            m.appendTail(sb);
            s = sb.toString();
        }
        sb = new StringBuilder();
        m = this.p1.matcher(s);
        while (m.find()) {
            m.appendReplacement(sb, "");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public XLIFFUnit prepareTransUnit() {
        XliffFile currentFile = this.xliff.getCurrentFile();
        FileBody body = currentFile.getBody();
        int currentFileID = currentFile.getFileID();
        XLIFFUnit temp = body.getCurrentTU();
        int pid = this.xliff.getID();
        int fid = XLIFF.fileCounter;
        XLIFFUnit tunit = new XLIFFUnit(pid, fid, -1, 0);
        if (fid != currentFileID) {
            tunit.first = true;
            currentFileID = fid;
        }
        tunit.setName("trans-unit");
        DefaultXMLElement tus = new DefaultXMLElement();
        tus.setName("source");
        DefaultXMLElement tut = new DefaultXMLElement();
        tut.setName("target");
        tut.setAttribute("state", "new");
        if (temp == null) {
            tus.setAttribute("xml:lang", currentFile.getAttribute("source-language"));
            tut.setAttribute("xml:lang", currentFile.getAttribute("target-language"));
        } else {
            XMLElement ttus = temp.getSource();
            XMLElement ttut = temp.getTarget();
            if (ttus != null) {
                tus.setAttribute("xml:lang", ttus.getAttribute("xml:lang"));
            }
            if (ttut != null) {
                tut.setAttribute("xml:lang", ttut.getAttribute("xml:lang"));
            }
        }
        int no = body.getTUCount() + 1;
        tunit.setAttribute("id", String.valueOf(no));
        tunit.setSource(tus);
        tunit.setTarget(tut);
        body.setCurrentTU(tunit);
        return tunit;
    }

    public void export(String spath) {
        XliffFile xfile = this.xliff.getCurrentFile();
        String s = this.exportFile(xfile);
        String prevFilePath = this.getTargetPath(spath);
        if (prevFilePath != null) {
            File previewFile = new File(prevFilePath);
            this.saveFile(previewFile, s);
        }
    }

    public boolean exportAll(String targetDir) {
        boolean success = false;
        List files = this.project.getProjectFiles();
        if (files != null) {
            if (this.xliff != null) {
                if (this.xliff.isExternalToolXLIFF) {
                    return success;
                }
            } else {
                return success;
            }
            for (int k = 0; k < files.size(); ++k) {
                String tool;
                int fsep;
                XMLElement exf;
                FileHeader h;
                XliffFile file;
                String phase;
                Object object = files.get(k);
                if (!(object instanceof XliffFile) || (phase = (file = (XliffFile)object).getCurrentPhase()) != null && (phase.equals("Alignment") || phase.equals("Autoalignment") || phase.equals("End")) || (h = file.getHeader()) == null) continue;
                String href = null;
                Skeleton sk = h.getSkeleton();
                if (sk != null && (exf = sk.getExternalFile()) != null) {
                    href = exf.getAttribute("href");
                }
                String zName = file.getAttribute("original");
                if (href == null || href.length() == 0) {
                    href = zName;
                }
                if (href == null) continue;
                File f = new File(href);
                String path = this.project.getProjectPath();
                if (!f.exists() && path != null && (fsep = path.lastIndexOf(AppPreferences.fs)) != -1) {
                    String fdir = path.substring(0, fsep + 1);
                    String fn = f.getName();
                    String sref = fdir + fn;
                    f = new File(sref);
                    if (f.exists()) {
                        h.setSkeletonReference(sref);
                    } else {
                        String pname;
                        int i;
                        String name = this.project.getName();
                        int j = name.indexOf(".xlf");
                        if (j != -1 && (i = href.lastIndexOf(pname = name.substring(0, j))) != -1) {
                            sref = fdir + href.substring(i);
                            try {
                                Pattern p = Pattern.compile(" ", 16);
                                sref = p.matcher(sref).replaceAll("%20");
                                p = Pattern.compile("\\", 16);
                                sref = p.matcher(sref).replaceAll("/");
                                URL url = new URL("file:///" + sref);
                                f = new File(url.toURI());
                                if (f.exists()) {
                                    h.setSkeletonReference(f.getPath());
                                }
                            }
                            catch (MalformedURLException ex) {
                                Logger.getLogger(POHandler.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            catch (URISyntaxException ex) {
                                Logger.getLogger(POHandler.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                }
                if ((tool = file.getAttribute("tool-id")).equalsIgnoreCase("CafeTran") && f.exists()) {
                    String targetPath;
                    String targetLang;
                    if (this.project.mode == 2 || (targetLang = file.getAttribute("target-language")) == null) continue;
                    String sourceLang = file.getAttribute("source-language");
                    String sourceName = f.getName();
                    if (sourceLang == null) continue;
                    int si = sourceName.lastIndexOf("_" + sourceLang);
                    if (si != -1) {
                        String targetName = sourceName.substring(0, si) + sourceName.substring(si + sourceLang.length() + 1);
                        targetPath = targetDir + AppPreferences.fs + targetName;
                        new File(targetPath).getParentFile().mkdirs();
                    } else {
                        targetPath = targetDir + AppPreferences.fs + targetLang + "_" + sourceName;
                    }
                    String s = this.exportFile(file);
                    File previewFile = new File(targetPath);
                    this.saveFile(previewFile, s);
                    success = true;
                    continue;
                }
                if (tool.equalsIgnoreCase("CafeTran")) {
                    JOptionPane.showMessageDialog(null, "CafeTran cannot find the original source language document: " + f.getName());
                    continue;
                }
                JOptionPane.showMessageDialog(null, "This is not CafeTran project file.");
            }
        }
        return success;
    }

    private String exportFile(XliffFile xfile) {
        StringBuilder sb = new StringBuilder();
        FileBody body = xfile.getBody();
        List units = body.getTransUnits();
        String singularTarget = null;
        int count = 0;
        int mgtype = 0;
        for (XLIFFUnit next : units) {
            if (count == 0) {
                String con;
                DefaultXMLElement c;
                Object no;
                List notes = next.getNotes();
                if (notes.size() > 0 && (no = (c = (DefaultXMLElement)notes.get(0)).getContent(0)) != null && (con = no.toString()).length() > 0) {
                    sb.append(con);
                }
            } else {
                String context;
                String src = next.getSourceString();
                String trg = next.getTargetString();
                String msgtype = next.getAttribute("resname");
                mgtype = msgtype != null ? (msgtype.equals("msgid_singular") ? 1 : (msgtype.equals("msgid_plural") ? 2 : 0)) : 0;
                if (mgtype < 2) {
                    sb.append("\n\n");
                } else {
                    sb.append("\n");
                }
                if (mgtype < 2) {
                    List notes = next.getNotes();
                    for (DefaultXMLElement next1 : notes) {
                        String con;
                        Object no;
                        String s = next1.getAttribute("from");
                        if (s != null && s.equals("cafetran") || (no = next1.getContent(0)) == null || (con = no.toString()).length() <= 0) continue;
                        con = this.formatPOComment(con);
                        sb.append(con);
                        sb.append("\n");
                    }
                }
                if ((context = next.getContext()) != null && context.startsWith("msgctxt")) {
                    sb.append(context);
                    sb.append("\n");
                }
                src = this.formatSourceMsg(mgtype, src);
                trg = this.formatTargetMsg(mgtype, trg);
                sb.append(src);
                if (mgtype == 0) {
                    sb.append("\n");
                    sb.append(trg);
                    singularTarget = null;
                } else if (mgtype == 1) {
                    singularTarget = trg;
                } else {
                    if (singularTarget != null) {
                        sb.append("\n");
                        sb.append(singularTarget);
                    }
                    sb.append("\n");
                    sb.append(trg);
                    singularTarget = null;
                }
            }
            ++count;
        }
        return sb.toString();
    }

    private boolean saveFile(File file, String text) {
        try {
            File tempFile = File.createTempFile("Exp", file.getName(), file.getParentFile());
            this.storeFile(tempFile, text, "UTF-8");
            if (file.exists()) {
                file.delete();
            }
            if (!tempFile.renameTo(file)) {
                JOptionPane.showMessageDialog(null, "CafeTran cannot rename the file to " + file.getName());
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeFile(File tempFile, String text, String enc) {
        FileOutputStream fos = null;
        try {
            Charset charset = Charset.isSupported(enc) ? Charset.forName(enc) : Charset.forName("UTF-8");
            CharsetEncoder encoder = charset.newEncoder();
            encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            encoder.onMalformedInput(CodingErrorAction.REPLACE);
            fos = new FileOutputStream(tempFile);
            FileChannel fc = fos.getChannel();
            CharBuffer cb = CharBuffer.wrap(text.toCharArray());
            ByteBuffer bb = encoder.encode(cb);
            fc.write(bb);
            fos.close();
        }
        catch (IOException ex) {
            Logger.getLogger(POHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException ex) {
                Logger.getLogger(POHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private String getTargetPath(String p) {
        String prevFilePath;
        String path = this.xliff.getCurrentFile().getTranslatablePath();
        File file = new File(path);
        String name = file.getName();
        String extention = null;
        int i = name.lastIndexOf(".");
        extention = i != -1 ? name.substring(i, name.length()).toLowerCase() : "";
        String parent = file.getParent();
        if (p == null) {
            prevFilePath = parent + AppPreferences.fs + ResourceBundle.getBundle("translator/Bundle", AppPreferences.getUserLocale()).getString("PREVIEW") + extention;
        } else {
            prevFilePath = p.toLowerCase().endsWith(extention) ? p : p + extention;
            if (prevFilePath.equalsIgnoreCase(path)) {
                JOptionPane.showMessageDialog(null, "Never overwrite the original source language document!");
                return null;
            }
        }
        return prevFilePath;
    }

    private String formatPOComment(String note) {
        StringBuilder sb = new StringBuilder();
        Matcher m = this.p3.matcher(note);
        while (m.find()) {
            String gr = m.group();
            if (gr.startsWith("msgctxt") || gr.startsWith("#")) {
                m.appendReplacement(sb, Matcher.quoteReplacement(gr));
                continue;
            }
            m.appendReplacement(sb, "# " + Matcher.quoteReplacement(gr));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String formatSourceMsg(int mtype, String contents) {
        StringBuffer sb = new StringBuffer();
        Matcher m = this.p4.matcher(contents);
        while (m.find()) {
            String gr = m.group();
            m.appendReplacement(sb, "\"" + Matcher.quoteReplacement(gr) + "\"");
        }
        m.appendTail(sb);
        if (mtype < 2) {
            sb.insert(0, "msgid ");
        } else {
            sb.insert(0, "msgid_plural ");
        }
        return sb.toString().trim();
    }

    private String formatTargetMsg(int mtype, String contents) {
        if (contents.startsWith("msgstr")) {
            return contents;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = this.p4.matcher(contents);
        int c = 1;
        while (m.find()) {
            String gr = m.group();
            if (mtype < 2) {
                m.appendReplacement(sb, "\"" + Matcher.quoteReplacement(gr) + "\"");
            } else {
                String s = "msgstr[" + Integer.toString(c) + "] \"" + gr + "\"";
                m.appendReplacement(sb, Matcher.quoteReplacement(s));
            }
            ++c;
        }
        m.appendTail(sb);
        if (sb.length() == 0) {
            if (mtype == 2) {
                sb.append("msgstr[1] \"\"");
            } else {
                sb.append("\"\"");
            }
        }
        if (mtype == 0) {
            sb.insert(0, "msgstr ");
        } else if (mtype == 1) {
            sb.insert(0, "msgstr[0] ");
        }
        return sb.toString().trim();
    }

    private void p(String s) {
        System.out.println(s);
    }
}

