/*
 * Decompiled with CFR 0.152.
 */
package translator.xliff;

import java.io.CharArrayWriter;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import translator.DefaultXMLElement;
import translator.MainView;
import translator.Project;
import translator.XMLElement;
import translator.xliff.CDATA;
import translator.xliff.FileBody;
import translator.xliff.FileHeader;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;
import translator.xliff.XliffFile;

public class TXMLHandler
extends DefaultHandler
implements LexicalHandler {
    protected CharArrayWriter contents = new CharArrayWriter();
    protected Stack deck = new Stack();
    private Project project;
    private XLIFF xliff;
    private FileBody body;
    boolean translatable = false;

    public TXMLHandler(MainView topui, Project project) {
        this.project = project;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
        DefaultXMLElement xml;
        if (qName.equals("segment") && this.translatable) {
            int pid = this.xliff.getID();
            int fid = XLIFF.fileCounter;
            xml = new XLIFFUnit(pid, fid, -1, 2);
        } else if (qName.equals("txml")) {
            this.xliff = new XLIFF();
            this.xliff.isTXML = true;
            this.project.setXLIFF(this.xliff);
            xml = this.xliff;
            XliffFile file = new XliffFile();
            for (int i = 0; i < attr.getLength(); ++i) {
                String qname = attr.getQName(i);
                if (qname.equals("locale")) {
                    qname = "source-language";
                    file.setAttribute(qname, attr.getValue(i));
                    continue;
                }
                if (qname.equals("targetlocale")) {
                    qname = "target-language";
                    file.setAttribute(qname, attr.getValue(i));
                    continue;
                }
                if (!qname.equals("file_name")) continue;
                qname = "original";
                file.setAttribute(qname, attr.getValue(i));
            }
            this.xliff.setCurrentFile(file);
            this.body = new FileBody();
            file.setBody(this.body);
            FileHeader elem = new FileHeader();
            file.setHeader(elem);
        } else {
            xml = new DefaultXMLElement();
            if (qName.equals("translatable")) {
                this.translatable = true;
            }
        }
        for (int i = 0; i < attr.getLength(); ++i) {
            xml.setAttribute(attr.getQName(i), attr.getValue(i));
        }
        xml.setName(qName);
        if (this.contents.size() > 0 && !this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement pxml = (XMLElement)o;
            String s = this.contents.toString();
            pxml.addChild(s);
        }
        this.deck.push(xml);
        this.contents.reset();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        XMLElement childXml = (XMLElement)this.deck.pop();
        if (this.contents.size() > 0) {
            String s = this.contents.toString();
            childXml.addChild(s);
        }
        if (!this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement xml = (XMLElement)o;
            xml.addChild(childXml);
        }
        if (qName.equals("segment")) {
            String s;
            XMLElement target;
            XLIFFUnit xtu = (XLIFFUnit)childXml;
            List commentsList = xtu.getChildren("comments");
            if (commentsList.size() == 1) {
                DefaultXMLElement comments = (DefaultXMLElement)commentsList.get(0);
                xtu.setNotes(comments.getChildren("comment"));
            }
            if ((target = xtu.getTarget()) != null && (s = target.getAttribute("score")) != null) {
                xtu.percent = s + "%";
                if (xtu.percent.equals("100%")) {
                    xtu.setMatch(100, 1, false);
                }
            }
            this.body.addXfliffTU(xtu);
            String con = xtu.getSourceText();
            if (con.length() > 0) {
                this.xliff.addToMemory(con, xtu, false, false);
            }
        }
        if (qName.equals("translatable")) {
            this.translatable = false;
        }
        this.contents.reset();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.write(ch, start, length);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        CDATA xml = new CDATA();
        xml.setName("!CDATA");
        this.deck.push(xml);
        this.contents.reset();
    }

    @Override
    public void endCDATA() throws SAXException {
        XMLElement childXml = (XMLElement)this.deck.pop();
        if (this.contents.size() > 0) {
            String s = this.contents.toString();
            childXml.addChild(s);
        }
        if (!this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement xml = (XMLElement)o;
            xml.addChild(childXml);
        }
        this.contents.reset();
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }
}

