/*
 * Decompiled with CFR 0.152.
 */
package translator.xliff;

import java.io.CharArrayWriter;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import translator.AppPreferences;
import translator.DefaultXMLElement;
import translator.MainView;
import translator.Project;
import translator.Tag;
import translator.XMLElement;
import translator.XMLHelper;
import translator.xliff.AltTrans;
import translator.xliff.Billing;
import translator.xliff.BinaryUnit;
import translator.xliff.CDATA;
import translator.xliff.ContextGroup;
import translator.xliff.CountGroup;
import translator.xliff.FileBody;
import translator.xliff.FileHeader;
import translator.xliff.Glossary;
import translator.xliff.Group;
import translator.xliff.PhaseGroup;
import translator.xliff.Reference;
import translator.xliff.Skeleton;
import translator.xliff.XLIFF;
import translator.xliff.XLIFFUnit;
import translator.xliff.XliffFile;

public class XliffHandler
extends DefaultHandler
implements LexicalHandler {
    protected CharArrayWriter contents = new CharArrayWriter();
    protected Stack deck = new Stack();
    private Project project;
    private XLIFF xliff;
    private FileBody body;
    private int fileType = 0;
    private boolean inHeader;
    private boolean hasBodySet;
    private int currentFileID = -1;
    private boolean TUScope = false;
    private boolean tagsScope = false;
    private boolean revsScope = false;

    public XliffHandler(MainView topui, Project project, boolean fromString) {
        this.project = project;
        if (fromString) {
            this.xliff = project.getXLIFF();
            this.body = this.xliff.getCurrentFile().getBody();
            this.hasBodySet = true;
        }
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
        String s;
        if (this.xliff != null && this.xliff.isCafeTranXLIFF && (s = this.xliff.getAttribute("xmlns:ct")) == null) {
            this.xliff.setAttribute("xmlns:ct", "urn:cafetran:ct");
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
        String s;
        DefaultXMLElement xml;
        boolean inFile = false;
        if (qName.equals("trans-unit") || this.fileType == 3 && qName.equals("segment")) {
            this.TUScope = true;
            int pid = this.xliff.getID();
            int fid = XLIFF.fileCounter;
            xml = new XLIFFUnit(pid, fid, -1, this.fileType);
        } else if (qName.equals("bin-unit")) {
            xml = new BinaryUnit();
        } else if (qName.equals("alt-trans")) {
            xml = new AltTrans();
        } else if (qName.equals("xliff")) {
            this.xliff = new XLIFF();
            String v = attr.getValue("version");
            if (v != null && v.startsWith("2.")) {
                this.fileType = 3;
                this.xliff.setVersion(2);
            }
            if (this.project.sdlxliffType) {
                this.fileType = 1;
                this.xliff.isExternalToolXLIFF = true;
                if (this.project.sdlxliffFile) {
                    this.xliff.isStudioXLIFF = true;
                }
            } else {
                String path = this.project.getProjectPath();
                if (path != null && path.toLowerCase().endsWith(".sdlxliff")) {
                    this.xliff.isExternalToolXLIFF = true;
                    this.xliff.isStudioXLIFF = true;
                    this.fileType = 1;
                } else {
                    path = this.xliff.getPath();
                    if (path != null && path.toLowerCase().endsWith(".sdlxliff")) {
                        this.xliff.isExternalToolXLIFF = true;
                        this.xliff.isStudioXLIFF = true;
                        this.fileType = 1;
                    } else {
                        String sdlx = attr.getValue("xmlns:sdl");
                        if (sdlx != null && sdlx.length() > 0) {
                            this.xliff.isExternalToolXLIFF = true;
                            this.xliff.isStudioXLIFF = true;
                            this.fileType = 1;
                        } else {
                            String s2 = attr.getValue("xmlns:text");
                            if (s2 != null && s2.equals("urn:cafetran:text")) {
                                this.xliff.isCafeTranXLIFF = true;
                            } else if (this.project.xliffFile) {
                                this.xliff.isUnknownXLIFF = true;
                            }
                        }
                    }
                }
            }
            if ((v = attr.getValue("xmlns:gs4tr")) != null && v.indexOf("www.gs4tr.org") != -1) {
                this.xliff.isTXLIFF = true;
            } else {
                v = attr.getValue("xmlns:m");
                if (v != null && v.indexOf("www.memsource.com") != -1) {
                    this.xliff.isMXLIFF = true;
                }
            }
            this.project.setXLIFF(this.xliff);
            xml = this.xliff;
        } else if (qName.equals("file")) {
            XliffFile elem = new XliffFile();
            xml = elem;
            inFile = true;
            if (this.fileType == 3) {
                this.body = new FileBody();
                elem.setVirtualBody(this.body);
            }
        } else if (qName.equals("header")) {
            this.inHeader = true;
            FileHeader elem = new FileHeader();
            xml = elem;
        } else if (qName.equals("body")) {
            this.inHeader = false;
            if (!this.hasBodySet) {
                this.body = new FileBody();
            }
            xml = this.body;
        } else if (qName.equals("bill:billing")) {
            Billing elem = new Billing();
            xml = elem;
        } else if (qName.equals("skl")) {
            Skeleton elem = new Skeleton();
            xml = elem;
        } else if (qName.equals("reference")) {
            Reference elem = new Reference();
            xml = elem;
        } else if (qName.equals("glossary")) {
            Glossary elem = new Glossary();
            xml = elem;
        } else if (qName.equals("count-group")) {
            CountGroup elem = new CountGroup();
            xml = elem;
        } else if (qName.equals("context-group")) {
            ContextGroup elem = new ContextGroup();
            xml = elem;
        } else if (qName.equals("phase-group")) {
            PhaseGroup elem = new PhaseGroup();
            xml = elem;
        } else {
            xml = qName.equals("group") ? new Group() : new DefaultXMLElement();
        }
        for (int i = 0; i < attr.getLength(); ++i) {
            xml.setAttribute(attr.getQName(i), attr.getValue(i));
        }
        xml.setName(qName);
        if (this.xliff.isExternalToolXLIFF) {
            if (qName.equals("target")) {
                Project.hasSDLTargetSegments = true;
            } else if (qName.equals("x")) {
                String s3 = xml.getAttribute("id");
                if (s3 != null && s3.startsWith("locked")) {
                    this.body.addSDLLockedElement(xml);
                }
            } else if (qName.equals("tag-defs")) {
                this.tagsScope = true;
            } else if (qName.equals("rev-defs")) {
                this.revsScope = true;
            }
        }
        if (inFile && this.fileType != 3) {
            String s4 = xml.getAttribute("tool-id");
            if (s4 != null && s4.toLowerCase().startsWith("cafetran")) {
                if (s4.equals("CafeTran-LibreOffice")) {
                    this.project.setLibreOfficeMode(1);
                }
                this.xliff.isCafeTranXLIFF = true;
                this.fileType = 0;
            } else {
                this.xliff.isExternalToolXLIFF = true;
                AppPreferences.projectType = 3;
                this.fileType = 1;
            }
            s4 = xml.getAttribute("datatype");
            if (s4 != null && s4.equals("x-po")) {
                this.project.poFile = true;
                this.xliff.isPO = true;
                XMLHelper.showCustomTags();
            }
        }
        if (this.inHeader && qName.equals("tool") && (s = xml.getAttribute("tool-id")) != null && s.equals("MQ")) {
            this.xliff.isMQXLIFF = true;
        }
        if (this.contents.size() > 0 && !this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement pxml = (XMLElement)o;
            String s5 = this.contents.toString();
            if (this.xliff.isExternalToolXLIFF && !this.TUScope) {
                s5 = s5.replace("\n", "\r\n");
            }
            pxml.addChild(s5);
        }
        this.deck.push(xml);
        this.contents.reset();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String a;
        XMLElement childXml = (XMLElement)this.deck.pop();
        if (this.contents.size() > 0) {
            String s = this.contents.toString();
            if (this.xliff.isExternalToolXLIFF && !this.TUScope) {
                s = s.replace("\n", "\r\n");
            }
            childXml.addChild(s);
        }
        boolean translate = true;
        if (!this.deck.empty()) {
            String n;
            Object o = this.deck.peek();
            XMLElement xml = (XMLElement)o;
            xml.addChild(childXml);
            if (this.fileType == 3 && (n = xml.getName()).equals("unit") && (a = xml.getAttribute("translate")) != null && a.equals("no")) {
                translate = false;
            }
        }
        if (qName.equals("trans-unit") || this.fileType == 3 && qName.equals("segment")) {
            this.TUScope = false;
            XLIFFUnit xtu = (XLIFFUnit)childXml;
            if (this.xliff.isCafeTranXLIFF) {
                int fid;
                String s = xtu.getAttribute("property:bookmark");
                if (s != null) {
                    xtu.bookmark = true;
                }
                if ((s = xtu.getAttribute("ct:propagate")) != null && s.equals("false")) {
                    xtu.propagate = false;
                }
                if ((s = xtu.getAttribute("ct:locked")) != null && s.equals("true")) {
                    xtu.locked = true;
                }
                if ((fid = xtu.getFileID()) != this.currentFileID) {
                    xtu.first = true;
                    this.currentFileID = fid;
                }
            } else if (this.fileType == 3 && !translate) {
                xtu.translate = translate;
            }
            if (this.xliff.isExternalToolXLIFF) {
                String t = xtu.getAttribute("translate");
                if (t == null || !t.equals("no")) {
                    if (this.isLocked(xtu)) {
                        xtu.locked = true;
                    }
                    this.body.addSDLXliffTU(this.xliff, xtu);
                } else {
                    xtu.translate = false;
                }
                String lockID = xtu.getAttribute("id");
                if (lockID != null && lockID.startsWith("lockTU")) {
                    XLIFFUnit.lockedTUs.put(lockID, xtu);
                }
                if (this.xliff.isMQXLIFF) {
                    String c;
                    DefaultXMLElement context;
                    String attr;
                    DefaultXMLElement mqContextGroup;
                    List mqctx;
                    List mqctxg;
                    List mqCommentsList;
                    a = xtu.getAttribute("mq:status");
                    if (a != null && a.equals("ManuallyConfirmed")) {
                        xtu.setState(1);
                    } else if (a != null && a.equals("Reviewer1Confirmed")) {
                        xtu.setState(2);
                    } else if (a != null && a.equals("Rejected")) {
                        xtu.setState(3);
                    }
                    String s = xtu.getAttribute("mq:percent");
                    if (s != null) {
                        xtu.percent = s + "%";
                        if (xtu.percent.equals("100%")) {
                            xtu.setMatch(100, 1, false);
                        }
                    }
                    if ((mqCommentsList = xtu.getChildren("mq:comments")).size() == 1) {
                        DefaultXMLElement mqComments = (DefaultXMLElement)mqCommentsList.get(0);
                        xtu.setNotes(mqComments.getChildren("mq:comment"));
                    }
                    if ((mqctxg = xtu.getContextGroups()).size() > 0 && (mqctx = (mqContextGroup = (DefaultXMLElement)mqctxg.get(0)).getChildren("context")).size() > 0 && (attr = (context = (DefaultXMLElement)mqctx.get(0)).getAttribute("context-type")) != null && attr.equals("x-mmq-context") && (c = (String)context.getContent(0)) != null && c.length() > 0) {
                        xtu.setContext(c);
                    }
                } else if (this.xliff.isMXLIFF) {
                    List ctxg;
                    Object o;
                    XMLElement xml;
                    String n;
                    a = xtu.getAttribute("m:confirmed");
                    if (a != null && a.equals("1")) {
                        xtu.setState(1);
                    }
                    if (!this.deck.empty() && (n = (xml = (XMLElement)(o = this.deck.peek())).getName()).equals("group") && (ctxg = xml.getChildren("context-group")).size() > 0) {
                        DefaultXMLElement contextGroup = (DefaultXMLElement)ctxg.get(0);
                        List ctx = contextGroup.getChildren("context");
                        for (DefaultXMLElement context : ctx) {
                            String c;
                            String attr = context.getAttribute("context-type");
                            if (attr == null || !attr.equals("x-key-note") || (c = (String)context.getContent(0)) == null || c.length() <= 0) continue;
                            xtu.setContext(c);
                            break;
                        }
                    }
                } else if (this.xliff.isTXLIFF) {
                    List wfCommentsList = xtu.getChildren("gs4tr:note");
                    if (wfCommentsList.size() > 0) {
                        xtu.setNotes(wfCommentsList);
                    }
                } else if (this.xliff.isUnknownXLIFF) {
                    XMLElement target;
                    a = xtu.getAttribute("approved");
                    if (a != null) {
                        if (a.equals("yes")) {
                            xtu.setState(2);
                        } else if (a.equals("no")) {
                            xtu.setState(3);
                        }
                    }
                    if (xtu.getState() < 2 && (target = xtu.getTarget()) != null && (a = target.getAttribute("state")) != null && a.equals("signed-off")) {
                        xtu.setState(1);
                    }
                }
            } else {
                this.body.addXfliffTU(xtu);
                String con = xtu.getSourceText();
                if (con.length() > 0) {
                    this.xliff.addToMemory(con, xtu, false, false);
                }
                if (this.xliff.isCafeTranXLIFF) {
                    XMLElement target;
                    DefaultXMLElement context;
                    String c;
                    DefaultXMLElement contextGroup;
                    List ctx;
                    List ctxg;
                    if (this.xliff.isPO && (ctxg = xtu.getContextGroups()).size() > 0 && (ctx = (contextGroup = (DefaultXMLElement)ctxg.get(0)).getChildren("context")).size() > 0 && (c = (String)(context = (DefaultXMLElement)ctx.get(0)).getContent(0)) != null && c.length() > 0) {
                        xtu.setContext(c);
                    }
                    if ((target = xtu.getTarget()) != null) {
                        a = target.getAttribute("state-qualifier");
                        if (a != null) {
                            if (a.equals("x-ai-translation")) {
                                xtu.setMatch(0, 0, false);
                            } else if (a.equals("x-human-translation")) {
                                xtu.setMatch(0, 5, false);
                            } else if (a.startsWith("x-machine-translation")) {
                                if (a.endsWith("-ct")) {
                                    xtu.setMatch(0, 3, false);
                                } else {
                                    xtu.setMatch(0, 4, false);
                                }
                            } else if (a.startsWith("x-exact-match-")) {
                                a = a.substring(14);
                                int k = Integer.parseInt(a);
                                xtu.setMatch(k, 1, false);
                            } else if (a.startsWith("x-fuzzy-match-")) {
                                a = a.substring(14);
                                int k = Integer.parseInt(a);
                                xtu.setMatch(k, 2, false);
                            }
                        }
                        if ((a = xtu.getAttribute("approved")) != null) {
                            if (a.equals("yes")) {
                                xtu.setState(2);
                            } else if (a.equals("no")) {
                                xtu.setState(3);
                            }
                        }
                        if (xtu.getState() < 2 && (a = target.getAttribute("state")) != null && a.equals("signed-off")) {
                            xtu.setState(1);
                        }
                    }
                }
            }
        } else if (this.xliff.isExternalToolXLIFF && qName.equals("cmt-def")) {
            String id = childXml.getAttribute("id");
            if (id != null) {
                List cmts = childXml.getChildren("Comments");
                XLIFF.sdlCommentsMap.put(id, cmts);
            }
        } else if (this.tagsScope) {
            this.createFormatTag(childXml);
        } else if (this.revsScope) {
            String n = childXml.getName();
            if (n.equals("rev-defs")) {
                this.revsScope = false;
            } else if (n.equals("rev-def") && this.xliff != null) {
                this.xliff.addTrackedElementInfo(childXml);
            }
        }
        this.contents.reset();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.contents.write(ch, start, length);
    }

    private void createFormatTag(XMLElement childXml) {
        Object o;
        XMLElement e;
        String n2;
        List li;
        String id;
        String n = childXml.getName();
        if (n.equals("tag-defs")) {
            this.tagsScope = false;
        } else if (n.equals("tag") && (id = childXml.getAttribute("id")) != null && !(li = childXml.getChildren("bpt")).isEmpty() && (n2 = (e = (XMLElement)li.get(0)).getAttribute("name")) != null && n2.equals("cf") && (o = e.getContent(0)) != null) {
            int i;
            Tag tag = new Tag();
            String os = o.toString();
            if ((os = os.replace("\"", "")).indexOf("bold=True") != -1) {
                tag.setBold(true);
            }
            if (os.indexOf("italic=True") != -1) {
                tag.setItalic(true);
            }
            if (os.indexOf("underline=") != -1) {
                tag.setUnderline(true);
            }
            if (os.indexOf("superscript=True") != -1) {
                tag.setSuperscript(true);
            }
            if (os.indexOf("subscript=True") != -1) {
                tag.setSubsript(true);
            }
            if ((i = os.indexOf("color=")) != -1) {
                int j = os.indexOf(" ", i);
                if (j != -1) {
                    String c = os.substring(i + 6, j);
                    tag.setColor(c);
                } else {
                    j = os.indexOf(">", i);
                    if (j != -1) {
                        String c = os.substring(i + 6, j);
                        tag.setColor(c);
                    }
                }
            }
            Project.addTag(id, tag);
        }
    }

    private boolean isLocked(XLIFFUnit tu) {
        String ch;
        boolean locked = false;
        if (this.xliff.isMQXLIFF && (ch = tu.getAttribute("mq:locked")) != null && ch.equals("locked")) {
            locked = true;
        }
        return locked;
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        CDATA xml = new CDATA();
        xml.setName("!CDATA");
        this.deck.push(xml);
        this.contents.reset();
    }

    @Override
    public void endCDATA() throws SAXException {
        XMLElement childXml = (XMLElement)this.deck.pop();
        if (this.contents.size() > 0) {
            String s = this.contents.toString();
            childXml.addChild(s);
        }
        if (!this.deck.empty()) {
            Object o = this.deck.peek();
            XMLElement xml = (XMLElement)o;
            xml.addChild(childXml);
        }
        this.contents.reset();
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }
}

