/*
 * Decompiled with CFR 0.152.
 */
package mt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTMLDocument;
import translator.AppPreferences;
import translator.AutoCompletion;
import translator.DefaultResource;
import translator.MT;
import translator.MainView;
import translator.MySwingWorker;
import translator.ScrollPaneWatermark;
import translator.SourceView;
import translator.TabView;
import translator.TargetView;
import translator.XMLHelper;
import translator.html.CTHTMLEditorKit;
import translator.json.JSONArray;
import translator.json.JSONObject;

public class MyMemory
extends DefaultResource
implements MT {
    private MainView topui;
    private TabView tview;
    private SourceView sourceview;
    private JPopupMenu pop;
    private String key;
    private String info = "";
    private JTextPane mtHTMLPane;
    private boolean running;
    private String resourceName;
    private MySwingWorker worker;
    private HashMap map;
    private HashMap reverseMap;
    String[] langs = new String[]{"Afrikaans", "Albanian", "Arabic", "Belarusian", "Bulgarian", "Catalan", "Chinese Simplified", "Chinese Traditional", "Croatian", "Czech", "Danish", "Dutch", "English", "Estonian", "Filipino", "Finnish", "French", "Galician", "German", "Greek", "Hebrew", "Hindi", "Hungarian", "Icelandic", "Indonesian", "Irish", "Italian", "Japanese", "Korean", "Latvian", "Lithuanian", "Macedonian", "Malay", "Maltese", "Norwegian", "Persian", "Polish", "Portuguese", "Romanian", "Russian", "Serbian", "Slovak", "Slovenian", "Spanish", "Swahili", "Swedish", "Thai", "Turkish", "Ukrainian", "Vietnamese", "Welsh", "Yiddish"};
    String result;
    String charset;
    private Timer timer;
    private boolean canLook = true;
    private String barBackgroundColor;
    private String barFontColor;
    String pair;
    private String startURL = "http://mymemory.translated.net/api/get?";
    ActionListener timerAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            MyMemory.this.canLook = true;
        }
    };

    public MyMemory() {
        Color c;
        int background;
        String[] langCodes = new String[]{"af", "sq", "ar", "be", "bg", "ca", "zh-CN", "zh-TW", "hr", "cs", "da", "nl", "en", "et", "tl", "fi", "fr", "gl", "de", "el", "iw", "hi", "hu", "is", "id", "ga", "it", "ja", "ko", "lv", "lt", "mk", "ms", "mt", "no", "fa", "pl", "pt", "ro", "ru", "sr", "sk", "sl", "es", "sw", "sv", "th", "tr", "uk", "vi", "cy", "yi"};
        this.map = new HashMap();
        this.reverseMap = new HashMap();
        for (int i = 0; i < this.langs.length; ++i) {
            String lang = this.langs[i];
            String code = langCodes[i];
            this.map.put(lang, code);
            this.reverseMap.put(code, lang);
        }
        this.setLanguagePair(AppPreferences.mtSource3, AppPreferences.mtTarget3);
        this.resourceName = "MyMemory MT";
        this.timer = new Timer(5000, this.timerAction);
        this.timer.setRepeats(false);
        if (AppPreferences.pforeground == -16777216) {
            background = -1117759;
            c = new Color(background);
            this.barBackgroundColor = "#" + Integer.toHexString(c.getRGB()).substring(2);
            this.barFontColor = "black";
        } else {
            background = -11310509;
            c = new Color(background);
            this.barBackgroundColor = "#" + Integer.toHexString(c.getRGB()).substring(2);
            this.barFontColor = "white";
        }
    }

    public void setAPIKey(String k) {
        this.key = k;
    }

    public void setMainView(MainView topui) {
        this.topui = topui;
        this.tview = topui.getTabView();
        this.sourceview = topui.getSourceView();
        this.setPopup();
        this.createMTTab();
        this.showMessage(this.info);
    }

    private void setPopup() {
        this.pop = new JPopupMenu();
        JMenuItem item = new JMenuItem(new AbstractAction("Translate"){

            public void actionPerformed(ActionEvent a) {
                JTextPane pane = MyMemory.this.topui.getSourcePane();
                String query = pane.getSelectedText();
                if (query == null) {
                    query = pane.getText();
                }
                if (query.length() > 0) {
                    query = XMLHelper.parseTags((String)query);
                    MyMemory.this.search(query, null);
                }
            }
        });
        this.pop.add(item);
    }

    private void showPopUp(Component comp, int x, int y) {
        this.pop.show(comp, x, y);
    }

    public String[] getLanguages() {
        return this.langs;
    }

    public void setLanguagePair(String source, String target) {
        if (source != null && target != null) {
            Object o1 = this.map.get(source);
            Object o2 = this.map.get(target);
            if (o1 != null && o2 != null) {
                String sourceLang = (String)o1;
                String targetLang = (String)o2;
                this.pair = "&langpair=" + sourceLang + "|" + targetLang;
                StringBuilder sb = new StringBuilder();
                sb.append("<html>");
                sb.append(AppPreferences.styles);
                sb.append("<body>");
                sb.append("<table align=center WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=1 CELLPADDING=6><tr><td>");
                sb.append("MyMemory: ");
                sb.append(source);
                sb.append(" -&gt; ");
                sb.append(target);
                sb.append("</tr></td></table></body></html>");
                this.info = sb.toString();
                this.showMessage(this.info);
            }
        }
    }

    public void setLanguageCodesPair(String sourceLang, String targetLang) {
        if (sourceLang != null && targetLang != null) {
            int sdash = sourceLang.indexOf("-");
            int tdash = targetLang.indexOf("-");
            if (sdash != -1 && !sourceLang.startsWith("zh-")) {
                sourceLang = sourceLang.substring(0, sdash);
            }
            if (tdash != -1 && !targetLang.startsWith("zh-")) {
                targetLang = targetLang.substring(0, tdash);
            }
            Object o1 = this.reverseMap.get(sourceLang);
            Object o2 = this.reverseMap.get(targetLang);
            if (o1 != null && o2 != null) {
                String source = (String)o1;
                String target = (String)o2;
                this.pair = "&langpair=" + sourceLang + "|" + targetLang;
                StringBuilder sb = new StringBuilder();
                sb.append("<html>");
                sb.append(AppPreferences.styles);
                sb.append("<body>");
                sb.append("<table align=center WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=1 CELLPADDING=6><tr><td>");
                sb.append("MyMemory: ");
                sb.append(source);
                sb.append(" -&gt; ");
                sb.append(target);
                sb.append("</tr></td></table></body></html>");
                this.info = sb.toString();
                AppPreferences.mtSource3 = source;
                AppPreferences.mtTarget3 = target;
                this.showMessage(this.info);
            }
        }
    }

    public void apply() {
        if (this.result != null) {
            this.topui.getTargetPane().setText(this.result);
        }
    }

    public void translate(String source) {
        this.search(source, null);
    }

    public void search(String okey, String rep) {
        if (!this.canLook) {
            return;
        }
        final String key = okey = okey.replaceAll("\\s+", " ");
        this.worker = new MySwingWorker(){

            public Object construct() {
                MyMemory.this.find(key);
                return null;
            }

            public void finished() {
            }
        };
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void find(String request) {
        try {
            request = URLEncoder.encode(request, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer.start();
        this.canLook = false;
        BufferedReader in = null;
        try {
            String query = this.startURL + "q=" + request + this.pair;
            URL url = new URL(query);
            URLConnection conn = url.openConnection();
            String enc = conn.getContentEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            InputStream ins = conn.getInputStream();
            in = new BufferedReader(new InputStreamReader(ins, enc));
            this.running = true;
            this.result = "";
            StringBuilder sb = new StringBuilder();
            String eline = "";
            while ((eline = in.readLine()) != null && this.running) {
                sb.append(eline);
            }
            JSONObject myjson = new JSONObject(sb.toString());
            StringBuilder html = new StringBuilder();
            html.append("<html>");
            html.append(AppPreferences.styles);
            html.append("<body>");
            html.append("<table WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=1 CELLPADDING=6>");
            JSONArray nameArray = myjson.names();
            for (int i = 0; i < nameArray.length(); ++i) {
                String p = nameArray.getString(i);
                if (p.equals("responseData")) {
                    JSONObject rd = myjson.getJSONObject(p);
                    String tr = rd.getString("translatedText");
                    if (tr == null || tr.length() <= 0) continue;
                    this.setAutotext(tr);
                    this.result = tr;
                    continue;
                }
                if (!p.equals("matches")) continue;
                JSONArray m = myjson.getJSONArray(p);
                for (int j = 0; j < m.length(); ++j) {
                    String s;
                    JSONObject mo = m.getJSONObject(j);
                    boolean mt = false;
                    if (mo == null || (s = mo.getString("segment")) == null) continue;
                    String createdby = mo.getString("created-by");
                    if (createdby != null && createdby.equals("MT!")) {
                        mt = true;
                    }
                    String subject = mo.getString("subject");
                    String reference = mo.getString("reference");
                    String quality = mo.getString("quality");
                    html.append("<tr>");
                    if (j == 0) {
                        if (!mt) {
                            html.append("<td width=50%><p><b>" + s + "</b></p></td>");
                        }
                    } else if (!mt) {
                        html.append("<td width=50%><p>" + s + "</p></td>");
                    }
                    s = mo.getString("translation");
                    if (j == 0) {
                        if (!mt) {
                            html.append("<td><p><b>");
                        } else {
                            html.append("<td colspan=2><p><b>");
                        }
                        html.append(s);
                        html.append("</b></p></td>");
                    } else {
                        if (!mt) {
                            html.append("<td><p>");
                        } else {
                            html.append("<td colspan=2><p>");
                        }
                        html.append(s);
                        html.append("</p></td>");
                    }
                    html.append("</tr>");
                    html.append("<tr><td style=background:").append(this.barBackgroundColor).append(";color:").append(this.barFontColor).append(" colspan=2>");
                    html.append("<p style=font:12>");
                    if (!mt && subject != null && subject.length() > 0) {
                        html.append("&nbsp;&nbsp;&nbsp;&nbsp;Subject: ");
                        html.append(subject);
                    }
                    if (quality != null && quality.length() > 0) {
                        html.append("&nbsp;&nbsp;&nbsp;&nbsp;Quality: ");
                        html.append(quality);
                        html.append("%");
                    }
                    if (reference != null && reference.length() > 0) {
                        html.append("&nbsp;&nbsp;&nbsp;&nbsp;Reference: ");
                        int pipe = reference.indexOf("|");
                        if (pipe != -1) {
                            reference = reference.substring(0, pipe);
                        }
                        if (!mt && reference.length() > 66) {
                            reference = reference.substring(0, 66) + "...";
                        }
                        html.append(reference);
                    }
                    html.append("</p></td></tr>");
                }
            }
            html.append("</table></body></html>");
            String r = html.toString();
            this.showMessage(r);
            this.canLook = true;
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
            this.closeConnection(in);
        }
        catch (Exception er) {
            try {
                er.printStackTrace();
                StringBuilder sb = new StringBuilder();
                sb.append("<html>");
                sb.append(AppPreferences.styles);
                sb.append("<body>");
                sb.append("<table align=center WIDTH=100% BORDER=0 BORDERCOLOR=#000000 CELLSPACING=1 CELLPADDING=6><tr><td>");
                sb.append("MyMemory translation service is not available!");
                sb.append("</tr></td></table></body></html>");
                this.showMessage(sb.toString());
                this.closeConnection(in);
            }
            catch (Throwable throwable) {
                this.closeConnection(in);
                throw throwable;
            }
        }
    }

    private void closeConnection(BufferedReader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MyMemory.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void stopSearch() {
        this.running = false;
        this.worker.interrupt();
    }

    public void createMTTab() {
        File file;
        this.mtHTMLPane = new JTextPane();
        this.mtHTMLPane.setEditorKitForContentType("text/html", (EditorKit)new CTHTMLEditorKit());
        this.mtHTMLPane.putClientProperty("type", "memory");
        this.mtHTMLPane.setContentType("text/html");
        Graphics g = this.mtHTMLPane.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        }
        Color background = null;
        if (AppPreferences.pbackground != 0 || AppPreferences.pBackgroundIm.length() > 0) {
            Color foreground = new Color(AppPreferences.pforeground);
            background = new Color(AppPreferences.pbackground);
            Color selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.tBackgroundIm.length() > 0) {
                selection = this.topui.toAlphaColor(selection, 127);
            }
            this.mtHTMLPane.setCaretColor(foreground);
            this.mtHTMLPane.setBackground(background);
            this.mtHTMLPane.setForeground(foreground);
            this.mtHTMLPane.setSelectionColor(selection);
            this.mtHTMLPane.setSelectedTextColor(foreground);
        }
        this.mtHTMLPane.setFont(new Font(AppPreferences.mfontname, AppPreferences.mfontstyle, AppPreferences.mfontsize));
        this.mtHTMLPane.setMargin(new Insets(12, 12, 12, 12));
        this.mtHTMLPane.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                MyMemory.this.topui.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        this.mtHTMLPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    MyMemory.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            public void mouseReleased(MouseEvent evt) {
                JEditorPane memoryPane = (JEditorPane)evt.getSource();
                String sel = memoryPane.getSelectedText();
                if (sel != null) {
                    TargetView pview = MyMemory.this.topui.getTargetView();
                    pview.grabSelection(sel);
                }
                if (evt.isPopupTrigger()) {
                    MyMemory.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        this.mtHTMLPane.setEditable(false);
        Style sstyle = this.mtHTMLPane.addStyle("highlight", null);
        Color segment = new Color(AppPreferences.segment);
        StyleConstants.setForeground(sstyle, segment);
        JScrollPane jScrollPane = new JScrollPane();
        if (background != null) {
            jScrollPane.setBackground(background);
        }
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            jScrollPane.getViewport().setOpaque(false);
            this.mtHTMLPane.setBackground(new Color(0, 0, 0, 0));
            this.mtHTMLPane.setOpaque(false);
        }
        jScrollPane.getViewport().add((Component)this.mtHTMLPane, null);
        if (AppPreferences.alpha == -1 && AppPreferences.pBackgroundIm.length() > 0 && (file = new File(AppPreferences.pBackgroundIm)).exists()) {
            JViewport vp = (JViewport)this.mtHTMLPane.getParent();
            JScrollPane scroll = (JScrollPane)vp.getParent();
            ScrollPaneWatermark viewport = new ScrollPaneWatermark();
            try {
                URL url = file.toURI().toURL();
                viewport.setView((JComponent)this.mtHTMLPane);
                viewport.setOpaque(false);
                scroll.setViewport((JViewport)viewport);
                this.topui.setBackgroudImage(url, viewport);
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
        }
        this.tview.addTab((Object)this, this.resourceName, (Component)jScrollPane);
    }

    public void showMessage(String mes) {
        if (this.mtHTMLPane != null) {
            HTMLDocument doc = (HTMLDocument)this.mtHTMLPane.getDocument();
            try {
                doc.setInnerHTML(doc.getDefaultRootElement(), mes);
                this.mtHTMLPane.setCaretPosition(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void closeResource() {
        this.running = false;
        if (this.worker != null) {
            this.worker.interrupt();
        }
        this.topui.getResourceView().setMT("");
        this.tview.removeCurrentTab();
    }

    private void setAutotext(String entry) {
        AutoCompletion auto = this.sourceview.getAutoCompletion();
        if (auto != null) {
            String[] entries = entry.split("\\s+");
            auto.getMTPhrases(entries);
        }
    }
}

