/*
 * Decompiled with CFR 0.152.
 */
package mt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import mt.BingAPI;
import translator.AppPreferences;
import translator.AutoCompletion;
import translator.DefaultResource;
import translator.MT;
import translator.MainView;
import translator.MySwingWorker;
import translator.ScrollPaneWatermark;
import translator.SourceView;
import translator.TabView;
import translator.TargetView;
import translator.XMLHelper;

public class Bing
extends DefaultResource
implements MT {
    private MainView topui;
    private TabView tview;
    private SourceView sourceview;
    private JPopupMenu pop;
    private BingAPI api;
    private String info = "";
    private JTextComponent textPane;
    protected DefaultStyledDocument doc;
    private String resourceName;
    private MySwingWorker worker;
    private HashMap map;
    private HashMap reverseMap;
    String[] langs = new String[]{"Arabic", "Bulgarian", "Catalan", "Chinese Simplified", "Chinese Traditional", "Czech", "Danish", "Dutch", "English", "Estonian", "Finnish", "French", "German", "Greek", "Haitian Creole", "Hebrew", "Hindi", "Hungarian", "Indonesian", "Italian", "Japanese", "Korean", "Latvian", "Lithuanian", "Norwegian", "Polish", "Portuguese", "Romanian", "Russian", "Slovak", "Slovenian", "Spanish", "Swedish", "Thai", "Turkish", "Ukrainian", "Vietnamese"};
    String result;
    String charset;
    private Timer timer;
    private boolean canLook = true;
    String sourceLanguage;
    String targetLanguage;
    ActionListener timerAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Bing.this.canLook = true;
        }
    };

    public Bing() {
        this.api = new BingAPI();
        String[] langCodes = new String[]{"ar", "bg", "ca", "zh-CN", "zh-TW", "cs", "da", "nl", "en", "et", "fi", "fr", "de", "el", "ht", "iw", "hi", "hu", "id", "it", "ja", "ko", "lv", "lt", "no", "pl", "pt", "ro", "ru", "sk", "sl", "es", "sv", "th", "tr", "uk", "vi"};
        this.map = new HashMap();
        this.reverseMap = new HashMap();
        for (int i = 0; i < this.langs.length; ++i) {
            String lang = this.langs[i];
            String code = langCodes[i];
            this.map.put(lang, code);
            this.reverseMap.put(code, lang);
        }
        this.setLanguagePair(AppPreferences.mtSource2, AppPreferences.mtTarget2);
        this.resourceName = "MSTranslator MT";
        this.timer = new Timer(5000, this.timerAction);
        this.timer.setRepeats(false);
    }

    public void setMainView(MainView topui) {
        this.topui = topui;
        this.tview = topui.getTabView();
        this.sourceview = topui.getSourceView();
        this.setPopup();
        this.createMTTab();
    }

    public void setAPIKey(String key) {
        String[] sp;
        if (key != null && (sp = key.split("\n")) != null && sp.length == 2) {
            String id = sp[0];
            String secret = sp[1];
            this.api.setClientId(id);
            this.api.setClientSecret(secret);
        }
    }

    private void setPopup() {
        this.pop = new JPopupMenu();
        JMenuItem item = new JMenuItem(new AbstractAction("Translate"){

            public void actionPerformed(ActionEvent a) {
                JTextPane pane = Bing.this.topui.getSourcePane();
                String query = pane.getSelectedText();
                if (query == null) {
                    query = pane.getText();
                }
                if (query.length() > 0) {
                    query = XMLHelper.parseTags((String)query);
                    Bing.this.search(query, null);
                }
            }
        });
        this.pop.add(item);
    }

    private void showPopUp(Component comp, int x, int y) {
        this.pop.show(comp, x, y);
    }

    public String[] getLanguages() {
        return this.langs;
    }

    public void setLanguagePair(String source, String target) {
        if (source != null && target != null) {
            Object o1 = this.map.get(source);
            Object o2 = this.map.get(target);
            if (o1 != null && o2 != null) {
                this.sourceLanguage = (String)o1;
                this.targetLanguage = (String)o2;
                this.info = "MS Translator: " + source + " -> " + target;
                if (this.textPane != null) {
                    this.textPane.setText(this.info);
                }
            }
        }
    }

    public void setLanguageCodesPair(String sourceLang, String targetLang) {
        if (sourceLang != null && targetLang != null) {
            int sdash = sourceLang.indexOf("-");
            int tdash = targetLang.indexOf("-");
            if (sdash != -1 && !sourceLang.startsWith("zh-")) {
                sourceLang = sourceLang.substring(0, sdash);
            }
            if (tdash != -1 && !targetLang.startsWith("zh-")) {
                targetLang = targetLang.substring(0, tdash);
            }
            Object o1 = this.reverseMap.get(sourceLang);
            Object o2 = this.reverseMap.get(targetLang);
            if (o1 != null && o2 != null) {
                String source = (String)o1;
                String target = (String)o2;
                this.sourceLanguage = sourceLang;
                this.targetLanguage = targetLang;
                this.info = "MS Translator: " + source + " -> " + target;
                AppPreferences.mtSource2 = source;
                AppPreferences.mtTarget2 = target;
                if (this.textPane != null) {
                    this.textPane.setText(this.info);
                }
            }
        }
    }

    public void apply() {
        if (this.result != null) {
            this.topui.getTargetPane().setText(this.result);
        }
    }

    public void translate(String source) {
        this.search(source, null);
    }

    public void search(String okey, String rep) {
        if (!this.canLook) {
            return;
        }
        final String key = okey = okey.replaceAll("\\s+", " ");
        this.worker = new MySwingWorker(){

            public Object construct() {
                Bing.this.find(key);
                return null;
            }

            public void finished() {
            }
        };
        this.worker.start();
    }

    private void find(String request) {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer.start();
        this.canLook = false;
        try {
            this.result = this.api.translate(request, this.sourceLanguage, this.targetLanguage);
            if (this.result != null) {
                this.textPane.setText(this.result);
                this.setAutotext(this.result);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Bing.class.getName()).log(Level.SEVERE, null, ex);
            this.textPane.setText(ex.getMessage());
            this.result = null;
        }
        this.canLook = true;
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
    }

    public void stopSearch() {
        this.worker.interrupt();
    }

    private void createMTTab() {
        File file;
        this.doc = this.createNewStyledDoc();
        this.textPane = new JTextPane(this.doc);
        Graphics g = this.textPane.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        }
        this.textPane.setEditable(false);
        Color background = null;
        if (AppPreferences.background != 0 || AppPreferences.pBackgroundIm.length() > 0) {
            background = new Color(AppPreferences.background);
            Color foreground = new Color(AppPreferences.foreground);
            Color selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.tBackgroundIm.length() > 0) {
                selection = this.topui.toAlphaColor(selection, 127);
            }
            this.textPane.setCaretColor(foreground);
            this.textPane.setBackground(background);
            this.textPane.setForeground(foreground);
            this.textPane.setSelectionColor(selection);
            this.textPane.setSelectedTextColor(foreground);
        }
        this.textPane.setFont(new Font(AppPreferences.fontname, 0, AppPreferences.fontsize));
        this.textPane.setMargin(new Insets(12, 12, 12, 12));
        this.textPane.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Bing.this.topui.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        this.textPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    Bing.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            public void mouseReleased(MouseEvent evt) {
                String sel = Bing.this.textPane.getSelectedText();
                if (sel != null) {
                    TargetView pview = Bing.this.topui.getTargetView();
                    pview.grabSelection(sel);
                }
                if (evt.isPopupTrigger()) {
                    Bing.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        this.textPane.setText(this.info);
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        if (background != null) {
            jScrollPane.setBackground(background);
        }
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            jScrollPane.getViewport().setOpaque(false);
            this.textPane.setOpaque(false);
            this.textPane.setBackground(new Color(0, 0, 0, 0));
        }
        if (AppPreferences.alpha == -1 && AppPreferences.pBackgroundIm.length() > 0 && (file = new File(AppPreferences.pBackgroundIm)).exists()) {
            JViewport vp = (JViewport)this.textPane.getParent();
            JScrollPane scroll = (JScrollPane)vp.getParent();
            ScrollPaneWatermark viewport = new ScrollPaneWatermark();
            try {
                URL url = file.toURI().toURL();
                viewport.setView((JComponent)this.textPane);
                viewport.setOpaque(false);
                scroll.setViewport((JViewport)viewport);
                this.topui.setBackgroudImage(url, viewport);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        this.tview.addTab((Object)this, this.resourceName, (Component)jScrollPane);
    }

    private DefaultStyledDocument createNewStyledDoc() {
        StyleContext styles = new StyleContext();
        DefaultStyledDocument doc = new DefaultStyledDocument(styles);
        Style style = styles.addStyle("dicPane", null);
        Style underlineStyle = styles.addStyle("underline", null);
        StyleConstants.setUnderline(underlineStyle, true);
        Color selection = new Color(AppPreferences.selection);
        StyleConstants.setBackground(style, selection);
        StyleConstants.setForeground(style, new Color(AppPreferences.foreground));
        return doc;
    }

    public void closeResource() {
        if (this.worker != null) {
            this.worker.interrupt();
        }
        this.topui.getResourceView().setMT("");
        this.tview.removeCurrentTab();
    }

    private void setAutotext(String entry) {
        AutoCompletion auto = this.sourceview.getAutoCompletion();
        if (auto != null) {
            String[] entries = entry.split("\\s+");
            auto.getMTPhrases(entries);
        }
    }
}

