/*
 * Decompiled with CFR 0.152.
 */
package mt;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import translator.json.JSONObject;

class BingAPI {
    private String SERVICE_URL = "http://api.microsofttranslator.com/V2/Ajax.svc/Translate?";
    private String ENCODING = "UTF-8";
    private String apiKey;
    private String DatamarketAccessUri = "https://datamarket.accesscontrol.windows.net/v2/OAuth2-13";
    private String clientId;
    private String clientSecret;
    private String token;
    private long tokenExpiration = 0L;
    private String APP_ID = "appId=";
    private String TO_LANG = "&to=";
    private String FROM_LANG = "&from=";
    private String TEXT = "&text=";

    BingAPI() {
    }

    public void setKey(String pKey) {
        this.apiKey = pKey;
    }

    public void setClientId(String pClientId) {
        this.clientId = pClientId;
    }

    public void setClientSecret(String pClientSecret) {
        this.clientSecret = pClientSecret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getToken(String clientId, String clientSecret) throws Exception {
        String params = "grant_type=client_credentials&scope=http://api.microsofttranslator.com&client_id=" + URLEncoder.encode(clientId, this.ENCODING) + "&client_secret=" + URLEncoder.encode(clientSecret, this.ENCODING);
        URL url = new URL(this.DatamarketAccessUri);
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        uc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=" + this.ENCODING);
        uc.setRequestProperty("Accept-Charset", this.ENCODING);
        uc.setRequestMethod("POST");
        uc.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(uc.getOutputStream());
        wr.write(params);
        wr.flush();
        try {
            int responseCode = uc.getResponseCode();
            String result = this.readStreamToString(uc.getInputStream());
            if (responseCode != 200) {
                throw new Exception("Error from API: " + result);
            }
            String string = result;
            return string;
        }
        finally {
            if (uc != null) {
                uc.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getResponse(URL url) throws Exception {
        if (this.clientId != null && this.clientSecret != null && System.currentTimeMillis() > this.tokenExpiration) {
            String tokenJson = this.getToken(this.clientId, this.clientSecret);
            JSONObject myjson = new JSONObject(tokenJson);
            String exp = myjson.getString("expires_in");
            String atoken = myjson.getString("access_token");
            Integer expiresIn = Integer.parseInt(exp);
            this.tokenExpiration = System.currentTimeMillis() + (long)(expiresIn * 1000 - 1);
            this.token = "Bearer " + atoken;
        }
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        uc.setRequestProperty("Content-Type", "text/plain; charset=" + this.ENCODING);
        uc.setRequestProperty("Accept-Charset", this.ENCODING);
        if (this.token != null) {
            uc.setRequestProperty("Authorization", this.token);
        }
        uc.setRequestMethod("GET");
        uc.setDoOutput(true);
        try {
            int responseCode = uc.getResponseCode();
            String result = this.readStreamToString(uc.getInputStream());
            if (responseCode != 200) {
                throw new Exception("Error from API: " + result);
            }
            String string = result;
            return string;
        }
        finally {
            if (uc != null) {
                uc.disconnect();
            }
        }
    }

    private String getResponseString(URL url) throws Exception {
        try {
            String response = this.getResponse(url);
            return response;
        }
        catch (Exception ex) {
            throw new Exception("Connection error: " + ex.getMessage(), ex);
        }
    }

    private String readStreamToString(InputStream inputStream) throws Exception {
        StringBuilder outputBuilder = new StringBuilder();
        try {
            if (inputStream != null) {
                String string;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, this.ENCODING));
                while (null != (string = reader.readLine())) {
                    outputBuilder.append(string.replaceAll("\ufeff", ""));
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("Connection error: " + ex.getMessage(), ex);
        }
        if (outputBuilder.length() > 1) {
            char last;
            char first = outputBuilder.charAt(0);
            if (first == '\"') {
                outputBuilder.deleteCharAt(0);
            }
            if ((last = outputBuilder.charAt(outputBuilder.length() - 1)) == '\"') {
                outputBuilder.deleteCharAt(outputBuilder.length() - 1);
            }
        }
        String r = outputBuilder.toString();
        r = r.replace("\\\"", "\"");
        return r;
    }

    private void validate(String text) throws Exception {
        int byteLength = text.getBytes(this.ENCODING).length;
        if (byteLength > 10240) {
            throw new RuntimeException("The source segment is too long for the request!");
        }
        if (this.apiKey != null && this.apiKey.length() < 16) {
            throw new RuntimeException("Please set the Microsoft Translator key");
        }
        if (this.clientId == null || this.clientSecret == null) {
            throw new RuntimeException("Please set the Client Id and Client Secret keys for Microsoft Translator!");
        }
    }

    public String translate(String text, String from, String to) throws Exception {
        this.validate(text);
        String p = (this.apiKey != null ? this.APP_ID + URLEncoder.encode(this.apiKey, this.ENCODING) : "") + this.FROM_LANG + URLEncoder.encode(from, this.ENCODING) + this.TO_LANG + URLEncoder.encode(to, this.ENCODING) + this.TEXT + URLEncoder.encode(text, this.ENCODING);
        URL url = new URL(this.SERVICE_URL + p);
        String r = this.getResponseString(url);
        return r;
    }
}

