/*
 * Decompiled with CFR 0.152.
 */
package mt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import translator.AppPreferences;
import translator.AutoCompletion;
import translator.DefaultResource;
import translator.MT;
import translator.MainView;
import translator.MySwingWorker;
import translator.ScrollPaneWatermark;
import translator.SourceView;
import translator.TabView;
import translator.TargetView;
import translator.XMLHelper;

public class Google
extends DefaultResource
implements MT {
    private MainView topui;
    private TabView tview;
    private SourceView sourceview;
    private JPopupMenu pop;
    private String key;
    private String info = "";
    private JTextComponent textPane;
    protected DefaultStyledDocument doc;
    private boolean running;
    private String resourceName;
    private MySwingWorker worker;
    private HashMap map;
    private HashMap reverseMap;
    String[] langs = new String[]{"Afrikaans", "Albanian", "Arabic", "Belarusian", "Bulgarian", "Catalan", "Chinese Simplified", "Chinese Traditional", "Croatian", "Czech", "Danish", "Dutch", "English", "Estonian", "Filipino", "Finnish", "French", "Galician", "German", "Greek", "Hebrew", "Hindi", "Hungarian", "Icelandic", "Indonesian", "Irish", "Italian", "Japanese", "Korean", "Latvian", "Lithuanian", "Macedonian", "Malay", "Maltese", "Norwegian", "Persian", "Polish", "Portuguese", "Romanian", "Russian", "Serbian", "Slovak", "Slovenian", "Spanish", "Swahili", "Swedish", "Thai", "Turkish", "Ukrainian", "Vietnamese", "Welsh", "Yiddish"};
    String result;
    String charset;
    private Timer timer;
    private boolean canLook = true;
    String pair;
    private String startResult = "\"translatedText\":";
    private String startURL = "https://www.googleapis.com/language/translate/v2?key=";
    ActionListener timerAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            Google.this.canLook = true;
        }
    };

    public Google() {
        String[] langCodes = new String[]{"af", "sq", "ar", "be", "bg", "ca", "zh-CN", "zh-TW", "hr", "cs", "da", "nl", "en", "et", "tl", "fi", "fr", "gl", "de", "el", "iw", "hi", "hu", "is", "id", "ga", "it", "ja", "ko", "lv", "lt", "mk", "ms", "mt", "no", "fa", "pl", "pt", "ro", "ru", "sr", "sk", "sl", "es", "sw", "sv", "th", "tr", "uk", "vi", "cy", "yi"};
        this.map = new HashMap();
        this.reverseMap = new HashMap();
        for (int i = 0; i < this.langs.length; ++i) {
            String lang = this.langs[i];
            String code = langCodes[i];
            this.map.put(lang, code);
            this.reverseMap.put(code, lang);
        }
        this.setLanguagePair(AppPreferences.mtSource, AppPreferences.mtTarget);
        this.resourceName = "Google MT";
        this.timer = new Timer(5000, this.timerAction);
        this.timer.setRepeats(false);
    }

    public void setAPIKey(String k) {
        this.key = k;
    }

    public void setMainView(MainView topui) {
        this.topui = topui;
        this.tview = topui.getTabView();
        this.sourceview = topui.getSourceView();
        this.setPopup();
        this.createMTTab();
    }

    private void setPopup() {
        this.pop = new JPopupMenu();
        JMenuItem item = new JMenuItem(new AbstractAction("Translate"){

            public void actionPerformed(ActionEvent a) {
                JTextPane pane = Google.this.topui.getSourcePane();
                String query = pane.getSelectedText();
                if (query == null) {
                    query = pane.getText();
                }
                if (query.length() > 0) {
                    query = XMLHelper.parseTags((String)query);
                    Google.this.search(query, null);
                }
            }
        });
        this.pop.add(item);
    }

    private void showPopUp(Component comp, int x, int y) {
        this.pop.show(comp, x, y);
    }

    public String[] getLanguages() {
        return this.langs;
    }

    public void setLanguagePair(String source, String target) {
        if (source != null && target != null) {
            Object o1 = this.map.get(source);
            Object o2 = this.map.get(target);
            if (o1 != null && o2 != null) {
                String sourceLang = (String)o1;
                String targetLang = (String)o2;
                this.pair = "&source=" + sourceLang + "&target=" + targetLang + "&";
                this.info = "Google Translate: " + source + " -> " + target;
                if (this.textPane != null) {
                    this.textPane.setText(this.info);
                }
            }
        }
    }

    public void setLanguageCodesPair(String sourceLang, String targetLang) {
        if (sourceLang != null && targetLang != null) {
            int sdash = sourceLang.indexOf("-");
            int tdash = targetLang.indexOf("-");
            if (sdash != -1 && !sourceLang.startsWith("zh-")) {
                sourceLang = sourceLang.substring(0, sdash);
            }
            if (tdash != -1 && !targetLang.startsWith("zh-")) {
                targetLang = targetLang.substring(0, tdash);
            }
            Object o1 = this.reverseMap.get(sourceLang);
            Object o2 = this.reverseMap.get(targetLang);
            if (o1 != null && o2 != null) {
                String source = (String)o1;
                String target = (String)o2;
                this.pair = "&source=" + sourceLang + "&target=" + targetLang + "&";
                this.info = "Google Translate: " + source + " -> " + target;
                AppPreferences.mtSource = source;
                AppPreferences.mtTarget = target;
                if (this.textPane != null) {
                    this.textPane.setText(this.info);
                }
            }
        }
    }

    public void apply() {
        if (this.result != null) {
            this.topui.getTargetPane().setText(this.result);
        }
    }

    public void translate(String source) {
        this.search(source, null);
    }

    public void search(String okey, String rep) {
        if (!this.canLook) {
            return;
        }
        final String key = okey = okey.replaceAll("\\s+", " ");
        this.worker = new MySwingWorker(){

            public Object construct() {
                Google.this.find(key);
                return null;
            }

            public void finished() {
            }
        };
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void find(String request) {
        if (this.key == null) {
            this.textPane.setText("Please set the Google Translate API key!");
            return;
        }
        try {
            request = URLEncoder.encode(request, "UTF-8");
            request = request.replace("+", "%20");
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.timer.start();
        this.canLook = false;
        BufferedReader in = null;
        try {
            String query = this.startURL + this.key + this.pair + "q=" + request;
            URL url = new URL(query);
            URLConnection conn = url.openConnection();
            String enc = conn.getContentEncoding();
            if (enc == null) {
                enc = "UTF-8";
            }
            InputStream ins = conn.getInputStream();
            in = new BufferedReader(new InputStreamReader(ins, enc));
            this.running = true;
            this.result = "";
            StringBuilder sb = new StringBuilder();
            String eline = "";
            while ((eline = in.readLine()) != null && this.running) {
                sb.append(eline);
            }
            int sr = sb.indexOf(this.startResult);
            if (sr != -1) {
                int j = sb.indexOf("\"", sr + this.startResult.length());
                int k = sb.indexOf("\"\n", j + 1);
                if (k == -1) {
                    k = sb.indexOf("\"}", j + 1);
                }
                if (k == -1) {
                    k = sb.indexOf("\"", j + 1);
                }
                if (j != -1 && k != -1) {
                    this.result = sb.substring(j + 1, k);
                }
            }
            if (this.result != null) {
                this.result = this.result.replaceAll(Matcher.quoteReplacement("\\u0026"), "&");
                this.result = this.result.replaceAll(Matcher.quoteReplacement("\\u003c"), "<");
                this.result = this.result.replaceAll(Matcher.quoteReplacement("\\u003e"), ">");
                this.result = XMLHelper.resolveEntitiesXML((String)this.result);
                this.textPane.setText(this.result);
                this.setAutotext(this.result);
            }
            this.canLook = true;
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
            this.closeConnection(in);
        }
        catch (Exception er) {
            this.textPane.setText("Error: Google Translate is not available!");
        }
        finally {
            this.closeConnection(in);
        }
    }

    private void closeConnection(BufferedReader in) {
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Google.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void stopSearch() {
        this.running = false;
        this.worker.interrupt();
    }

    private void createMTTab() {
        File file;
        this.doc = this.createNewStyledDoc();
        this.textPane = new JTextPane(this.doc);
        Graphics g = this.textPane.getGraphics();
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        }
        this.textPane.setEditable(false);
        Color background = null;
        if (AppPreferences.background != 0 || AppPreferences.pBackgroundIm.length() > 0) {
            background = new Color(AppPreferences.background);
            Color foreground = new Color(AppPreferences.foreground);
            Color selection = new Color(AppPreferences.selection);
            if (AppPreferences.backGrid || AppPreferences.tBackgroundIm.length() > 0) {
                selection = this.topui.toAlphaColor(selection, 127);
            }
            this.textPane.setCaretColor(foreground);
            this.textPane.setBackground(background);
            this.textPane.setForeground(foreground);
            this.textPane.setSelectionColor(selection);
            this.textPane.setSelectedTextColor(foreground);
        }
        this.textPane.setFont(new Font(AppPreferences.fontname, 0, AppPreferences.fontsize));
        this.textPane.setMargin(new Insets(12, 12, 12, 12));
        this.textPane.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Google.this.topui.setFocusedTextComponent((JTextComponent)e.getComponent());
            }
        });
        this.textPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    Google.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            public void mouseReleased(MouseEvent evt) {
                String sel = Google.this.textPane.getSelectedText();
                if (sel != null) {
                    TargetView pview = Google.this.topui.getTargetView();
                    pview.grabSelection(sel);
                }
                if (evt.isPopupTrigger()) {
                    Google.this.showPopUp(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        this.textPane.setText(this.info);
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        if (background != null) {
            jScrollPane.setBackground(background);
        }
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jScrollPane.setViewportBorder(new EmptyBorder(0, 0, 0, 0));
        if (AppPreferences.backGrid) {
            jScrollPane.getViewport().setOpaque(false);
            this.textPane.setOpaque(false);
            this.textPane.setBackground(new Color(0, 0, 0, 0));
        }
        if (AppPreferences.alpha == -1 && AppPreferences.pBackgroundIm.length() > 0 && (file = new File(AppPreferences.pBackgroundIm)).exists()) {
            JViewport vp = (JViewport)this.textPane.getParent();
            JScrollPane scroll = (JScrollPane)vp.getParent();
            ScrollPaneWatermark viewport = new ScrollPaneWatermark();
            try {
                URL url = file.toURI().toURL();
                viewport.setView((JComponent)this.textPane);
                viewport.setOpaque(false);
                scroll.setViewport((JViewport)viewport);
                this.topui.setBackgroudImage(url, viewport);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        this.tview.addTab((Object)this, this.resourceName, (Component)jScrollPane);
    }

    private DefaultStyledDocument createNewStyledDoc() {
        StyleContext styles = new StyleContext();
        DefaultStyledDocument doc = new DefaultStyledDocument(styles);
        Style style = styles.addStyle("dicPane", null);
        Style underlineStyle = styles.addStyle("underline", null);
        StyleConstants.setUnderline(underlineStyle, true);
        Color selection = new Color(AppPreferences.selection);
        StyleConstants.setBackground(style, selection);
        StyleConstants.setForeground(style, new Color(AppPreferences.foreground));
        return doc;
    }

    public void closeResource() {
        this.running = false;
        if (this.worker != null) {
            this.worker.interrupt();
        }
        this.topui.getResourceView().setMT("");
        this.tview.removeCurrentTab();
    }

    private void setAutotext(String entry) {
        AutoCompletion auto = this.sourceview.getAutoCompletion();
        if (auto != null) {
            String[] entries = entry.split("\\s+");
            auto.getMTPhrases(entries);
        }
    }
}

