/*
 * Decompiled with CFR 0.152.
 */
package mt;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import translator.json.JSONObject;

public class MicrosoftTranslatorAPI {
    private static final String SERVICE_URL = "http://api.microsofttranslator.com/V2/Ajax.svc/Translate?";
    protected static final String ENCODING = "UTF-8";
    protected static String apiKey;
    private static String DatamarketAccessUri;
    private static String referrer;
    private static String clientId;
    private static String clientSecret;
    private static String token;
    private static long tokenExpiration;
    protected static final String PARAM_APP_ID = "appId=";
    protected static final String PARAM_TO_LANG = "&to=";
    protected static final String PARAM_FROM_LANG = "&from=";
    protected static final String PARAM_TEXT_SINGLE = "&text=";
    protected static final String PARAM_TEXT_ARRAY = "&texts=";
    protected static final String PARAM_SPOKEN_LANGUAGE = "&language=";
    protected static final String PARAM_SENTENCES_LANGUAGE = "&language=";
    protected static final String PARAM_LOCALE = "&locale=";
    protected static final String PARAM_LANGUAGE_CODES = "&languageCodes=";

    public static void setKey(String pKey) {
        apiKey = pKey;
    }

    public static void setClientId(String pClientId) {
        clientId = pClientId;
    }

    public static void setClientSecret(String pClientSecret) {
        clientSecret = pClientSecret;
    }

    public static void setHttpReferrer(String pReferrer) {
        referrer = pReferrer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getToken(String clientId, String clientSecret) throws Exception {
        String params = "grant_type=client_credentials&scope=http://api.microsofttranslator.com&client_id=" + URLEncoder.encode(clientId, ENCODING) + "&client_secret=" + URLEncoder.encode(clientSecret, ENCODING);
        URL url = new URL(DatamarketAccessUri);
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        if (referrer != null) {
            uc.setRequestProperty("referer", referrer);
        }
        uc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        uc.setRequestProperty("Accept-Charset", ENCODING);
        uc.setRequestMethod("POST");
        uc.setDoOutput(true);
        OutputStreamWriter wr = new OutputStreamWriter(uc.getOutputStream());
        wr.write(params);
        wr.flush();
        try {
            int responseCode = uc.getResponseCode();
            String result = MicrosoftTranslatorAPI.inputStreamToString(uc.getInputStream());
            if (responseCode != 200) {
                throw new Exception("Error from Microsoft Translator API: " + result);
            }
            String string = result;
            return string;
        }
        finally {
            if (uc != null) {
                uc.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String retrieveResponse(URL url) throws Exception {
        if (clientId != null && clientSecret != null && System.currentTimeMillis() > tokenExpiration) {
            String tokenJson = MicrosoftTranslatorAPI.getToken(clientId, clientSecret);
            JSONObject myjson = new JSONObject(tokenJson);
            String exp = myjson.getString("expires_in");
            String atoken = myjson.getString("access_token");
            Integer expiresIn = Integer.parseInt(exp);
            tokenExpiration = System.currentTimeMillis() + (long)(expiresIn * 1000 - 1);
            token = "Bearer " + atoken;
        }
        HttpURLConnection uc = (HttpURLConnection)url.openConnection();
        if (referrer != null) {
            uc.setRequestProperty("referer", referrer);
        }
        uc.setRequestProperty("Content-Type", "text/plain; charset=UTF-8");
        uc.setRequestProperty("Accept-Charset", ENCODING);
        if (token != null) {
            uc.setRequestProperty("Authorization", token);
        }
        uc.setRequestMethod("GET");
        uc.setDoOutput(true);
        try {
            int responseCode = uc.getResponseCode();
            String result = MicrosoftTranslatorAPI.inputStreamToString(uc.getInputStream());
            if (responseCode != 200) {
                throw new Exception("Error from Microsoft Translator API: " + result);
            }
            String string = result;
            return string;
        }
        finally {
            if (uc != null) {
                uc.disconnect();
            }
        }
    }

    protected static String retrieveString(URL url) throws Exception {
        try {
            String response = MicrosoftTranslatorAPI.retrieveResponse(url);
            return response;
        }
        catch (Exception ex) {
            throw new Exception("[microsoft-translator-api] Error retrieving translation : " + ex.getMessage(), ex);
        }
    }

    protected static String[] retrieveStringArr(URL url, String jsonProperty) throws Exception {
        try {
            String response = MicrosoftTranslatorAPI.retrieveResponse(url);
            return null;
        }
        catch (Exception ex) {
            throw new Exception("[microsoft-translator-api] Error retrieving translation.", ex);
        }
    }

    protected static String[] retrieveStringArr(URL url) throws Exception {
        return MicrosoftTranslatorAPI.retrieveStringArr(url, null);
    }

    private static String inputStreamToString(InputStream inputStream) throws Exception {
        StringBuilder outputBuilder = new StringBuilder();
        try {
            if (inputStream != null) {
                String string;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, ENCODING));
                while (null != (string = reader.readLine())) {
                    outputBuilder.append(string.replaceAll("\ufeff", ""));
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("[microsoft-translator-api] Error reading translation stream.", ex);
        }
        return outputBuilder.toString();
    }

    protected static void validateServiceState() throws Exception {
        if (apiKey != null && apiKey.length() < 16) {
            throw new RuntimeException("INVALID_API_KEY - Please set the API Key with your Bing Developer's Key");
        }
        if (clientId == null || clientSecret == null) {
            throw new RuntimeException("Must provide a Windows Azure Marketplace Client Id and Client Secret - Please see http://msdn.microsoft.com/en-us/library/hh454950.aspx for further documentation");
        }
    }

    protected static String buildStringArrayParam(Object[] values) {
        StringBuilder targetString = new StringBuilder("[\"");
        for (Object obj : values) {
            String value;
            if (obj == null || (value = obj.toString()).length() == 0) continue;
            if (targetString.length() > 2) {
                targetString.append(",\"");
            }
            targetString.append(value);
            targetString.append("\"");
        }
        targetString.append("]");
        return targetString.toString();
    }

    private static void validateServiceState(String text) throws Exception {
        int byteLength = text.getBytes(ENCODING).length;
        if (byteLength > 10240) {
            throw new RuntimeException("TEXT_TOO_LARGE - Microsoft Translator (Translate) can handle up to 10,240 bytes per request");
        }
        MicrosoftTranslatorAPI.validateServiceState();
    }

    public static String execute(String text, String from, String to) throws Exception {
        MicrosoftTranslatorAPI.validateServiceState(text);
        String params = (apiKey != null ? PARAM_APP_ID + URLEncoder.encode(apiKey, ENCODING) : "") + PARAM_FROM_LANG + URLEncoder.encode(from, ENCODING) + PARAM_TO_LANG + URLEncoder.encode(to, ENCODING) + PARAM_TEXT_SINGLE + URLEncoder.encode(text, ENCODING);
        URL url = new URL(SERVICE_URL + params);
        String response = MicrosoftTranslatorAPI.retrieveString(url);
        return response;
    }

    public static void main(String[] args) {
        MicrosoftTranslatorAPI api = new MicrosoftTranslatorAPI();
        try {
            String transJSON = MicrosoftTranslatorAPI.execute("Hello all my friends!", "en", "pl");
            System.out.println(transJSON);
        }
        catch (Exception ex) {
            Logger.getLogger(MicrosoftTranslatorAPI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    static {
        DatamarketAccessUri = "https://datamarket.accesscontrol.windows.net/v2/OAuth2-13";
        clientId = "a735a188-642f-4d7a-a896-fb47eb4dd50d";
        clientSecret = "8n7DgLohrhx60GlazhC8yHouX/8c14gqxUXUqJYbJ+s=";
        tokenExpiration = 0L;
    }
}

